/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.Nullable;

public class CallerJSInspection
extends JavaScriptInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("caller.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSReferenceExpression(JSReferenceExpression jsReferenceExpression) {
            super.visitJSReferenceExpression(jsReferenceExpression);
            if (!"caller".equals(jsReferenceExpression.getReferencedName())) {
                return;
            }
            JSExpression qualifier = jsReferenceExpression.getQualifier();
            if (!(qualifier instanceof JSReferenceExpression) || !"arguments".equals(((JSReferenceExpression)qualifier).getReferencedName()) || ((JSReferenceExpression)qualifier).getQualifier() != null) {
                return;
            }
            this.registerError(jsReferenceExpression.getReferenceNameElement());
        }
    }
}

