/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeGuardFixHelper;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.TypeGuardSurroundKind;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeAssignableErrorMessage;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSStubBasedExpressionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.lang.javascript.validation.fixes.ChangeJSDocTypeFix;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class JSTypeChecker {
    @NotNull
    protected final JSProblemReporter<?> myReporter;
    private static final int ERROR_COUNT_LIMIT = 3;

    public JSTypeChecker(@NotNull JSProblemReporter<?> reporter) {
        if (reporter == null) {
            JSTypeChecker.$$$reportNull$$$0(0);
        }
        this.myReporter = reporter;
    }

    public final void registerProblem(PsiElement place, String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        this.myReporter.registerProblem(place, null, message, highlightType, fixes);
    }

    public final void registerProblem(PsiElement place, TextRange rangeWithin, String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        this.myReporter.registerProblem(place, rangeWithin, message, highlightType, fixes);
    }

    public final void checkExpressionIsAssignableToTypeAndReportError(@Nullable JSExpression expr, @Nullable String type, @NotNull String problemKey, @Nullable PsiElement typeOwner, boolean widenLiteralTypes) {
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(1);
        }
        if ("*".equals(type) || type == null || expr == null) {
            return;
        }
        this.checkExpressionIsAssignableToTypeAndReportError(expr, JSTypeUtils.createType(type, JSTypeSourceFactory.createTypeSource((PsiElement)expr)), problemKey, typeOwner, widenLiteralTypes);
    }

    public final boolean checkExpressionIsAssignableToTypeAndReportError(@Nullable JSExpression expr, @Nullable JSType jsType, @NotNull String problemKey, @Nullable PsiElement typeOwner, boolean widenLiteralTypes) {
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(2);
        }
        ProcessingContext context = JSTypeComparingContextService.getProcessingContextWithCache((PsiElement)expr);
        return this.checkExpressionIsAssignableToTypeAndReportError(expr, jsType, typeOwner, problemKey, context, widenLiteralTypes);
    }

    public boolean checkExpressionIsAssignableToTypeAndReportError(@Nullable JSExpression expr, @Nullable JSType jsType, @Nullable PsiElement typeOwner, @NotNull String problemKey, @Nullable ProcessingContext context, boolean widenLiteralTypes) {
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(3);
        }
        if (this.canSkipTypeChecking(expr, jsType)) {
            return true;
        }
        JSType expressionJSType = this.getExpressionTypeForChecking(expr, widenLiteralTypes);
        return this.checkExpressionIsAssignableToTypeAndReportError(expr, jsType, typeOwner, problemKey, context, expressionJSType);
    }

    public boolean checkExpressionIsAssignableToTypeAndReportError(JSExpression expr, @Nullable JSType jsType, @Nullable PsiElement typeOwner, @NotNull String problemKey, @Nullable ProcessingContext context, @Nullable JSType expressionJSType) {
        PsiElement typeOfTarget;
        String typeOfImmediateTarget;
        boolean isActionScript;
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(4);
        }
        if (expressionJSType == null) {
            return true;
        }
        if (this.skipByExpressionType(expr, expressionJSType)) {
            return true;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)expr);
        boolean isTypescript = holder != null && holder.isTypeScript;
        boolean bl = isActionScript = holder != null && holder.isECMA4;
        if (!isTypescript && expressionJSType instanceof JSNamedType && ((JSNamedType)expressionJSType).isStaticOrInstance() == JSContext.STATIC) {
            return true;
        }
        if (!expressionJSType.getSource().isStrict() && !isActionScript) {
            return true;
        }
        if (JSResolveUtil.isAssignableJSType(jsType, expressionJSType, context)) {
            if (isActionScript && jsType != null && ValidateTypesUtil.checkIfNullIsAssignedToNumeric(expr, jsType, expressionJSType)) {
                this.registerProblem((PsiElement)expr, JavaScriptBundle.message((String)"javascript.expression.type.implicitly.coerced.to.unrelated.type", (Object[])new Object[]{jsType.getTypeText(JSType.TypeTextFormat.PRESENTABLE), expressionJSType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, JSTypeChecker.getFixes(expr, jsType, typeOwner, expressionJSType, context, holder).toArray(LocalQuickFix.EMPTY_ARRAY));
                return false;
            }
            return true;
        }
        PsiElement expressionTypeSource = expressionJSType.getSource().getSourceElement();
        if (expressionTypeSource instanceof JSObjectLiteralExpression && !(expr.getParent() instanceof JSArgumentList) && !(expr.getParent() instanceof JSReturnStatement) && !(expr.getParent() instanceof JSFunctionExpression) && ((JSObjectLiteralExpression)expressionTypeSource).getProperties().length == 0 && JSTypeUtils.getValuableType(jsType) instanceof JSRecordType) {
            return true;
        }
        JSExpression exprToCheckForProxy = expr;
        if (exprToCheckForProxy instanceof JSCallExpression) {
            exprToCheckForProxy = ((JSCallExpression)exprToCheckForProxy).getMethodExpression();
            if (expr instanceof JSNewExpression && exprToCheckForProxy instanceof JSArrayLiteralExpression) {
                exprToCheckForProxy = null;
            }
        }
        if (exprToCheckForProxy instanceof JSReferenceExpression) {
            exprToCheckForProxy = ((JSReferenceExpression)exprToCheckForProxy).getQualifier();
        }
        if (exprToCheckForProxy != null && !(exprToCheckForProxy instanceof JSLiteralExpression) && !isTypescript && (typeOfImmediateTarget = ActionScriptResolveUtil.getQualifiedExpressionType(exprToCheckForProxy, expr.getContainingFile())) != null && (typeOfTarget = JSResolveUtil.findType(typeOfImmediateTarget, (PsiElement)exprToCheckForProxy, true)) instanceof JSClass) {
            if ("XML".equals(typeOfImmediateTarget) || "XMLList".equals(typeOfImmediateTarget) || (holder == null || holder.isJavaScript()) && typeOfTarget instanceof XmlBackedJSClass && expr instanceof JSThisExpression) {
                return true;
            }
            JSClassResolver resolver = JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver();
            PsiElement parentClass = resolver.findClassByQName("flash.utils.Proxy", typeOfTarget.getResolveScope());
            if (parentClass instanceof JSClass && JSInheritanceUtil.isParentClass((JSClass)typeOfTarget, (JSClass)parentClass, false)) {
                return true;
            }
        }
        AssignableInfoData infoData = JSTypeChecker.buildAssignableErrorMessage(expr, jsType, expressionJSType, holder, problemKey, context);
        String message = infoData.message;
        Collection<LocalQuickFix> fixes = JSTypeChecker.getFixes(expr, jsType, typeOwner, expressionJSType, context, holder);
        this.registerProblem((PsiElement)expr, infoData.range, message, ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)expr), (LocalQuickFix[])ArrayUtil.mergeCollections(fixes, infoData.fixes, LocalQuickFix[]::new));
        return false;
    }

    protected boolean skipByExpressionType(@NotNull JSExpression expr, @Nullable JSType expressionJSType) {
        if (expr == null) {
            JSTypeChecker.$$$reportNull$$$0(5);
        }
        return false;
    }

    @Nullable
    private JSType getExpressionTypeForChecking(@Nullable JSExpression expr, boolean widenLiteralTypes) {
        JSType expressionJSType = this.getExpressionType(expr);
        if (expr != null && widenLiteralTypes) {
            JSType contextual = JSDialectSpecificHandlersFactory.findExpectedType(expr, JSExpectedTypeKind.CONTEXTUAL);
            return JSTypeUtils.expandEnumAndLiteralTypeByExpectedType(expressionJSType, contextual);
        }
        return expressionJSType;
    }

    @Nullable
    protected JSType getExpressionType(JSExpression expr) {
        JSType evaluatedType = JSResolveUtil.getExpressionJSType(expr);
        return JSCompositeTypeImpl.optimizeTypeIfComposite(evaluatedType);
    }

    protected boolean canSkipTypeChecking(JSExpression expr, @Nullable JSType jsType) {
        if (jsType == null || expr == null || jsType instanceof JSAnyType || jsType instanceof JSStubBasedExpressionType && ((JSStubBasedExpressionType)jsType).findAssociatedExpression() == expr) {
            return true;
        }
        if (jsType instanceof JSNamedType && ((JSNamedType)jsType).isStaticOrInstance() == JSContext.STATIC) {
            return true;
        }
        return !jsType.getSource().isEcma() && !jsType.getSource().isStrict() && !JSTypeUtils.hasFunctionType(jsType, false, (PsiElement)expr);
    }

    public void checkIfProperTypeReference(JSExpression rOperand) {
    }

    @NotNull
    private static Collection<LocalQuickFix> getFixes(JSExpression expr, @NotNull JSType declaredJSType, @Nullable PsiElement elementToChangeTypeOf, @NotNull JSType expressionJSType, ProcessingContext context, @Nullable DialectOptionHolder holder) {
        JSType promiseArg;
        if (declaredJSType == null) {
            JSTypeChecker.$$$reportNull$$$0(6);
        }
        if (expressionJSType == null) {
            JSTypeChecker.$$$reportNull$$$0(7);
        }
        if (expr instanceof JSSpreadExpression) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSTypeChecker.$$$reportNull$$$0(8);
            }
            return list2;
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        String expressionType = JSTypeChecker.formatTypeForFix(expressionJSType, holder);
        String declaredTypeText = JSTypeChecker.formatTypeForFix(declaredJSType, holder);
        if (holder != null && (holder.isTypeScript && declaredJSType instanceof JSNamedType && !(declaredJSType instanceof JSPrimitiveLiteralType) || holder.isECMA4)) {
            LocalQuickFix insertCastFix = ValidateTypesUtil.jsInsertCastFix(declaredTypeText, expr);
            if (holder.isTypeScript) {
                if (declaredJSType.isDirectlyAssignableType(expressionJSType, context) || expressionJSType.isDirectlyAssignableType(declaredJSType, context)) {
                    fixes.add(insertCastFix);
                    fixes.add(JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)expr, declaredJSType, new TypeScriptTypeGuardFixHelper.JSTypeGuardFixData(TypeGuardSurroundKind.IfStatement, null, null, false, true)));
                    fixes.add(JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)expr, declaredJSType, new TypeScriptTypeGuardFixHelper.JSTypeGuardFixData(TypeGuardSurroundKind.Ternary, null, null, false, true)));
                } else if (declaredJSType instanceof JSPrimitiveType && !(declaredJSType instanceof JSLiteralType) && expressionJSType instanceof JSPrimitiveType) {
                    fixes.add(JSFixFactory.getInstance().jsInsertPrimitiveWrapperFix(declaredTypeText, expr));
                }
                if (expressionJSType instanceof JSUnionType) {
                    List<JSType> types2 = ((JSUnionType)expressionJSType).getTypes();
                    boolean hasNullOrUndefined = false;
                    boolean hasOurType = false;
                    boolean hasOtherTypes = false;
                    for (JSType part : types2) {
                        if (part.isEquivalentTo(declaredJSType, null, true)) {
                            hasOurType = true;
                            continue;
                        }
                        if (part instanceof JSNullType || part instanceof JSUndefinedType) {
                            hasNullOrUndefined = true;
                            continue;
                        }
                        hasOtherTypes = true;
                    }
                    if (hasNullOrUndefined && hasOurType && !hasOtherTypes) {
                        fixes.add(JSFixFactory.getInstance().createInsertTypeGuardFix((PsiElement)expr, new JSNullType(expressionJSType.getSource()), new TypeScriptTypeGuardFixHelper.JSTypeGuardFixData(TypeGuardSurroundKind.IfStatement, null, null, true, TypeScriptTypeGuardFixHelper.canSimplifyNullCheck(Collections.singletonList(declaredJSType)))));
                    }
                }
            } else {
                fixes.add(insertCastFix);
            }
        }
        if (holder != null && holder.isTypeScript && expr instanceof JSObjectLiteralExpression && !(declaredJSType instanceof JSPrimitiveType)) {
            if (declaredJSType.asRecordType().getProperties().stream().anyMatch(p -> p.isOptional())) {
                fixes.add(JSFixFactory.getInstance().createImplementMembersFix(expr, true));
            }
            fixes.add(JSFixFactory.getInstance().createImplementMembersFix(expr, false));
        }
        if (expressionJSType instanceof JSGenericTypeImpl && JSTypeUtils.isExactlyPromiseLikeType(expressionJSType) && (promiseArg = JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)expressionJSType, t -> true, false)) != null && declaredJSType.isDirectlyAssignableType(promiseArg, context)) {
            fixes.add(JSFixFactory.getInstance().createInsertAwaitFix(expr, false));
        }
        ContainerUtil.addIfNotNull(fixes, (Object)ValidateTypesUtil.tryCreateInheritanceFix(declaredTypeText, expressionType, (PsiElement)expr));
        boolean hasTypes = DialectDetector.hasFeature(elementToChangeTypeOf, JSLanguageFeature.TYPES);
        if (elementToChangeTypeOf instanceof JSVariable) {
            if (expressionJSType instanceof JSVoidType) {
                ArrayList<LocalQuickFix> arrayList = fixes;
                if (arrayList == null) {
                    JSTypeChecker.$$$reportNull$$$0(9);
                }
                return arrayList;
            }
            JSVariable variable = (JSVariable)elementToChangeTypeOf;
            boolean hasJSDoc = variable.hasJSDoc();
            if (elementToChangeTypeOf instanceof JSParameter) {
                JSParameter parameter = (JSParameter)elementToChangeTypeOf;
                JSFunction function2 = parameter.getDeclaringFunction();
                if (function2 != null) {
                    boolean bl = hasJSDoc = hasJSDoc || function2.hasJSDoc();
                    if (hasTypes) {
                        if (expr.getParent() instanceof JSArgumentList) {
                            fixes.add(JSFixFactory.getInstance().changeSignatureFix(function2, (JSArgumentList)expr.getParent()));
                        } else {
                            fixes.add(JSTypeChecker.changeSignatureForSingleParameterFix(function2, parameter.getName(), expressionType));
                        }
                    }
                }
            } else if (hasTypes) {
                fixes.add(ValidateTypesUtil.changeTypeFix((JSNamedElement)variable, expressionType, "javascript.fix.change.type"));
            }
            if (!hasTypes && declaredJSType.getSource().isStrict() && hasJSDoc) {
                fixes.add((LocalQuickFix)new ChangeJSDocTypeFix((JSNamedElement)((JSVariable)elementToChangeTypeOf), expressionJSType));
            }
        } else if (elementToChangeTypeOf instanceof JSFunction) {
            JSFunction function3 = (JSFunction)elementToChangeTypeOf;
            JSType typeToUse = TypeFromUsageDetector.getReturnTypeInContext(expressionJSType, null, null, function3);
            if (hasTypes) {
                if (JSInheritanceUtil.participatesInMemberHierarchy((JSQualifiedNamedElement)(function3.getParent() instanceof JSField ? (JSField)function3.getParent() : function3))) {
                    fixes.add(JSFixFactory.getInstance().changeSignatureFix(function3, Collections.emptyMap(), expressionType));
                } else {
                    fixes.add(ValidateTypesUtil.changeTypeFix((JSNamedElement)function3, JSTypeChecker.formatTypeForFix(typeToUse, holder), "javascript.fix.set.method.return.type"));
                }
            } else if (function3.hasJSDoc()) {
                fixes.add((LocalQuickFix)new ChangeJSDocTypeFix((JSNamedElement)function3, typeToUse));
            }
        }
        ArrayList<LocalQuickFix> arrayList = fixes;
        if (arrayList == null) {
            JSTypeChecker.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    public boolean checkExpressionIsAssignableToVariable(JSVariable p, @Nullable JSExpression expr, @PropertyKey(resourceBundle="messages.JavaScriptBundle") String problemKey) {
        if (!p.requiresTypeChecking()) {
            return true;
        }
        JSType variableType = p.getJSType();
        if (p instanceof JSOptionalOwner && ((JSOptionalOwner)p).isOptional()) {
            variableType = TypeScriptTypeGuard.wrapWithUndefined(variableType, null);
        }
        return this.checkExpressionIsAssignableToTypeAndReportError(expr, variableType, problemKey, (PsiElement)p, true);
    }

    public void checkTypesInReturnStatement(@NotNull JSElement returnStatementOrShorthandArrowFunctionExpression) {
        JSType actualType;
        JSExpression expression;
        JSType iterableComponentType;
        JSFunction fun;
        if (returnStatementOrShorthandArrowFunctionExpression == null) {
            JSTypeChecker.$$$reportNull$$$0(11);
        }
        if ((fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)returnStatementOrShorthandArrowFunctionExpression, JSFunction.class)) == null) {
            return;
        }
        JSType returnType = JSFunctionImpl.evaluateReturnTypeFromHierarchy((JSFunctionItem)fun);
        if (returnType == null) {
            return;
        }
        DialectOptionHolder dialectOptionHolder = DialectDetector.dialectOfElement((PsiElement)fun);
        if (dialectOptionHolder != null && !dialectOptionHolder.hasFeature(JSLanguageFeature.TYPES) && JSDocumentationUtils.findFunctionComment(fun) == null) {
            return;
        }
        if (fun.isGenerator() && (iterableComponentType = JSTypeUtils.getIterableComponentType(returnType)) != null) {
            returnType = iterableComponentType;
        }
        if (fun.isAsync()) {
            returnType = this.getAsyncFunctionReturnTypeForValidation(fun, returnType);
        }
        if (returnStatementOrShorthandArrowFunctionExpression instanceof JSReturnStatement) {
            expression = ((JSReturnStatement)returnStatementOrShorthandArrowFunctionExpression).getExpression();
            if (expression == null) {
                this.checkEmptyReturnStatement((JSReturnStatement)returnStatementOrShorthandArrowFunctionExpression, fun, returnType);
                return;
            }
        } else {
            expression = (JSExpression)returnStatementOrShorthandArrowFunctionExpression;
        }
        if (returnType instanceof JSVoidType && (actualType = JSResolveUtil.getExpressionJSType(expression)) != null && !(actualType instanceof JSVoidType)) {
            this.registerProblem((PsiElement)returnStatementOrShorthandArrowFunctionExpression, JavaScriptBundle.message((String)"javascript.cannot.return.expression.from.function.with.void.result.type", (Object[])new Object[0]), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)returnStatementOrShorthandArrowFunctionExpression), ValidateTypesUtil.removeASTNodeFix((PsiElement)expression, "javascript.cannot.return.expression.from.function.with.void.result.type.fix"), ValidateTypesUtil.changeTypeFix((JSNamedElement)fun, actualType.getTypeText(JSType.TypeTextFormat.CODE), "javascript.fix.set.method.return.type"));
            return;
        }
        this.checkExpressionIsAssignableToTypeAndReportError(expression, returnType, "javascript.returned.expression.type.mismatch", (PsiElement)fun, true);
    }

    private void checkEmptyReturnStatement(@NotNull JSReturnStatement node, @NotNull JSFunction function2, @NotNull JSType returnType) {
        if (node == null) {
            JSTypeChecker.$$$reportNull$$$0(12);
        }
        if (function2 == null) {
            JSTypeChecker.$$$reportNull$$$0(13);
        }
        if (returnType == null) {
            JSTypeChecker.$$$reportNull$$$0(14);
        }
        if (!ValidateTypesUtil.emptyReturnIsAcceptable(function2, returnType)) {
            String message = JavaScriptBundle.message((String)"javascript.validation.message.return.value.of.type.is.required", (Object[])new Object[]{returnType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)});
            ProblemHighlightType highlightType = ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node);
            this.registerProblem((PsiElement)node, message, highlightType, new LocalQuickFix[0]);
        }
    }

    @NotNull
    protected JSType getAsyncFunctionReturnTypeForValidation(@NotNull JSFunction function2, @NotNull JSType declaredType) {
        if (function2 == null) {
            JSTypeChecker.$$$reportNull$$$0(15);
        }
        if (declaredType == null) {
            JSTypeChecker.$$$reportNull$$$0(16);
        }
        declaredType = JSTypeUtils.getValuableType(declaredType);
        JSType componentType = JSTypeUtils.getPromiseComponentTypeOrNull(declaredType);
        JSTypeSource typeSource = declaredType.getSource();
        if (componentType != null) {
            JSType jSType = JSCompositeTypeFactory.createUnionType(typeSource, declaredType, componentType);
            if (jSType == null) {
                JSTypeChecker.$$$reportNull$$$0(17);
            }
            return jSType;
        }
        JSType jSType = JSCompositeTypeFactory.createUnionType(typeSource, declaredType, JSAnyType.get((PsiElement)function2, typeSource.isStrict()));
        if (jSType == null) {
            JSTypeChecker.$$$reportNull$$$0(18);
        }
        return jSType;
    }

    @NotNull
    public static String formatTypeForFix(@NotNull JSType jsType, @NotNull PsiElement context) {
        if (jsType == null) {
            JSTypeChecker.$$$reportNull$$$0(19);
        }
        if (context == null) {
            JSTypeChecker.$$$reportNull$$$0(20);
        }
        return JSTypeChecker.formatTypeForFix(jsType, DialectDetector.dialectOfElement(context));
    }

    @NotNull
    private static String formatTypeForFix(@NotNull JSType jsType, @Nullable DialectOptionHolder holder) {
        if (jsType == null) {
            JSTypeChecker.$$$reportNull$$$0(21);
        }
        if (holder != null && holder.isECMA4) {
            String string = jsType.getResolvedTypeText();
            if (string == null) {
                JSTypeChecker.$$$reportNull$$$0(22);
            }
            return string;
        }
        String string = jsType.getTypeText(JSType.TypeTextFormat.CODE);
        if (string == null) {
            JSTypeChecker.$$$reportNull$$$0(23);
        }
        return string;
    }

    public void checkTypesInForIn(@NotNull JSForInStatement node) {
        if (node == null) {
            JSTypeChecker.$$$reportNull$$$0(24);
        }
    }

    @NotNull
    private static AssignableInfoData buildAssignableErrorMessage(@NotNull JSExpression expression, @NotNull JSType jsType, @NotNull JSType expressionType, @Nullable DialectOptionHolder holder, @NotNull String problemKey, @Nullable ProcessingContext context) {
        if (expression == null) {
            JSTypeChecker.$$$reportNull$$$0(25);
        }
        if (jsType == null) {
            JSTypeChecker.$$$reportNull$$$0(26);
        }
        if (expressionType == null) {
            JSTypeChecker.$$$reportNull$$$0(27);
        }
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(28);
        }
        Project project = expression.getProject();
        String jsTypeText = jsType.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        String expressionTypeText = expressionType.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        String message = JavaScriptBundle.message((String)problemKey, (Object[])new Object[]{jsTypeText, expressionTypeText});
        if (holder == null || holder.isECMA4 || holder.isTypeScript && TypeScriptCompilerSettings.getSettings(project).useService() && !ApplicationManager.getApplication().isUnitTestMode() || jsType.isJavaScript() && expressionType.isJavaScript()) {
            return new AssignableInfoData(message);
        }
        ProcessingContext newContext = context == null ? new ProcessingContext() : JSTypeBaseImpl.copyProcessingContextWithoutComparingCache(context);
        JSTypeAssignableErrorMessage.startTracking((ProcessingContext)newContext);
        newContext.put(JSTypeComparingContextService.TYPE_COMPARATOR, (Object)new JSTypeComparingCache());
        if (JSResolveUtil.isAssignableJSType(jsType, expressionType, newContext)) {
            Logger.getInstance(JSTypeChecker.class).error("Comparing returned different value without cache in " + expression.getContainingFile().getVirtualFile().getPath() + ": " + jsTypeText + ", " + expressionTypeText);
            return new AssignableInfoData(message);
        }
        List texts = (List)newContext.get(JSTypeAssignableErrorMessage.NOT_ASSIGNABLE_CHAIN_KEY);
        if (texts == null || texts.isEmpty()) {
            return new AssignableInfoData(message);
        }
        String tautologyMessage = JavaScriptBundle.message((String)"javascript.type.is.not.assignable.to.type", (Object[])new Object[]{jsTypeText, expressionTypeText});
        Stream<String> distinct = ContainerUtil.reverse((List)texts).stream().limit(3L).map(el -> el.getText()).filter(s -> !s.equals(tautologyMessage)).distinct();
        StringBuilder result2 = new StringBuilder();
        result2.append("<html>");
        result2.append(message);
        StringBuilder separator = new StringBuilder("<br>");
        if (texts.size() > 4) {
            result2.append((CharSequence)separator);
            result2.append("...");
        }
        String spaces = "&nbsp;&nbsp;";
        distinct.forEach(el -> {
            separator.append(spaces);
            result2.append((CharSequence)separator);
            result2.append(XmlUtil.escape((String)el));
        });
        result2.append("</html>");
        SmartList fixes = new SmartList();
        for (JSTypeAssignableErrorMessage text : texts) {
            Pair keyAndArgs = text.getProblemKeyAndArgs();
            if (keyAndArgs == null) continue;
            JSTypeChecker.addFixesByInfoKey(jsType, expression, (List<LocalQuickFix>)fixes, (String)keyAndArgs.first, (String[])keyAndArgs.second);
        }
        return new AssignableInfoData(result2.toString(), texts.size() == 1 ? ((JSTypeAssignableErrorMessage)texts.get(0)).getCustomErrorRange((PsiElement)expression) : null, (List)fixes);
    }

    private static void addFixesByInfoKey(@NotNull JSType jsType, @NotNull JSExpression expression, List<LocalQuickFix> fixes, @PropertyKey(resourceBundle="messages.JavaScriptBundle") String key, String[] second) {
        if (jsType == null) {
            JSTypeChecker.$$$reportNull$$$0(29);
        }
        if (expression == null) {
            JSTypeChecker.$$$reportNull$$$0(30);
        }
        switch (key) {
            case "javascript.known.props.only": {
                if (!(expression instanceof JSObjectLiteralExpression) || second.length != 1) {
                    return;
                }
                String desc = second[0];
                List names = ContainerUtil.map((Collection)StringUtil.split((String)desc, (String)","), s -> StringUtil.unquoteString((String)s.trim(), (char)'\''));
                JSType valuableType = JSTypeUtils.getValuableType(jsType);
                List<JSType> allTypes = valuableType instanceof JSUnionOrIntersectionType ? ((JSUnionOrIntersectionType)valuableType).getTypes() : Collections.singletonList(valuableType);
                for (JSType type : allTypes) {
                    Collection<JSClass> classes;
                    if (type instanceof JSGenericTypeImpl) {
                        type = ((JSGenericTypeImpl)type).getType();
                    }
                    if (!(type instanceof JSResolvableType) || (classes = ((JSResolvableType)type).resolveType().getDeclarationsOfType(JSClass.class)).size() != 1 || classes.iterator().next() instanceof TypeScriptTypeAlias) continue;
                    fixes.add(JSFixFactory.getInstance().createAddTypeMembersByLiteralFix((JSObjectLiteralExpression)expression, names, classes.iterator().next()));
                }
                break;
            }
        }
    }

    private static LocalQuickFix changeSignatureForSingleParameterFix(JSFunction function2, String name, String type) {
        Map parameters = ContainerUtil.newHashMap((Pair)Pair.create((Object)name, (Object)type), (Pair[])new Pair[0]);
        return JSFixFactory.getInstance().changeSignatureFix(function2, parameters, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemKey";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredJSType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionJSType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSTypeChecker";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatementOrShorthandArrowFunctionExpression";
                break;
            }
            case 12: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredType";
                break;
            }
            case 19: 
            case 21: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSTypeChecker";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsyncFunctionReturnTypeForValidation";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTypeForFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkExpressionIsAssignableToTypeAndReportError";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "skipByExpressionType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 22: 
            case 23: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkTypesInReturnStatement";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkEmptyReturnStatement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAsyncFunctionReturnTypeForValidation";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "formatTypeForFix";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkTypesInForIn";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "buildAssignableErrorMessage";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addFixesByInfoKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AssignableInfoData {
        @NotNull
        final String message;
        @Nullable
        final TextRange range;
        @NotNull
        final List<LocalQuickFix> fixes;

        private AssignableInfoData(@NotNull String message) {
            if (message == null) {
                AssignableInfoData.$$$reportNull$$$0(0);
            }
            this(message, (TextRange)null);
        }

        private AssignableInfoData(@NotNull String message, @Nullable TextRange range) {
            if (message == null) {
                AssignableInfoData.$$$reportNull$$$0(1);
            }
            this(message, range, Collections.emptyList());
        }

        private AssignableInfoData(@NotNull String message, @Nullable TextRange range, @NotNull List<LocalQuickFix> fixes) {
            if (message == null) {
                AssignableInfoData.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                AssignableInfoData.$$$reportNull$$$0(3);
            }
            this.message = message;
            this.range = range;
            this.fixes = fixes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fixes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/validation/JSTypeChecker$AssignableInfoData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

