/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.dialects.ECMAL4LanguageDialect;
import com.intellij.lang.javascript.dialects.TypeScriptJSXLanguageDialect;
import com.intellij.lang.javascript.dialects.TypeScriptLanguageDialect;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.impl.JSDefinitionExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSIndexedPropertyAccessExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSDefinitionExpressionStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSDefinitionExpressionStubImpl;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDefinitionExpressionElementType
extends JSStubElementType<JSDefinitionExpressionStub, JSDefinitionExpression> {
    public JSDefinitionExpressionElementType() {
        super("DEFINITION_EXPRESSION");
    }

    @NotNull
    public JSDefinitionExpressionStub createStub(@NotNull JSDefinitionExpression psi, StubElement parentStub) {
        if (psi == null) {
            JSDefinitionExpressionElementType.$$$reportNull$$$0(0);
        }
        return new JSDefinitionExpressionStubImpl(psi, parentStub);
    }

    @Nullable
    public PsiElement construct(ASTNode node) {
        return new JSDefinitionExpressionImpl(node);
    }

    @NotNull
    public JSDefinitionExpressionStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            JSDefinitionExpressionElementType.$$$reportNull$$$0(1);
        }
        return new JSDefinitionExpressionStubImpl(dataStream, parentStub);
    }

    public boolean shouldCreateStub(ASTNode node) {
        ASTNode expressionNode = JSDefinitionExpressionImpl.getExpressionNode(node);
        if (expressionNode == null) {
            return false;
        }
        if (expressionNode.getElementType() == JSElementTypes.REFERENCE_EXPRESSION) {
            Language language;
            ASTNode nameElement = JSReferenceExpressionImpl.getNameElement(expressionNode);
            ASTNode qualifierNode = JSReferenceExpressionImpl.getQualifierNode(expressionNode);
            if (qualifierNode == null && nameElement != null && ((language = JSTreeUtil.getLanguage(node)) instanceof ECMAL4LanguageDialect || JSTreeUtil.definedInScopeAndUp(nameElement.getText(), node) || JSResolveUtil.hasUseStrictPragmaUp(node))) {
                return false;
            }
            return qualifierNode == null || qualifierNode.getElementType() != JSElementTypes.THIS_EXPRESSION || !((language = JSTreeUtil.getLanguage(node)) instanceof TypeScriptLanguageDialect) && !(language instanceof TypeScriptJSXLanguageDialect);
        }
        if (expressionNode.getElementType() == JSElementTypes.INDEXED_PROPERTY_ACCESS_EXPRESSION) {
            ASTNode index = JSIndexedPropertyAccessExpressionImpl.getIndexExpression(expressionNode);
            return index != null && (index.getElementType() == JSStubElementTypes.LITERAL_EXPRESSION && JSLiteralExpressionImpl.isQuotedLiteral(index) || index.getElementType() == JSElementTypes.REFERENCE_EXPRESSION);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/types/JSDefinitionExpressionElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createStub";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "deserialize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

