/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.settings;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSApplicationSettings {
    @Deprecated
    private static final String TS_NODE_MODULES_RESOLUTION_PROPERTY = "typescript.use.directory.import.node";
    @Deprecated
    private static final String MERGE_IMPORTS = "typescript.merge.auto.import";
    @Deprecated
    private static final String USE_CONFIG = "typescript.use.config.auto.import";
    private static final String USE_TYPESCRIPT_AUTO_IMPORT_PROPERTY = "typescript.show.auto.import";
    private static final String USE_JAVASCRIPT_AUTO_IMPORT_PROPERTY = "es6.show.auto.import";
    private static final String JS_ONLY_TYPE_BASED_COMPLETION = "js.only.type.based.completion";
    private static final boolean JS_ONLY_TYPE_BASED_COMPLETION_DEFAULT = false;
    private static final String USE_JAVASCRIPT_VAR_NAMES_COMPLETION = "js.var.names.completion";
    private static final String USE_JAVASCRIPT_FIELD_NAMES_COMPLETION = "js.field.names.completion";
    private static final String USE_JAVASCRIPT_VAR_NAMES_COMPLETION_KIND = "js.var.names.completion.kind";
    private static final String USE_JAVASCRIPT_OVERRIDES_COMPLETION = "js.overrides.completion";
    private static final String USE_JAVASCRIPT_OPT_CHAIN_COMPLETION = "js.opt.chain.completion";
    private static final String TS_ADD_IMPORTS_ON_THE_FLY_PROPERTY = "typescript.add.unambiguous.imports.on.the.fly";
    private static final String TS_ADD_IMPORTS_ON_COMPLETION_PROPERTY = "typescript.add.imports.on.the.completion";
    private static final String TS_SHOW_IMPORT_POPUP_PROPERTY = "typescript.show.imports.popup";
    private static final boolean TS_ADD_IMPORTS_ON_THE_FLY_DEFAULT_VALUE = false;
    private static final boolean TS_ADD_IMPORTS_ON_COMPLETION_DEFAULT_VALUE = true;
    private static final boolean TS_SHOW_IMPORT_POPUP_DEFAULT_VALUE = true;

    public static JSApplicationSettings getInstance() {
        return (JSApplicationSettings)ServiceManager.getService(JSApplicationSettings.class);
    }

    public boolean isOnlyTypeBasedCompletion() {
        return PropertiesComponent.getInstance().getBoolean(JS_ONLY_TYPE_BASED_COMPLETION, false);
    }

    public void setOnlyTypeBasedCompletion(boolean onlyTypeBasedCompletion) {
        PropertiesComponent.getInstance().setValue(JS_ONLY_TYPE_BASED_COMPLETION, onlyTypeBasedCompletion, false);
    }

    public boolean isUseVarNamesCompletion() {
        return PropertiesComponent.getInstance().getBoolean(USE_JAVASCRIPT_VAR_NAMES_COMPLETION, true);
    }

    public void setUseVarNamesCompletion(boolean use) {
        PropertiesComponent.getInstance().setValue(USE_JAVASCRIPT_VAR_NAMES_COMPLETION, Boolean.toString(use));
    }

    public boolean isUseFieldNamesCompletion() {
        return PropertiesComponent.getInstance().getBoolean(USE_JAVASCRIPT_FIELD_NAMES_COMPLETION, false);
    }

    public void setUseFieldNamesCompletion(boolean use) {
        PropertiesComponent.getInstance().setValue(USE_JAVASCRIPT_FIELD_NAMES_COMPLETION, Boolean.toString(use));
    }

    public VariableCompletionKind getVariableCompletionKind() {
        return Enum.valueOf(VariableCompletionKind.class, PropertiesComponent.getInstance().getValue(USE_JAVASCRIPT_VAR_NAMES_COMPLETION_KIND, VariableCompletionKind.NAMES_ONLY.name()));
    }

    public void setVariableCompletionKind(VariableCompletionKind kind) {
        PropertiesComponent.getInstance().setValue(USE_JAVASCRIPT_VAR_NAMES_COMPLETION_KIND, kind.name());
    }

    public boolean isUseOverridesCompletion() {
        return PropertiesComponent.getInstance().getBoolean(USE_JAVASCRIPT_OVERRIDES_COMPLETION, true);
    }

    public void setUseOverridesCompletion(boolean use) {
        PropertiesComponent.getInstance().setValue(USE_JAVASCRIPT_OVERRIDES_COMPLETION, Boolean.toString(use));
    }

    public boolean isOptChainCompletion() {
        return PropertiesComponent.getInstance().getBoolean(USE_JAVASCRIPT_OPT_CHAIN_COMPLETION, true);
    }

    public void setOptChainCompletion(boolean use) {
        PropertiesComponent.getInstance().setValue(USE_JAVASCRIPT_OPT_CHAIN_COMPLETION, Boolean.toString(use));
    }

    public boolean isUseTypeScriptAutoImport() {
        return PropertiesComponent.getInstance().getBoolean(USE_TYPESCRIPT_AUTO_IMPORT_PROPERTY, true);
    }

    public boolean isUseJavaScriptAutoImport() {
        return PropertiesComponent.getInstance().getBoolean(USE_JAVASCRIPT_AUTO_IMPORT_PROPERTY, true);
    }

    public void setUseTypeScriptAutoImport(boolean show) {
        PropertiesComponent.getInstance().setValue(USE_TYPESCRIPT_AUTO_IMPORT_PROPERTY, Boolean.toString(show));
    }

    public void setUseJavaScriptAutoImport(boolean show) {
        PropertiesComponent.getInstance().setValue(USE_JAVASCRIPT_AUTO_IMPORT_PROPERTY, Boolean.toString(show));
    }

    public boolean hasTSUnambiguousImportsOnTheFly(@NotNull Project project) {
        if (project == null) {
            JSApplicationSettings.$$$reportNull$$$0(0);
        }
        return PropertiesComponent.getInstance((Project)project).getBoolean(TS_ADD_IMPORTS_ON_THE_FLY_PROPERTY, false);
    }

    public boolean hasTSImportCompletion(@NotNull Project project) {
        if (project == null) {
            JSApplicationSettings.$$$reportNull$$$0(1);
        }
        return PropertiesComponent.getInstance((Project)project).getBoolean(TS_ADD_IMPORTS_ON_COMPLETION_PROPERTY, true);
    }

    public void setTSImportCompletion(@NotNull Project project, boolean value) {
        if (project == null) {
            JSApplicationSettings.$$$reportNull$$$0(2);
        }
        PropertiesComponent.getInstance((Project)project).setValue(TS_ADD_IMPORTS_ON_COMPLETION_PROPERTY, value, true);
    }

    public boolean showTSImportPopup(@NotNull Project project) {
        if (project == null) {
            JSApplicationSettings.$$$reportNull$$$0(3);
        }
        return PropertiesComponent.getInstance((Project)project).getBoolean(TS_SHOW_IMPORT_POPUP_PROPERTY, true);
    }

    public void setShowTSImportPopup(@NotNull Project project, boolean value) {
        if (project == null) {
            JSApplicationSettings.$$$reportNull$$$0(4);
        }
        PropertiesComponent.getInstance((Project)project).setValue(TS_SHOW_IMPORT_POPUP_PROPERTY, value, true);
    }

    public void setTSAddUnambiguousImportsOnTheFly(@NotNull Project project, boolean value) {
        if (project == null) {
            JSApplicationSettings.$$$reportNull$$$0(5);
        }
        PropertiesComponent.getInstance((Project)project).setValue(TS_ADD_IMPORTS_ON_THE_FLY_PROPERTY, value, false);
    }

    public boolean hasTSImportCompletionEffective(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        return this.isUseTypeScriptAutoImport() && this.hasTSImportCompletion(project);
    }

    public boolean haTSUnambiguousImportsOnTheFlyEffective(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        return this.isUseTypeScriptAutoImport() && this.hasTSUnambiguousImportsOnTheFly(project);
    }

    public boolean showTSImportPopupEffective(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        return this.isUseTypeScriptAutoImport() && this.showTSImportPopup(project);
    }

    @Deprecated
    public boolean isMergeImports() {
        return PropertiesComponent.getInstance().getBoolean(MERGE_IMPORTS, true);
    }

    @Deprecated
    public boolean isUseAbsoluteConfigPath() {
        return PropertiesComponent.getInstance().getBoolean(USE_CONFIG, false);
    }

    @Deprecated
    public boolean isUseNodeModulesResolutionImports() {
        return PropertiesComponent.getInstance().getBoolean(TS_NODE_MODULES_RESOLUTION_PROPERTY, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/lang/javascript/settings/JSApplicationSettings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasTSUnambiguousImportsOnTheFly";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasTSImportCompletion";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setTSImportCompletion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showTSImportPopup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setShowTSImportPopup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setTSAddUnambiguousImportsOnTheFly";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum VariableCompletionKind {
        NAMES_ONLY,
        TYPES_FOR_PARAMS,
        TYPES_FOR_PARAMS_FIELDS,
        TYPES_EVERYWHERE_EXCEPT_FIELDS,
        TYPES_EVERYWHERE;


        public String toString() {
            switch (this) {
                case NAMES_ONLY: {
                    return JavaScriptBundle.message((String)"settings.javascript.var.names.completion.names.only", (Object[])new Object[0]);
                }
                case TYPES_FOR_PARAMS: {
                    return JavaScriptBundle.message((String)"settings.javascript.var.names.completion.types.for.params", (Object[])new Object[0]);
                }
                case TYPES_FOR_PARAMS_FIELDS: {
                    return JavaScriptBundle.message((String)"settings.javascript.var.names.completion.types.for.params.fields", (Object[])new Object[0]);
                }
                case TYPES_EVERYWHERE_EXCEPT_FIELDS: {
                    return JavaScriptBundle.message((String)"settings.javascript.var.names.completion.types.except.fields", (Object[])new Object[0]);
                }
                case TYPES_EVERYWHERE: {
                    return JavaScriptBundle.message((String)"settings.javascript.var.names.completion.types.everywhere", (Object[])new Object[0]);
                }
            }
            return "UNKNOWN";
        }

        public boolean allowsFields() {
            return this == TYPES_FOR_PARAMS_FIELDS || this == TYPES_EVERYWHERE || this == NAMES_ONLY || this == TYPES_FOR_PARAMS;
        }
    }
}

