/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.memberPushDown;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.presentable.Capitalization;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.refactoring.BaseJSRefactoringHandler;
import com.intellij.lang.javascript.refactoring.memberPushDown.JSPushDownDialog;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JSPushDownHandler
extends BaseJSRefactoringHandler {
    public JSPushDownHandler() {
        super(JSPushDownHandler.getRefactoringName(), JSPushDownHandler.getCannotRefactorReason());
    }

    @Override
    public boolean isEnabledOnElements(PsiElement[] elements) {
        return super.isEnabledOnElements(elements) && JSPushDownHandler.doCheckEcma(elements[0]);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            JSPushDownHandler.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            JSPushDownHandler.$$$reportNull$$$0(1);
        }
        if (elements.length != 1) {
            return;
        }
        PsiElement element = elements[0];
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (!this.checkEcma(element, editor)) {
            return;
        }
        JSClass aClass = JSPushDownHandler.getClass(element);
        if (aClass == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JSPushDownHandler.getCannotRefactorReason());
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JSPushDownHandler.getRefactoringName(), null);
            return;
        }
        Collection<JSClass> subClasses = JSInheritanceUtil.findDirectSubClasses(aClass, false);
        if (subClasses.isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaScriptBundle.message((String)"class.does.not.have.inheritors.in.current.project", (Object[])new Object[]{new JSNamedElementPresenter((PsiElement)aClass, Capitalization.UpperCase).describeWithQualifiedName()}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JSPushDownHandler.getRefactoringName(), null);
            return;
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)aClass, editor, JSPushDownHandler.getRefactoringName())) {
            return;
        }
        ArrayList<JSMemberInfo> memberInfos = new ArrayList<JSMemberInfo>();
        JSMemberInfo.extractClassMembers(aClass, memberInfos, (MemberInfoBase.Filter<? super JSAttributeListOwner>)new MemberInfoBase.EmptyFilter());
        if (element instanceof JSElement) {
            for (JSMemberInfo memberInfo : memberInfos) {
                memberInfo.setChecked(Collections.singletonList((JSElement)element));
            }
        }
        JSPushDownDialog dialog = new JSPushDownDialog(project, memberInfos, aClass, subClasses);
        dialog.show();
    }

    private static String getCannotRefactorReason() {
        return RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.push.members.from");
    }

    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"push.members.down.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/refactoring/memberPushDown/JSPushDownHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

