/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.evaluable;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReturnedExpressionType
extends JSEvaluableOnlyTypeBase
implements JSEvaluableOnlyType {
    private final int myReturnedExpressionIndex;

    public JSReturnedExpressionType(int returnedExpressionIndex, @NotNull JSTypeSource source) {
        if (source == null) {
            JSReturnedExpressionType.$$$reportNull$$$0(0);
        }
        super(source);
        this.myReturnedExpressionIndex = returnedExpressionIndex;
    }

    public JSReturnedExpressionType(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSReturnedExpressionType.$$$reportNull$$$0(1);
        }
        if (inputStream == null) {
            JSReturnedExpressionType.$$$reportNull$$$0(2);
        }
        super(source);
        this.myReturnedExpressionIndex = JSTypeSerializer.readInt(inputStream);
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSReturnedExpressionType.$$$reportNull$$$0(3);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeInt(this.myReturnedExpressionIndex, outputStream);
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return Objects.hash(this.getSourceElement(), this.myReturnedExpressionIndex);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            JSReturnedExpressionType.$$$reportNull$$$0(4);
        }
        return Objects.equals(this.getSourceElement(), type.getSourceElement()) && this.myReturnedExpressionIndex == ((JSReturnedExpressionType)type).myReturnedExpressionIndex;
    }

    @Override
    @NotNull
    protected JSReturnedExpressionType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSReturnedExpressionType.$$$reportNull$$$0(5);
        }
        return new JSReturnedExpressionType(this.myReturnedExpressionIndex, source);
    }

    @Nullable
    public JSExpression findAssociatedExpression() {
        PsiElement sourceElement = this.getSourceElement();
        if (!(sourceElement instanceof JSFunction)) {
            String className2 = sourceElement == null ? null : sourceElement.getClass().getSimpleName();
            Logger.getInstance(JSReturnedExpressionType.class).error("Expected function, was " + className2);
            return null;
        }
        return JSStubBasedPsiTreeUtil.findReturnedExpressions((JSFunction)sourceElement).stream().filter(JSReturnedExpressionType::isCountableReturnedExpression).skip(this.myReturnedExpressionIndex).findFirst().orElse(null);
    }

    public static boolean isCountableReturnedExpression(@NotNull JSExpression returnedExpression) {
        PsiElement context;
        if (returnedExpression == null) {
            JSReturnedExpressionType.$$$reportNull$$$0(6);
        }
        if ((context = returnedExpression.getContext()) instanceof JSParenthesizedExpression) {
            context = JSUtils.getParentSkipParentheses(context);
        }
        return JSStubBasedPsiTreeUtil.isStubBased((PsiElement)returnedExpression) && (context instanceof JSReturnStatement || context instanceof JSFunctionExpression) && JSStubBasedPsiTreeUtil.isStubBased(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnedExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSReturnedExpressionType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "copyWithNewSource";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isCountableReturnedExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

