/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionReturnWrapperType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGeneratorReturnType
extends JSFunctionReturnWrapperType {
    @Nullable
    private JSType myTypeForYield;
    private final boolean myIsAsync;
    @Nullable
    private final JSType myReturnType;

    public JSGeneratorReturnType(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(0);
        }
        if (inputStream == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(1);
        }
        super(source, inputStream);
        this.myIsAsync = JSTypeSerializer.readBoolean(inputStream);
        this.myReturnType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source, inputStream);
        this.myTypeForYield = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source, inputStream);
    }

    public JSGeneratorReturnType(@NotNull JSTypeSource typeSource, @Nullable JSType innerType, @Nullable JSType returnType, @Nullable JSType typeForYield, boolean isAsync) {
        if (typeSource == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(2);
        }
        super(typeSource, innerType instanceof JSVoidType ? new TypeScriptNeverJSTypeImpl(innerType.getSource()) : innerType);
        this.myTypeForYield = typeForYield;
        this.myIsAsync = isAsync;
        this.myReturnType = returnType;
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(3);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myIsAsync, outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.myReturnType, outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.myTypeForYield, outputStream);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        JSType yieldTypeTransformed;
        if (childTransform == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(4);
        }
        JSType innerTransformed = this.myInnerType == null ? null : (JSType)childTransform.fun((Object)this.myInnerType);
        JSType returnTransformed = this.myReturnType == null ? null : (JSType)childTransform.fun((Object)this.myReturnType);
        JSType jSType = yieldTypeTransformed = this.myTypeForYield == null ? null : (JSType)childTransform.fun((Object)this.myTypeForYield);
        if (innerTransformed == this.myInnerType && returnTransformed == this.myReturnType && yieldTypeTransformed == this.myTypeForYield) {
            JSGeneratorReturnType jSGeneratorReturnType = this;
            if (jSGeneratorReturnType == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(5);
            }
            return jSGeneratorReturnType;
        }
        return new JSGeneratorReturnType(this.getSource(), innerTransformed, returnTransformed, yieldTypeTransformed, this.myIsAsync);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(6);
        }
        return super.isEquivalentToWithSameClass(type, context, allowResolve) && JSGeneratorReturnType.areEquivalent(this.myReturnType, ((JSGeneratorReturnType)type).myReturnType, context, allowResolve) && JSGeneratorReturnType.areEquivalent(this.myTypeForYield, ((JSGeneratorReturnType)type).myTypeForYield, context, allowResolve);
    }

    @Override
    protected JSType createInstance(@NotNull JSTypeSource typeSource, @Nullable JSType innerType) {
        if (typeSource == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(7);
        }
        return new JSGeneratorReturnType(typeSource, innerType, this.myReturnType, this.myTypeForYield, this.myIsAsync);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(8);
        }
        if (this.myInnerType != null) {
            this.myInnerType.accept(visitor);
        }
        if (this.myReturnType != null) {
            this.myReturnType.accept(visitor);
        }
        if (this.myTypeForYield != null) {
            this.myTypeForYield.accept(visitor);
        }
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return Objects.hash(this.myIsAsync, this.myInnerType == null ? 0 : this.myInnerType.resolvedHashCode(), this.myReturnType == null ? 0 : this.myReturnType.resolvedHashCode(), this.myTypeForYield == null ? 0 : this.myTypeForYield.resolvedHashCode());
    }

    @Override
    protected String getPrefix() {
        return "iret";
    }

    @Override
    protected JSType doSubstitute(@Nullable JSType type, @NotNull JSTypeSource source, JSTypeSubstitutionContext context) {
        JSType expandedReturn;
        if (source == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(9);
        }
        String typeName = this.getTypeName(source);
        JSType iterableType = JSNamedTypeFactory.createType(typeName, source, JSContext.INSTANCE);
        JSType expandedType = type == null ? null : context.substituteNested(type);
        JSType jSType = expandedReturn = this.myReturnType == null ? null : context.substituteNested(this.myReturnType);
        if (typeName == "AsyncIterableIterator" || typeName == "IterableIterator") {
            return new JSGenericTypeImpl(source, iterableType, JSGeneratorReturnType.combineObsoleteGeneratorType(source, expandedType, expandedReturn));
        }
        if (expandedType == null) {
            JSSimpleTypeBaseImpl jSSimpleTypeBaseImpl = expandedType = source.isTypeScript() ? new TypeScriptNeverJSTypeImpl(source) : JSAnyType.get(source);
        }
        if (expandedReturn == null) {
            expandedReturn = new JSVoidType(source);
        }
        JSType expandedYield = this.expandYieldType(source, context);
        return new JSGenericTypeImpl(source, iterableType, Arrays.asList(JSTypeUtils.widenLiteralTypes(expandedType), JSTypeUtils.widenLiteralTypes(expandedReturn), expandedYield));
    }

    @NotNull
    private JSType expandYieldType(@NotNull JSTypeSource source, JSTypeSubstitutionContext context) {
        JSType expandedYield;
        if (source == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(10);
        }
        JSType jSType = this.myTypeForYield == null ? null : (expandedYield = this.myTypeForYield instanceof JSIntersectionType ? JSGeneratorReturnType.filterIntersection(source, (JSIntersectionType)this.myTypeForYield, context, true) : context.substituteNested(this.myTypeForYield));
        if (expandedYield == null) {
            JSUnknownType jSUnknownType = expandedYield = source.isTypeScript() ? JSUnknownType.TS_INSTANCE : JSUnknownType.JS_INSTANCE;
        }
        if (expandedYield instanceof JSIntersectionType) {
            expandedYield = JSGeneratorReturnType.filterIntersection(source, (JSIntersectionType)expandedYield, context, false);
        }
        if (expandedYield instanceof JSAnyType) {
            expandedYield = source.isTypeScript() ? JSUnknownType.TS_INSTANCE : JSUnknownType.JS_INSTANCE;
        }
        JSType jSType2 = expandedYield;
        if (jSType2 == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(11);
        }
        return jSType2;
    }

    @NotNull
    private static JSType filterIntersection(@NotNull JSTypeSource source, JSIntersectionType expandedYield, JSTypeSubstitutionContext context, boolean substituteComponents) {
        List filtered;
        if (source == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(12);
        }
        if (ContainerUtil.equalsIdentity(filtered = expandedYield.getTypes().stream().map(t -> substituteComponents ? context.substituteNested(t) : t).filter(t -> t != null && !(t instanceof JSAnyType)).collect(Collectors.toList()), expandedYield.getTypes())) {
            JSIntersectionType jSIntersectionType = expandedYield;
            if (jSIntersectionType == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(13);
            }
            return jSIntersectionType;
        }
        JSType jSType = JSCompositeTypeFactory.createIntersectionType(filtered, source);
        if (jSType == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(14);
        }
        return jSType;
    }

    @NotNull
    private static JSType combineObsoleteGeneratorType(@NotNull JSTypeSource source, JSType expandedType, JSType expandedReturn) {
        boolean expandedIsNullOrVoid;
        if (source == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(15);
        }
        boolean bl = expandedIsNullOrVoid = expandedType == null || expandedType instanceof JSVoidType;
        if (expandedIsNullOrVoid && expandedReturn == null) {
            JSAnyType jSAnyType = JSAnyType.get(source);
            if (jSAnyType == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(16);
            }
            return jSAnyType;
        }
        if (expandedIsNullOrVoid) {
            JSType jSType = expandedReturn;
            if (jSType == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(17);
            }
            return jSType;
        }
        if (expandedReturn == null) {
            JSType jSType = expandedType;
            if (jSType == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(18);
            }
            return jSType;
        }
        JSType jSType = JSCompositeTypeImpl.getCommonType(expandedType, expandedReturn, source, true);
        if (jSType == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(19);
        }
        return jSType;
    }

    @NotNull
    private String getTypeName(JSTypeSource source) {
        PsiElement sourceElement = source.getSourceElement();
        return JSGeneratorReturnType.getGeneratorClassName(sourceElement, this.myIsAsync);
    }

    @NotNull
    public static String getGeneratorClassName(PsiElement sourceElement, boolean isAsync) {
        String defaultName;
        String string = defaultName = isAsync ? "AsyncIterableIterator" : "IterableIterator";
        if (sourceElement == null) {
            String string2 = defaultName;
            if (string2 == null) {
                JSGeneratorReturnType.$$$reportNull$$$0(20);
            }
            return string2;
        }
        JSTypeResolveResult result2 = JSImportHandler.getInstance().resolveTypeName("Generator", sourceElement);
        if (result2.hasElements() && result2.getElements().stream().anyMatch(e -> e instanceof TypeScriptTypeParameterListOwner && ((TypeScriptTypeParameterListOwner)e).getTypeParameters().length > 0)) {
            return isAsync ? "AsyncGenerator" : "Generator";
        }
        String string3 = defaultName;
        if (string3 == null) {
            JSGeneratorReturnType.$$$reportNull$$$0(21);
        }
        return string3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSGeneratorReturnType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSGeneratorReturnType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "expandYieldType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "filterIntersection";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "combineObsoleteGeneratorType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratorClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doSubstitute";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "expandYieldType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filterIntersection";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "combineObsoleteGeneratorType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

