/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAnyType
extends JSSimpleTypeBaseImpl
implements JSNamespace,
JSUtilType {
    @NotNull
    private final JSTypeSource.SourceLanguage myLanguage;
    private static final JSAnyType ourTSDeclared = new JSAnyType(JSTypeSource.SourceLanguage.TS, true);
    private static final JSAnyType ourTSEvaluated = new JSAnyType(JSTypeSource.SourceLanguage.TS, false);
    private static final JSAnyType ourJSDeclared = new JSAnyType(JSTypeSource.SourceLanguage.JS, true);
    private static final JSAnyType ourJSEvaluated = new JSAnyType(JSTypeSource.SourceLanguage.JS, false);
    private static final JSAnyType ourASDeclared = new JSAnyType(JSTypeSource.SourceLanguage.AS, true);
    private static final JSAnyType ourASEvaluated = new JSAnyType(JSTypeSource.SourceLanguage.AS, false);

    protected JSAnyType(@NotNull JSTypeSource.SourceLanguage language, boolean isStrict) {
        if (language == null) {
            JSAnyType.$$$reportNull$$$0(0);
        }
        super(new JSTypeSource(null, null, language, isStrict));
        this.myLanguage = language;
    }

    @NotNull
    public static JSAnyType deserialize(@NotNull CharacterIterator inputStream) {
        JSTypeSource.SourceLanguage language;
        if (inputStream == null) {
            JSAnyType.$$$reportNull$$$0(1);
        }
        char languageChar = inputStream.current();
        inputStream.next();
        boolean isStrict = JSTypeSerializer.readBoolean(inputStream);
        switch (languageChar) {
            case 'J': {
                language = JSTypeSource.SourceLanguage.JS;
                break;
            }
            case 'T': {
                language = JSTypeSource.SourceLanguage.TS;
                break;
            }
            case 'A': {
                language = JSTypeSource.SourceLanguage.AS;
                break;
            }
            default: {
                throw new JSTypeSerializer.JSTypeDeserializationException();
            }
        }
        return JSAnyType.getWithLanguage(language, isStrict);
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSAnyType.$$$reportNull$$$0(2);
        }
        switch (this.myLanguage) {
            case JS: {
                outputStream.append('J');
                break;
            }
            case TS: {
                outputStream.append('T');
                break;
            }
            case AS: {
                outputStream.append('A');
            }
        }
        JSTypeSerializer.writeBoolean(this.isSourceStrict(), outputStream);
    }

    @NotNull
    public static JSAnyType get(@NotNull JSTypeSource source) {
        if (source == null) {
            JSAnyType.$$$reportNull$$$0(3);
        }
        return JSAnyType.getWithLanguage(source.getLanguage(), source.isStrict());
    }

    @NotNull
    public static JSAnyType get(@Nullable PsiElement context, boolean isStrict) {
        return JSAnyType.getWithLanguage(JSTypeSourceFactory.getSourceLanguage(context), isStrict);
    }

    @NotNull
    public static JSAnyType getWithLanguage(JSTypeSource.SourceLanguage language, boolean isExplicitlyDeclared) {
        if (language == JSTypeSource.SourceLanguage.TS) {
            JSAnyType jSAnyType = isExplicitlyDeclared ? ourTSDeclared : ourTSEvaluated;
            if (jSAnyType == null) {
                JSAnyType.$$$reportNull$$$0(4);
            }
            return jSAnyType;
        }
        if (language == JSTypeSource.SourceLanguage.AS) {
            JSAnyType jSAnyType = isExplicitlyDeclared ? ourASDeclared : ourASEvaluated;
            if (jSAnyType == null) {
                JSAnyType.$$$reportNull$$$0(5);
            }
            return jSAnyType;
        }
        JSAnyType jSAnyType = isExplicitlyDeclared ? ourJSDeclared : ourJSEvaluated;
        if (jSAnyType == null) {
            JSAnyType.$$$reportNull$$$0(6);
        }
        return jSAnyType;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSAnyType.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            JSAnyType.$$$reportNull$$$0(8);
        }
        if (format == JSType.TypeTextFormat.PRESENTABLE) {
            builder.append(this.myLanguage == JSTypeSource.SourceLanguage.AS ? "*" : "any");
        } else {
            builder.append(this.myLanguage == JSTypeSource.SourceLanguage.TS ? "any" : "*");
        }
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return this.hashCode();
    }

    @Override
    public void accept(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSAnyType.$$$reportNull$$$0(9);
        }
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSAnyType.$$$reportNull$$$0(10);
        }
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSAnyType.$$$reportNull$$$0(11);
        }
        if (processingContext == null) {
            JSAnyType.$$$reportNull$$$0(12);
        }
        return true;
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSAnyType.$$$reportNull$$$0(13);
        }
        return true;
    }

    @Override
    @NotNull
    protected JSAnyType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSAnyType.$$$reportNull$$$0(14);
        }
        return JSAnyType.getWithLanguage(source.getLanguage(), source.isStrict());
    }

    @Nullable
    public JSQualifiedName getQualifiedName() {
        return null;
    }

    public boolean hasQualifiedName() {
        return false;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordType jSRecordType = this.emptyRecordType();
        if (jSRecordType == null) {
            JSAnyType.$$$reportNull$$$0(15);
        }
        return jSRecordType;
    }

    public boolean isDeclaration() {
        return false;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = JSContext.UNKNOWN;
        if (jSContext == null) {
            JSAnyType.$$$reportNull$$$0(16);
        }
        return jSContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSAnyType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSAnyType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWithLanguage";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

