/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.context;

import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeInfoOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyDestructuringPropertyElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyElvisContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyIndexedAccessElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyInstanceContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyPropertyElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyStaticContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSUnwrapPromiseTypeElement;
import com.intellij.lang.javascript.psi.resolve.context.JSWrapInPromiseTypeElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSElvisType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.evaluable.JSQualifiedReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSApplyContextUtil {
    @Nullable
    public static JSParameterTypeDecorator getTypeDecoratorWithAppliedContext(@NotNull JSParameterTypeDecorator decorator, @NotNull JSEvaluateContext context) {
        if (decorator == null) {
            JSApplyContextUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSApplyContextUtil.$$$reportNull$$$0(1);
        }
        if (context.isJSElementsToApplyEmpty()) {
            return decorator;
        }
        JSApplyContextElement pop = context.popJSElementToApply();
        JSParameterTypeDecorator result2 = null;
        JSType type = decorator.getSimpleType();
        if (pop instanceof JSApplyCallElement) {
            JSType innerType;
            if (type instanceof JSFunctionTypeImpl && (innerType = ((JSFunctionTypeImpl)type).getReturnType()) != null) {
                JSParameterTypeDecoratorImpl newDecorator = new JSParameterTypeDecoratorImpl(innerType, false, false, decorator.isExplicitlyDeclared());
                result2 = JSApplyContextUtil.getTypeDecoratorWithAppliedContext(newDecorator, context);
            }
        } else if (pop instanceof JSApplyPropertyElement) {
            JSRecordType.PropertySignature signature;
            if (type instanceof JSRecordType && (signature = ((JSRecordType)type).findPropertySignature(((JSApplyPropertyElement)pop).getName())) != null) {
                JSParameterTypeDecoratorImpl propertyDecorator = new JSParameterTypeDecoratorImpl(signature.getJSType(), signature.isOptional(), false, decorator.isExplicitlyDeclared());
                result2 = JSApplyContextUtil.getTypeDecoratorWithAppliedContext(propertyDecorator, context);
            }
        } else if (pop instanceof JSApplyIndexedAccessElement) {
            JSType componentType = null;
            if (type != null) {
                type = JSArrayType.GenericArrayBuilder.asArrayIfGenericType(type);
            }
            if (type instanceof JSArrayType) {
                componentType = ((JSArrayType)type).getType();
            }
            if (componentType != null) {
                JSParameterTypeDecoratorImpl newDecorator = new JSParameterTypeDecoratorImpl(componentType, false, false, decorator.isExplicitlyDeclared());
                result2 = JSApplyContextUtil.getTypeDecoratorWithAppliedContext(newDecorator, context);
            }
        }
        context.pushJSElementToApply(pop);
        return result2;
    }

    public static void processIndexedAccess(@NotNull JSApplyIndexedAccessElement pop, @NotNull JSType _type, @NotNull Consumer<? super JSType> callback) {
        if (pop == null) {
            JSApplyContextUtil.$$$reportNull$$$0(2);
        }
        if (_type == null) {
            JSApplyContextUtil.$$$reportNull$$$0(3);
        }
        if (callback == null) {
            JSApplyContextUtil.$$$reportNull$$$0(4);
        }
        if (pop.applyWithArgument(_type = _type.substitute(), callback)) {
            return;
        }
        JSType componentType = JSTypeUtils.getIndexableComponentType(_type);
        if (componentType != null) {
            JSType optimizeTypeIfComposite = componentType.substitute();
            if (optimizeTypeIfComposite instanceof JSUnionType) {
                optimizeTypeIfComposite = JSTypeUtils.copyWithStrict(optimizeTypeIfComposite, false);
            }
            callback.accept((JSType)optimizeTypeIfComposite);
        }
    }

    public static void applyTypeToContext(@NotNull JSType type, @Nullable JSEvaluationResultContext evaluateContext, @NotNull BiConsumer<? super JSType, ? super JSEvaluationResultContext> consumer) {
        if (type == null) {
            JSApplyContextUtil.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            JSApplyContextUtil.$$$reportNull$$$0(6);
        }
        if (evaluateContext == null) {
            consumer.accept((JSType)type, null);
            return;
        }
        JSApplyCallElement newElement = null;
        JSType baseType = null;
        if (type instanceof JSApplyCallType) {
            baseType = ((JSApplyCallType)type).getBaseType();
            newElement = new JSApplyCallElement((JSApplyCallType)type);
        }
        if (newElement == null) {
            consumer.accept((JSType)type, evaluateContext);
            return;
        }
        JSType _baseType = baseType;
        JSEvaluateContext.processWithJSElementToApply(newElement, evaluateContext, newContext -> consumer.accept((JSType)_baseType, (JSEvaluationResultContext)newContext));
    }

    public static void processProperty(@NotNull JSApplyPropertyElement pop, @NotNull JSType _type, @NotNull BiConsumer<? super JSType, ? super PsiElement> callback) {
        String propertyName;
        JSRecordType candidate;
        JSDestructuringProperty property;
        if (pop == null) {
            JSApplyContextUtil.$$$reportNull$$$0(7);
        }
        if (_type == null) {
            JSApplyContextUtil.$$$reportNull$$$0(8);
        }
        if (callback == null) {
            JSApplyContextUtil.$$$reportNull$$$0(9);
        }
        _type = JSTypeUtils.getValuableType(_type);
        JSDestructuringProperty jSDestructuringProperty = property = pop instanceof JSApplyDestructuringPropertyElement ? ((JSApplyDestructuringPropertyElement)pop).getProperty() : null;
        if (property != null && property.isRest()) {
            JSDestructuringObject objectPattern = (JSDestructuringObject)ObjectUtils.tryCast((Object)property.getParent(), JSDestructuringObject.class);
            if (objectPattern == null) {
                return;
            }
            Set existingNames = ContainerUtil.map2Set((Object[])objectPattern.getProperties(), p -> !p.isRest() ? p.getName() : null);
            JSType result2 = JSApplyContextUtil.createRestPropertyType(_type, property, existingNames);
            callback.accept((JSType)result2, (PsiElement)property);
            return;
        }
        if (!(_type instanceof JSRecordType) && !_type.isEcma() && ((candidate = _type.asRecordType()).hasProperties() || _type.isTypeScript())) {
            _type = candidate;
        }
        if (StringUtil.isEmpty((String)(propertyName = pop.getName()))) {
            return;
        }
        if (_type instanceof JSRecordType) {
            JSApplyContextUtil.processRecordTypeDestructuringProperty((JSRecordType)_type, callback, propertyName);
        } else if (_type instanceof JSNamedType) {
            String newTypeName = _type.getTypeText(JSType.TypeTextFormat.RESOLVED) + "." + propertyName;
            JSTypeSource newTypeSource = _type.getSource();
            if (property != null) {
                newTypeSource = JSTypeSourceFactory.copyTypeSource(newTypeSource, (PsiElement)property);
            }
            JSType newType = JSNamedTypeFactory.createType(newTypeName, newTypeSource, JSContext.STATIC);
            callback.accept((JSType)newType, (PsiElement)property);
            List typesFromElements = JSApplyContextUtil.resolveTypesFromElements(_type, propertyName).toList();
            if (!typesFromElements.isEmpty()) {
                callback.accept((JSType)JSCompositeTypeFactory.createUnionType(_type.getSource(), typesFromElements), (PsiElement)property);
            }
        }
    }

    @NotNull
    private static StreamEx<JSType> resolveTypesFromElements(@NotNull JSType type, String propertyName) {
        Collection<PsiElement> declarations;
        PsiElement sourceElement;
        if (type == null) {
            JSApplyContextUtil.$$$reportNull$$$0(10);
        }
        if (type instanceof JSNamedType && ((JSNamedType)type).getJSContext() == JSContext.INSTANCE && (sourceElement = type.getSourceElement()) != null && !(declarations = JSQualifiedReferenceType.resolveNamespaceElements(sourceElement, propertyName, type)).isEmpty()) {
            StreamEx streamEx = StreamEx.of(declarations).select(JSTypeInfoOwner.class).map(JSTypeInfoOwner::getJSType);
            if (streamEx == null) {
                JSApplyContextUtil.$$$reportNull$$$0(11);
            }
            return streamEx;
        }
        StreamEx streamEx = StreamEx.empty();
        if (streamEx == null) {
            JSApplyContextUtil.$$$reportNull$$$0(12);
        }
        return streamEx;
    }

    @NotNull
    private static JSType createRestPropertyType(@NotNull JSType _type, @NotNull JSDestructuringProperty property, @NotNull Set<String> existingNames) {
        if (_type == null) {
            JSApplyContextUtil.$$$reportNull$$$0(13);
        }
        if (property == null) {
            JSApplyContextUtil.$$$reportNull$$$0(14);
        }
        if (existingNames == null) {
            JSApplyContextUtil.$$$reportNull$$$0(15);
        }
        JSTypeSource jsTypeSource = JSTypeSourceFactory.copyTypeSource(_type.getSource(), (PsiElement)property);
        if (_type instanceof JSRecordType) {
            List typeMembers = ContainerUtil.filter((Collection)((JSRecordType)_type).getTypeMembers(), p -> p instanceof JSRecordType.PropertySignature && !existingNames.contains(((JSRecordType.PropertySignature)p).getMemberName()));
            return new JSRecordTypeImpl(jsTypeSource, typeMembers);
        }
        JSRecordType recordType = _type.asRecordType();
        JSType keyOf = JSCompositeTypeFactory.createKeyOfType(_type, jsTypeSource);
        JSType existingPropsType = JSCompositeTypeFactory.createUnionType(jsTypeSource, existingNames.stream().filter(n -> n != null).map(name -> new JSTypeKeyTypeImpl((String)name, recordType, jsTypeSource)).collect(Collectors.toList()));
        JSType excludeNamedType = JSNamedTypeFactory.createType("Exclude", jsTypeSource, JSTypeContext.INSTANCE);
        JSGenericTypeImpl exclude = new JSGenericTypeImpl(jsTypeSource, excludeNamedType, Arrays.asList(keyOf, existingPropsType));
        JSType pickNamedType = JSNamedTypeFactory.createType("Pick", jsTypeSource, JSTypeContext.INSTANCE);
        return new JSGenericTypeImpl(jsTypeSource, pickNamedType, Arrays.asList(_type, exclude));
    }

    private static void processRecordTypeDestructuringProperty(@NotNull JSRecordType _type, @NotNull BiConsumer<? super JSType, ? super PsiElement> callback, @NotNull String propertyName) {
        JSRecordType.PropertySignature signature;
        if (_type == null) {
            JSApplyContextUtil.$$$reportNull$$$0(16);
        }
        if (callback == null) {
            JSApplyContextUtil.$$$reportNull$$$0(17);
        }
        if (propertyName == null) {
            JSApplyContextUtil.$$$reportNull$$$0(18);
        }
        if ((signature = _type.findPropertySignature(propertyName)) != null) {
            JSType type = signature.isOptional() ? TypeScriptTypeGuard.wrapWithUndefined(signature.getJSType(), null) : signature.getJSType();
            JSApplyContextUtil.acceptMemberType(callback, (JSRecordType.TypeMember)signature, type);
            return;
        }
        JSRecordType.IndexSignature numericIndexer = _type.findIndexer(JSRecordType.IndexSignatureKind.NUMERIC);
        if (numericIndexer != null && JSNumberParser.tryParseNumericValue(propertyName, false) != null) {
            JSApplyContextUtil.acceptMemberType(callback, (JSRecordType.TypeMember)numericIndexer, numericIndexer.getMemberType());
            return;
        }
        JSRecordType.IndexSignature stringIndexer = _type.findIndexer(JSRecordType.IndexSignatureKind.STRING);
        if (stringIndexer != null) {
            JSApplyContextUtil.acceptMemberType(callback, (JSRecordType.TypeMember)stringIndexer, stringIndexer.getMemberType());
        }
    }

    private static void acceptMemberType(@NotNull BiConsumer<? super JSType, ? super PsiElement> callback, @NotNull JSRecordType.TypeMember member, @Nullable JSType propertyType) {
        if (callback == null) {
            JSApplyContextUtil.$$$reportNull$$$0(19);
        }
        if (member == null) {
            JSApplyContextUtil.$$$reportNull$$$0(20);
        }
        if (propertyType == null) {
            return;
        }
        JSRecordType.MemberSource source = member.getMemberSource();
        List elements = source.getAllSourceElements();
        if (elements.size() == 0) {
            callback.accept((JSType)propertyType, null);
            return;
        }
        for (PsiElement e : elements) {
            callback.accept((JSType)propertyType, (PsiElement)e);
        }
    }

    @NotNull
    public static JSApplyContextElement fromCallExpression(@NotNull JSCallExpression callExpression, @Nullable JSExpression methodExpression) {
        if (callExpression == null) {
            JSApplyContextUtil.$$$reportNull$$$0(21);
        }
        JSApplyContextElement jSApplyContextElement = callExpression instanceof JSNewExpression ? new JSApplyInstanceContextElement((JSCallItem)callExpression) : JSApplyCallElement.fromCall(callExpression, methodExpression);
        if (jSApplyContextElement == null) {
            JSApplyContextUtil.$$$reportNull$$$0(22);
        }
        return jSApplyContextElement;
    }

    @Nullable
    public static JSType applyContextElementToType(@NotNull JSType type, @NotNull JSApplyContextElement pop) {
        if (type == null) {
            JSApplyContextUtil.$$$reportNull$$$0(23);
        }
        if (pop == null) {
            JSApplyContextUtil.$$$reportNull$$$0(24);
        }
        if (pop instanceof JSApplyCallElement) {
            JSExpression expression;
            JSType returnType = JSTypeUtils.tryGetReturnType(type, (JSApplyCallElement)pop);
            if (returnType == null) {
                expression = ((JSApplyCallElement)pop).getMethodExpression();
                JSAnyType jSAnyType = returnType = !(type instanceof JSAnyType) && type.isSourceStrict() && type.isTypeScript() && expression != null ? JSAnyType.get((PsiElement)expression, true) : JSAnyType.get((PsiElement)expression, false);
            }
            if (returnType instanceof JSAnyType) {
                JSCallItem item;
                List types2;
                expression = ((JSApplyCallElement)pop).getMethodExpression();
                if (JSNamedType.isNamedTypeWithNames(type, JSCommonTypeNames.NODE_REQUIRE_FUNCTIONS) && (types2 = (item = ((JSApplyCallElement)pop).getCallItem()).getArgumentTypes(false)).size() == 1) {
                    JSTypeSource source = type.isJavaScript() ? type.getSource() : JSTypeSourceFactory.createTypeSource((PsiElement)expression, true);
                    JSType module = (JSType)types2.get(0);
                    if (module != null) {
                        return new JSRequireCallExpressionType(module, source);
                    }
                }
            }
            return returnType;
        }
        if (pop instanceof JSApplyPropertyElement) {
            Ref result2 = Ref.create();
            JSApplyContextUtil.processProperty((JSApplyPropertyElement)pop, type, (newType, element) -> result2.set(newType));
            return (JSType)result2.get();
        }
        if (pop instanceof JSApplyIndexedAccessElement) {
            Ref result3 = Ref.create();
            JSApplyContextUtil.processIndexedAccess((JSApplyIndexedAccessElement)pop, type, arg_0 -> ((Ref)result3).set(arg_0));
            return (JSType)result3.get();
        }
        if (pop instanceof JSApplyInstanceContextElement) {
            JSType returnType;
            JSCallItem callItem = ((JSApplyInstanceContextElement)pop).getCallItem();
            boolean processed = false;
            if (callItem != null && (returnType = JSTypeUtils.getReturnType(type, callItem)) != null) {
                processed = true;
                if (!(returnType instanceof JSVoidType)) {
                    return returnType;
                }
            }
            if (!processed && type instanceof JSNamedType && ((JSNamedType)type).isStaticOrInstance() != JSContext.INSTANCE) {
                return ((JSNamedType)type).copyWithJSContext(JSContext.INSTANCE);
            }
        } else if (pop instanceof JSApplyStaticContextElement) {
            if (type instanceof JSNamedType && ((JSNamedType)type).isStaticOrInstance() != JSContext.STATIC) {
                return ((JSNamedType)type).copyWithJSContext(JSContext.STATIC);
            }
        } else if (pop instanceof JSUnwrapPromiseTypeElement) {
            JSType substituted = type.substitute();
            JSType unwrapped = JSTypeUtils.getPromiseComponentTypeOrNull(substituted);
            if (unwrapped != null) {
                return unwrapped;
            }
            if (JSTypeUtils.hasForeignGenericParameter(substituted)) {
                return JSCompositeTypeFactory.createAwaitedType(substituted, type.getSource());
            }
        } else {
            if (pop instanceof JSWrapInPromiseTypeElement) {
                return JSTypeUtils.wrapInPromiseType(type.substitute(), JSTypeSourceFactory.createTypeSource(((JSWrapInPromiseTypeElement)pop).getContext(), true));
            }
            if (pop instanceof JSApplyElvisContextElement) {
                if (((JSApplyElvisContextElement)pop).isFinal()) {
                    JSType nonNullable = JSElvisType.removeElvisNullableComponents(type);
                    return TypeScriptTypeGuard.wrapWithUndefined(nonNullable, type.getSource());
                }
                boolean isTail = ((JSApplyElvisContextElement)pop).isTail();
                boolean hasNullableComponent = JSElvisType.hasNullableComponent(JSCompositeTypeImpl.optimizeTypeIfComposite(type), isTail);
                return new JSElvisType(type.getSource(), JSElvisType.removeNullableComponents(type, isTail), hasNullableComponent);
            }
        }
        return null;
    }

    @Nullable
    public static JSNamespace applyContextElementToNamespace(@NotNull JSNamespace namespace, @NotNull JSApplyContextElement pop) {
        if (namespace == null) {
            JSApplyContextUtil.$$$reportNull$$$0(25);
        }
        if (pop == null) {
            JSApplyContextUtil.$$$reportNull$$$0(26);
        }
        if (pop instanceof JSApplyInstanceContextElement) {
            return JSNamedTypeFactory.copyWithJSContext(namespace, JSContext.INSTANCE);
        }
        if (pop instanceof JSApplyStaticContextElement) {
            return JSNamedTypeFactory.copyWithJSContext(namespace, JSContext.STATIC);
        }
        if (pop instanceof JSApplyPropertyElement) {
            String name = ((JSApplyPropertyElement)pop).getName();
            List typesFromElements = JSApplyContextUtil.resolveTypesFromElements((JSType)namespace, name).select(JSNamespace.class).toList();
            if (typesFromElements.size() == 1) {
                return (JSNamespace)typesFromElements.get(0);
            }
            return JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.create(name, namespace.getQualifiedName()), JSContext.STATIC, null, namespace.isSourceStrict());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 7: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pop";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_type";
                break;
            }
            case 4: 
            case 9: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 5: 
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: 
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/context/JSApplyContextUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/context/JSApplyContextUtil";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTypesFromElements";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "fromCallExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDecoratorWithAppliedContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processIndexedAccess";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyTypeToContext";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processProperty";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypesFromElements";
                break;
            }
            case 11: 
            case 12: 
            case 22: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createRestPropertyType";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processRecordTypeDestructuringProperty";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "acceptMemberType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fromCallExpression";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "applyContextElementToType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "applyContextElementToNamespace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

