/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSQualifiedNamedElementBaseImpl;
import com.intellij.lang.javascript.psi.resolve.JSQualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.TypeScriptModuleStub;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import icons.JavaScriptPsiIcons;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptModuleImpl
extends JSQualifiedNamedElementBaseImpl<TypeScriptModuleStub>
implements TypeScriptModule,
StubBasedPsiElement<TypeScriptModuleStub> {
    private ThreeState myIsInstantiated = ThreeState.UNSURE;

    public TypeScriptModuleImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptModuleImpl(TypeScriptModuleStub stub) {
        super(stub, (IStubElementType)JSStubElementTypes.TYPESCRIPT_MODULE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            TypeScriptModuleImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitTypeScriptModule((TypeScriptModule)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Nullable
    public ASTNode findNameIdentifier() {
        return TypeScriptModuleImpl.findNameIdentifier(this.getNode());
    }

    @Nullable
    public static ASTNode findNameIdentifier(@NotNull ASTNode typeScriptModule) {
        if (typeScriptModule == null) {
            TypeScriptModuleImpl.$$$reportNull$$$0(1);
        }
        boolean wasKeyword = false;
        for (ASTNode element = typeScriptModule.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            IElementType type = element.getElementType();
            if (type == JSTokenTypes.LBRACE) {
                return null;
            }
            if (type == JSStubElementTypes.LITERAL_EXPRESSION) {
                return element;
            }
            if (!wasKeyword) {
                if (!JSKeywordSets.MODULES_AND_GLOBAL_KEYWORDS.contains(type)) continue;
                wasKeyword = true;
                continue;
            }
            if (!JSKeywordSets.TS_IDENTIFIERS_TOKENS_SET.contains(type)) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode nameIdentifier = this.findNameIdentifier();
        return nameIdentifier != null ? nameIdentifier.getPsi() : null;
    }

    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName(this);
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        TypeScriptModuleStub stub = (TypeScriptModuleStub)this.getGreenStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        return this.isInternal() ? JSPsiImplUtils.getNamespace((JSNamedElement)this) : null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new JSItemPresentation((JSPsiElementBase)this){

            @Override
            public String getPresentableText() {
                String text = super.getPresentableText();
                if (text == null) {
                    return null;
                }
                return text;
            }
        };
    }

    public String getName() {
        TypeScriptModuleStub stub = (TypeScriptModuleStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        return this.doGetName();
    }

    @Nullable
    protected String doGetName() {
        PsiElement element = this.getNameIdentifier();
        if (element instanceof JSLiteralExpression) {
            return CommonJSUtil.unifyModuleName(element.getText());
        }
        if (element != null) {
            return element.getText();
        }
        return null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode nameIdentifier;
        if (name == null) {
            TypeScriptModuleImpl.$$$reportNull$$$0(2);
        }
        if ((nameIdentifier = this.findNameIdentifier()) != null) {
            ASTNode identifier = JSChangeUtil.createNameIdentifier(this.getProject(), name, JavaScriptSupportLoader.TYPESCRIPT);
            nameIdentifier.getTreeParent().replaceChild(nameIdentifier, identifier);
        }
        return this;
    }

    public int getTextOffset() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getNode().getStartOffset() : super.getTextOffset();
    }

    @Nullable
    public JSAttributeList getAttributeList() {
        return (JSAttributeList)this.getStubOrPsiChild((IStubElementType)JSStubElementTypes.ATTRIBUTE_LIST);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            TypeScriptModuleImpl.$$$reportNull$$$0(3);
        }
        if (state == null) {
            TypeScriptModuleImpl.$$$reportNull$$$0(4);
        }
        if (place == null) {
            TypeScriptModuleImpl.$$$reportNull$$$0(5);
        }
        return TypeScriptModuleImpl.processModuleDeclarations(this, processor, state, lastParent);
    }

    public static boolean processModuleDeclarations(@NotNull TypeScriptModule module, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent) {
        if (module == null) {
            TypeScriptModuleImpl.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            TypeScriptModuleImpl.$$$reportNull$$$0(7);
        }
        if (state == null) {
            TypeScriptModuleImpl.$$$reportNull$$$0(8);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)module);
        if (lastParent != module && !processor.execute((PsiElement)module, state)) {
            return false;
        }
        if (TypeScriptModuleImpl.skipProcessingMembers(lastParent)) {
            return true;
        }
        if (!JSQualifiedNameResolver.processES6DeclarationsInScope((JSElement)module, processor, lastParent == module)) {
            return false;
        }
        if (processor instanceof ResolveProcessor && !((ResolveProcessor)processor).isLocalResolve()) {
            return TypeScriptModuleImpl.processMergedElements(module, processor);
        }
        return true;
    }

    private static boolean skipProcessingMembers(PsiElement lastParent) {
        return lastParent == null;
    }

    private static boolean processMergedElements(@NotNull TypeScriptModule module, @NotNull PsiScopeProcessor processor) {
        String name;
        if (module == null) {
            TypeScriptModuleImpl.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            TypeScriptModuleImpl.$$$reportNull$$$0(10);
        }
        if ((name = module.getQualifiedName()) != null) {
            Collection<JSQualifiedNamedElement> elements = TypeScriptClassResolver.getInstance().findElementsByQNameFilteredByConfig(name, (PsiElement)module);
            if (elements.size() == 1) {
                return true;
            }
            ES6PsiUtil.ES6ExportedElementsProcessor newProcessor = processor instanceof ES6PsiUtil.ES6ExportedElementsProcessor ? (ES6PsiUtil.ES6ExportedElementsProcessor)processor : new ES6PsiUtil.ES6ExportedElementsProcessor(processor);
            for (JSQualifiedNamedElement element : elements) {
                if (element == module || !(element instanceof TypeScriptModule) || JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)element, newProcessor, false)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return JavaScriptPsiIcons.Classes.Typescript_Module;
    }

    public boolean isInternal() {
        return this.getExternalModuleText() == null;
    }

    public boolean isInstantiated() {
        ThreeState instantiated = this.myIsInstantiated;
        if (instantiated == ThreeState.UNSURE) {
            boolean isInstantiated = this.isInstantiatedImpl();
            this.myIsInstantiated = instantiated = isInstantiated ? ThreeState.YES : ThreeState.NO;
        }
        return instantiated.toBoolean();
    }

    public boolean isGlobalScopeAugmentation() {
        return this.getName() == null;
    }

    public boolean isAugmentation() {
        TypeScriptModuleStub stub = (TypeScriptModuleStub)this.getGreenStub();
        if (stub != null) {
            return stub.isAugmentation();
        }
        return TypeScriptAugmentationUtil.isExternalModuleAugmentation((PsiElement)this);
    }

    public boolean isShorthandAmbientModule() {
        TypeScriptModuleStub stub = (TypeScriptModuleStub)this.getGreenStub();
        if (stub != null) {
            return stub.isShorthandAmbientModule();
        }
        return !this.isInternal() && this.getNode().findChildByType(JSTokenTypes.LBRACE) == null;
    }

    private boolean isInstantiatedImpl() {
        for (JSSourceElement element : JSResolveUtil.getSourceElements((PsiElement)this)) {
            if (!TypeScriptModuleImpl.checkNestedElementInstantiated((PsiElement)element)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkNestedElementInstantiated(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptModuleImpl.$$$reportNull$$$0(11);
        }
        if (!(element instanceof TypeScriptCompileTimeType) && !(element instanceof TypeScriptModule)) {
            return true;
        }
        return element instanceof TypeScriptModule && ((TypeScriptModule)element).isInstantiated();
    }

    public boolean isNamespaceExplicitlyDeclared() {
        return true;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList list2 = this.getAttributeList();
        JSAttributeList.AccessType accessType = list2 != null ? list2.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            TypeScriptModuleImpl.$$$reportNull$$$0(12);
        }
        return accessType;
    }

    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = JSContext.STATIC;
        if (jSContext == null) {
            TypeScriptModuleImpl.$$$reportNull$$$0(13);
        }
        return jSContext;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myIsInstantiated = ThreeState.UNSURE;
    }

    public boolean hasImplicitExportForDeclarations() {
        if (this.isExternal() || this.isGlobalScopeAugmentation() || TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)this)) {
            return !TypeScriptPsiUtil.hasExportStatements((PsiElement)this);
        }
        return false;
    }

    @Nullable
    public String getExternalModuleText() {
        String name = this.getName();
        return TypeScriptUtil.convertToExternalModuleText(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeScriptModule";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptModuleImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptModuleImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findNameIdentifier";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processModuleDeclarations";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processMergedElements";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkNestedElementInstantiated";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

