/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.completion.JSKeywordsCompletionProvider;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.impl.JSExpressionCodeFragmentImpl;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSElementFactory {
    private JSElementFactory() {
    }

    @NotNull
    public static JSExpressionCodeFragment createExpressionCodeFragment(@NotNull Project project, CharSequence text, @Nullable PsiElement context) {
        if (project == null) {
            JSElementFactory.$$$reportNull$$$0(0);
        }
        return JSElementFactory.createExpressionCodeFragment(project, text, context, true, null, null, TopLevelCompletion.YES, null);
    }

    @NotNull
    public static JSExpressionCodeFragment createExpressionCodeFragment(@NotNull Project project, CharSequence text, @Nullable PsiElement context, @Nullable JSLanguageDialect dialect, @Nullable GlobalSearchScope resolveScope, @NotNull TopLevelCompletion topLevelCompletion, @Nullable JavaScriptParserBase.ForceContext forceContext) {
        if (project == null) {
            JSElementFactory.$$$reportNull$$$0(1);
        }
        if (topLevelCompletion == null) {
            JSElementFactory.$$$reportNull$$$0(2);
        }
        return JSElementFactory.createExpressionCodeFragment(project, text, context, true, dialect, resolveScope, topLevelCompletion, forceContext);
    }

    @NotNull
    public static JSExpressionCodeFragment createExpressionCodeFragment(@NotNull Project project, CharSequence text, @Nullable PsiElement context, boolean physical, @Nullable JSLanguageDialect dialect, @Nullable GlobalSearchScope resolveScope, final @NotNull TopLevelCompletion topLevelCompletion, @Nullable JavaScriptParserBase.ForceContext forceContext) {
        if (project == null) {
            JSElementFactory.$$$reportNull$$$0(3);
        }
        if (topLevelCompletion == null) {
            JSElementFactory.$$$reportNull$$$0(4);
        }
        String name = "fragment." + (dialect != null ? dialect.getFileExtension() : JavaScriptSupportLoader.JAVASCRIPT.getDefaultExtension());
        JSExpressionCodeFragmentImpl codeFragment = new JSExpressionCodeFragmentImpl(project, name, text, physical, forceContext){

            @Override
            public List<?> getTopLevelVariants(PsiElement context) {
                switch (topLevelCompletion) {
                    case YES: {
                        return super.getTopLevelVariants(context);
                    }
                    case NO: {
                        return Collections.emptyList();
                    }
                    case LITERAL_VALUES: {
                        return Arrays.asList(JSKeywordsCompletionProvider.TYPE_LITERAL_VALUES);
                    }
                }
                assert (false) : "unknown completion type: " + (Object)((Object)topLevelCompletion);
                return null;
            }
        };
        codeFragment.forceResolveScope(resolveScope);
        codeFragment.setContext(context);
        JSExpressionCodeFragmentImpl jSExpressionCodeFragmentImpl = codeFragment;
        if (jSExpressionCodeFragmentImpl == null) {
            JSElementFactory.$$$reportNull$$$0(5);
        }
        return jSExpressionCodeFragmentImpl;
    }

    @Deprecated
    @NotNull
    public static JSExpression replaceExpression(@NotNull JSExpression expression, @NotNull String text) throws IncorrectOperationException {
        if (expression == null) {
            JSElementFactory.$$$reportNull$$$0(6);
        }
        if (text == null) {
            JSElementFactory.$$$reportNull$$$0(7);
        }
        JSExpression jSExpression = JSRefactoringUtil.replaceExpressionAndReformat(expression, text);
        if (jSExpression == null) {
            JSElementFactory.$$$reportNull$$$0(8);
        }
        return jSExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelCompletion";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/JSElementFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/JSElementFactory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionCodeFragment";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionCodeFragment";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TopLevelCompletion {
        YES,
        NO,
        LITERAL_VALUES;

    }
}

