/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSFileHighlightingInfo;
import com.intellij.lang.javascript.service.JSHighlightingInfoBuilder;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSErrorInspection
extends JSInspection
implements CustomSuppressableInspectionTool,
PairedUnfairLocalInspectionTool {
    public SuppressQuickFix @NotNull [] getBatchSuppressActions(@Nullable PsiElement element) {
        if (SuppressQuickFix.EMPTY_ARRAY == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(0);
        }
        return SuppressQuickFix.EMPTY_ARRAY;
    }

    public SuppressIntentionAction @Nullable [] getSuppressActions(@Nullable PsiElement element) {
        return SuppressIntentionAction.EMPTY_ARRAY;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(1);
        }
        return false;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(2);
        }
        if (session == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(3);
        }
        if (this.myOnTheFly) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                FlowJSErrorInspection.$$$reportNull$$$0(4);
            }
            return psiElementVisitor;
        }
        return new PsiElementVisitor(){

            public void visitFile(@NotNull PsiFile file2) {
                FlowJSServerService service;
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((service = FlowJSServerManager.getService(file2)) == null) {
                    return;
                }
                if (!FlowJSAnnotation.hasFlowAnnotation(file2)) {
                    return;
                }
                Document document2 = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
                if (document2 == null) {
                    return;
                }
                JSFileHighlightingInfo info = JSHighlightingInfoBuilder.createInfoWithUnSavedFiles(file2.getProject(), file2.getVirtualFile(), service.getAcceptableFilesFilter());
                CompletableFuture highlight = service.highlight(file2, info);
                List errors = (List)JSLanguageServiceUtil.awaitFuture(highlight);
                if (errors != null) {
                    FlowJSErrorInspection.reportErrors(errors, file2, document2, holder);
                }
                super.visitFile(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSErrorInspection$1", "visitFile"));
            }
        };
    }

    @NotNull
    public String getInspectionForBatchShortName() {
        String string = this.getShortName();
        if (string == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static void reportErrors(@NotNull List<? extends JSAnnotationError> annotationResult, @NotNull PsiFile file2, @NotNull Document document2, @NotNull ProblemsHolder holder) {
        if (annotationResult == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(7);
        }
        if (document2 == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            FlowJSErrorInspection.$$$reportNull$$$0(9);
        }
        VirtualFile virtualFile = file2.getViewProvider().getVirtualFile();
        for (JSAnnotationError jSAnnotationError : annotationResult) {
            JSLanguageServiceUtil.PsiElementInfo info;
            if (StringUtil.isEmpty((String)jSAnnotationError.getAbsoluteFilePath()) || !FileUtil.pathsEqual((String)jSAnnotationError.getAbsoluteFilePath(), (String)virtualFile.getCanonicalPath()) || (info = JSLanguageServiceUtil.getElementInfo(file2, document2, jSAnnotationError)) == null) continue;
            PsiElement element = info.getElement();
            holder.registerProblem((PsiElement)(element != null ? element : file2), info.getRange(), jSAnnotationError.getDescription(), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSErrorInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationResult";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSErrorInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionForBatchShortName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reportErrors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

