/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.completion.ES6MemberAccessCompletionContributor;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class JSObjectLiteralPropertiesCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        JSType thisContext;
        JSFunction parentFunction;
        PsiElement parent;
        if (parameters == null) {
            JSObjectLiteralPropertiesCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSObjectLiteralPropertiesCompletionContributor.$$$reportNull$$$0(1);
        }
        if (!JSPsiImplUtils.isRuntimeUnqualifiedRefExpression(parent = parameters.getPosition().getParent())) {
            return;
        }
        JSFunction parentPropertyCandidate = parentFunction = JSPsiImplUtils.getParentFunctionThroughLambdas(parent);
        if (parentFunction instanceof JSFunctionExpression) {
            parentPropertyCandidate = parentFunction.getParent();
        }
        if (!(parentPropertyCandidate instanceof JSProperty)) {
            return;
        }
        JSObjectLiteralExpression expression = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)parentPropertyCandidate.getParent(), JSObjectLiteralExpression.class);
        if (expression == null) {
            return;
        }
        JSType jSType = thisContext = parentFunction instanceof TypeScriptFunction ? TypeScriptUtil.evaluateThisTypeFromFunction((TypeScriptFunction)parentFunction, parent) : null;
        if (thisContext == null) {
            thisContext = new JSPsiBasedTypeOfType((PsiElement)expression, false);
        }
        for (JSRecordType.PropertySignature property : thisContext.asRecordType().getProperties()) {
            String name;
            ProgressManager.checkCanceled();
            PsiElement sourceElement = property.getMemberSource().getSingleElement();
            if (!(sourceElement instanceof JSPsiElementBase) || !sourceElement.isValid() || "constructor".equals(name = property.getMemberName()) || "prototype".equals(name)) continue;
            String nameWithAccess = ES6MemberAccessCompletionContributor.getNameWithAccess(name, false, false, (PsiElement)expression);
            LookupElementBuilder baseElementWithThis = JSLookupUtilImpl.createLookupElement(sourceElement, "this" + nameWithAccess);
            LookupElement element = PrioritizedLookupElement.withPriority((LookupElement)baseElementWithThis.withInsertHandler(JSInsertHandler.insertBracesIfNeeded(sourceElement, null)).withLookupString(name), (double)JSLookupPriority.RELEVANT_SMARTNESS_PRIORITY.getPriorityValue());
            result2.addElement(element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/completion/JSObjectLiteralPropertiesCompletionContributor";
        objectArray[2] = "fillCompletionVariants";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

