/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.modules.JSModuleNameInfoImpl;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSTypeArgumentsOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentsListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCompletionUtil {
    private static final int MAX_DEPTH = 10;

    @Nullable
    public static LookupElement createLookupElementForJSModule(@Nullable PsiElement psiElement, boolean insertRelativePrefix) {
        PsiFile psiFile = (PsiFile)ObjectUtils.tryCast((Object)psiElement, PsiFile.class);
        if (psiFile == null || !psiFile.isPhysical()) {
            return null;
        }
        String fileName = psiFile.getName();
        String fixedName = JSModuleNameInfoImpl.getModuleName(fileName, psiFile.getVirtualFile(), psiElement);
        if (!fixedName.equals(fileName) || insertRelativePrefix) {
            LookupElementBuilder item = LookupElementBuilder.create((Object)psiFile, (String)fixedName).withIcon(psiFile.getIcon(0)).withPresentableText(fileName);
            if (insertRelativePrefix) {
                item = item.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                        if (context == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (item == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        int offset = context.getStartOffset();
                        context.getDocument().insertString(offset, (CharSequence)"./");
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "context";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "item";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/lang/javascript/completion/JSCompletionUtil$1";
                        objectArray[2] = "handleInsert";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            return item;
        }
        return null;
    }

    @NotNull
    public static LookupElement withJSLookupPriority(@NotNull LookupElement element, @NotNull JSLookupPriority priority) {
        if (element == null) {
            JSCompletionUtil.$$$reportNull$$$0(0);
        }
        if (priority == null) {
            JSCompletionUtil.$$$reportNull$$$0(1);
        }
        element = PrioritizedLookupElement.withPriority((LookupElement)element, (double)priority.getPriorityValue());
        if (priority.getProximityValue() != 0 || element instanceof PrioritizedLookupElement && ((PrioritizedLookupElement)element).getExplicitProximity() != 0) {
            element = PrioritizedLookupElement.withExplicitProximity((LookupElement)element, (int)priority.getProximityValue());
        }
        LookupElement lookupElement = element;
        if (lookupElement == null) {
            JSCompletionUtil.$$$reportNull$$$0(2);
        }
        return lookupElement;
    }

    public static double getLookupElementPriority(@NotNull LookupElement element) {
        if (element == null) {
            JSCompletionUtil.$$$reportNull$$$0(3);
        }
        while (element instanceof LookupElementDecorator && !(element instanceof PrioritizedLookupElement)) {
            element = ((LookupElementDecorator)element).getDelegate();
        }
        if (element instanceof PrioritizedLookupElement) {
            return ((PrioritizedLookupElement)element).getPriority();
        }
        return JSLookupPriority.LOWEST_PRIORITY.getPriorityValue();
    }

    public static int getLookupElementProximity(LookupElement element) {
        while (element instanceof LookupElementDecorator && !(element instanceof PrioritizedLookupElement)) {
            element = ((LookupElementDecorator)element).getDelegate();
        }
        if (element instanceof PrioritizedLookupElement) {
            return ((PrioritizedLookupElement)element).getExplicitProximity();
        }
        return JSLookupPriority.LOWEST_PRIORITY.getProximityValue();
    }

    public static int getCompletionLimit() {
        return Registry.intValue((String)"ide.completion.variant.limit") / 2;
    }

    public static void handleOverflow(@NotNull CompletionResultSet resultSet) {
        if (resultSet == null) {
            JSCompletionUtil.$$$reportNull$$$0(4);
        }
        resultSet.restartCompletionOnAnyPrefixChange();
        resultSet.addLookupAdvertisement("Not all variants are shown, please type more letters to see the rest");
    }

    @NotNull
    public static Collection<LookupElement> pushVariants(@NotNull Collection<LookupElement> variants, Set<String> populatedVariants, @NotNull CompletionResultSet result2) {
        if (variants == null) {
            JSCompletionUtil.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            JSCompletionUtil.$$$reportNull$$$0(6);
        }
        ArrayList<Object> elementsToAdd = new ArrayList<Object>();
        for (LookupElement element : variants) {
            LookupElementBuilder lookupItem;
            if (populatedVariants.contains(element.getLookupString())) continue;
            if (element instanceof LookupElementBuilder && (lookupItem = (LookupElementBuilder)element).getInsertHandler() == null) {
                elementsToAdd.add(lookupItem.withInsertHandler(JSInsertHandler.DEFAULT));
                continue;
            }
            elementsToAdd.add(element);
        }
        result2.addAllElements(elementsToAdd);
        Collection<LookupElement> collection = variants;
        if (collection == null) {
            JSCompletionUtil.$$$reportNull$$$0(7);
        }
        return collection;
    }

    public static void createAndStartAddGenericsTemplate(@NotNull Project project, @NotNull Editor editor, @NotNull JSTypeArgumentsOwner place, @NotNull TypeScriptTypeParameterList typeParameterList) {
        TypeScriptTypeArgumentList list2;
        if (project == null) {
            JSCompletionUtil.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            JSCompletionUtil.$$$reportNull$$$0(9);
        }
        if (place == null) {
            JSCompletionUtil.$$$reportNull$$$0(10);
        }
        if (typeParameterList == null) {
            JSCompletionUtil.$$$reportNull$$$0(11);
        }
        ArrayList<String> genericArgs = new ArrayList<String>();
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template template = JSCompletionUtil.getTemplate(templateManager, genericArgs, place, typeParameterList);
        MacroCallNode expression = new MacroCallNode((Macro)new CompleteMacro());
        TextExpression defaultExpression = new TextExpression("any");
        for (String genericText : genericArgs) {
            template.addVariable(genericText, (Expression)expression, (Expression)defaultExpression, true);
        }
        template.setToReformat(true);
        if (place instanceof TypeScriptTypeArgumentsListOwner && (list2 = ((TypeScriptTypeArgumentsListOwner)place).getTypeArgumentList()) != null) {
            ApplicationManager.getApplication().runWriteAction(() -> list2.delete());
        }
        int offset = ((JSElement)place).getTextOffset() + ((JSElement)place).getTextLength();
        editor.getCaretModel().moveToOffset(offset);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        templateManager.startTemplate(editor, template);
    }

    @NotNull
    private static Template getTemplate(@NotNull TemplateManager templateManager, @NotNull List<String> genericArgs, @NotNull JSTypeArgumentsOwner place, @NotNull TypeScriptTypeParameterList typeParameterList) {
        if (templateManager == null) {
            JSCompletionUtil.$$$reportNull$$$0(12);
        }
        if (genericArgs == null) {
            JSCompletionUtil.$$$reportNull$$$0(13);
        }
        if (place == null) {
            JSCompletionUtil.$$$reportNull$$$0(14);
        }
        if (typeParameterList == null) {
            JSCompletionUtil.$$$reportNull$$$0(15);
        }
        JSTypeDeclaration[] typeDeclarationsList = place.getTypeArguments();
        TypeScriptTypeParameter[] typeParametersList = typeParameterList.getTypeParameters();
        String genericArgsText = JSCompletionUtil.getGenericArgsText(typeDeclarationsList, typeParametersList, genericArgs);
        Template template = templateManager.createTemplate("", "", genericArgsText);
        if (template == null) {
            JSCompletionUtil.$$$reportNull$$$0(16);
        }
        return template;
    }

    @NotNull
    private static String getGenericArgsText(JSTypeDeclaration @NotNull [] typeDeclarationsList, TypeScriptTypeParameter @NotNull [] typeParametersList, @NotNull List<String> genericArgs) {
        if (genericArgs == null) {
            JSCompletionUtil.$$$reportNull$$$0(17);
        }
        if (typeDeclarationsList == null) {
            JSCompletionUtil.$$$reportNull$$$0(18);
        }
        if (typeParametersList == null) {
            JSCompletionUtil.$$$reportNull$$$0(19);
        }
        StringBuilder templateText = new StringBuilder();
        templateText.append("<");
        for (JSTypeDeclaration declaration : typeDeclarationsList) {
            templateText.append(declaration.getText()).append(",");
        }
        int typeDeclarationsLength = typeDeclarationsList.length;
        int typeParametersLength = typeParametersList.length;
        for (int i = typeDeclarationsLength; i < typeParametersLength; ++i) {
            TypeScriptTypeParameter typeParameter = typeParametersList[i];
            if (typeParameter == null || typeParameter.getDefault() != null) continue;
            String typeParameterText = typeParameter.getName();
            typeParameterText = typeParameterText != null ? typeParameterText : "T";
            templateText.append("$").append(typeParameterText).append(i).append("$,");
            genericArgs.add(typeParameterText + i);
        }
        int index = templateText.lastIndexOf(",");
        assert (index != -1);
        templateText.deleteCharAt(index);
        templateText.append(">");
        String string = templateText.toString();
        if (string == null) {
            JSCompletionUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    public static boolean isUnparsedGenericTail(@NotNull PsiElement expr) {
        if (expr == null) {
            JSCompletionUtil.$$$reportNull$$$0(21);
        }
        if (expr instanceof TypeScriptField) {
            PsiElement parent = expr.getParent();
            JSVarStatement statement = (JSVarStatement)ObjectUtils.tryCast((Object)parent, JSVarStatement.class);
            if (statement != null && JSCompletionUtil.isVarReadonlyTail((JSStatement)statement)) {
                return true;
            }
            if (parent instanceof TypeScriptObjectType) {
                TypeScriptField field;
                PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)expr);
                if (prev instanceof PsiErrorElement) {
                    prev = prev.getPrevSibling();
                }
                if ((field = (TypeScriptField)ObjectUtils.tryCast((Object)prev, TypeScriptField.class)) != null && JSCompletionUtil.endsWithReadonly((PsiElement)field)) {
                    return true;
                }
            }
        }
        if (!(expr instanceof JSReferenceExpression)) {
            if (expr instanceof JSVariable) {
                JSVarStatement statement = ((JSVariable)expr).getStatement();
                if (statement == null) {
                    return false;
                }
                Object[] declarations = statement.getDeclarations();
                int index = ArrayUtil.indexOf((Object[])declarations, (Object)expr);
                if (index <= 0) {
                    return false;
                }
                for (int i = 1; i < index; ++i) {
                    Object declaration = declarations[i];
                    if (declaration instanceof JSVariable && declaration.getInitializer() == null) continue;
                    return false;
                }
                Object prevDeclaration = declarations[0];
                if (!(prevDeclaration instanceof JSVariable)) {
                    return false;
                }
                JSExpression initializer = prevDeclaration.getInitializer();
                return JSCompletionUtil.isUnparsedContextBeforeGenerics((PsiElement)initializer);
            }
            return false;
        }
        return JSCompletionUtil.isUnparsedContextBeforeGenerics(expr.getParent());
    }

    protected static boolean isVarReadonlyTail(JSStatement statement) {
        JSInitializerOwner[] declarations;
        PsiElement prevItem = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)statement);
        JSVarStatement prevStatement = (JSVarStatement)ObjectUtils.tryCast((Object)prevItem, JSVarStatement.class);
        if (prevStatement != null && (declarations = prevStatement.getDeclarations()).length == 1 && declarations[0] instanceof JSVariable && JSCompletionUtil.endsWithReadonly((PsiElement)declarations[0])) {
            return true;
        }
        if (prevItem instanceof JSFunction) {
            return JSCompletionUtil.endsWithReadonly(prevItem);
        }
        return false;
    }

    private static boolean endsWithReadonly(@NotNull PsiElement declaration) {
        PsiElement lastChild;
        if (declaration == null) {
            JSCompletionUtil.$$$reportNull$$$0(22);
        }
        if ((lastChild = JSPsiImplUtils.getLastLeafChild(declaration.getLastChild())) instanceof PsiErrorElement) {
            lastChild = lastChild.getPrevSibling();
        }
        return "readonly".equals((lastChild = JSPsiImplUtils.getLastLeafChild(lastChild)).getText()) && PsiTreeUtil.getParentOfType((PsiElement)lastChild, TypeScriptSingleType.class, (boolean)false) != null;
    }

    public static boolean isUnparsedContextBeforeGenerics(@Nullable PsiElement parent) {
        return JSCompletionUtil.isUnparsedContextBeforeGenerics(parent, 0);
    }

    private static boolean isUnparsedContextBeforeGenerics(@Nullable PsiElement parent, int depth) {
        PsiElement grandParent;
        if ((parent instanceof JSCallExpression || parent instanceof JSIndexedPropertyAccessExpression) && (grandParent = parent.getParent()) instanceof JSBinaryExpression) {
            parent = grandParent;
        }
        if (parent instanceof JSBinaryExpression && ((JSBinaryExpression)parent).getOperationSign() == JSTokenTypes.LT) {
            JSExpression operand = ((JSBinaryExpression)parent).getLOperand();
            if (operand instanceof JSNewExpression && operand.getLastChild() instanceof JSReferenceExpression) {
                return true;
            }
            if (operand instanceof JSReferenceExpression) {
                for (ResolveResult result2 : ((JSReferenceExpression)operand).multiResolve(true)) {
                    PsiElement element = result2.getElement();
                    if (!(element instanceof TypeScriptTypeParameterListOwner) || ((TypeScriptTypeParameterListOwner)element).getTypeParameterList() == null) continue;
                    return true;
                }
            }
        }
        if (parent instanceof JSCommaExpression) {
            if (depth > 10) {
                return false;
            }
            return JSCompletionUtil.isUnparsedContextBeforeGenerics((PsiElement)((JSCommaExpression)parent).getLOperand(), depth + 1);
        }
        if (parent instanceof JSExpressionStatement && JSCompletionUtil.isVarReadonlyTail((JSStatement)parent)) {
            return true;
        }
        JSExpressionStatement expressionStatement = (JSExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, JSExpressionStatement.class);
        return expressionStatement != null && expressionStatement.getTextOffset() == parent.getTextOffset() && JSCompletionUtil.isVarReadonlyTail((JSStatement)expressionStatement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 16: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 16: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 2: 
            case 7: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSCompletionUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterList";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateManager";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericArgs";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDeclarationsList";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParametersList";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSCompletionUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withJSLookupPriority";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "pushVariants";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplate";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericArgsText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withJSLookupPriority";
                break;
            }
            case 2: 
            case 7: 
            case 16: 
            case 20: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElementPriority";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleOverflow";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "pushVariants";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createAndStartAddGenericsTemplate";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTemplate";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getGenericArgsText";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isUnparsedGenericTail";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "endsWithReadonly";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 16: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

