/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt.rc;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.ComponentWithEmptyBrowseButton;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntService;
import com.intellij.lang.javascript.buildTools.grunt.GruntUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileManager;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileStructure;
import com.intellij.lang.javascript.buildTools.grunt.beforeRun.GruntBeforeRunTaskDialog;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettings;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunConfiguration;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;

public class GruntRunConfigurationEditor
extends SettingsEditor<GruntRunConfiguration> {
    private static final Logger LOG = Logger.getInstance(GruntRunConfigurationEditor.class);
    private final Project myProject;
    private final TextFieldWithHistoryWithBrowseButton myGruntfileTextFieldWithBrowseButton;
    private final TextFieldWithHistory myTasksField;
    private final RawCommandLineEditor myArguments;
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final RawCommandLineEditor myNodeOptionsEditor;
    private final NodePackageField myGruntCliPackageField;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final JPanel myPanel;

    public GruntRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            GruntRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myGruntfileTextFieldWithBrowseButton = GruntRunConfigurationEditor.createGruntfileFieldWithBrowseButton(project);
        this.myTasksField = this.createTasksField();
        this.myArguments = new RawCommandLineEditor();
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myNodeOptionsEditor = GruntRunConfigurationEditor.createNodeOptionsEditor();
        this.myGruntCliPackageField = new NodePackageField(this.myNodeInterpreterField, GruntUtil.GRUNT, null);
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myPanel = FormBuilder.createFormBuilder().setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(JavaScriptBundle.message((String)"grunt.rc.gruntfile.label", (Object[])new Object[0]), (JComponent)this.myGruntfileTextFieldWithBrowseButton).addLabeledComponent(JavaScriptBundle.message((String)"grunt.rc.tasks.label", (Object[])new Object[0]), ComponentWithEmptyBrowseButton.wrap(this.myTasksField)).addLabeledComponent(JavaScriptBundle.message((String)"grunt.rc.arguments.label", (Object[])new Object[0]), (JComponent)this.myArguments).addComponent((JComponent)new JSeparator(), 8).addLabeledComponent(JavaScriptBundle.message((String)"grunt.rc.nodeInterpreter.label", (Object[])new Object[0]), (JComponent)((Object)this.myNodeInterpreterField), 8).addLabeledComponent(JavaScriptBundle.message((String)"grunt.rc.nodeOptions.label", (Object[])new Object[0]), (JComponent)this.myNodeOptionsEditor).addLabeledComponent(JavaScriptBundle.message((String)"grunt.rc.gruntCliPackage.label", (Object[])new Object[0]), (JComponent)((Object)this.myGruntCliPackageField)).addLabeledComponent(JavaScriptBundle.message((String)"grunt.rc.environmentVariables.label", (Object[])new Object[0]), (JComponent)this.myEnvVarsComponent).getPanel();
    }

    @NotNull
    public static RawCommandLineEditor createNodeOptionsEditor() {
        return new RawCommandLineEditor();
    }

    @NotNull
    private static TextFieldWithHistoryWithBrowseButton createGruntfileFieldWithBrowseButton(@NotNull Project project) {
        if (project == null) {
            GruntRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)JavaScriptBundle.message((String)"grunt.rc.gruntfile.browseDialogTitle", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleLocalFileDescriptor(), () -> {
            LinkedHashSet<VirtualFile> files = new LinkedHashSet<VirtualFile>();
            files.addAll(GruntService.getInstance().detectAllBuildfiles(project));
            files.addAll(GruntfileManager.getInstance(project).getBuildfiles());
            ArrayList<String> filePaths = new ArrayList<String>(files.size());
            for (VirtualFile file2 : files) {
                filePaths.add(FileUtil.toSystemDependentName((String)file2.getPath()));
            }
            Collections.sort(filePaths);
            return filePaths;
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            GruntRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    private TextFieldWithHistory createTasksField() {
        final TextFieldWithHistory field = new TextFieldWithHistory();
        field.setMinimumAndPreferredWidth(0);
        field.setHistorySize(-1);
        JsbtUtil.enableExpandingWithLazyHistoryLoading(field);
        final Ref lastGruntfileRef = Ref.create();
        field.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                final VirtualFile gruntfile = LocalFileSystem.getInstance().findFileByPath(((TextFieldWithHistory)GruntRunConfigurationEditor.this.myGruntfileTextFieldWithBrowseButton.getChildComponent()).getText());
                if (gruntfile == null || !gruntfile.isValid() || gruntfile.isDirectory()) {
                    SwingHelper.setHistory((TextFieldWithHistory)field, Collections.emptyList(), (boolean)false);
                    lastGruntfileRef.set(null);
                    return;
                }
                if (gruntfile.equals(lastGruntfileRef.get())) {
                    return;
                }
                lastGruntfileRef.set((Object)gruntfile);
                GruntfileManager gruntfileManager = GruntfileManager.getInstance(GruntRunConfigurationEditor.this.myProject);
                GruntfileStructure structure = gruntfileManager.getCachedStructure(gruntfile);
                if (structure != null) {
                    SwingHelper.setHistory((TextFieldWithHistory)field, JsbtUtil.encodeNames(structure.getTaskNames()), (boolean)false);
                } else {
                    gruntfileManager.fetchGruntStructure(gruntfile, new CatchingConsumer<GruntfileStructure, JsbtTaskFetchException>(){

                        public void consume(GruntfileStructure structure) {
                            List<String> taskNames = structure.getTaskNames();
                            field.setHistory(JsbtUtil.encodeNames(taskNames));
                        }

                        public void consume(JsbtTaskFetchException e) {
                            SwingHelper.setHistory((TextFieldWithHistory)field, Collections.emptyList(), (boolean)false);
                            LOG.warn("Cannot load grunt tasks for " + gruntfile.getPath(), (Throwable)e);
                        }
                    });
                }
            }
        });
        TextFieldWithHistory textFieldWithHistory = field;
        if (textFieldWithHistory == null) {
            GruntRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        return textFieldWithHistory;
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            GruntRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    protected void resetEditorFrom(@NotNull GruntRunConfiguration gruntRc) {
        if (gruntRc == null) {
            GruntRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        this.resetEditorFrom(gruntRc.getRunSettings());
    }

    public void resetEditorFrom(@NotNull GruntRunSettings runSettings) {
        if (runSettings == null) {
            GruntRunConfigurationEditor.$$$reportNull$$$0(6);
        }
        NodeJsInterpreterRef interpreterRef = runSettings.getInterpreterRef();
        GruntNonSharedSettings nonSharedSettings = GruntUtil.getGruntPackage(this.myProject, interpreterRef.resolve(this.myProject), runSettings.getGruntfile());
        this.myNodeInterpreterField.setInterpreterRef(interpreterRef);
        this.myNodeOptionsEditor.setText(runSettings.getNodeOptions());
        this.myGruntCliPackageField.setSelected(nonSharedSettings.getGruntCliPackage());
        this.myGruntfileTextFieldWithBrowseButton.setTextAndAddToHistory(runSettings.getGruntfilePath());
        this.myTasksField.setTextAndAddToHistory(ParametersListUtil.join(runSettings.getTasks()));
        this.myArguments.setText(runSettings.getArguments());
        this.myEnvVarsComponent.setData(runSettings.getEnvData());
        DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)this.myPanel);
        if (dialogWrapper instanceof SingleConfigurableEditor || dialogWrapper instanceof GruntBeforeRunTaskDialog) {
            this.myNodeInterpreterField.setPreferredWidthToFitText();
            this.myGruntCliPackageField.setPreferredWidthToFitText();
            SwingHelper.resizeDialogToFitTextFor((JComponent[])new JComponent[]{this.myGruntfileTextFieldWithBrowseButton});
        }
    }

    protected void applyEditorTo(@NotNull GruntRunConfiguration gruntRc) throws ConfigurationException {
        if (gruntRc == null) {
            GruntRunConfigurationEditor.$$$reportNull$$$0(7);
        }
        gruntRc.setRunSettings(this.getCurrentSettings());
    }

    @NotNull
    public GruntRunSettings getCurrentSettings() {
        GruntUtil.setGruntPackage(this.myProject, this.myGruntCliPackageField.getSelected());
        GruntRunSettings.Builder builder = new GruntRunSettings.Builder();
        builder.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder.setNodeOptions(this.myNodeOptionsEditor.getText());
        builder.setGruntfilePath(((TextFieldWithHistory)this.myGruntfileTextFieldWithBrowseButton.getChildComponent()).getText());
        List tasks = Collections.emptyList();
        String tasksText = this.myTasksField.getText();
        if (!StringUtil.isEmptyOrSpaces((String)tasksText)) {
            tasks = ParametersListUtil.parse((String)tasksText);
        }
        builder.setTasks(tasks);
        builder.setArguments(this.myArguments.getText());
        builder.setEnvData(this.myEnvVarsComponent.getData());
        GruntRunSettings gruntRunSettings = builder.build();
        if (gruntRunSettings == null) {
            GruntRunConfigurationEditor.$$$reportNull$$$0(8);
        }
        return gruntRunSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfigurationEditor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gruntRc";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createGruntfileFieldWithBrowseButton";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTasksField";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createGruntfileFieldWithBrowseButton";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

