/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.documentation;

import com.intellij.javascript.nodejs.documentation.NodeJsPackageDocumentation;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.SemVer;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionRangeDocBuilder {
    private final String myPackageName;
    private final InstalledPackageVersion myPkg;
    private final SemVer myFromInclusiveVersion;
    private final SemVer myToExclusiveVersion;

    public VersionRangeDocBuilder(@NotNull String packageName, @Nullable InstalledPackageVersion pkg, @NotNull String versionRange) {
        if (packageName == null) {
            VersionRangeDocBuilder.$$$reportNull$$$0(0);
        }
        if (versionRange == null) {
            VersionRangeDocBuilder.$$$reportNull$$$0(1);
        }
        this.myPackageName = packageName;
        this.myPkg = pkg;
        Pair<SemVer, SemVer> range = VersionRangeDocBuilder.findTildeRange(versionRange);
        if (range == null) {
            range = VersionRangeDocBuilder.findCaretRange(versionRange);
        }
        this.myFromInclusiveVersion = range != null ? (SemVer)range.first : null;
        this.myToExclusiveVersion = range != null ? (SemVer)range.second : null;
    }

    @Nullable
    private static Pair<SemVer, SemVer> findTildeRange(@NotNull String versionRange) {
        if (versionRange == null) {
            VersionRangeDocBuilder.$$$reportNull$$$0(2);
        }
        if (!versionRange.startsWith("~")) {
            return null;
        }
        Pair<SemVer, Integer> pair = VersionRangeDocBuilder.normalize(versionRange.substring(1));
        return pair == null ? null : VersionRangeDocBuilder.findTildeRange((SemVer)pair.first, (Integer)pair.second);
    }

    private static Pair<SemVer, SemVer> findTildeRange(@NotNull SemVer fromVersion, int components) {
        if (fromVersion == null) {
            VersionRangeDocBuilder.$$$reportNull$$$0(3);
        }
        if (fromVersion.getParsedVersion().equals(fromVersion.getRawVersion())) {
            return new Pair((Object)fromVersion, (Object)VersionRangeDocBuilder.version(fromVersion.getMajor() + (components == 1 ? 1 : 0), fromVersion.getMinor() + (components != 1 ? 1 : 0), 0));
        }
        return new Pair((Object)fromVersion, (Object)VersionRangeDocBuilder.version(fromVersion.getMajor(), fromVersion.getMinor() + 1, 0));
    }

    @Nullable
    private static Pair<SemVer, SemVer> findCaretRange(@NotNull String versionRange) {
        if (versionRange == null) {
            VersionRangeDocBuilder.$$$reportNull$$$0(4);
        }
        if (!versionRange.startsWith("^")) {
            return null;
        }
        Pair<SemVer, Integer> pair = VersionRangeDocBuilder.normalize(versionRange.substring(1));
        return pair == null ? null : VersionRangeDocBuilder.findCaretRange((SemVer)pair.first, (Integer)pair.second);
    }

    @NotNull
    private static Pair<SemVer, SemVer> findCaretRange(SemVer fromVersion, int components) {
        SemVer toVersion = fromVersion.getMajor() != 0 || components == 1 ? VersionRangeDocBuilder.version(fromVersion.getMajor() + 1, 0, 0) : (fromVersion.getMinor() != 0 || components == 2 ? VersionRangeDocBuilder.version(fromVersion.getMajor(), fromVersion.getMinor() + 1, 0) : VersionRangeDocBuilder.version(fromVersion.getMajor(), fromVersion.getMinor(), fromVersion.getPatch() + 1));
        return new Pair((Object)fromVersion, (Object)toVersion);
    }

    @Nullable
    private static Pair<SemVer, Integer> normalize(@NotNull String versionStr) {
        if (versionStr == null) {
            VersionRangeDocBuilder.$$$reportNull$$$0(5);
        }
        int components = Math.min(3, StringUtil.countChars((CharSequence)versionStr, (char)'.') + 1);
        SemVer ver = SemVer.parseFromText((String)(versionStr = versionStr + StringUtil.repeat((String)".0", (int)(3 - components))));
        return ver == null ? null : new Pair((Object)ver, (Object)components);
    }

    @NotNull
    private static SemVer version(int major, int minor, int patch) {
        SemVer semVer = Objects.requireNonNull(SemVer.parseFromText((String)(major + "." + minor + "." + patch)));
        if (semVer == null) {
            VersionRangeDocBuilder.$$$reportNull$$$0(6);
        }
        return semVer;
    }

    @Nullable
    public String buildQuickNavigateInfo() {
        String versionRangeHint = this.buildVersionRangeHint();
        String installed = this.myPkg != null ? "installed: " + (this.myPkg.getVersion() != null ? this.myPkg.getVersion().getRawVersion() : "?") : "not installed";
        Ref<SemVer> latestRef = NodeJsPackageDocumentation.getLatest(this.myPackageName, null);
        String latest = latestRef == null ? "loading..." : (latestRef.get() == null ? "not found" : ((SemVer)latestRef.get()).getRawVersion());
        String installedAndLatest = installed + ", latest: " + latest;
        if (versionRangeHint != null) {
            return versionRangeHint + " (" + installedAndLatest + ")";
        }
        return installedAndLatest;
    }

    @Nullable
    private String buildVersionRangeHint() {
        if (this.myFromInclusiveVersion != null && this.myToExclusiveVersion != null) {
            String descr = "Allows";
            if (this.myToExclusiveVersion.getMajor() == this.myFromInclusiveVersion.getMajor() + 1 && this.myToExclusiveVersion.getMinor() == 0 && this.myToExclusiveVersion.getPatch() == 0) {
                descr = "Allows minor updates:";
            } else if (this.myToExclusiveVersion.getMajor() == this.myFromInclusiveVersion.getMajor() && this.myToExclusiveVersion.getMinor() == this.myFromInclusiveVersion.getMinor() + 1 && this.myToExclusiveVersion.getPatch() == 0) {
                descr = "Allows patch updates:";
            }
            return descr + " " + this.myFromInclusiveVersion.getRawVersion() + " &gt;= version &lt; " + this.myToExclusiveVersion.getRawVersion();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromVersion";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionStr";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/documentation/VersionRangeDocBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/documentation/VersionRangeDocBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findTildeRange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findCaretRange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

