/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.codeInsight;

import com.intellij.javascript.nodejs.env.NodeEnvironmentVariablesProvider;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeFrameworkIndexingHandler
extends FrameworkIndexingHandler {
    private static final String[] PROCESS_ENV = new String[]{"process", "env"};

    @Override
    public boolean processTypeBeforeAdd(@NotNull JSType type, @NotNull JSEvaluateContext context, @NotNull JSTypeProcessor processor) {
        JSReferenceExpression processEnvExpr;
        if (type == null) {
            NodeFrameworkIndexingHandler.$$$reportNull$$$0(0);
        }
        if (context == null) {
            NodeFrameworkIndexingHandler.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            NodeFrameworkIndexingHandler.$$$reportNull$$$0(2);
        }
        if ((processEnvExpr = context.getProcessedExpression()) != null && NodeFrameworkIndexingHandler.isProcessEnv(type, processEnvExpr)) {
            JSTypeSource source = type.getSource();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)processEnvExpr);
            Map<String, String> envs = NodeEnvironmentVariablesProvider.getInstance(processEnvExpr.getProject()).getEnvironment(virtualFile);
            List memberList = ContainerUtil.map(envs.entrySet(), entry -> NodeFrameworkIndexingHandler.createMember(processEnvExpr, source, (String)entry.getKey(), (String)entry.getValue()));
            JSStringType stringType = new JSStringType(true, source, JSTypeContext.INSTANCE);
            memberList.add(new JSRecordTypeImpl.IndexSignatureImpl((JSType)stringType, (JSType)stringType, (PsiElement)processEnvExpr, false));
            JSSimpleRecordTypeImpl recordType = new JSSimpleRecordTypeImpl(source, memberList);
            processor.process(recordType, context, (PsiElement)processEnvExpr);
            return false;
        }
        return true;
    }

    @NotNull
    private static JSRecordType.TypeMember createMember(@NotNull JSReferenceExpression processEnvExpr, @NotNull JSTypeSource source, @NotNull String envVarName, final @Nullable String envVarValue) {
        if (processEnvExpr == null) {
            NodeFrameworkIndexingHandler.$$$reportNull$$$0(3);
        }
        if (source == null) {
            NodeFrameworkIndexingHandler.$$$reportNull$$$0(4);
        }
        if (envVarName == null) {
            NodeFrameworkIndexingHandler.$$$reportNull$$$0(5);
        }
        FakeEnvElement provider = new FakeEnvElement(processEnvExpr, envVarName);
        JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(envVarName, (PsiElement)provider).forbidAstAccess();
        JSImplicitElementImpl element = new JSImplicitElementImpl(builder){

            @Override
            public ItemPresentation getPresentation() {
                return new JSItemPresentation((JSPsiElementBase)this){

                    @Override
                    @NotNull
                    public String getLocationString(boolean completion) {
                        String string = (String)ObjectUtils.notNull((Object)envVarValue, (Object)"undefined");
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/codeInsight/NodeFrameworkIndexingHandler$1$1", "getLocationString"));
                    }
                };
            }
        };
        return new JSRecordTypeImpl.PropertySignatureImpl(envVarName, (JSType)new JSStringLiteralTypeImpl(StringUtil.notNullize((String)envVarValue), true, source), true, true, new JSRecordMemberSourceFactory.SingleMemberSource((PsiElement)element));
    }

    private static boolean isProcessEnv(@NotNull JSType type, @NotNull JSReferenceExpression expr) {
        if (type == null) {
            NodeFrameworkIndexingHandler.$$$reportNull$$$0(6);
        }
        if (expr == null) {
            NodeFrameworkIndexingHandler.$$$reportNull$$$0(7);
        }
        if (type instanceof JSTypeImpl && "ProcessEnv".equals(type.getTypeText(JSType.TypeTextFormat.SIMPLE))) {
            return true;
        }
        PsiElement sourceElement = type.getSourceElement();
        if (sourceElement instanceof JSProperty && "process.env".equals(((JSProperty)sourceElement).getQualifiedName())) {
            return true;
        }
        return NodeFrameworkIndexingHandler.isProcessEnv(expr);
    }

    public static boolean isProcessEnv(@Nullable JSReferenceExpression expr) {
        return JSSymbolUtil.isAccurateReferenceExpressionName(expr, PROCESS_ENV);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processEnvExpr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVarName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/codeInsight/NodeFrameworkIndexingHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processTypeBeforeAdd";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createMember";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isProcessEnv";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FakeEnvElement
    extends FakePsiElement
    implements SyntheticElement {
        private final JSReferenceExpression myProcessEnvExpr;
        private final String myEnvVarName;

        private FakeEnvElement(@NotNull JSReferenceExpression processEnvExpr, @NotNull String envVarName) {
            if (processEnvExpr == null) {
                FakeEnvElement.$$$reportNull$$$0(0);
            }
            if (envVarName == null) {
                FakeEnvElement.$$$reportNull$$$0(1);
            }
            this.myProcessEnvExpr = processEnvExpr;
            this.myEnvVarName = envVarName;
        }

        public PsiElement getParent() {
            return this.myProcessEnvExpr;
        }

        public void navigate(boolean requestFocus) {
            VirtualFile contextFile = PsiUtilCore.getVirtualFile((PsiElement)this.myProcessEnvExpr);
            NodeEnvironmentVariablesProvider.getInstance(this.myProcessEnvExpr.getProject()).navigate(this.myEnvVarName, contextFile);
        }

        @Nullable
        public Navigatable getNavigatable() {
            NodeEnvironmentVariablesProvider provider = NodeEnvironmentVariablesProvider.getInstance(this.myProcessEnvExpr.getProject());
            return provider.getNavigatable(this.myEnvVarName, PsiUtilCore.getVirtualFile((PsiElement)this.myProcessEnvExpr));
        }

        public String getName() {
            return null;
        }

        public TextRange getTextRange() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processEnvExpr";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "envVarName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/codeInsight/NodeFrameworkIndexingHandler$FakeEnvElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

