/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.psi.JSArgumentsHolder;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<JSArgumentsHolder, JSFunctionWithSubstitutor, JSExpression> {
    private static final Set<Class<?>> ourArgumentListAllowedParentClassesSet = ContainerUtil.newHashSet((Object[])new Class[]{JSCallLikeExpression.class});
    private static final Set<Class<?>> ourStopSearch = Collections.singleton(JSFunction.class);
    private static final int MAX_CANCELED_RETRY_COUNT = 5;
    private static final String NO_NAME = "<no name>";
    public static final Function<JSType, String> TYPE_DESCRIBER = type -> JSLookupUtilImpl.getShortName(type.transformTypeHierarchy(t -> JSParameterInfoHandler.widenIfLiteral(t)).getTypeText(JSType.TypeTextFormat.PRESENTABLE));

    public boolean couldShowInLookup() {
        return true;
    }

    @NotNull
    public Set<? extends Class<?>> getArgListStopSearchClasses() {
        Set<Class<?>> set = ourStopSearch;
        if (set == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(0);
        }
        return set;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        if (!(item instanceof MutableLookupElement)) {
            return null;
        }
        PsiElement o = item.getPsiElement();
        if (o instanceof JSFunctionItem) {
            LinkedHashMap<String, JSFunctionWithSubstitutor> typedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>();
            LinkedHashMap<String, JSFunctionWithSubstitutor> untypedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>();
            HashSet<String> untypedKeysForTypedSignatures = new HashSet<String>();
            if (o instanceof JSFunction) {
                for (PsiElement el : DefinitionsScopedSearch.search((PsiElement)((JSFunction)o))) {
                    if (!(el instanceof JSFunction)) continue;
                    JSParameterInfoHandler.doAddSignature(typedSignatures, untypedSignatures, untypedKeysForTypedSignatures, (JSFunctionItem)((JSFunction)el), JSTypeSubstitutor.EMPTY);
                }
            }
            ArrayList<JSFunctionWithSubstitutor> result2 = new ArrayList<JSFunctionWithSubstitutor>(typedSignatures.size() + 1);
            result2.add(new JSFunctionWithSubstitutor((JSFunctionItem)o, JSTypeSubstitutor.EMPTY));
            result2.addAll(typedSignatures.values());
            return ArrayUtil.toObjectArray(result2);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    private static void doAddSignature(@NotNull Map<String, JSFunctionWithSubstitutor> typedSignatures, @NotNull Map<String, JSFunctionWithSubstitutor> untypedSignatures, @NotNull Set<String> untypedKeysForTypedSignatures, @NotNull JSFunctionItem functionItem, @NotNull JSTypeSubstitutor typeSubstitutor) {
        String untypedSignature;
        String typedSignature;
        if (typedSignatures == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (untypedSignatures == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(2);
        }
        if (untypedKeysForTypedSignatures == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(3);
        }
        if (functionItem == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (typeSubstitutor == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(5);
        }
        if ((typedSignature = JSParameterInfoHandler.buildSignature((JSFunctionItem)functionItem, (boolean)false, (int)-1, (JSTypeSubstitutor)typeSubstitutor).text).equals(untypedSignature = JSParameterInfoHandler.buildSignature((JSFunctionItem)functionItem, (boolean)true, (int)-1, (JSTypeSubstitutor)typeSubstitutor).text)) {
            if (!untypedSignatures.containsKey(untypedSignature)) {
                untypedSignatures.put(untypedSignature, new JSFunctionWithSubstitutor(functionItem, typeSubstitutor));
            }
        } else if (!typedSignatures.containsKey(typedSignature)) {
            typedSignatures.put(typedSignature, new JSFunctionWithSubstitutor(functionItem, typeSubstitutor));
            untypedKeysForTypedSignatures.add(untypedSignature);
        }
    }

    public JSArgumentsHolder findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        JSArgumentsHolder argList;
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if ((argList = JSParameterInfoHandler.findArgumentList(context.getFile(), context.getOffset())) == null) {
            return null;
        }
        if (this.skipTypeScript() && DialectDetector.isTypeScript((PsiElement)argList)) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Stream<JSFunctionWithSubstitutor> resultStream = this.fillSignaturesForArgumentList(context, argList);
            if (resultStream != null) {
                context.setItemsToShow(resultStream.toArray());
                return argList;
            }
            context.setItemsToShow(null);
            return null;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            int canceledCount = 0;
            while (canceledCount < 5) {
                boolean isInvalid = (Boolean)ReadAction.compute(() -> {
                    if (!argList.isValid() || JSParameterInfoHandler.findArgumentList(context.getFile(), context.getOffset()) != argList) {
                        return true;
                    }
                    Editor editor = context.getEditor();
                    return context.getProject().isDisposed() || editor.isDisposed();
                });
                if (isInvalid) {
                    return;
                }
                ProgressIndicatorBase indicator = new ProgressIndicatorBase();
                boolean success = this.runInReadActionWithWritePriority(context, argList, (ProgressIndicator)indicator);
                if (success) {
                    return;
                }
                if (!indicator.isCanceled()) continue;
                ++canceledCount;
            }
        });
        return null;
    }

    private boolean runInReadActionWithWritePriority(@NotNull CreateParameterInfoContext context, @NotNull JSArgumentsHolder argList, @NotNull ProgressIndicator indicator) {
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(7);
        }
        if (argList == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(9);
        }
        return ProgressManager.getInstance().runInReadActionWithWriteActionPriority(() -> {
            Stream<JSFunctionWithSubstitutor> resultStream = this.fillSignaturesForArgumentList(context, argList);
            if (resultStream != null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    context.setItemsToShow(resultStream.toArray());
                    this.showParameterInfo(argList, context);
                });
            }
        }, indicator);
    }

    @Nullable
    public static JSArgumentsHolder findArgumentList(@Nullable PsiFile file2, int offset) {
        JSCallExpression callExpression;
        if (file2 == null) {
            return null;
        }
        JSArgumentsHolder argList = (JSArgumentsHolder)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file2, (int)offset, JSArgumentsHolder.class, (Class[])new Class[]{JSStatement.class, JSFunctionExpression.class});
        if (argList == null && (callExpression = (JSCallExpression)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file2, (int)offset, JSCallExpression.class, (Class[])new Class[]{JSStatement.class})) != null) {
            argList = callExpression.getArgumentList();
        }
        return argList != null && PsiTreeUtil.getContextOfType((PsiElement)file2.findElementAt(offset), TypeScriptTypeArgumentList.class, (boolean)true, (Class[])new Class[]{JSStatement.class}) == null ? argList : null;
    }

    @Nullable
    protected Stream<JSFunctionWithSubstitutor> fillSignaturesForArgumentList(CreateParameterInfoContext context, @NotNull JSArgumentsHolder argList) {
        JSFunctionItem implicitFunction;
        if (argList == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiElement psiElement = argList.getParent();
        if (!(psiElement instanceof JSCallLikeExpression)) {
            return null;
        }
        JSCallLikeExpression parent = (JSCallLikeExpression)psiElement;
        JSExpression methodExpression = JSUtils.unparenthesize(parent.getMethodExpression());
        if (methodExpression instanceof JSReferenceExpression || methodExpression instanceof JSIndexedPropertyAccessExpression) {
            return this.fillSignaturesForReferenceOrIndexAccessExpression(parent, methodExpression);
        }
        if (methodExpression instanceof JSSuperExpression || methodExpression instanceof JSThisExpression) {
            PsiReference reference = methodExpression.getReference();
            if (reference == null) {
                return null;
            }
            PsiElement clazz = reference.resolve();
            if (clazz instanceof JSFunction) {
                if (clazz instanceof TypeScriptFunction) {
                    Collection<? extends JSFunctionItem> overloadDeclarations = TypeScriptPsiUtil.getAllOverloadSignatures((JSFunctionItem)((TypeScriptFunction)clazz));
                    return overloadDeclarations.stream().map(c -> new JSFunctionWithSubstitutor((JSFunctionItem)c, JSTypeSubstitutor.EMPTY));
                }
                return Stream.of(new JSFunctionWithSubstitutor((JSFunctionItem)((JSFunction)clazz), JSTypeSubstitutor.EMPTY));
            }
        } else if (methodExpression instanceof JSFunctionExpression) {
            return Stream.of(new JSFunctionWithSubstitutor((JSFunctionItem)((JSFunctionExpression)methodExpression), JSTypeSubstitutor.EMPTY));
        }
        if ((implicitFunction = JSParameterInfoHandler.getImplicitFunction(methodExpression)) != null) {
            return JSParameterInfoHandler.fillSignatures(Collections.singletonList(implicitFunction), JSTypeSubstitutor.EMPTY);
        }
        return null;
    }

    private static Collection<PsiElement> getResolvedPsiElements(JSExpression methodExpression) {
        if (methodExpression instanceof JSReferenceExpression) {
            ResolveResult[] resolveResults = ((JSReferenceExpression)methodExpression).multiResolve(true);
            if (resolveResults.length <= 0) {
                return Collections.emptyList();
            }
            return JSResolveResult.toElements(resolveResults, false);
        }
        if (methodExpression instanceof JSIndexedPropertyAccessExpression) {
            String value;
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
            JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)methodExpression).getIndexExpression();
            String propertyName = null;
            if (indexExpression instanceof JSLiteralExpression && (value = ((JSLiteralExpression)indexExpression).getStringValue()) != null) {
                propertyName = value;
            }
            if (JSPsiImplUtils.isSymbolRef(indexExpression)) {
                propertyName = "[" + indexExpression.getText() + "]";
            }
            if (propertyName != null) {
                JSRecordType recordType;
                JSRecordType.PropertySignature propertySignature;
                JSType qualifierType = JSResolveUtil.getExpressionJSType(((JSIndexedPropertyAccessExpression)methodExpression).getQualifier());
                if ((qualifierType = JSTypeUtils.getValuableType(qualifierType)) != null && (propertySignature = (recordType = qualifierType.asRecordType()).findPropertySignature(propertyName)) != null) {
                    JSRecordType.MemberSource source = propertySignature.getMemberSource();
                    if (!source.isUnion()) {
                        elements.addAll(source.getAllSourceElements());
                    } else if (propertySignature instanceof JSCompositeFunctionPropertySignatureImpl) {
                        for (JSRecordType.PropertySignature part : ((JSCompositeFunctionPropertySignatureImpl)propertySignature).getMembers()) {
                            source = part.getMemberSource();
                            if (source.isUnion()) continue;
                            elements.addAll(source.getAllSourceElements());
                        }
                    }
                }
            }
            return elements;
        }
        throw new UnsupportedOperationException("Expression " + methodExpression.getClass() + " is not supported");
    }

    @Nullable
    protected Stream<JSFunctionWithSubstitutor> fillSignaturesForReferenceOrIndexAccessExpression(@NotNull JSCallLikeExpression parent, @NotNull JSExpression methodExpression) {
        Collection<PsiElement> elements;
        if (parent == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(11);
        }
        if (methodExpression == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(12);
        }
        if ((elements = JSParameterInfoHandler.getResolvedPsiElements(methodExpression)).size() == 0) {
            return null;
        }
        elements = JSParameterInfoHandler.getElementsWithConstructors(parent, elements);
        assert (methodExpression instanceof JSQualifiedExpression);
        JSExpression qualifier = ((JSQualifiedExpression)methodExpression).getQualifier();
        List<JSFunctionItem> items = JSParameterInfoHandler.getFunctionItems(methodExpression, elements);
        JSTypeSubstitutor typeSubstitutor = JSParameterInfoHandler.getTypeSubstitutor(methodExpression, qualifier, items);
        return JSParameterInfoHandler.fillSignatures(items, typeSubstitutor);
    }

    @NotNull
    private static Stream<JSFunctionWithSubstitutor> fillSignatures(List<JSFunctionItem> items, JSTypeSubstitutor typeSubstitutor) {
        LinkedHashMap<String, JSFunctionWithSubstitutor> typedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>(items.size());
        LinkedHashMap<String, JSFunctionWithSubstitutor> untypedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>();
        HashSet<String> untypedKeysForTypedSignatures = new HashSet<String>();
        for (JSFunctionItem functionItem : items) {
            JSParameterInfoHandler.doAddSignature(typedSignatures, untypedSignatures, untypedKeysForTypedSignatures, functionItem, typeSubstitutor);
        }
        Stream typedStream = typedSignatures.values().stream();
        Stream.Builder untypedStreamBuilder = Stream.builder();
        for (Map.Entry entry : untypedSignatures.entrySet()) {
            if (untypedKeysForTypedSignatures.contains(entry.getKey())) continue;
            untypedStreamBuilder.add(entry.getValue());
        }
        Stream<JSFunctionWithSubstitutor> stream = Stream.concat(typedStream, untypedStreamBuilder.build());
        if (stream == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(13);
        }
        return stream;
    }

    @NotNull
    private static List<JSFunctionItem> getFunctionItems(@NotNull JSExpression methodExpression, @NotNull Collection<PsiElement> elements) {
        if (methodExpression == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(14);
        }
        if (elements == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(15);
        }
        List<JSFunctionItem> items = new LinkedList<JSFunctionItem>();
        for (PsiElement element : elements) {
            Collection<? extends JSFunctionItem> functionItems;
            if (element instanceof TypeScriptProxyImplicitElementWithBackingItem) {
                element = ((TypeScriptProxyImplicitElementWithBackingItem)element).getBackingElement();
            }
            if ((functionItems = JSParameterInfoHandler.getFunctionItems(methodExpression, element)).size() == 0) continue;
            items.addAll(functionItems);
        }
        if (items.size() == 0) {
            items = JSParameterInfoHandler.getImplicitFunctions(methodExpression);
        }
        LinkedList<JSFunctionItem> linkedList = items;
        if (linkedList == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(16);
        }
        return linkedList;
    }

    @Nullable
    public static JSFunctionItem getImplicitFunction(@Nullable JSExpression methodExpression) {
        List<JSFunctionItem> functions = JSParameterInfoHandler.getImplicitFunctions(methodExpression);
        return functions.size() == 1 ? functions.get(0) : null;
    }

    @NotNull
    public static List<JSFunctionItem> getImplicitFunctions(@Nullable JSExpression methodExpression) {
        JSExpression innerExpression;
        if (methodExpression instanceof JSParenthesizedExpression && (innerExpression = ((JSParenthesizedExpression)methodExpression).getInnerExpression()) instanceof JSFunctionItem) {
            List<JSFunctionItem> list2 = Collections.singletonList((JSFunctionItem)innerExpression);
            if (list2 == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(17);
            }
            return list2;
        }
        SmartList implicitFunctions = new SmartList();
        JSType methodType = JSResolveUtil.getExpressionJSType(methodExpression);
        if (methodType != null) {
            JSRecordType recordType = methodType.asRecordType();
            List signatures = recordType.getCallSignatures();
            for (JSRecordType.CallSignature signature : signatures) {
                implicitFunctions.add(new JSImplicitFunctionImpl(new JSImplicitElementStructureImpl(new JSImplicitElementImpl.Builder("func", null)), (JSParameterItem[])JSParameterInfoHandler.getParameters(signature), null));
            }
        }
        SmartList smartList = implicitFunctions;
        if (smartList == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(18);
        }
        return smartList;
    }

    private static JSParameterTypeDecorator @NotNull [] getParameters(@NotNull JSRecordType.CallSignature signature) {
        JSParameterItem[] sourceParameters;
        if (signature == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(19);
        }
        PsiElement sourceElement = signature.getMemberSource().getSingleElement();
        List parameterTypes = signature.getParameterTypeDecorators();
        if (sourceElement instanceof JSImplicitFunctionImpl && DialectDetector.isJavaScript(sourceElement) && (sourceParameters = ((JSImplicitFunctionImpl)sourceElement).getParameters()).length == parameterTypes.size() && parameterTypes.stream().allMatch(p -> p.getName() == null)) {
            JSParameterTypeDecorator[] finalTypes = new JSParameterTypeDecorator[sourceParameters.length];
            for (int i = 0; i < sourceParameters.length; ++i) {
                finalTypes[i] = new JSParameterTypeDecoratorImpl(sourceParameters[i].getName(), ((JSParameterTypeDecorator)parameterTypes.get(i)).getSimpleType(), ((JSParameterTypeDecorator)parameterTypes.get(i)).isOptional(), ((JSParameterTypeDecorator)parameterTypes.get(i)).isRest(), ((JSParameterTypeDecorator)parameterTypes.get(i)).isExplicitlyDeclared());
            }
            if (finalTypes == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(20);
            }
            return finalTypes;
        }
        if (parameterTypes.size() > 0 && parameterTypes.stream().anyMatch(p -> p.getName() == null || p.isOptional() && TypeScriptTypeRelations.isUnionWithUndefinedType(p.getInferredType())) && sourceElement instanceof JSFunctionItem) {
            JSParameterTypeDecorator[] jSParameterTypeDecoratorArray = (JSParameterTypeDecorator[])ContainerUtil.toArray(JSParameterInfoHandler.fixParamNamesAndUndefinedStatus(parameterTypes, ((JSFunctionItem)sourceElement).getParameters()), JSParameterTypeDecorator[]::new);
            if (jSParameterTypeDecoratorArray == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(21);
            }
            return jSParameterTypeDecoratorArray;
        }
        JSParameterTypeDecorator[] jSParameterTypeDecoratorArray = (JSParameterTypeDecorator[])ContainerUtil.toArray((Collection)parameterTypes, JSParameterTypeDecorator[]::new);
        if (jSParameterTypeDecoratorArray == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(22);
        }
        return jSParameterTypeDecoratorArray;
    }

    @NotNull
    private static List<JSParameterTypeDecorator> fixParamNamesAndUndefinedStatus(@NotNull List<JSParameterTypeDecorator> parameterTypes, JSParameterItem @NotNull [] parameters) {
        if (parameterTypes == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(23);
        }
        if (parameters == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(24);
        }
        ArrayList<JSParameterTypeDecorator> newDecorators = new ArrayList<JSParameterTypeDecorator>(parameterTypes.size());
        for (int i = 0; i < parameterTypes.size(); ++i) {
            JSParameterTypeDecorator type = parameterTypes.get(i);
            if (type.getName() == null && i < parameters.length) {
                List<JSType> types2;
                List nonUndefined;
                boolean optional = type.isOptional();
                JSType inferredType = type.getInferredType();
                if (optional && inferredType instanceof JSUnionType && (nonUndefined = ContainerUtil.filter(types2 = ((JSUnionType)inferredType).getTypes(), t -> !(t instanceof JSUndefinedType))).size() < types2.size()) {
                    inferredType = JSCompositeTypeFactory.createUnionType(inferredType.getSource(), nonUndefined);
                }
                newDecorators.add(new JSParameterTypeDecoratorImpl(parameters[i].getName(), inferredType, optional, type.isRest(), type.isExplicitlyDeclared()));
                continue;
            }
            newDecorators.add(type);
        }
        ArrayList<JSParameterTypeDecorator> arrayList = newDecorators;
        if (arrayList == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @NotNull
    private static JSTypeSubstitutor getTypeSubstitutor(JSExpression methodExpression, @Nullable JSExpression qualifier, @NotNull List<JSFunctionItem> items) {
        JSNamespace namespace;
        JSType qualifierType;
        JSFunctionItem firstFunction;
        if (items == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(26);
        }
        if ((firstFunction = (JSFunctionItem)ContainerUtil.getFirstItem(items)) instanceof TypeScriptFunction) {
            JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getInstance().getTypeSubstitutorForMember((JSElement)firstFunction, (PsiElement)methodExpression);
            if (jSTypeSubstitutor == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(27);
            }
            return jSTypeSubstitutor;
        }
        if (qualifier != null && (qualifierType = JSResolveUtil.getExpressionJSType(qualifier)) != null && (namespace = JSTypeUtils.getNamespaceMatchingType(qualifierType, false)) != null) {
            JSTypeSubstitutor jSTypeSubstitutor = (JSTypeSubstitutor)ObjectUtils.coalesce((Object)JSTypeWithOuterGenerics.getGenericArguments(namespace), (Object)JSTypeSubstitutor.EMPTY);
            if (jSTypeSubstitutor == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(28);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(29);
        }
        return jSTypeSubstitutor;
    }

    private static Collection<PsiElement> getElementsWithConstructors(JSCallLikeExpression parent, Collection<PsiElement> elements) {
        JSExpression methodExpression = parent.getMethodExpression();
        if (methodExpression == null) {
            return elements;
        }
        if (parent instanceof JSNewExpression) {
            ArrayList<PsiElement> newElements = new ArrayList<PsiElement>(elements.size());
            for (PsiElement element : elements) {
                if (element instanceof JSClass) {
                    ResolveResult[] constructorResults;
                    JSClass jsClass = (JSClass)element;
                    for (ResolveResult result2 : constructorResults = JSClassUtils.resolveES6Constructor(jsClass, methodExpression)) {
                        PsiElement resultConstructor = result2.getElement();
                        if (resultConstructor == null) continue;
                        newElements.add(resultConstructor);
                    }
                    continue;
                }
                newElements.add(element);
            }
            elements = newElements;
        }
        return elements;
    }

    @NotNull
    private static Collection<? extends JSFunctionItem> getFunctionItems(JSExpression methodExpression, PsiElement element) {
        JSFunctionItem functionItem = JSParameterInfoHandler.calculatePossibleFunctionCarefully(element, (PsiElement)methodExpression);
        if (functionItem instanceof TypeScriptFunction) {
            Collection<? extends JSFunctionItem> collection = TypeScriptPsiUtil.getAllOverloadSignatures((JSFunctionItem)((TypeScriptFunction)functionItem));
            if (collection == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(30);
            }
            return collection;
        }
        List list2 = ContainerUtil.createMaybeSingletonList((Object)functionItem);
        if (list2 == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(31);
        }
        return list2;
    }

    public void showParameterInfo(@NotNull JSArgumentsHolder element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(32);
        }
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(33);
        }
        context.showHint((PsiElement)element, element.getTextOffset(), (ParameterInfoHandler)this);
    }

    public JSArgumentsHolder findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(34);
        }
        return JSParameterInfoHandler.findArgumentList(context.getFile(), context.getOffset());
    }

    public void updateParameterInfo(@NotNull JSArgumentsHolder parameterOwner, @NotNull UpdateParameterInfoContext context) {
        if (parameterOwner == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(35);
        }
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(36);
        }
        context.setCurrentParameter(JSParameterInfoHandler.getParameterIndex(parameterOwner, context.getOffset()));
    }

    private static int getParameterIndex(@NotNull JSArgumentsHolder parameterOwner, int offset) {
        if (parameterOwner == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(37);
        }
        return ParameterInfoUtils.getCurrentParameterIndex((ASTNode)parameterOwner.getNode(), (int)offset, (IElementType)parameterOwner.getDelimiter());
    }

    public void updateUI(JSFunctionWithSubstitutor pair, @NotNull ParameterInfoUIContext context) {
        int highlightStart;
        JSFunctionItem p;
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(38);
        }
        if (!((p = pair.myFunctionItem) instanceof JSImplicitFunctionImpl) && !p.isValid()) {
            return;
        }
        JSParameterItem[] params = p.getParameters();
        int currentParameterIndex = context.getCurrentParameterIndex() >= 0 ? context.getCurrentParameterIndex() : params.length;
        JSParameterItem parameter = JSParameterInfoHandler.getParameter(params, currentParameterIndex);
        SignatureInfo signatureInfo = JSParameterInfoHandler.buildSignature(p, false, currentParameterIndex, pair.myTypeSubstitutor);
        String name = signatureInfo.text;
        String currentParameterSignature = parameter != null ? JSParameterInfoHandler.getSignatureForParameter(parameter, pair.myTypeSubstitutor, TYPE_DESCRIBER) : null;
        int n = highlightStart = signatureInfo.selectedParameterStart != -1 ? signatureInfo.selectedParameterStart : 0;
        int highlightEnd = signatureInfo.selectedParameterEnd != -1 ? signatureInfo.selectedParameterEnd : (parameter != null ? highlightStart + currentParameterSignature.length() : 0);
        context.setupUIComponentPresentation(name, highlightStart, highlightEnd, false, false, false, context.getDefaultParameterColor());
    }

    @Nullable
    private static JSParameterItem getParameter(JSParameterItem[] params, int currentParameterIndex) {
        JSParameterItem lastParam;
        if (currentParameterIndex < params.length) {
            return params[currentParameterIndex];
        }
        if (params.length > 0 && (lastParam = params[params.length - 1]).isRest()) {
            return lastParam;
        }
        return null;
    }

    @Nullable
    public static JSFunctionItem calculatePossibleFunctionCarefully(@NotNull PsiElement resolveResult, @Nullable PsiElement methodExpression) {
        PsiElement module;
        if (resolveResult == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(39);
        }
        if (resolveResult instanceof JSParameter && (module = JSAmdPsiUtil.findReferencedModule((JSParameter)resolveResult)) != null) {
            resolveResult = module;
        }
        return JSPsiImplUtils.calculatePossibleFunction(resolveResult, methodExpression, false);
    }

    private static JSType widenIfLiteral(JSType t) {
        return t instanceof JSLiteralType && ((JSLiteralType)t).allowWidening() ? ((JSLiteralType)t).widen(true) : t;
    }

    @NotNull
    private static SignatureInfo buildSignature(@NotNull JSFunctionItem function2, boolean skipType, int selectedParameterIndex, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (function2 == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(40);
        }
        JSParameterItem[] params = function2.getParameters();
        SignatureInfo info = new SignatureInfo();
        if (params.length > 0) {
            StringBuilder result2 = new StringBuilder();
            for (int i = 0; i < params.length; ++i) {
                List<String> signatures;
                if (result2.length() > 0) {
                    result2.append(", ");
                }
                if (selectedParameterIndex >= i) {
                    info.selectedParameterStart = result2.toString().length();
                }
                int innerIndex = (signatures = JSParameterInfoHandler.getSignaturesForParameter(params[i], skipType, typeSubstitutor, TYPE_DESCRIBER)).size() > 1 ? selectedParameterIndex - params.length + 1 : -1;
                for (int j = 0; j < signatures.size(); ++j) {
                    if (j != 0) {
                        result2.append(", ");
                    }
                    if (innerIndex == j) {
                        info.selectedParameterStart = result2.toString().length();
                    }
                    result2.append(signatures.get(j));
                    if (innerIndex != j) continue;
                    info.selectedParameterEnd = result2.toString().length();
                }
            }
            if (function2.isReferencesArguments()) {
                result2.append(", ...");
            }
            info.text = result2.toString();
        } else {
            String signature = function2.isReferencesArguments() ? "..." : CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]);
            info.text = signature;
        }
        SignatureInfo signatureInfo = info;
        if (signatureInfo == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(41);
        }
        return signatureInfo;
    }

    @NotNull
    private static List<String> getSignaturesForParameter(@NotNull JSParameterItem p, boolean skipType, @Nullable JSTypeSubstitutor typeSubstitutor, @NotNull Function<JSType, String> typeDescriber) {
        if (p == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(42);
        }
        if (typeDescriber == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(43);
        }
        JSParameterTypeDecorator decorator = p.getTypeDecorator();
        JSType type = (JSType)ObjectUtils.coalesce((Object)p.getSimpleType(), (Object)p.getInferredType());
        if (type != null) {
            type = JSTypeUtils.applyGenericArguments(type, typeSubstitutor);
        }
        String initializerText = p instanceof JSParameter ? ((JSParameter)p).getLiteralOrReferenceInitializerText() : null;
        DialectOptionHolder holder = p instanceof PsiElement ? DialectDetector.dialectOfElement((PsiElement)p) : null;
        if (type == null && !(skipType |= p instanceof JSDestructuringParameter && ((JSDestructuringParameter)p).getTypeElement() == null) && initializerText == null && !p.isRest() && p instanceof PsiElement) {
            type = JSResolveUtil.getElementJSType((PsiElement)p);
        }
        if (!skipType && type != null) {
            return JSParameterInfoHandler.getTypedSignatures(p, type, holder != null && holder.isECMA4, initializerText, typeDescriber);
        }
        String res = JSParameterInfoHandler.getParameterItemPresentableName(p);
        if (p.isRest()) {
            res = "... " + res;
        }
        if (p.isOptional() && decorator.isExplicitlyDeclared()) {
            res = res + "?";
        }
        if (initializerText != null) {
            res = res + " = " + initializerText;
        }
        List<String> list2 = Collections.singletonList(res);
        if (list2 == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(44);
        }
        return list2;
    }

    @NotNull
    private static List<String> getTypedSignatures(JSParameterItem p, JSType type, boolean isActionScript, String initializerText, Function<JSType, String> typeDescriber) {
        String typeSeparator;
        boolean needOptional = p.isOptional() && initializerText == null;
        String string = typeSeparator = isActionScript ? ":" : ": ";
        if (p.isRest()) {
            if (type instanceof JSRestTypeImpl) {
                JSType iterableType = ((JSRestTypeImpl)type).getIterableType();
                if (iterableType instanceof JSTupleType) {
                    int optionalStart = ((JSTupleType)iterableType).getOptionalStart();
                    List types2 = ((JSTupleType)iterableType).getTypes();
                    int index = 1;
                    LinkedList<String> allSignatures = new LinkedList<String>();
                    for (JSType jsType : types2) {
                        StringBuilder result2 = new StringBuilder();
                        String name = JSParameterInfoHandler.getNameFromParentOrDefault(p, index, jsType, iterableType);
                        if (jsType instanceof JSSpreadType) {
                            result2.append("...");
                            jsType = ((JSSpreadType)jsType).getInnerType();
                        }
                        result2.append(name);
                        if (optionalStart != -1 && index > optionalStart) {
                            result2.append("?");
                        }
                        result2.append(typeSeparator).append(typeDescriber.apply(jsType));
                        allSignatures.add(result2.toString());
                        ++index;
                    }
                    LinkedList<String> linkedList = allSignatures;
                    if (linkedList == null) {
                        JSParameterInfoHandler.$$$reportNull$$$0(45);
                    }
                    return linkedList;
                }
                type = iterableType;
            }
            StringBuilder result3 = new StringBuilder();
            result3.append("...").append(JSParameterInfoHandler.getParameterItemPresentableName(p)).append(typeSeparator).append(typeDescriber.apply(type));
            JSType simpleType = p.getSimpleType();
            if (!JSTypeUtils.isArrayLikeType(simpleType) && !(simpleType instanceof JSRestTypeImpl)) {
                result3.append("[]");
            }
            List<String> list2 = Collections.singletonList(result3.toString());
            if (list2 == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(46);
            }
            return list2;
        }
        StringBuilder result4 = new StringBuilder();
        result4.append(JSParameterInfoHandler.getParameterItemPresentableName(p));
        if (needOptional) {
            result4.append('?');
        }
        result4.append(typeSeparator).append(typeDescriber.apply(type));
        if (initializerText != null) {
            result4.append(" = ");
            result4.append(initializerText);
        }
        List<String> list3 = Collections.singletonList(result4.toString());
        if (list3 == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(47);
        }
        return list3;
    }

    @NotNull
    public static String getNameFromParentOrDefault(JSParameterItem item, int index, JSType ... jsTypes) {
        String name = JSParameterInfoHandler.getParameterItemPresentableName(item);
        if (name == NO_NAME) {
            name = "p" + index;
        }
        for (JSType jsType : jsTypes) {
            PsiElement parent;
            PsiElement sourceElement = jsType.getSourceElement();
            PsiElement psiElement = parent = sourceElement == null ? null : sourceElement.getParent();
            if (!(parent instanceof JSParameterItem)) continue;
            name = JSParameterInfoHandler.getParameterItemPresentableName((JSParameterItem)parent);
            break;
        }
        String string = name;
        if (string == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(48);
        }
        return string;
    }

    @NotNull
    public static String getParameterItemPresentableName(@NotNull JSParameterItem p) {
        String res;
        if (p == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(49);
        }
        if (p instanceof JSDestructuringParameter) {
            StringBuilder builder = new StringBuilder();
            JSDestructuringContainer target = ((JSDestructuringParameter)p).getTarget();
            if (target != null) {
                ES6PsiUtil.buildSignatureForDestructuringContainer(target, builder, true);
            }
            res = builder.toString();
        } else {
            res = p.getName();
        }
        return res != null ? res : NO_NAME;
    }

    public static String getSignatureForParameter(JSParameterItem p, @Nullable JSTypeSubstitutor typeSubstitutor, @NotNull Function<JSType, String> typeDescriber) {
        if (typeDescriber == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(50);
        }
        return StringUtil.join(JSParameterInfoHandler.getSignaturesForParameter(p, false, typeSubstitutor, typeDescriber), (String)", ");
    }

    public JSExpression @NotNull [] getActualParameters(@NotNull JSArgumentsHolder arguments) {
        if (arguments == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(51);
        }
        JSExpression[] jSExpressionArray = arguments.getArguments();
        if (jSExpressionArray == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(52);
        }
        return jSExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = JSTokenTypes.COMMA;
        if (iElementType == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(53);
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = JSTokenTypes.RBRACE;
        if (iElementType == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(54);
        }
        return iElementType;
    }

    @NotNull
    public Set<Class<?>> getArgumentListAllowedParentClasses() {
        Set<Class<?>> set = ourArgumentListAllowedParentClassesSet;
        if (set == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(55);
        }
        return set;
    }

    @NotNull
    public Class<JSArgumentsHolder> getArgumentListClass() {
        return JSArgumentsHolder.class;
    }

    protected boolean skipTypeScript() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 49: 
            case 50: 
            case 51: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 49: 
            case 50: 
            case 51: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/JSParameterInfoHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedSignatures";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "untypedSignatures";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "untypedKeysForTypedSignatures";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSubstitutor";
                break;
            }
            case 6: 
            case 7: 
            case 33: 
            case 34: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argList";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterOwner";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 42: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 43: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDescriber";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgListStopSearchClasses";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/JSParameterInfoHandler";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "fillSignatures";
                break;
            }
            case 16: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionItems";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitFunctions";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "fixParamNamesAndUndefinedStatus";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutor";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSignature";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignaturesForParameter";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedSignatures";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameFromParentOrDefault";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListAllowedParentClasses";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doAddSignature";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithWritePriority";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fillSignaturesForArgumentList";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fillSignaturesForReferenceOrIndexAccessExpression";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionItems";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fixParamNamesAndUndefinedStatus";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutor";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getParameterIndex";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleFunctionCarefully";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "buildSignature";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSignaturesForParameter";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getParameterItemPresentableName";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureForParameter";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 49: 
            case 50: 
            case 51: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SignatureInfo {
        String text;
        int selectedParameterStart = -1;
        int selectedParameterEnd = -1;

        private SignatureInfo() {
        }
    }
}

