/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.model.DasObject;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPositionalReference;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0002J!\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0096\u0002J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/intentions/SqlReplaceColumnNumberWithNameIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "getFamilyName", "", "getRefExpr", "Lcom/intellij/sql/psi/impl/SqlPositionalReference;", "element", "Lcom/intellij/psi/PsiElement;", "getRefName", "expr", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "intellij.database.sql.impl"})
public final class SqlReplaceColumnNumberWithNameIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        return "Replace column number with a name";
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return editor != null && this.getRefName(element2) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        SqlPositionalReference sqlPositionalReference = this.getRefExpr(element2);
        if (sqlPositionalReference == null) {
            return;
        }
        SqlPositionalReference refExpr = sqlPositionalReference;
        String string = this.getRefName(refExpr);
        if (string == null) {
            return;
        }
        String name = string;
        PsiFile file = element2.getContainingFile();
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(file)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        PsiElement psiElement = refExpr.resolve();
        if (!(psiElement instanceof DasObject)) {
            psiElement = null;
        }
        DasObject dasObject = (DasObject)psiElement;
        if (dasObject != null) {
            DasObject dasObject2 = dasObject;
            boolean bl2 = false;
            boolean bl3 = false;
            DasObject it2 = dasObject2;
            boolean bl4 = false;
            bl = DbSqlUtil.isQuoted(it2);
        } else {
            bl = false;
        }
        boolean forceQuotation = bl;
        String refText = dialect.getDatabaseDialect().quoteIdentifier(name, forceQuotation, false, Casing.EXACT);
        SqlReferenceExpression sqlReferenceExpression = SqlPsiElementFactory.createReferenceFromText(refText, dialect, SqlCompositeElementTypes.SQL_COLUMN_REFERENCE, (PsiElement)file);
        if (sqlReferenceExpression == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlReferenceExpression, (String)"SqlPsiElementFactory.cre\u2026NCE, file\n    ) ?: return");
        SqlReferenceExpression newRefExpr = sqlReferenceExpression;
        refExpr.replace((PsiElement)newRefExpr);
    }

    private final SqlPositionalReference getRefExpr(PsiElement element2) {
        PsiElement psiElement = element2.getParent();
        if (!(psiElement instanceof SqlPositionalReference)) {
            psiElement = null;
        }
        return (SqlPositionalReference)psiElement;
    }

    private final String getRefName(PsiElement element2) {
        String string;
        SqlPositionalReference sqlPositionalReference = this.getRefExpr(element2);
        if (sqlPositionalReference != null) {
            SqlPositionalReference sqlPositionalReference2 = sqlPositionalReference;
            boolean bl = false;
            boolean bl2 = false;
            SqlPositionalReference it2 = sqlPositionalReference2;
            boolean bl3 = false;
            string = this.getRefName(it2);
        } else {
            string = null;
        }
        return string;
    }

    private final String getRefName(SqlPositionalReference expr) {
        String string;
        PsiElement immediateSource = expr.getReference().resolveImmediate();
        PsiElement psiElement = immediateSource;
        if (psiElement instanceof PomTargetPsiElement) {
            PomTarget pomTarget = SqlImplUtil.getPomTarget(immediateSource);
            if (!(pomTarget instanceof SqlColumnSymbol)) {
                pomTarget = null;
            }
            SqlColumnSymbol sqlColumnSymbol = (SqlColumnSymbol)pomTarget;
            if (sqlColumnSymbol == null) {
                return null;
            }
            SqlColumnSymbol columnSymbol = sqlColumnSymbol;
            if (!(columnSymbol.getTargetDefinition() instanceof PsiNamedElement)) {
                return null;
            }
            string = columnSymbol.getName();
        } else {
            string = psiElement instanceof PsiNamedElement ? ((PsiNamedElement)immediateSource).getName() : null;
        }
        return string;
    }
}

