/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.inspections.DropPsiFix;
import com.intellij.sql.inspections.QuickFixWithExplicitWrite;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/inspections/DropPsiListItemFix;", "Lcom/intellij/sql/inspections/QuickFixWithExplicitWrite;", "kind", "", "elementClass", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "(Ljava/lang/String;Ljava/lang/Class;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "intellij.database.sql.impl"})
public final class DropPsiListItemFix
extends QuickFixWithExplicitWrite {
    private final String kind;
    private final Class<? extends PsiElement> elementClass;

    @NotNull
    public String getFamilyName() {
        return "Delete " + this.kind;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement psiElement;
        PsiElement deleteFrom;
        PsiElement psiElement2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement startElement = descriptor.getStartElement();
        PsiElement endElement = descriptor.getEndElement();
        PsiElement prevItem = PsiTreeUtil.getPrevSiblingOfType((PsiElement)startElement, this.elementClass);
        PsiElement nextItem = PsiTreeUtil.getNextSiblingOfType((PsiElement)endElement, this.elementClass);
        if (nextItem == null) {
            psiElement2 = prevItem;
            if (psiElement2 == null || (psiElement2 = psiElement2.getNextSibling()) == null) {
                psiElement2 = startElement;
            }
        } else {
            psiElement2 = deleteFrom = startElement;
        }
        if ((psiElement = nextItem) == null || (psiElement = psiElement.getPrevSibling()) == null) {
            psiElement = endElement;
        }
        PsiElement deleteTo = psiElement;
        PsiElement psiElement3 = deleteFrom;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"deleteFrom");
        PsiElement psiElement4 = deleteTo;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"deleteTo");
        DropPsiFix.INSTANCE.dropRange(psiElement3, psiElement4);
    }

    public DropPsiListItemFix(@NotNull String kind, @NotNull Class<? extends PsiElement> elementClass) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Intrinsics.checkParameterIsNotNull(elementClass, (String)"elementClass");
        this.kind = kind;
        this.elementClass = elementClass;
    }
}

