/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter;

import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0006\u0010\u0013\u001a\u00020\u0003J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/intellij/sql/formatter/Change;", "", "from", "", "till", "replacement", "", "(IILjava/lang/String;)V", "getFrom", "()I", "getReplacement", "()Ljava/lang/String;", "getTill", "compareTo", "other", "component1", "component2", "component3", "copy", "delta", "equals", "", "", "hashCode", "range", "Lcom/intellij/openapi/util/TextRange;", "toString", "Companion", "intellij.database.sql.impl"})
public final class Change
implements Comparable<Change> {
    private final int from;
    private final int till;
    @NotNull
    private final String replacement;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final TextRange range() {
        return new TextRange(this.from, this.till);
    }

    public final int delta() {
        return this.replacement.length() - (this.till - this.from);
    }

    @Override
    public int compareTo(@NotNull Change other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return this.from < other.from ? -1 : (this.from > other.from ? 1 : (this.till < other.till ? -1 : (this.till > other.till ? 1 : (this.replacement.compareTo(other.replacement) < 0 ? -1 : (this.replacement.compareTo(other.replacement) > 0 ? 1 : 0)))));
    }

    @NotNull
    public String toString() {
        int delta = this.delta();
        int sign = MathKt.getSign((int)delta);
        String d2 = sign == 0 ? "" : (sign == -1 ? "" + '(' + delta + ')' : (sign == 1 ? "(+" + delta + ')' : "(sign = " + sign + ", delta = " + delta + ')'));
        return "" + this.from + ':' + this.till + ' ' + d2 + " <- " + this.replacement;
    }

    public final int getFrom() {
        return this.from;
    }

    public final int getTill() {
        return this.till;
    }

    @NotNull
    public final String getReplacement() {
        return this.replacement;
    }

    public Change(int from, int till, @NotNull String replacement) {
        Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
        this.from = from;
        this.till = till;
        this.replacement = replacement;
    }

    public final int component1() {
        return this.from;
    }

    public final int component2() {
        return this.till;
    }

    @NotNull
    public final String component3() {
        return this.replacement;
    }

    @NotNull
    public final Change copy(int from, int till, @NotNull String replacement) {
        Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
        return new Change(from, till, replacement);
    }

    public static /* synthetic */ Change copy$default(Change change, int n, int n2, String string, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = change.from;
        }
        if ((n3 & 2) != 0) {
            n2 = change.till;
        }
        if ((n3 & 4) != 0) {
            string = change.replacement;
        }
        return change.copy(n, n2, string);
    }

    public int hashCode() {
        String string = this.replacement;
        return (Integer.hashCode(this.from) * 31 + Integer.hashCode(this.till)) * 31 + (string != null ? string.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Change)) break block3;
                Change change = (Change)object;
                if (this.from != change.from || this.till != change.till || !Intrinsics.areEqual((Object)this.replacement, (Object)change.replacement)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final Change insert(int position, @NotNull String text2) {
        return Companion.insert(position, text2);
    }

    @JvmStatic
    @NotNull
    public static final Change insertBefore(@NotNull TextRange range, @NotNull String text2) {
        return Companion.insertBefore(range, text2);
    }

    @JvmStatic
    @NotNull
    public static final Change insertAfter(@NotNull TextRange range, @NotNull String text2) {
        return Companion.insertAfter(range, text2);
    }

    @JvmStatic
    @NotNull
    public static final Change replace(int from, int till, @NotNull String text2) {
        return Companion.replace(from, till, text2);
    }

    @JvmStatic
    @NotNull
    public static final Change replace(@NotNull TextRange range, @NotNull String text2) {
        return Companion.replace(range, text2);
    }

    @JvmStatic
    @NotNull
    public static final Change delete(int from, int till) {
        return Companion.delete(from, till);
    }

    @JvmStatic
    @NotNull
    public static final Change delete(@NotNull TextRange range) {
        return Companion.delete(range);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/formatter/Change$Companion;", "", "()V", "delete", "Lcom/intellij/sql/formatter/Change;", "range", "Lcom/intellij/openapi/util/TextRange;", "from", "", "till", "insert", "position", "text", "", "insertAfter", "insertBefore", "replace", "intellij.database.sql.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Change insert(int position, @NotNull String text2) {
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            return new Change(position, position, text2);
        }

        @JvmStatic
        @NotNull
        public final Change insertBefore(@NotNull TextRange range, @NotNull String text2) {
            Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            return this.insert(range.getStartOffset(), text2);
        }

        @JvmStatic
        @NotNull
        public final Change insertAfter(@NotNull TextRange range, @NotNull String text2) {
            Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            return this.insert(range.getEndOffset(), text2);
        }

        @JvmStatic
        @NotNull
        public final Change replace(int from, int till, @NotNull String text2) {
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            return new Change(from, till, text2);
        }

        @JvmStatic
        @NotNull
        public final Change replace(@NotNull TextRange range, @NotNull String text2) {
            Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
            Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
            return this.replace(range.getStartOffset(), range.getEndOffset(), text2);
        }

        @JvmStatic
        @NotNull
        public final Change delete(int from, int till) {
            return new Change(from, till, "");
        }

        @JvmStatic
        @NotNull
        public final Change delete(@NotNull TextRange range) {
            Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
            return this.delete(range.getStartOffset(), range.getEndOffset());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

