/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlTypeSystem;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.editor.QuoteIdentifierQuickFix;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlFunctionCallTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlSelectIntoNewTableClauseImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.stubs.SqlColumnStub;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlLanguageDialectEx
extends SqlLanguageDialect
implements CasingProvider {
    private final Object myLock;
    private Map<String, SqlFunctionDefinition.Type> myTypes;

    @NotNull
    public abstract SqlTypeSystem getTypeSystem();

    protected void addTypes(Map<String, SqlFunctionDefinition.Type> myTypes) {
        SqlFunctionDefinition.addSimpleTypes(myTypes, this);
    }

    public SqlLanguageDialectEx(@NonNls @NotNull String id) {
        if (id == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(0);
        }
        super(id);
        this.myLock = new Object();
    }

    protected SqlLanguageDialectEx(@NotNull SqlLanguageDialect base, @NonNls @NotNull String id) {
        if (base == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(1);
        }
        if (id == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(2);
        }
        super(base, id);
        this.myLock = new Object();
    }

    @NotNull
    public String getDisplayName() {
        String string = this.getDbms().getDisplayName();
        if (string == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect(this.getDbms());
        if (databaseDialectEx == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(4);
        }
        return databaseDialectEx;
    }

    @NotNull
    public Icon getIcon() {
        Dbms dbms = this.getDbms();
        Icon icon = dbms == Dbms.UNKNOWN ? DatabaseIcons.Sql : dbms.getIcon();
        if (icon == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return null;
    }

    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return null;
    }

    public boolean isVariablePrefix(@Nullable String prefix) {
        return false;
    }

    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(7);
        }
        SqlTypeSystem typeSystem = this.getTypeSystem();
        if ((SqlImplUtil.equalsInsensitiveOrTrue(name, ReservedEntities.RE_NEXTVAL.name, resolve) || SqlImplUtil.equalsInsensitiveOrTrue(name, ReservedEntities.RE_CURRVAL.name, resolve)) && SqlImplUtil.getQualifierKind(element2) == ObjectKind.SEQUENCE) {
            if (!processor.executeTarget(ReservedEntities.RE_NEXTVAL, element2, typeSystem.integerType(), false, ResolveState.initial())) {
                return false;
            }
            if (!processor.executeTarget(ReservedEntities.RE_CURRVAL, element2, typeSystem.integerType(), false, ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        return this.checkIdentifierIsKeyword(o, manager, onTheFly, false);
    }

    @Nullable
    protected ProblemDescriptor checkIdentifierIsKeyword(SqlIdentifier o, InspectionManager manager, boolean onTheFly, boolean pl) {
        IElementType type = PsiUtilCore.getElementType((PsiElement)o.getFirstChild());
        if (!(type instanceof SqlKeywordTokenType) || !(!pl ? this.isReservedKeyword(type) : this.isReservedKeywordPL(type))) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)o, SqlBundle.message("identifier.1.should.be.quoted", o.getName()), (LocalQuickFix)new QuoteIdentifierQuickFix(this), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly);
    }

    @Nullable
    protected ProblemDescriptor checkIdentifierStartsWithLetter(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        String text2 = o.getText();
        if (text2.length() <= 0 || Character.isLetter(text2.charAt(0))) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)o, SqlBundle.message("identifier.should.start.with.letter", new Object[0]), (LocalQuickFix)new QuoteIdentifierQuickFix(this), ProblemHighlightType.GENERIC_ERROR, onTheFly);
    }

    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, @Nullable Version version) {
        if (identifier == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(8);
        }
        return Integer.MAX_VALUE;
    }

    protected static boolean processReservedEntitiesWithTypeDual(@Nullable String name, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(10);
        }
        if (processor.isExpected(ObjectKind.COLUMN)) {
            return true;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element2, SqlFromClause.class, (boolean)true, (Class[])new Class[]{SqlStatement.class}) == null) {
            return true;
        }
        if (element2 instanceof SqlReferenceExpression && ((SqlReferenceExpression)element2).getQualifierExpression() != null) {
            return true;
        }
        return SqlLanguageDialectEx.processReservedEntitiesWithTypeSimple(ReservedEntities.RE_DUAL, (SqlType)SqlTableTypeBase.EMPTY_TABLE, name, element2, resolve, processor, true, false);
    }

    protected static boolean processReservedEntitiesWithTypeSimple(DasObject entity, SqlType result, @Nullable String name, @NotNull PsiElement element2, boolean resolve, @NotNull SqlScopeProcessor processor, boolean checkType, Boolean forcedCaseSense) {
        if (element2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(12);
        }
        return !SqlImplUtil.equalsInsensitiveOrTrue(name, entity.getName(), resolve) || checkType && !processor.isExpected(entity.getKind()) || processor.executeTarget(entity, element2, result, forcedCaseSense, ResolveState.initial());
    }

    public TokenSet getStatementSeparators() {
        return SqlCommonTokens.STATEMENT_SEPARATORS;
    }

    public boolean isAutoIncrementColumn(@NotNull DasColumn column) {
        ASTNode node;
        SqlColumnStub stub;
        if (column == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(13);
        }
        SqlColumnStub sqlColumnStub = stub = column instanceof SqlColumnDefinitionImpl ? (SqlColumnStub)((SqlColumnDefinitionImpl)column).getStub() : null;
        if (stub != null) {
            return stub.isAutoVal();
        }
        ASTNode aSTNode = node = column instanceof PsiElement ? ((PsiElement)column).getNode() : null;
        return node != null && node.findChildByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE) != null;
    }

    @NotNull
    public JBIterable<ObjectKind> getExtraKindsStrict(@NotNull SqlReferenceImpl reference) {
        if (reference == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(14);
        }
        if (reference.getReferenceElementType().getTargetKind() == ObjectKind.OBJECT_TYPE) {
            JBIterable jBIterable = JBIterable.of((Object[])new ObjectKind[]{ObjectKind.COLLECTION_TYPE, ObjectKind.ALIAS_TYPE, ObjectKind.TABLE_TYPE});
            if (jBIterable == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result, ObjectKind type) {
        if (type instanceof SqlDbElementType) {
            ContainerUtil.addIfNotNull(result, (Object)((SqlDbElementType)type).parentType);
        }
        if (type == ObjectKind.VARIABLE) {
            result.add((ObjectKind)ObjectKind.VARIABLE);
        }
        if (type == ObjectKind.INDEX) {
            result.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.TRIGGER) {
            result.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.OBJECT_TYPE) {
            result.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.PARTITION) {
            result.add((ObjectKind)ObjectKind.TABLE);
        }
        DbImplUtil.getMetaModel(this.getDbms()).getParentKinds(this.unaliased(type)).addAllTo(result);
        if (type == ObjectKind.USER) {
            result.add((ObjectKind)ObjectKind.USER);
        }
        if (type == SqlDbElementType.SYSTEM_VARIABLE) {
            result.add((ObjectKind)SqlDbElementType.SYSTEM_VARIABLE);
        }
        return result;
    }

    public boolean canBeCalledWithoutParens(@NotNull SqlFunctionDefinition.Prototype prototype) {
        if (prototype == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(17);
        }
        SqlFunctionDefinition def = prototype.getFunction();
        return prototype.getParams().length == 0 && !"required".equals(def.getDialectAttribute("parens")) && !"true".equals(def.getDialectAttribute("analytic"));
    }

    public String quoteIdentifier(@NotNull SqlIdentifier identifier, @NotNull String newElementName) {
        if (identifier == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(18);
        }
        if (newElementName == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(19);
        }
        return this.quoteIdentifier(identifier.getProject(), newElementName);
    }

    public String quoteIdentifier(@NotNull Project project, @NotNull String newElementName) {
        if (project == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(20);
        }
        if (newElementName == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(21);
        }
        SqlCodeStyleSettings settings = SqlCodeStyles.getSqlSettings((Project)project, (Language)this);
        boolean force = settings.QUOTE_IDENTIFIER == 0 || this.isReservedKeyword((IElementType)SqlTokenRegistry.findTokenType((String)newElementName));
        NamingService namingService = NamingServices.getNamingService(this.getDbms());
        if (namingService.isQuoted(newElementName)) {
            return newElementName;
        }
        return force ? namingService.enquoteName(newElementName, settings.getQuotesPriority()) : namingService.nameToScript(newElementName, true, settings.getQuotesPriority());
    }

    public JBIterable<? extends SqlDefinition> extractDefinitions(@NotNull SqlElement statement) {
        if (statement == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(22);
        }
        if (statement instanceof SqlSelectStatement) {
            return ((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)statement).expand(Conditions.notInstanceOf(SqlSelectIntoNewTableClauseImpl.class))).filter(SqlSelectIntoNewTableClauseImpl.class);
        }
        if (statement instanceof SqlBlockStatementImpl) {
            JBIterable children2 = SqlImplUtil.childrenIt((PsiElement)statement).filter(SqlCompositeElement.class);
            return children2.filter(SqlDefinition.class).append((Iterable)children2.flatten(this::extractDefinitions));
        }
        return JBIterable.empty();
    }

    public boolean processUnqualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiReference ref) {
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(23);
        }
        if (state == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(24);
        }
        if (ref == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(25);
        }
        return true;
    }

    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiReference ref, @NotNull SqlExpression qualifier) {
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(26);
        }
        if (state == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(27);
        }
        if (ref == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(28);
        }
        if (qualifier == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(29);
        }
        return true;
    }

    public boolean processTypeExtra(SqlTableType type, PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        return true;
    }

    public boolean shouldWrap(SqlDefinition o, ObjectKind kind) {
        return kind == ObjectKind.PACKAGE || kind == ObjectKind.OBJECT_TYPE;
    }

    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        return type != SqlDbElementType.CHARSET && type != ObjectKind.COLLATION && type != ObjectKind.TABLESPACE && type != ObjectKind.DB_LINK && type != SqlDbElementType.GENERIC_AT_LINK && type != ObjectKind.USER && type != SqlDbElementType.SYSTEM_VARIABLE && type != ObjectKind.ROLE && type != ObjectKind.OPERATOR;
    }

    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(30);
        }
        return true;
    }

    @NotNull
    public abstract BuiltinFunctions getSupportedFunctions();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Map<String, SqlFunctionDefinition.Type> getBuiltInTypes() {
        Object object = this.myLock;
        // MONITORENTER : object
        if (this.myTypes == null) {
            this.myTypes = new HashMap<String, SqlFunctionDefinition.Type>();
            this.addTypes(this.myTypes);
        }
        Map<String, SqlFunctionDefinition.Type> map2 = this.myTypes;
        // MONITOREXIT : object
        if (map2 != null) return map2;
        SqlLanguageDialectEx.$$$reportNull$$$0(31);
        return map2;
    }

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(32);
        }
        Casing casing = this.getDatabaseDialect().getCasing(kind, context);
        if (casing == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(33);
        }
        return casing;
    }

    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return null;
    }

    public boolean supportsSql92CharSetSpecFor(@NotNull IElementType element2) {
        if (element2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(34);
        }
        return false;
    }

    public String getDelimiterAt(@NotNull SqlFile file, int offset) {
        if (file == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(35);
        }
        return ";";
    }

    public boolean mayContainExternalPsi() {
        return false;
    }

    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(36);
        }
        return collection;
    }

    public final boolean isMajorChild(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(37);
        }
        return this.getMajorChildKinds().contains(kind);
    }

    public boolean shouldSkipFromQualification(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(38);
        }
        return DbImplUtil.isDataTable(kind);
    }

    @NotNull
    public TreePattern getDefaultImports(@Nullable DbDataSource dataSource2) {
        ObjectName[] dsNames = SqlImportUtil.getRealDsNames(dataSource2);
        TreePattern imports = this.getBaseImports(dataSource2, dsNames);
        TreePattern treePattern = this.applyImplicitImports(dsNames, imports);
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(39);
        }
        return treePattern;
    }

    @NotNull
    protected TreePattern getBaseImports(@Nullable DbDataSource dataSource2, @Nullable ObjectName[] dsNames) {
        ObjectKind kind;
        JBIterable<ObjectKind> kinds = DbImplUtil.getMetaModel(this.getDbms()).getRootNamespaceKinds();
        if (kinds.contains((Object)ObjectKind.DATABASE)) {
            kind = ObjectKind.DATABASE;
        } else if (kinds.contains((Object)ObjectKind.SCHEMA)) {
            kind = ObjectKind.SCHEMA;
        } else {
            throw new AssertionError((Object)"Unexpected root kind");
        }
        ObjectName userName = ObjectName.plain((String)SqlDialectImplUtil.getUserName(SqlImportUtil.getConnectionConfig(dataSource2)));
        DasNamespace namespace = SqlLanguageDialectEx.getDefaultNamespace(dataSource2, userName);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, namespace.getKind() == ObjectKind.SCHEMA ? null : SqlImportUtil.createNodeIfNotNull(userName, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(40);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.createNodeIfNotNull(userName, kind, new TreePatternNode.Group[0])));
    }

    @NotNull
    protected TreePattern getSchemaBaseImports(@Nullable DbDataSource dataSource2, @Nullable ObjectName[] dsNames, boolean useSchemaDefault) {
        String schemaName = SqlDialectImplUtil.getDatabaseName(SqlImportUtil.getConnectionConfig(dataSource2));
        if (schemaName == null && useSchemaDefault) {
            schemaName = "default";
        }
        return new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.createNodeIfNotNull(ObjectName.quoted((String)schemaName), ObjectKind.SCHEMA, new TreePatternNode.Group[0])));
    }

    @Nullable
    protected static DasNamespace getDefaultTopNamespace(@Nullable DbDataSource dataSource2, @Nullable ObjectName fallback) {
        DasModel model;
        LocalDataSource ds = dataSource2 == null ? null : (LocalDataSource)ObjectUtils.tryCast((Object)dataSource2.getDelegate(), LocalDataSource.class);
        DasModel dasModel = model = ds == null ? null : ds.getModel();
        if (model == null) {
            return null;
        }
        DasNamespace cur = model.getCurrentRootNamespace();
        if (cur == null && fallback != null) {
            cur = (DasNamespace)model.getModelRoots().filter(DasNamespace.class).filter(n -> Comparing.strEqual((String)fallback.name, (String)n.getName(), (boolean)fallback.quoted)).first();
        }
        return cur;
    }

    @Nullable
    protected static DasNamespace getDefaultSubNamespace(@Nullable DasNamespace cur, @Nullable ObjectName fallback) {
        if (cur == null) {
            return null;
        }
        DasNamespace schema = SqlLanguageDialectEx.getCurrentSchema(cur);
        if (schema != null || fallback == null) {
            return schema;
        }
        return (DasNamespace)cur.getDasChildren(null).filter(DasNamespace.class).filter(n -> Comparing.strEqual((String)fallback.name, (String)n.getName(), (boolean)fallback.quoted)).first();
    }

    @Nullable
    protected static DasNamespace getDefaultNamespace(@Nullable DbDataSource dataSource2, @Nullable ObjectName fallback) {
        DasNamespace cur = SqlLanguageDialectEx.getDefaultTopNamespace(dataSource2, fallback);
        if (cur == null || cur.getKind() == ObjectKind.SCHEMA) {
            return cur;
        }
        DasNamespace sc = SqlLanguageDialectEx.getCurrentSchema(cur);
        return (DasNamespace)ObjectUtils.chooseNotNull((Object)sc, (Object)cur);
    }

    @Nullable
    protected static DasNamespace getCurrentSchema(@Nullable DasNamespace cur) {
        return cur == null ? null : (DasNamespace)cur.getDasChildren(ObjectKind.SCHEMA).filter(BasicNamespace.class).filter(BasicNamespace::isCurrent).first();
    }

    @NotNull
    public TreePattern applyImplicitImports(@Nullable ObjectName[] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(41);
        }
        TreePattern treePattern = pattern;
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(42);
        }
        return treePattern;
    }

    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource2, @Nullable SearchPath searchPath) {
        ObjectName[] dsNames = SqlImportUtil.getRealDsNames(dataSource2);
        List elements = SearchPath.getElements((SearchPath)searchPath);
        TreePattern treePattern = this.applyImplicitImports(dsNames, !elements.isEmpty() ? TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from((Iterable)elements).transform(n -> SqlDialectImplUtil.createObjectPattern(dsNames, this.getDbms(), n, (TreePatternNode.Group[])null))) : (dsNames == null ? TreePattern.EMPTY : this.getBaseImports(dataSource2, dsNames)));
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(43);
        }
        return treePattern;
    }

    @NotNull
    public TreePattern srcFilePattern(@Nullable DbDataSource dataSource2, @NotNull SearchPath object) {
        if (object == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(44);
        }
        TreePattern treePattern = this.forcedContextPattern(dataSource2, object);
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(45);
        }
        return treePattern;
    }

    @NotNull
    public TreePattern processImports(@NotNull SqlUseDatabaseStatement stmt, @NotNull TreePattern prev) {
        if (stmt == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(46);
        }
        if (prev == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(47);
        }
        SmartList refs = new SmartList();
        ObjectKind kind = null;
        boolean reset = false;
        for (SqlReferenceExpression ref : ContainerUtil.iterateBackward((List)stmt.getUseReferences())) {
            if (ref == null) {
                reset = true;
                break;
            }
            refs.add(ref);
            ObjectKind k = ref.getReferenceElementType().getTargetKind();
            assert (kind == null || kind == k);
            kind = k;
        }
        if (reset) {
            TreePattern treePattern = SqlDialectImplUtil.getDefaultInitialPattern((SqlFile)stmt.getContainingFile());
            if (treePattern == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(48);
            }
            return treePattern;
        }
        boolean empty = refs.isEmpty();
        if (empty || kind == null) {
            if (!this.canBeWithoutCurrentSchema()) {
                TreePattern treePattern = prev;
                if (treePattern == null) {
                    SqlLanguageDialectEx.$$$reportNull$$$0(49);
                }
                return treePattern;
            }
            List<ObjectKind> path = SqlImportUtil.getSingleRootPath(ObjectKind.SCHEMA, this.getDbms());
            if (path == null) {
                TreePattern treePattern = this.applyImplicitImports(null, TreePattern.EMPTY);
                if (treePattern == null) {
                    SqlLanguageDialectEx.$$$reportNull$$$0(50);
                }
                return treePattern;
            }
            ObjectKind[] kinds = ContainerUtil.reverse(path.subList(1, path.size())).toArray(new ObjectKind[path.size() - 1]);
            boolean[] mask = new boolean[kinds.length];
            Arrays.fill(mask, true);
            TreePattern treePattern = this.applyImplicitImports(null, TreePatternUtils.mask(prev, kinds, mask, false));
            if (treePattern == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(51);
            }
            return treePattern;
        }
        TreePattern state = TreePatternUtils.union((Iterable<TreePattern>)JBIterable.from((Iterable)refs).transform(r -> this.createRefPattern(prev, (SqlReferenceExpression)r)).filter(x -> x != null));
        final boolean inclusive = stmt.isInclusive();
        state = new TreePatternUtils.GroupedGroupFactory(){

            @Override
            protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value2) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return this.hasSecond(value2);
            }

            @Override
            protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode<?>> value2) {
                if (value2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return this.hasSecond(value2);
            }

            @Override
            protected boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode<?>> groups) {
                return !this.hasSecond(groups);
            }

            private boolean hasSecond(@NotNull Iterable<?> value2) {
                Object second;
                Iterator<?> it2;
                if (value2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                Object first2 = (it2 = value2.iterator()).hasNext() ? it2.next() : null;
                Object v0 = second = it2.hasNext() ? it2.next() : null;
                if (second == null) {
                    return first2 != null && inclusive;
                }
                if (!(second instanceof TreePatternNode)) {
                    return true;
                }
                if (((TreePatternNode)second).naming instanceof TreePatternNode.PositiveNaming) {
                    return true;
                }
                return first2 != null;
            }

            @Override
            public boolean mergeChildren() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "value";
                objectArray2[1] = "com/intellij/sql/dialects/SqlLanguageDialectEx$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkGroup";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkNode";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "hasSecond";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.merge(Arrays.asList(prev, state));
        TreePattern treePattern = this.applyImplicitImports(null, state);
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(52);
        }
        return treePattern;
    }

    protected TreePattern createRefPattern(@NotNull TreePattern prev, @NotNull SqlReferenceExpression ref) {
        if (prev == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(53);
        }
        if (ref == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(54);
        }
        return SqlImportUtil.createRefPattern(ref, ref.getReferenceElementType().getTargetKind(), this.getDbms());
    }

    protected boolean canBeWithoutCurrentSchema() {
        return false;
    }

    @NotNull
    public Set<ObjectKind> getIgnoredParentKinds(@Nullable PsiElement context, @NotNull ObjectKind target) {
        if (target == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(55);
        }
        Set<ObjectKind> set = Collections.emptySet();
        if (set == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(56);
        }
        return set;
    }

    @Nullable
    public IElementType getFunctionParserExtension(@NotNull String name) {
        if (name == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(57);
        }
        SqlReferenceElementType unused = SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
        return SqlTokenRegistry.findCompositeType((String)("SQL_" + name));
    }

    @NotNull
    public ObjectKind unaliased(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(58);
        }
        ObjectKind objectKind = kind;
        if (objectKind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(59);
        }
        return objectKind;
    }

    public boolean allowGlobalTableResolve(@NotNull PsiElement place) {
        if (place == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(60);
        }
        return false;
    }

    @NotNull
    public Set<SqlFunctionDefinition.Location> getExpectedFunctionLocations(@Nullable SqlExpression expression) {
        if (expression != null && SqlLanguageDialectEx.isTableFunctionCallRef((PsiElement)expression)) {
            EnumSet<SqlFunctionDefinition.Location> enumSet = EnumSet.of(SqlFunctionDefinition.Location.NORMAL, SqlFunctionDefinition.Location.TABLE_FUNCTION);
            if (enumSet == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(61);
            }
            return enumSet;
        }
        EnumSet<SqlFunctionDefinition.Location> enumSet = EnumSet.of(SqlFunctionDefinition.Location.NORMAL);
        if (enumSet == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(62);
        }
        return enumSet;
    }

    private static boolean isTableFunctionCallRef(@NotNull PsiElement expr) {
        PsiElement parent2;
        if (expr == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(63);
        }
        return (parent2 = expr.getParent()) instanceof SqlFunctionCallExpression && parent2.getParent() instanceof SqlFunctionCallTableExpressionImpl || parent2 instanceof SqlQueryExpression;
    }

    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        return new DFABuildingVisitor(this);
    }

    @NotNull
    public SqlErrorSpecHelper getErrorSpecHelper() {
        SqlErrorSpecHelper sqlErrorSpecHelper = SqlErrorSpecHelper.DEFAULT_INSTANCE;
        if (sqlErrorSpecHelper == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(64);
        }
        return sqlErrorSpecHelper;
    }

    public boolean isValidRawToken(@NotNull IElementType type, @NotNull CharSequence text2) {
        if (type == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(65);
        }
        if (text2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(66);
        }
        return false;
    }

    public boolean supportsJoinUsing() {
        return false;
    }

    public boolean supportsNaturalJoin() {
        return false;
    }

    public boolean isSpecialFunctionReference(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(67);
        }
        return false;
    }

    public boolean isTableAliasAllowedAt(@NotNull PsiElement element2) {
        if (element2 == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(68);
        }
        return PsiTreeUtil.getContextOfType((PsiElement)element2, (Class[])new Class[]{SqlFromClause.class}) != null;
    }

    @Nullable
    public SqlDateTimeLanguageHelper getDateTimeHelper() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 31: 
            case 33: 
            case 36: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 59: 
            case 61: 
            case 62: 
            case 64: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 31: 
            case 33: 
            case 36: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 59: 
            case 61: 
            case 62: 
            case 64: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 31: 
            case 33: 
            case 36: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 59: 
            case 61: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlLanguageDialectEx";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 34: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototype";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 25: 
            case 28: 
            case 30: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 32: 
            case 37: 
            case 38: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
            case 47: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlLanguageDialectEx";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraKindsStrict";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltInTypes";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultImports";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "srcFilePattern";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "processImports";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredParentKinds";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "unaliased";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedFunctionLocations";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorSpecHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 31: 
            case 33: 
            case 36: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 59: 
            case 61: 
            case 62: 
            case 64: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithTypeDual";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithTypeSimple";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAutoIncrementColumn";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExtraKindsStrict";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "canBeCalledWithoutParens";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifier";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "extractDefinitions";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "supportsSql92CharSetSpecFor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDelimiterAt";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isMajorChild";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipFromQualification";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "srcFilePattern";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "processImports";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createRefPattern";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredParentKinds";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParserExtension";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "unaliased";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "allowGlobalTableResolve";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isTableFunctionCallRef";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isValidRawToken";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialFunctionReference";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 31: 
            case 33: 
            case 36: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 56: 
            case 59: 
            case 61: 
            case 62: 
            case 64: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LazyData {
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS = Arrays.asList(ObjectKind.TRIGGER, ObjectKind.INDEX);

        LazyData() {
        }
    }

    protected static class BuiltinFunctionsMap
    implements BuiltinFunctions {
        private final Map<String, SqlFunctionDefinition> myMap;

        public BuiltinFunctionsMap(@NotNull Map<String, SqlFunctionDefinition> map2) {
            if (map2 == null) {
                BuiltinFunctionsMap.$$$reportNull$$$0(0);
            }
            this.myMap = map2;
        }

        @Override
        @Nullable
        public SqlFunctionDefinition get(@Nullable String name) {
            return this.myMap.get(name);
        }

        @Override
        public boolean contains(@Nullable String name) {
            return this.myMap.containsKey(name);
        }

        @Override
        @NotNull
        public Iterable<SqlFunctionDefinition> byMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher == null) {
                BuiltinFunctionsMap.$$$reportNull$$$0(1);
            }
            JBIterable jBIterable = JBIterable.from(this.myMap.entrySet()).filterMap(e -> matcher.prefixMatches((String)e.getKey()) ? (SqlFunctionDefinition)((Object)((Object)e.getValue())) : null);
            if (jBIterable == null) {
                BuiltinFunctionsMap.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public Collection<SqlFunctionDefinition> forTokens() {
            Collection<SqlFunctionDefinition> collection = this.myMap.values();
            if (collection == null) {
                BuiltinFunctionsMap.$$$reportNull$$$0(3);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/SqlLanguageDialectEx$BuiltinFunctionsMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/SqlLanguageDialectEx$BuiltinFunctionsMap";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "byMatcher";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "forTokens";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "byMatcher";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface ReservedEntities {
        public static final ReservedEntity RE_NEXTVAL = new ReservedEntity("nextval", ObjectKind.COLUMN);
        public static final ReservedEntity RE_CURRVAL = new ReservedEntity("currval", ObjectKind.COLUMN);
        public static final ReservedEntity RE_DUAL = new ReservedEntity("dual", ObjectKind.TABLE);
    }

    public static interface BuiltinFunctions {
        @Nullable
        public SqlFunctionDefinition get(@Nullable String var1);

        public boolean contains(@Nullable String var1);

        @NotNull
        public Iterable<SqlFunctionDefinition> byMatcher(@NotNull PrefixMatcher var1);

        @NotNull
        public Collection<SqlFunctionDefinition> forTokens();
    }
}

