/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.providers;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.database.model.DataType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.util.ObjectUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SqlFunctionDefinitionCompletions {
    private static final TokenSet FOR_FUNCTION_COMPLETION = TokenSet.create((IElementType[])new IElementType[]{SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE, SqlCompositeElementTypes.SQL_COLUMN_REFERENCE, SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE, SqlCompositeElementTypes.SQL_PROCEDURE_REFERENCE, SqlCompositeElementTypes.SQL_FUNCTION_REFERENCE, SqlCompositeElementTypes.SQL_ARGUMENT_REFERENCE, SqlCompositeElementTypes.SQL_VARIABLE_REFERENCE, SqlCompositeElementTypes.SQL_REFERENCE});

    static void addFunctionDefinitionCompletions(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet _result, @NotNull Set<String> existingFunctionNames) {
        SqlType qualType;
        IElementType fragmentType;
        SqlReferenceImpl ref;
        PsiFile file;
        if (parameters == null) {
            SqlFunctionDefinitionCompletions.$$$reportNull$$$0(0);
        }
        if (_result == null) {
            SqlFunctionDefinitionCompletions.$$$reportNull$$$0(1);
        }
        if (existingFunctionNames == null) {
            SqlFunctionDefinitionCompletions.$$$reportNull$$$0(2);
        }
        if (!((file = parameters.getOriginalFile()) instanceof SqlFile)) {
            return;
        }
        PsiElement position = parameters.getPosition();
        SqlExpression expression = (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)position, (Class[])new Class[]{SqlReferenceExpression.class, SqlStringLiteralExpression.class});
        SqlReferenceImpl sqlReferenceImpl = ref = expression == null ? null : (SqlReferenceImpl)ObjectUtils.tryCast((Object)expression.getReference(), SqlReferenceImpl.class);
        if (ref == null) {
            return;
        }
        IElementType iElementType = fragmentType = file instanceof SqlCodeFragment ? ((SqlCodeFragment)file).getElementType() : null;
        if (fragmentType == SqlCompositeElementTypes.SQL_TABLE_REFERENCE || fragmentType == SqlCompositeElementTypes.SQL_TYPE_ELEMENT) {
            return;
        }
        SqlExpression qualifier = ref.getQualifier();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        if (qualifier != null && !dialect.getDbms().isPostgres()) {
            return;
        }
        SqlType sqlType = qualType = qualifier == null ? null : qualifier.getSqlType();
        if (qualType == SqlType.UNKNOWN) {
            return;
        }
        CompletionResultSet result = _result.caseInsensitive();
        SqlReferenceElementType type = ref.getReferenceElementType();
        boolean triggerFunctionExpected = SqlCompletionUtil.isTriggerFunctionExpected(expression);
        if ((FOR_FUNCTION_COMPLETION.contains((IElementType)type) || dialect.isSpecialFunctionReference((IElementType)type)) && !SqlCompletionUtil.isModificationTarget(position) && !ref.resolveStrict()) {
            Set<SqlFunctionDefinition.Location> locations = dialect.getExpectedFunctionLocations(expression);
            for (SqlFunctionDefinition def : dialect.getSupportedFunctions().byMatcher(result.getPrefixMatcher())) {
                if (!locations.contains((Object)def.getLocation()) || existingFunctionNames.contains(def.getName())) continue;
                for (SqlFunctionDefinition.Prototype prototype : def.getPrototypes()) {
                    if (qualifier != null && !SqlFunctionDefinitionCompletions.isApplicable(prototype, qualifier, qualType)) continue;
                    if (triggerFunctionExpected) {
                        DataType returnDataType;
                        SqlFunctionDefinition.Type returnType = prototype.getReturnType();
                        DataType dataType = returnDataType = returnType != null ? returnType.getDataType() : null;
                        if (returnDataType == null || !dialect.getTypeSystem().isTriggerFunctionType(returnDataType)) continue;
                    }
                    result.addElement(PrioritizedLookupElement.withPriority((LookupElement)SqlCompletionUtil.createLookupItem(prototype, dialect), (double)0.0));
                }
            }
        }
    }

    private static boolean isApplicable(SqlFunctionDefinition.Prototype prototype, SqlExpression qual, SqlType type) {
        SqlFunctionDefinition.Parameter[] params = prototype.getParams();
        if (params.length != 1) {
            return false;
        }
        return SqlFunctionsUtil.isAssignable(params[0], qual, type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "_result";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "existingFunctionNames";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/completion/providers/SqlFunctionDefinitionCompletions";
        objectArray[2] = "addFunctionDefinitionCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

