/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion.options;

import com.intellij.application.options.CodeCompletionOptionsCustomSection;
import com.intellij.database.model.NameBasedRelationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.completion.options.SqlCodeCompletionOptionPanel;
import com.intellij.sql.completion.options.SqlCodeCompletionSettings;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class SqlCodeCompletionConfigurable
implements Configurable,
CodeCompletionOptionsCustomSection {
    private SqlCodeCompletionOptionPanel myPanel;

    @Nullable
    public JComponent createComponent() {
        this.myPanel = new SqlCodeCompletionOptionPanel();
        return this.myPanel.getPanel();
    }

    public boolean isModified() {
        SqlCodeCompletionSettings settings = SqlCodeCompletionSettings.getInstance();
        NameBasedRelationProvider.NameBasedRelationSettings fkSettings = NameBasedRelationProvider.NameBasedRelationSettings.getInstance();
        return settings.isUseAliasInJoinCompletion() != this.myPanel.getUseAliasesInCompletionJBCheckBox().isSelected() || settings.isAutoAliasTable() != this.myPanel.getAutoAliasTableJBCheckBox().isSelected() || settings.isInvertOrderInOnClause() != this.myPanel.getInvertOrderOfOperandsInJoinOnJBCheckBox().isSelected() || settings.isSupportNonStrictForeignKeys() != this.myPanel.getSupportNonStrictForeignKeysJBCheckBox().isSelected() || settings.isSuggestAliasNames() != this.myPanel.getSuggestTableAliasNamesJBCheckBox().isSelected() || !Comparing.equal(settings.getCustomMappings(), this.myPanel.getCustomMappings()) || !Comparing.equal(fkSettings.getFkRules(), this.myPanel.getFkRules());
    }

    public void apply() {
        SqlCodeCompletionSettings settings = SqlCodeCompletionSettings.getInstance();
        NameBasedRelationProvider.NameBasedRelationSettings fkSettings = NameBasedRelationProvider.NameBasedRelationSettings.getInstance();
        settings.setUseAliasInJoinCompletion(this.myPanel.getUseAliasesInCompletionJBCheckBox().isSelected());
        settings.setAutoAliasTable(this.myPanel.getAutoAliasTableJBCheckBox().isSelected());
        settings.setInvertOrderInOnClause(this.myPanel.getInvertOrderOfOperandsInJoinOnJBCheckBox().isSelected());
        settings.setSupportNonStrictForeignKeys(this.myPanel.getSupportNonStrictForeignKeysJBCheckBox().isSelected());
        settings.setSuggestAliasNames(this.myPanel.getSuggestTableAliasNamesJBCheckBox().isSelected());
        settings.setCustomMappings(this.myPanel.getCustomMappings());
        fkSettings.setFkRules(this.myPanel.getFkRules());
    }

    public void reset() {
        SqlCodeCompletionSettings settings = SqlCodeCompletionSettings.getInstance();
        NameBasedRelationProvider.NameBasedRelationSettings fkSettings = NameBasedRelationProvider.NameBasedRelationSettings.getInstance();
        this.myPanel.getUseAliasesInCompletionJBCheckBox().setSelected(settings.isUseAliasInJoinCompletion());
        this.myPanel.getAutoAliasTableJBCheckBox().setSelected(settings.isAutoAliasTable());
        this.myPanel.getInvertOrderOfOperandsInJoinOnJBCheckBox().setSelected(settings.isInvertOrderInOnClause());
        this.myPanel.getSupportNonStrictForeignKeysJBCheckBox().setSelected(settings.isSupportNonStrictForeignKeys());
        this.myPanel.getSuggestTableAliasNamesJBCheckBox().setSelected(settings.isSuggestAliasNames());
        this.myPanel.setCustomMappings(settings.getCustomMappings());
        this.myPanel.setFkRules(fkSettings.getFkRules());
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            Disposer.dispose((Disposable)this.myPanel);
            this.myPanel = null;
        }
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return SqlBundle.message("configurable.SqlCodeCompletionConfigurable.display.name", new Object[0]);
    }
}

