/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.view.ui.DbCheckBoxTree;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import icons.DatabaseIcons;
import org.jetbrains.annotations.NotNull;

public class DbSchemasTree
extends DbCheckBoxTree<MyNode> {
    public DbSchemasTree(@NotNull CheckedTreeNode root2) {
        if (root2 == null) {
            DbSchemasTree.$$$reportNull$$$0(0);
        }
        super(root2, new MyTreeCellRenderer());
    }

    public static CheckedTreeNode createNode(MyNode node) {
        return new CheckedTreeNode(node){

            public boolean isChecked() {
                return ((MyNode)this.getUserObject()).isChecked();
            }

            public void setChecked(boolean checked) {
                ((MyNode)this.getUserObject()).setChecked(checked);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/view/ui/DbSchemasTree", "<init>"));
    }

    public static class MyNode
    extends DbCheckBoxTree.MyNode<MyNode> {
        public MyNode(String name, BasicMetaObject<?> meta, Object object) {
            super(name, meta, object);
        }

        @Override
        @NotNull
        protected MyNode createAll(@NotNull BasicMetaObject<?> meta) {
            if (meta == null) {
                MyNode.$$$reportNull$$$0(0);
            }
            return new MyNode("All", meta, "*");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/database/view/ui/DbSchemasTree$MyNode", "createAll"));
        }
    }

    private static class MyTreeCellRenderer
    extends DbCheckBoxTree.CellWithUnderlinedAllRenderer<MyNode> {
        private MyTreeCellRenderer() {
        }

        @Override
        protected void customizeCheckboxRenderer(MyNode node) {
            if (node.getParent() == null) {
                return;
            }
            ColoredTreeCellRenderer renderer = this.getTextRenderer();
            if (node.getObject() instanceof LocalDataSource) {
                renderer.setIcon(((LocalDataSource)node.getObject()).getBaseIcon());
            } else if (node.getObject() instanceof SqlDataSource) {
                renderer.setIcon(DatabaseIcons.DdlDbms);
            }
            this.renderText(node, (ColoredTextContainer)renderer);
        }

        @Override
        protected void renderText(MyNode node, ColoredTextContainer renderer) {
            String name = node.getName();
            if (node.getObject() instanceof DasObject || node.getObject() instanceof DasDataSource) {
                if (StringUtil.isEmpty((String)name)) {
                    renderer.append("<Unnamed>", SimpleTextAttributes.GRAY_ATTRIBUTES);
                } else {
                    renderer.append(name, node.isShadow() ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            } else if (node.getObject() == "*") {
                String pluralized = StringUtil.pluralize((String)node.getKindName());
                renderer.append("All " + StringUtil.capitalizeWords((String)pluralized, (boolean)true), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else {
                renderer.append(StringUtil.isEmpty((String)name) ? "<Unnamed>" : name, SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
            }
        }
    }
}

