/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.editors.DatabaseTableKeyEditor;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.models.TableKeyEditorModel;
import com.intellij.database.view.ui.TableEditorToolbarsDecorator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.ui.ListTableModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTableKeysEditor
extends DatabaseTableEditor.TabProvider {
    private final JPanel myPanel;
    private final DatabaseEditorUtil.DbListTableWithEditor<DatabaseTableKeyEditor> myTable;
    private final ListTableModel<DatabaseTableKeyEditor> myTableKeysModel;
    private final DatabaseTableEditor myTableEditor;
    private final DatabaseEditorCapabilities.TableEditorCaps myCaps;

    public DatabaseTableKeysEditor(@NotNull DatabaseTableEditor tableEditor, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull TableEditorToolbarsDecorator toolbarsDecorator) {
        if (tableEditor == null) {
            DatabaseTableKeysEditor.$$$reportNull$$$0(0);
        }
        if (caps == null) {
            DatabaseTableKeysEditor.$$$reportNull$$$0(1);
        }
        if (toolbarsDecorator == null) {
            DatabaseTableKeysEditor.$$$reportNull$$$0(2);
        }
        this.myTableEditor = tableEditor;
        this.myCaps = caps;
        this.myTableKeysModel = DatabaseEditorUtil.createTableModel(this.getTableModel(), new DatabaseEditorUtil.EditorModelHelper<DatabaseTableKeyEditor>(){

            @Override
            @Nullable
            public DatabaseTableKeyEditor createRow() {
                if (!DatabaseTableKeysEditor.this.myCaps.getAltKeys().canAdd()) {
                    return null;
                }
                DeTableKey key = DatabaseTableKeysEditor.this.getTableModel().createTableKey(new DeColumn[0]);
                DatabaseTableKeysEditor.this.getTableModel().addTableKey(key);
                return DatabaseTableKeysEditor.this.createTableKeyEditor(key);
            }

            @Override
            public boolean removeRow(DatabaseTableKeyEditor item, int idx) {
                if (!DatabaseTableKeysEditor.this.myCaps.getAltKeys().canRemove()) {
                    return false;
                }
                DatabaseTableKeysEditor.this.getTableModel().removeTableKey((DeTableKey)item.getTableKeyModel().getObject());
                Disposer.dispose((Disposable)item);
                return true;
            }
        }, true);
        this.myTable = DatabaseEditorUtil.createTableWithEditor(this.myTableKeysModel, this.myTableEditor, null);
        this.myTable.getTable().getEmptyText().setText("No keys");
        ToolbarDecorator decorator = toolbarsDecorator.decorateKeys(caps, tableEditor, (JTable)this.myTable.getTable());
        this.myPanel = decorator.createPanel();
        DatabaseEditorUtil.setTableDecoratorMinSize(this.myPanel, (JTable)this.myTable.getTable());
        this.myPanel.setBorder(this.myTableEditor.getTabComponentBorder());
    }

    @Override
    public void configure(@NotNull DatabaseEditorCapabilities.TableEditorCaps caps) {
        if (caps == null) {
            DatabaseTableKeysEditor.$$$reportNull$$$0(3);
        }
    }

    @Override
    public boolean isMyObject(@NotNull DeObject object) {
        if (object == null) {
            DatabaseTableKeysEditor.$$$reportNull$$$0(4);
        }
        return object instanceof DeTableKey;
    }

    @Override
    @Nullable
    public DatabaseTableKeyEditor startItemEditing(@NotNull DeObject column) {
        if (column == null) {
            DatabaseTableKeysEditor.$$$reportNull$$$0(5);
        }
        return DatabaseEditorUtil.startItemEditing(column, this.myTable, this.myTableKeysModel);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            DatabaseTableKeysEditor.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @NotNull
    public TableEditorModel getTableModel() {
        TableEditorModel tableEditorModel = this.myTableEditor.getTableModel();
        if (tableEditorModel == null) {
            DatabaseTableKeysEditor.$$$reportNull$$$0(7);
        }
        return tableEditorModel;
    }

    @NotNull
    private DatabaseTableKeyEditor createTableKeyEditor(@NotNull DeTableKey key) {
        if (key == null) {
            DatabaseTableKeysEditor.$$$reportNull$$$0(8);
        }
        DatabaseTableKeyEditor editor = new DatabaseTableKeyEditor(this.myTableEditor.getState(), this.getTableModel(), this.getTableModel().modelsCache.get(key, TableKeyEditorModel.class), this.getTableKeyCaps(key));
        Disposer.register((Disposable)this.myTableEditor, (Disposable)editor);
        editor.getTableKeyModel().addListener(new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseTableKeysEditor.this.myTableEditor.fromModelToUi();
            }
        }, this.myTableEditor);
        DatabaseTableKeyEditor databaseTableKeyEditor = editor;
        if (databaseTableKeyEditor == null) {
            DatabaseTableKeysEditor.$$$reportNull$$$0(9);
        }
        return databaseTableKeyEditor;
    }

    @NotNull
    private DatabaseEditorCapabilities.TableKeyEditorCaps getTableKeyCaps(@NotNull DeTableKey key) {
        if (key == null) {
            DatabaseTableKeysEditor.$$$reportNull$$$0(10);
        }
        BasicTable table = (BasicTable)this.getTable().unwrap();
        BasicKey edKey = (BasicKey)key.unwrap();
        DatabaseEditorCapabilities.TableKeyEditorCaps tableKeyEditorCaps = DatabaseTableKeyEditor.getTableKeyCaps(this.myCaps, table, edKey);
        if (tableKeyEditorCaps == null) {
            DatabaseTableKeysEditor.$$$reportNull$$$0(11);
        }
        return tableKeyEditorCaps;
    }

    @Override
    public void updateFromModel() {
        DatabaseEditorUtil.cleanupEditors(this.myTableKeysModel, this.getTableModel().getTableKeys(), this::createTableKeyEditor);
        this.myTable.getTable().repaint();
    }

    @NotNull
    public DeTable getTable() {
        DeTable deTable = (DeTable)this.getTableModel().getObject();
        if (deTable == null) {
            DatabaseTableKeysEditor.$$$reportNull$$$0(12);
        }
        return deTable;
    }

    @Override
    @NotNull
    public String getTabTitle() {
        int count2 = this.getTableModel().getTableKeysCount();
        String string = "Keys" + (count2 == 0 ? "" : " (" + count2 + ")");
        if (string == null) {
            DatabaseTableKeysEditor.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public ListTableModel<DatabaseTableKeyEditor> getKeysListModel() {
        ListTableModel<DatabaseTableKeyEditor> listTableModel = this.myTableKeysModel;
        if (listTableModel == null) {
            DatabaseTableKeysEditor.$$$reportNull$$$0(14);
        }
        return listTableModel;
    }

    @Override
    @Nullable
    public DatabaseEditorBaseEx getActiveEditor() {
        return DatabaseEditorUtil.getEditedItem(this.myTable, this.myTableKeysModel);
    }

    @NotNull
    public DatabaseEditorCapabilities.ListCapability getCaps() {
        DatabaseEditorCapabilities.ListCapability listCapability = this.myCaps.getAltKeys();
        if (listCapability == null) {
            DatabaseTableKeysEditor.$$$reportNull$$$0(15);
        }
        return listCapability;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableEditor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbarsDecorator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseTableKeysEditor";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseTableKeysEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableKeyEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableKeyCaps";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeysListModel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMyObject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "startItemEditing";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTableKeyEditor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTableKeyCaps";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

