/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.ThrowablePairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncTask<T> {
    private static final Logger LOG = Logger.getInstance(AsyncTask.class);
    private static final boolean TRACK = Registry.is((String)"database.track.async.tasks", (boolean)false);
    public static final Key<ProgressIndicator> INDICATOR_KEY = Key.create((String)"PROGRESS_INDICATOR");
    public static final Executor NON_EDT = command -> {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().executeOnPooledThread(command);
        } else {
            command.run();
        }
    };
    private static final Key<Object> FRAME_DATA_KEY = Key.create((String)"FRAME_DATA");
    private static final Frame ANONYMOUS = new Frame(null, "<Anonymous>");
    private static final ThreadLocal<AsyncTask<?>> ourCurrent = new ThreadLocal();
    protected final Frame myFrame;
    protected final CompletionStage<T> myStage;

    private AsyncTask(@NotNull Frame frame, @NotNull ThrowableComputable<CompletionStage<T>, ?> capture) {
        if (frame == null) {
            AsyncTask.$$$reportNull$$$0(0);
        }
        if (capture == null) {
            AsyncTask.$$$reportNull$$$0(1);
        }
        this.myFrame = frame.ref();
        this.track();
        try {
            this.myStage = (CompletionStage)frame.framed(this, capture);
        }
        catch (Throwable th) {
            this.unTrack();
            frame.deref();
            ExceptionUtil.rethrow((Throwable)th);
            throw new AssertionError((Object)"unreachable");
        }
        this.init();
    }

    private AsyncTask(@NotNull Frame frame, @NotNull CompletionStage<T> stage) {
        if (frame == null) {
            AsyncTask.$$$reportNull$$$0(2);
        }
        if (stage == null) {
            AsyncTask.$$$reportNull$$$0(3);
        }
        this.myFrame = frame.ref();
        this.track();
        this.myStage = stage;
        this.init();
    }

    private void init() {
        this.myStage.whenComplete((r, th) -> {
            try {
                this.unTrack();
            }
            finally {
                this.myFrame.deref();
            }
            if (th != null) {
                this.myFrame.attachFrameData((Throwable)th);
            }
        });
    }

    private void unTrack() {
        if (this.myFrame.myTrackData == null) {
            return;
        }
        TaskInfo info = (TaskInfo)this.myFrame.myTrackData.tasks.remove(this);
        if (info == null || !info.schedules.isEmpty()) {
            // empty if block
        }
    }

    private void track() {
        if (this.myFrame.myTrackData == null) {
            return;
        }
        this.myFrame.myTrackData.tasks.put(this, new TaskInfo(ourCurrent.get()));
    }

    public <U> AsyncTask<U> applyAsync(@Nullable Executor e, @NotNull @NotNull ThrowableConvertor<? super T, @NotNull AsyncTask<U>, ?> computable) {
        if (computable == null) {
            AsyncTask.$$$reportNull$$$0(4);
        }
        Frame frame = Frame.currentOrAnonymous();
        return new AsyncTask<T>(frame, () -> AsyncUtil.thenComposeAsync(this.myStage, r -> (CompletionStage)frame.framed(this, () -> ((AsyncTask)computable.convert((Object)r)).myStage), AsyncTask.executor(frame, e)));
    }

    public <U> AsyncTask<U> apply(@Nullable Executor e, @NotNull ThrowableConvertor<? super T, ? extends U, ?> computable) {
        if (computable == null) {
            AsyncTask.$$$reportNull$$$0(5);
        }
        Frame frame = Frame.currentOrAnonymous();
        return new AsyncTask<T>(frame, () -> {
            Function<Object, Object> conv = r -> frame.framed(this, () -> computable.convert(r));
            return e == null ? this.myStage.thenApply(conv) : this.myStage.thenApplyAsync(conv, AsyncTask.executor(frame, e));
        });
    }

    public AsyncTask<T> whenComplete(@Nullable Executor e, @NotNull ThrowablePairConsumer<? super T, ? super Throwable, ?> consumer2) {
        if (consumer2 == null) {
            AsyncTask.$$$reportNull$$$0(6);
        }
        Frame frame = Frame.currentOrAnonymous();
        return new AsyncTask<T>(frame, () -> {
            BiConsumer<Object, Throwable> conv = (r, th) -> frame.framed(this, () -> {
                consumer2.consume(r, th);
                return null;
            });
            return e == null ? this.myStage.whenComplete(conv) : this.myStage.whenCompleteAsync(conv, AsyncTask.executor(frame, e));
        });
    }

    public AsyncTask<Pair<T, ? extends Throwable>> handle() {
        return new AsyncTask<Pair<T, ? extends Throwable>>(Frame.currentOrAnonymous(), this.myStage.handle(Pair::create));
    }

    @NotNull
    private static Executor executor(@NotNull Frame frame, @Nullable Executor e) {
        if (frame == null) {
            AsyncTask.$$$reportNull$$$0(7);
        }
        if (e == null) {
            Executor executor = Runnable::run;
            if (executor == null) {
                AsyncTask.$$$reportNull$$$0(8);
            }
            return executor;
        }
        AsyncTask<?> async = ourCurrent.get();
        Executor res = Frame.current() == frame ? e : task -> frame.framed(async, () -> {
            e.execute(task);
            return null;
        });
        Executor executor = frame.myTrackData == null ? res : task -> AsyncTask.executeAndTrack(res, frame, async, task);
        if (executor == null) {
            AsyncTask.$$$reportNull$$$0(9);
        }
        return executor;
    }

    private static void executeAndTrack(@NotNull Executor e, @NotNull Frame frame, @Nullable AsyncTask<?> async, Runnable task) {
        if (e == null) {
            AsyncTask.$$$reportNull$$$0(10);
        }
        if (frame == null) {
            AsyncTask.$$$reportNull$$$0(11);
        }
        Throwable trace = new Throwable();
        frame.trackScheduled(async, false, trace);
        e.execute(() -> {
            frame.trackScheduled(async, true, trace);
            task.run();
        });
    }

    public String toString() {
        if (this.myFrame.myTrackData != null) {
            return "finished: " + !this.myFrame.myTrackData.tasks.containsKey(this) + "\nleaf: " + (AsyncTask.allTasks().find(t -> ((TaskInfo)t.getValue()).caller == this) == null);
        }
        return super.toString();
    }

    private static JBIterable<Map.Entry<AsyncTask<?>, TaskInfo>> scheduledTasks() {
        return AsyncTask.allTasks().filter(i2 -> !((TaskInfo)i2.getValue()).schedules.isEmpty());
    }

    private static JBIterable<Map.Entry<AsyncTask<?>, TaskInfo>> allTasks() {
        return ((JBTreeTraverser)JBTreeTraverser.from(f -> ((Frame)f).myTrackData == null ? JBIterable.empty() : ((Frame)f).myTrackData.frames).withRoot((Object)ANONYMOUS)).traverse().flatten(f -> ((Frame)f).myTrackData == null ? Collections.emptySet() : ((Frame)f).myTrackData.tasks.entrySet());
    }

    public static <T> AsyncTask<T> completed(T res) {
        return new AsyncTask<T>(Frame.currentOrAnonymous(), CompletableFuture.completedFuture(res));
    }

    public static <T> AsyncTask<T> completed(T res, Throwable ex) {
        return ex == null ? AsyncTask.completed(res) : AsyncTask.exceptional(ex);
    }

    public static <T> AsyncTask<T> exceptional(Throwable ex) {
        return new AsyncTask(Frame.currentOrAnonymous(), AsyncUtil.exceptional(ex));
    }

    public static <T> AsyncTask<T> cancelled() {
        return new AsyncTask(Frame.currentOrAnonymous(), AsyncUtil.cancelled());
    }

    @NotNull
    public static Frame frame(@NotNull String frameName) {
        if (frameName == null) {
            AsyncTask.$$$reportNull$$$0(12);
        }
        Frame frame = Frame.create(frameName);
        if (frame == null) {
            AsyncTask.$$$reportNull$$$0(13);
        }
        return frame;
    }

    @NotNull
    public static Frame currentFrame() {
        Frame frame = Frame.currentOrAnonymous();
        if (frame == null) {
            AsyncTask.$$$reportNull$$$0(14);
        }
        return frame;
    }

    @NotNull
    public CompletionStage<T> unwrap() {
        CompletionStage<T> completionStage = this.myStage;
        if (completionStage == null) {
            AsyncTask.$$$reportNull$$$0(15);
        }
        return completionStage;
    }

    @NotNull
    public Future<T> toFuture() {
        CompletableFuture<T> completableFuture = this.myStage.toCompletableFuture();
        if (completableFuture == null) {
            AsyncTask.$$$reportNull$$$0(16);
        }
        return completableFuture;
    }

    public void cancel() {
        this.myStage.toCompletableFuture().cancel(true);
    }

    @NotNull
    public static Frame withBgIndicatorIfNeeded(@NotNull Frame frame, @NotNull Project project, @Nullable String caption) {
        ProgressIndicator indicator;
        if (frame == null) {
            AsyncTask.$$$reportNull$$$0(17);
        }
        if (project == null) {
            AsyncTask.$$$reportNull$$$0(18);
        }
        if ((indicator = frame.getInherited(INDICATOR_KEY)) == null) {
            ProgressIndicatorEx progress = AsyncUtil.createBackgroundIndicator(project, caption == null ? frame.getName() : caption);
            INDICATOR_KEY.set((UserDataHolder)frame, (Object)progress);
            progress.start();
            Disposer.register((Disposable)frame, () -> {
                progress.stop();
                progress.processFinish();
            });
        }
        Frame frame2 = frame;
        if (frame2 == null) {
            AsyncTask.$$$reportNull$$$0(19);
        }
        return frame2;
    }

    public static <T> T pass(@NotNull Pair<T, ? extends Throwable> p2) {
        if (p2 == null) {
            AsyncTask.$$$reportNull$$$0(20);
        }
        if (p2.second != null) {
            ExceptionUtil.rethrow((Throwable)((Throwable)p2.second));
        }
        return (T)p2.first;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capture";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/AsyncTask";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/AsyncTask";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "executor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "frame";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "currentFrame";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "toFuture";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "withBgIndicatorIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyAsync";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "whenComplete";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executor";
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeAndTrack";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "frame";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "withBgIndicatorIfNeeded";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "pass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DelayedTask<T> {
        private final AsyncTask<T> myTask;
        private final AtomicInteger myState;

        public DelayedTask(@NotNull Frame frame) {
            if (frame == null) {
                DelayedTask.$$$reportNull$$$0(0);
            }
            this.myState = new AtomicInteger(0);
            this.myTask = new AsyncTask(frame, new CompletableFuture());
        }

        public AsyncTask<T> start(@Nullable Executor e, @NotNull @NotNull ThrowableComputable<@NotNull AsyncTask<T>, ?> supply) {
            if (supply == null) {
                DelayedTask.$$$reportNull$$$0(1);
            }
            CompletableFuture stage = (CompletableFuture)this.myTask.myStage;
            if (!this.myState.compareAndSet(0, 1)) {
                return this.myTask;
            }
            if (stage.isCompletedExceptionally()) {
                return this.myTask;
            }
            if (stage.isDone()) {
                throw new AssertionError((Object)"Delayed already completed");
            }
            try {
                AsyncTask computation = (AsyncTask)this.myTask.myFrame.framed(this.myTask, () -> this.myTask.myFrame.computeAsync(e, supply));
                stage.whenComplete((r, th) -> computation.cancel());
                computation.whenComplete(null, (r, th) -> {
                    if (!stage.isDone()) {
                        if (th != null) {
                            stage.completeExceptionally((Throwable)th);
                        } else {
                            stage.complete(r);
                        }
                    }
                });
            }
            catch (Throwable th2) {
                stage.completeExceptionally(th2);
            }
            return this.myTask;
        }

        public void cancelIfNotStarted() {
            if (this.myState.compareAndSet(0, -1)) {
                this.myTask.cancel();
            }
        }

        @NotNull
        public AsyncTask<T> getTask() {
            AsyncTask<T> asyncTask = this.myTask;
            if (asyncTask == null) {
                DelayedTask.$$$reportNull$$$0(2);
            }
            return asyncTask;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supply";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/AsyncTask$DelayedTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/AsyncTask$DelayedTask";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "start";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class Frame
    extends UserDataHolderBase
    implements Disposable {
        private static final ThreadLocal<Frame> ourCurrent = new ThreadLocal();
        private final Frame myParent;
        private final String myName;
        private final AtomicInteger myRefCount;
        private final TrackData myTrackData;

        private Frame(@Nullable Frame parent2, @NotNull String name) {
            if (name == null) {
                Frame.$$$reportNull$$$0(0);
            }
            this.myRefCount = new AtomicInteger(0);
            this.myTrackData = TRACK ? new TrackData() : null;
            this.myParent = parent2;
            this.myName = name;
            if (this.myParent != null && this.myParent.myTrackData != null) {
                this.myParent.myTrackData.frames.add(this);
            }
        }

        public String getName() {
            return this.myName;
        }

        private Frame ref() {
            if (this.myParent != null) {
                this.myParent.ref();
            }
            this.myRefCount.incrementAndGet();
            return this;
        }

        private void deref() {
            try {
                int count2 = this.myRefCount.decrementAndGet();
                if (count2 < 0) {
                    throw new AssertionError((Object)"Ref count mismatch");
                }
                if (count2 == 0) {
                    Disposer.dispose((Disposable)this);
                }
            }
            finally {
                if (this.myParent != null) {
                    this.myParent.deref();
                }
            }
        }

        public void dispose() {
            if (this.myTrackData != null) {
                if (!this.myTrackData.tasks.isEmpty()) {
                    throw new AssertionError((Object)("Non finished tasks: " + this.myTrackData.tasks.size()));
                }
                if (!this.myTrackData.schedules.isEmpty()) {
                    throw new AssertionError("Scheduled tasks: " + this.myTrackData.schedules.size(), (Throwable)ContainerUtil.getFirstItem((Collection)this.myTrackData.schedules));
                }
            }
            if (this.myParent != null && this.myParent.myTrackData != null) {
                this.myParent.myTrackData.frames.remove((Object)this);
            }
        }

        private void trackScheduled(@Nullable AsyncTask<?> task, boolean ran, Throwable trace) {
            Set schedules;
            if (this.myTrackData == null) {
                return;
            }
            TaskInfo info = task == null ? null : (TaskInfo)this.myTrackData.tasks.get(task);
            Set set = schedules = info == null ? this.myTrackData.schedules : info.schedules;
            if (ran) {
                schedules.remove(trace);
            } else {
                schedules.add(trace);
            }
        }

        public String toString() {
            return this.trace(new StringBuilder()).toString() + " rc = " + this.myRefCount.get();
        }

        @NotNull
        public StringBuilder trace(@NotNull StringBuilder sb) {
            if (sb == null) {
                Frame.$$$reportNull$$$0(1);
            }
            if (this.myParent != null) {
                this.myParent.trace(sb).append(" -> ");
            }
            sb.append(this.myName);
            StringBuilder stringBuilder = sb;
            if (stringBuilder == null) {
                Frame.$$$reportNull$$$0(2);
            }
            return stringBuilder;
        }

        public Frame withFrameData(@Nullable Object data) {
            FRAME_DATA_KEY.set((UserDataHolder)this, data);
            return this;
        }

        @NotNull
        public static Frame create(@NotNull String frameName) {
            if (frameName == null) {
                Frame.$$$reportNull$$$0(3);
            }
            Frame parent2 = Frame.current();
            Frame frame = new Frame(parent2, frameName);
            if (parent2 == null) {
                ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
                INDICATOR_KEY.set((UserDataHolder)frame, (Object)indicator);
            }
            Frame frame2 = frame;
            if (frame2 == null) {
                Frame.$$$reportNull$$$0(4);
            }
            return frame2;
        }

        @NotNull
        public static Frame escape(@NotNull String frameName) {
            if (frameName == null) {
                Frame.$$$reportNull$$$0(5);
            }
            return new Frame(null, frameName);
        }

        public <T> AsyncTask<T> wrap(@Nullable Executor e, @NotNull Supplier<? extends CompletionStage<T>> stage) {
            if (stage == null) {
                Frame.$$$reportNull$$$0(6);
            }
            return new AsyncTask(this, () -> AsyncUtil.thenComposeAsync(this.supply(e, ((Supplier)stage)::get), Function.identity(), Runnable::run));
        }

        public <T> AsyncTask<T> wrap(@NotNull CompletionStage<T> stage) {
            if (stage == null) {
                Frame.$$$reportNull$$$0(7);
            }
            return new AsyncTask(this, stage);
        }

        public <T> AsyncTask<T> compute(@Nullable Executor e, @NotNull ThrowableComputable<? extends T, ?> computable) {
            if (computable == null) {
                Frame.$$$reportNull$$$0(8);
            }
            return new AsyncTask(this, this.supply(e, computable));
        }

        public <T> AsyncTask<T> computeAsync(@Nullable Executor e, @NotNull ThrowableComputable<AsyncTask<T>, ?> computable) {
            if (computable == null) {
                Frame.$$$reportNull$$$0(9);
            }
            return new AsyncTask(this, () -> AsyncUtil.thenComposeAsync(this.supply(e, computable), r -> r.myStage, Runnable::run));
        }

        @NotNull
        private <T> CompletionStage<T> supply(@Nullable Executor e, @NotNull ThrowableComputable<? extends T, ?> computable) {
            if (computable == null) {
                Frame.$$$reportNull$$$0(10);
            }
            AsyncTask task = (AsyncTask)ourCurrent.get();
            CompletableFuture<Object> completableFuture = CompletableFuture.supplyAsync(() -> this.framed(task, computable), AsyncTask.executor(this, e));
            if (completableFuture == null) {
                Frame.$$$reportNull$$$0(11);
            }
            return completableFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T framed(@Nullable AsyncTask<?> task, @NotNull ThrowableComputable<T, ?> computable) {
            ProgressIndicator indicator;
            if (computable == null) {
                Frame.$$$reportNull$$$0(12);
            }
            AsyncTask prevTask = (AsyncTask)ourCurrent.get();
            Frame prevFrame = Frame.current();
            if (prevFrame == this) {
                try {
                    ourCurrent.set(task);
                    Object object = computable.compute();
                    return (T)object;
                }
                catch (Throwable th) {
                    this.rethrow(th);
                }
                finally {
                    ourCurrent.set(prevTask);
                }
            }
            String prevText = (indicator = this.getInherited(INDICATOR_KEY)) == null ? null : indicator.getText2();
            try {
                ourCurrent.set(this);
                ourCurrent.set(task);
                this.ref();
                if (indicator != null) {
                    indicator.setText(this.myName);
                }
                Ref res = Ref.create();
                ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                    try {
                        res.set(computable.compute());
                    }
                    catch (Throwable th) {
                        this.rethrow(th);
                    }
                }, indicator);
                Object object = res.get();
                return (T)object;
            }
            finally {
                this.deref();
                if (Frame.current() != this) {
                    throw new AssertionError((Object)"Broken frames");
                }
                ourCurrent.set(prevFrame);
                ourCurrent.set(prevTask);
                if (indicator != null) {
                    indicator.setText(prevText);
                }
            }
        }

        private void rethrow(Throwable th) {
            this.attachFrameData(th);
            ExceptionUtil.rethrow((Throwable)th);
        }

        public void attachFrameData(Throwable th) {
            if (this == ANONYMOUS || AsyncUtil.isCancellation(th)) {
                return;
            }
            Throwable ue = ExceptionUtil.getRootCause((Throwable)th);
            for (Throwable e : ue.getSuppressed()) {
                if (!(e instanceof FrameData)) continue;
                return;
            }
            ue.addSuppressed(new FrameData(this));
        }

        @Nullable
        public static Frame current() {
            return ourCurrent.get();
        }

        @NotNull
        public static Frame currentOrAnonymous() {
            Frame frame = Frame.current();
            Frame frame2 = frame == null ? ANONYMOUS : frame;
            if (frame2 == null) {
                Frame.$$$reportNull$$$0(13);
            }
            return frame2;
        }

        public <T> T getInherited(@NotNull Key<T> key) {
            if (key == null) {
                Frame.$$$reportNull$$$0(14);
            }
            Frame f = this;
            while (f != null) {
                Object val = key.get((UserDataHolder)f);
                if (val != null) {
                    return (T)val;
                }
                f = f.myParent;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 11: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 11: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
                case 2: 
                case 4: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/util/AsyncTask$Frame";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frameName";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stage";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "computable";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/util/AsyncTask$Frame";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "trace";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "supply";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "currentOrAnonymous";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "trace";
                    break;
                }
                case 2: 
                case 4: 
                case 11: 
                case 13: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "escape";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "wrap";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "computeAsync";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "supply";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "framed";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getInherited";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 11: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class FrameData
        extends Throwable {
            private final Frame myData;

            private FrameData(Frame data) {
                super("Async frame data: " + data.trace(new StringBuilder()), null, false, false);
                this.myData = data;
            }
        }
    }

    private static class TrackData {
        private final List<Frame> frames = Collections.synchronizedList(new ArrayList());
        private final Map<AsyncTask<?>, TaskInfo> tasks = Collections.synchronizedMap(new LinkedHashMap());
        private final Set<Throwable> schedules = Collections.synchronizedSet(new LinkedHashSet());

        private TrackData() {
        }
    }

    private static class TaskInfo {
        private final Throwable trace;
        private final AsyncTask<?> caller;
        private final Set<Throwable> schedules = Collections.synchronizedSet(new LinkedHashSet());

        private TaskInfo(AsyncTask<?> caller) {
            this.caller = caller;
            this.trace = new Throwable();
        }
    }
}

