/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.renderers;

import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.editor.DatabaseColors;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.renderers.GridCellRenderer;
import com.intellij.database.run.ui.grid.renderers.GridCellRendererFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.EditorTextFieldCellRenderer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Component;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultTextRendererFactory
implements GridCellRendererFactory {
    @Nullable
    public static final Language JSON_LANGUAGE = DefaultTextRendererFactory.getJsonLanguage();
    @Nullable
    public static final Language XML_LANGUAGE = LanguageUtil.getFileTypeLanguage((FileType)FileTypeRegistry.getInstance().getFileTypeByExtension("xml"));
    protected final DataGrid myGrid;
    protected final Map<Language, TextRenderer> myRenderers;

    DefaultTextRendererFactory(@NotNull DataGrid grid) {
        if (grid == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(0);
        }
        this.myGrid = grid;
        this.myRenderers = FactoryMap.createMap(language -> {
            TextRenderer renderer = new TextRenderer(this.myGrid, (Language)language);
            Disposer.register((Disposable)this.myGrid, (Disposable)renderer);
            return renderer;
        }, ContainerUtil::newIdentityTroveMap);
    }

    @Override
    public boolean supportsDialect(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(1);
        }
        return true;
    }

    @Override
    public boolean supportsColumn(@NotNull DataConsumer.Column column) {
        if (column == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(2);
        }
        return true;
    }

    @Override
    @NotNull
    public GridCellRenderer getOrCreateRenderer(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (columnIdx == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(3);
        }
        GridCellRenderer gridCellRenderer = this.myRenderers.get(DefaultTextRendererFactory.getLanguage(columnIdx, this.myGrid));
        if (gridCellRenderer == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(4);
        }
        return gridCellRenderer;
    }

    @Nullable
    private static Language getJsonLanguage() {
        Language json5 = Language.findLanguageByID((String)"JSON5");
        return json5 != null ? json5 : LanguageUtil.getFileTypeLanguage((FileType)FileTypeRegistry.getInstance().getFileTypeByExtension("json"));
    }

    @NotNull
    private static Language getLanguage(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull DataGrid grid) {
        Language language;
        if (columnIdx == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(5);
        }
        if (grid == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(6);
        }
        if ((language = grid.getContentLanguage(columnIdx)) != Language.ANY) {
            Language language2 = language;
            if (language2 == null) {
                DefaultTextRendererFactory.$$$reportNull$$$0(7);
            }
            return language2;
        }
        DomainRegistry registry = DomainRegistry.get(DataGridUtil.getDbms(grid), null);
        if (registry != null) {
            LogicalType logicType;
            DataConsumer.Column column = DefaultTextRendererFactory.getColumn(columnIdx, grid);
            Domain domain = registry.getDomain(column);
            LogicalType logicalType = logicType = domain == null ? null : domain.getLogicType();
            if (logicType == LogicalType.JSON) {
                language = JSON_LANGUAGE;
            } else if (logicType == LogicalType.XML) {
                language = XML_LANGUAGE;
            }
        }
        Object object = language != Language.ANY && language != null ? language : PlainTextLanguage.INSTANCE;
        if (object == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(8);
        }
        return object;
    }

    @NotNull
    private static DataConsumer.Column getColumn(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull DataGrid grid) {
        if (columnIdx == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(9);
        }
        if (grid == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(10);
        }
        DataConsumer.Column column = Objects.requireNonNull(grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(columnIdx));
        if (column == null) {
            DefaultTextRendererFactory.$$$reportNull$$$0(11);
        }
        return column;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateRenderer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "supportsDialect";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "supportsColumn";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateRenderer";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getColumn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TextRenderer
    extends GridCellRenderer {
        private final Map<Object, String> myValueTextCache;
        private final Language myLanguage;
        private EditorTextFieldCellRenderer.AbbreviatingRendererComponent myComponent;

        public TextRenderer(@NotNull DataGrid grid, @NotNull Language language) {
            if (grid == null) {
                TextRenderer.$$$reportNull$$$0(0);
            }
            if (language == null) {
                TextRenderer.$$$reportNull$$$0(1);
            }
            super(grid);
            this.myValueTextCache = ContainerUtil.createConcurrentWeakKeySoftValueMap((int)10, (float)0.75f, (int)1, (TObjectHashingStrategy)TObjectHashingStrategy.IDENTITY);
            this.myLanguage = language;
            new UiNotifyConnector((Component)((Object)grid.getComponent()), new Activatable(){

                public void hideNotify() {
                    myValueTextCache.clear();
                }
            });
        }

        @NotNull
        public static EditorTextFieldCellRenderer.AbbreviatingRendererComponent createComponent(@NotNull Project project, @Nullable Language language) {
            if (project == null) {
                TextRenderer.$$$reportNull$$$0(2);
            }
            EditorTextFieldCellRenderer.AbbreviatingRendererComponent component = new EditorTextFieldCellRenderer.AbbreviatingRendererComponent(project, language, false, language == PlainTextLanguage.INSTANCE);
            component.setBorder((Border)new JBEmptyBorder(0, 3, 0, 3));
            EditorTextFieldCellRenderer.AbbreviatingRendererComponent abbreviatingRendererComponent = component;
            if (abbreviatingRendererComponent == null) {
                TextRenderer.$$$reportNull$$$0(3);
            }
            return abbreviatingRendererComponent;
        }

        @Override
        public int getSuitability(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
            if (row == null) {
                TextRenderer.$$$reportNull$$$0(4);
            }
            if (column == null) {
                TextRenderer.$$$reportNull$$$0(5);
            }
            return 1;
        }

        @Override
        @NotNull
        public JComponent getComponent(@NotNull ViewIndex<DataConsumer.Row> rowIdx, @NotNull ViewIndex<DataConsumer.Column> columnIdx, @Nullable Object value2) {
            if (rowIdx == null) {
                TextRenderer.$$$reportNull$$$0(6);
            }
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(7);
            }
            Pair<Integer, Integer> modelRowAndColumn = this.myGrid.getRawIndexConverter().rowAndColumn2Model().fun(rowIdx.asInteger(), columnIdx.asInteger());
            ModelIndex<DataConsumer.Column> modelColumn = ModelIndex.forColumn(this.myGrid, (int)((Integer)modelRowAndColumn.second));
            if (this.myComponent == null) {
                this.myComponent = TextRenderer.createComponent(DataGridUtil.getProject(this.myGrid), this.myLanguage);
                ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myComponent).subscribe(EditorColorsManager.TOPIC, scheme -> {
                    this.myGrid.getComponent().globalSchemeChange(scheme);
                    this.myComponent.getEditor().reinitSettings();
                });
            }
            EditorEx editor = this.myComponent.getEditor();
            this.configureEditor(editor);
            boolean selected = this.myGrid.getSelectionModel().isSelected(rowIdx, columnIdx);
            TextAttributes attributes2 = TextRenderer.getAttributes(value2, editor.getColorsScheme(), selected);
            String valueText = this.getValueText(modelColumn, value2);
            this.myComponent.setText(valueText, attributes2, selected);
            EditorTextFieldCellRenderer.AbbreviatingRendererComponent abbreviatingRendererComponent = this.myComponent;
            if (abbreviatingRendererComponent == null) {
                TextRenderer.$$$reportNull$$$0(8);
            }
            return abbreviatingRendererComponent;
        }

        public static TextAttributes getAttributes(@Nullable Object value2, @NotNull EditorColorsScheme scheme, boolean selected) {
            if (scheme == null) {
                TextRenderer.$$$reportNull$$$0(9);
            }
            TextAttributesKey attributesKey = TextRenderer.getAttributesKey(value2);
            return !selected && attributesKey != null ? scheme.getAttributes(attributesKey) : null;
        }

        protected void configureEditor(@NotNull EditorEx editor) {
            if (editor == null) {
                TextRenderer.$$$reportNull$$$0(10);
            }
            TextRenderer.configureEditor(editor, this.myGrid);
        }

        public static void configureEditor(@NotNull EditorEx editor, @NotNull DataGrid grid) {
            EditorColorsScheme scheme;
            boolean schemeAlreadySet;
            if (editor == null) {
                TextRenderer.$$$reportNull$$$0(11);
            }
            if (grid == null) {
                TextRenderer.$$$reportNull$$$0(12);
            }
            boolean bl = schemeAlreadySet = (scheme = editor.getColorsScheme()) instanceof DelegateColorScheme && ((DelegateColorScheme)scheme).getDelegate() == grid.getColorsScheme() && scheme.getEditorFontSize() == grid.getPreferredFocusedComponent().getFont().getSize();
            if (schemeAlreadySet) {
                return;
            }
            EditorColorsScheme bounded = editor.createBoundColorSchemeDelegate((EditorColorsScheme)grid.getColorsScheme());
            bounded.setEditorFontSize(grid.getPreferredFocusedComponent().getFont().getSize());
            editor.setColorsScheme(bounded);
        }

        @NotNull
        private String getValueText(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @Nullable Object value2) {
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(13);
            }
            if (value2 == null || value2 instanceof ReservedCellValue) {
                String string = ((ReservedCellValue)((Object)ObjectUtils.notNull((Object)((Object)((ReservedCellValue)((Object)value2))), (Object)((Object)ReservedCellValue.NULL)))).getDisplayName();
                if (string == null) {
                    TextRenderer.$$$reportNull$$$0(14);
                }
                return string;
            }
            String cachedText = this.myValueTextCache.get(value2);
            if (cachedText != null) {
                String string = cachedText;
                if (string == null) {
                    TextRenderer.$$$reportNull$$$0(15);
                }
                return string;
            }
            String text2 = TextRenderer.getDisplayString(this.getText(value2, columnIdx));
            this.myValueTextCache.put(value2, text2);
            String string = text2;
            if (string == null) {
                TextRenderer.$$$reportNull$$$0(16);
            }
            return string;
        }

        @NotNull
        protected String getText(@Nullable Object value2, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
            if (columnIdx == null) {
                TextRenderer.$$$reportNull$$$0(17);
            }
            DataConsumer.Column column = DefaultTextRendererFactory.getColumn(columnIdx, this.myGrid);
            String string = this.myGrid.getObjectFormatter().getPlainValue(value2, column, DataGridUtil.getDbms(this.myGrid));
            if (string == null) {
                TextRenderer.$$$reportNull$$$0(18);
            }
            return string;
        }

        public static String getDisplayString(@NotNull String str) {
            int lineEnd;
            if (str == null) {
                TextRenderer.$$$reportNull$$$0(19);
            }
            if (DataGridUtil.isFailedToLoad(str) && (lineEnd = str.indexOf(10, "<failed to load>".length() + 1)) > -1) {
                str = str.substring("<failed to load>".length(), lineEnd).trim();
            }
            return TextRenderer.trimTrailingWhitespace(str);
        }

        private static String trimTrailingWhitespace(String s) {
            int end2;
            for (end2 = s.length(); end2 > 0 && s.charAt(end2 - 1) <= ' '; --end2) {
            }
            return s.substring(0, end2);
        }

        @Override
        public void dispose() {
            if (this.myComponent != null) {
                Disposer.dispose((Disposable)this.myComponent);
            }
        }

        @Nullable
        public static TextAttributesKey getAttributesKey(@Nullable Object value2) {
            if (value2 == null || value2 == ReservedCellValue.UNSET) {
                return DatabaseColors.GRID_NULL_VALUE;
            }
            if (value2 instanceof ObjectFormatter.ImageInfo) {
                return DatabaseColors.GRID_IMAGE_VALUE;
            }
            if (DataGridUtil.isFailedToLoad(value2)) {
                return DatabaseColors.GRID_ERROR_VALUE;
            }
            if (value2 instanceof LobInfo.FileClobInfo || value2 instanceof LobInfo.FileBlobInfo) {
                return DatabaseColors.GRID_UPLOAD_VALUE;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 8: 
                case 14: 
                case 15: 
                case 16: 
                case 18: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 8: 
                case 14: 
                case 15: 
                case 16: 
                case 18: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 8: 
                case 14: 
                case 15: 
                case 16: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rowIdx";
                    break;
                }
                case 7: 
                case 13: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnIdx";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/renderers/DefaultTextRendererFactory$TextRenderer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComponent";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueText";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createComponent";
                    break;
                }
                case 3: 
                case 8: 
                case 14: 
                case 15: 
                case 16: 
                case 18: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuitability";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getComponent";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttributes";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "configureEditor";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getValueText";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getDisplayString";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 8: 
                case 14: 
                case 15: 
                case 16: 
                case 18: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

