/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.console.client.SessionClient;
import com.intellij.database.console.client.SessionClientHolder;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DatabaseMutatorImpl;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridPresentationMode;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.RawIndexConverter;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.datagrid.color.GridColorModel;
import com.intellij.database.datagrid.color.GridColorModelImpl;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.Mutation;
import com.intellij.database.editor.DatabaseStartupActivity;
import com.intellij.database.editor.DatabaseTableFileEditor;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasColumn;
import com.intellij.database.run.actions.DeleteRowsAction;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridRequestSource;
import com.intellij.database.run.ui.ErrorNotificationPanel;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.database.run.ui.GridEditGuard;
import com.intellij.database.run.ui.HiddenColumnsSelectionHolder;
import com.intellij.database.run.ui.MutationSupport;
import com.intellij.database.run.ui.ResultView;
import com.intellij.database.run.ui.ResultViewFactory;
import com.intellij.database.run.ui.ResultViewWithCells;
import com.intellij.database.run.ui.ResultViewWithColumns;
import com.intellij.database.run.ui.ResultViewWithRows;
import com.intellij.database.run.ui.grid.GridColorsScheme;
import com.intellij.database.run.ui.grid.GridCopyProvider;
import com.intellij.database.run.ui.grid.GridFilterPanel;
import com.intellij.database.run.ui.grid.GridMainPanel;
import com.intellij.database.run.ui.grid.GridMarkupModel;
import com.intellij.database.run.ui.grid.GridMarkupModelImpl;
import com.intellij.database.run.ui.grid.GridMutationModel;
import com.intellij.database.run.ui.grid.GridPasteProvider;
import com.intellij.database.run.ui.grid.GridRowComparator;
import com.intellij.database.run.ui.grid.GridRowHeader;
import com.intellij.database.run.ui.grid.GridScrollPositionManager;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactoryProvider;
import com.intellij.database.run.ui.grid.editors.RangeFormatResolver;
import com.intellij.database.run.ui.table.TableResultRowHeader;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.find.FindModel;
import com.intellij.find.SearchSession;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.impl.EditorEmptyTextPainter;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.ui.JBAutoscroller;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBLoadingPanelListener;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableResultPanel
extends UserDataHolderBase
implements DataGrid,
GridModel.Listener<DataConsumer.Row, DataConsumer.Column>,
MutationSupport {
    public static final Key<String> GRID_TAB_TITLE_KEY = new Key("GRID_TAB_TITLE");
    private static final String XML_LANGUAGE_ID = "XML";
    private static final String JSON_LANGUAGE_ID = "JSON";
    private static final int RESULT_VIEW_COMPONENT_Z_INDEX = 1;
    private static final int LOAD_DATA_Z_INDEX = 2;
    private ErrorNotificationPanel myErrorNotificationPanel;
    private final GridMainPanel myMainPanel;
    private final JLayeredPane myLayeredPane;
    private ResultView myResultView;
    private final ActionGroup myPopupActionGroup;
    protected final ActionGroup myGutterPopupActions;
    private final ActionGroup myColumnHeaderActions;
    private final ActionGroup myRowHeaderActions;
    private final GridCellEditorFactoryProvider myCellEditorFactoryProvider;
    private final GridColorsScheme myColorsScheme;
    private final ColumnAttributes myColumnAttributes;
    private final Project myProject;
    private final ObjectFormatter myConverter;
    protected final GridFilterPanel myFilterPanel;
    private final EventDispatcher<DataGridListener> myEventDispatcher;
    private final GridMarkupModel<DataConsumer.Row, DataConsumer.Column> myMarkupModel;
    private final GridDataHookUp<DataConsumer.Row, DataConsumer.Column> myDataHookUp;
    private final MyLoadDataPanel myLoadDataPanel;
    private JComponent myMainResultViewComponent;
    private final HiddenColumnsSelectionHolder myHiddenColumnSelectionHolder;
    private final JBAutoscroller.AutoscrollLocker myAutoscrollLocker;
    private GridColorModel myColorModel;
    private SearchSession mySearchSession;
    private GridPresentationMode myPresentationMode;
    private ResultViewFactory myViewFactory;
    private DataExtractorFactory.Text myExtractorFactory;
    private Component myFilterComponent;

    public TableResultPanel(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp, @NotNull ActionGroup popupActions) {
        if (project == null) {
            TableResultPanel.$$$reportNull$$$0(0);
        }
        if (dataHookUp == null) {
            TableResultPanel.$$$reportNull$$$0(1);
        }
        if (popupActions == null) {
            TableResultPanel.$$$reportNull$$$0(2);
        }
        this(project, dataHookUp, popupActions, popupActions, DataGridUtil.getGridColumnHeaderPopupActions(), ActionGroup.EMPTY_GROUP, null, false);
    }

    public TableResultPanel(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp, @NotNull ActionGroup popupActions, @NotNull ActionGroup gutterPopupActions, @NotNull ActionGroup columnHeaderActions, @NotNull ActionGroup rowHeaderActions, @Nullable GridCellEditorFactoryProvider cellEditorFactoryProvider, boolean useConsoleFonts) {
        if (project == null) {
            TableResultPanel.$$$reportNull$$$0(3);
        }
        if (dataHookUp == null) {
            TableResultPanel.$$$reportNull$$$0(4);
        }
        if (popupActions == null) {
            TableResultPanel.$$$reportNull$$$0(5);
        }
        if (gutterPopupActions == null) {
            TableResultPanel.$$$reportNull$$$0(6);
        }
        if (columnHeaderActions == null) {
            TableResultPanel.$$$reportNull$$$0(7);
        }
        if (rowHeaderActions == null) {
            TableResultPanel.$$$reportNull$$$0(8);
        }
        this.myConverter = new ObjectFormatter();
        this.myEventDispatcher = EventDispatcher.create(DataGridListener.class);
        this.myPresentationMode = GridPresentationMode.TABLE;
        this.myProject = project;
        this.myPopupActionGroup = popupActions;
        this.myGutterPopupActions = gutterPopupActions;
        this.myColumnHeaderActions = columnHeaderActions;
        this.myRowHeaderActions = rowHeaderActions;
        this.myCellEditorFactoryProvider = cellEditorFactoryProvider;
        this.myColorsScheme = useConsoleFonts ? new GridColorsScheme.ForConsole() : new GridColorsScheme();
        this.myMarkupModel = new GridMarkupModelImpl<DataConsumer.Row, DataConsumer.Column>();
        this.myHiddenColumnSelectionHolder = new HiddenColumnsSelectionHolder();
        this.myAutoscrollLocker = new JBAutoscroller.AutoscrollLocker();
        this.myDataHookUp = dataHookUp;
        this.myFilterPanel = new GridFilterPanel(this.myProject, this);
        this.myMainPanel = new GridMainPanel(this);
        DataManager.registerDataProvider((JComponent)((Object)this.myMainPanel), this::getData);
        this.myMainPanel.setLoadingText("");
        this.myLoadDataPanel = new MyLoadDataPanel(this);
        this.myLayeredPane = new JBLayeredPane(){

            public void doLayout() {
                TableResultPanel.this.myLoadDataPanel.setBounds(0, 0, this.getWidth(), this.getHeight());
                if (TableResultPanel.this.myMainResultViewComponent != null) {
                    TableResultPanel.this.myMainResultViewComponent.setBounds(0, 0, this.getWidth(), this.getHeight());
                }
            }
        };
        this.myMainPanel.add(this.myLayeredPane, "Center");
        this.getLoadingPanel().addListener((JBLoadingPanelListener)new JBLoadingPanelListener.Adapter(){

            public void onLoadingStart() {
                DatabaseStartupActivity.DataEditorConfigurator.disableLoadingDelay(TableResultPanel.this);
            }
        });
        this.myColumnAttributes = new ColumnAttributes();
        this.myExtractorFactory = this.getCurrentExtractorFactory();
        this.myViewFactory = ResultViewFactory.of(this.myPresentationMode);
        this.createResultView();
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        if (sortingModel != null) {
            sortingModel.addListener(new GridSortingModel.Listener(){

                @Override
                public void orderingChanged() {
                    TableResultPanel.this.updateColumnAttributes();
                    TableResultPanel.this.updateSortKeysFromColumnAttributes();
                }
            }, this);
        }
        Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector.Once((Component)((Object)this.getComponent()), new Activatable(){

            public void showNotify() {
                TableResultPanel.this.installDataHookUpListeners();
            }
        }));
    }

    @NotNull
    private DataExtractorFactory.Text getCurrentExtractorFactory() {
        DataExtractorFactory extractorFactory = DataGridUtil.getDbms(this).isMongo() ? DataExtractorFactories.findById("JSON-Groovy.json.groovy") : DataExtractorProperties.getCurrentExtractorFactory(this.myProject);
        DataExtractorFactory.Text text2 = extractorFactory instanceof DataExtractorFactory.Text ? (DataExtractorFactory.Text)extractorFactory : DataExtractorFactories.getDefault();
        if (text2 == null) {
            TableResultPanel.$$$reportNull$$$0(9);
        }
        return text2;
    }

    @Override
    public void loadingDelayDisabled() {
        this.myLayeredPane.remove(this.myLoadDataPanel);
    }

    @Override
    public void loadingDelayed() {
        this.myLayeredPane.add(this.myLoadDataPanel);
        this.myLayeredPane.setLayer(this.myLoadDataPanel, 2);
    }

    private void createResultView() {
        this.myResultView = this.myViewFactory.createResultView(this);
        this.myColorModel = new GridColorModelImpl(this, (GridMutator.DatabaseMutator)ObjectUtils.tryCast(this.getMutator(), DatabaseMutatorImpl.class));
        this.myMainResultViewComponent = this.myViewFactory.wrap(this, this.myResultView);
        this.myLayeredPane.add(this.myMainResultViewComponent);
        this.myLayeredPane.setLayer(this.myMainResultViewComponent, 1);
        this.registerEscapeAction(this.myResultView);
        this.myResultView.addSelectionChangedListener(() -> {
            ((DataGridListener)this.myEventDispatcher.getMulticaster()).onSelectionChanged(this);
            this.myResultView.getComponent().repaint();
            DataGridUtil.updateWidgets(this);
        });
        this.myResultView.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                if (!TableResultPanel.this.stopEditing()) {
                    TableResultPanel.this.cancelEditing();
                }
                if (TableResultPanel.this.myPopupActionGroup != ActionGroup.EMPTY_GROUP) {
                    ActionManager.getInstance().createActionPopupMenu("EditorPopup", TableResultPanel.this.myPopupActionGroup).getComponent().show(comp, x, y);
                }
            }
        });
        this.myResultView.getComponent().putClientProperty("AuxEditorComponent", Boolean.TRUE);
    }

    public ActionGroup getColumnHeaderActions() {
        return this.myColumnHeaderActions;
    }

    @NotNull
    public ActionGroup getRowHeaderActions() {
        ActionGroup actionGroup = this.myRowHeaderActions;
        if (actionGroup == null) {
            TableResultPanel.$$$reportNull$$$0(10);
        }
        return actionGroup;
    }

    public GridCellEditorFactoryProvider getCellEditorFactoryProvider() {
        return this.myCellEditorFactoryProvider;
    }

    @NotNull
    public GridColorModel getColorModel() {
        GridColorModel gridColorModel = this.myColorModel;
        if (gridColorModel == null) {
            TableResultPanel.$$$reportNull$$$0(11);
        }
        return gridColorModel;
    }

    public JBAutoscroller.AutoscrollLocker getAutoscrollLocker() {
        return this.myAutoscrollLocker;
    }

    public HiddenColumnsSelectionHolder getHiddenColumnSelectionHolder() {
        return this.myHiddenColumnSelectionHolder;
    }

    public ColumnAttributes getColumnAttributes() {
        return this.myColumnAttributes;
    }

    @NotNull
    public GridRowHeader createRowHeader(@NotNull TableResultView table) {
        if (table == null) {
            TableResultPanel.$$$reportNull$$$0(12);
        }
        return new TableResultRowHeader(this, table, this.myGutterPopupActions);
    }

    public void installDataHookUpListeners() {
        this.myDataHookUp.addRequestListener(new GridDataHookUp.RequestListener<DataConsumer.Row, DataConsumer.Column>(){

            @Override
            public void error(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, @Nullable String message2, @Nullable Throwable th) {
                if (source == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (source.grid != TableResultPanel.this) {
                    return;
                }
                if (message2 != null) {
                    Throwable throwable = new Throwable(message2);
                    throwable.setStackTrace(th == null ? new StackTraceElement[]{} : th.getStackTrace());
                    th = throwable;
                }
                if (th != null) {
                    TableResultPanel.this.handleError(source, th);
                }
                if (source.source instanceof DataGridRequestSource) {
                    ((DataGridRequestSource)((Object)source.source)).setErrorReported();
                }
            }

            @Override
            public void updateCountReceived(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, int updateCount2) {
                if (source == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (source.grid != TableResultPanel.this) {
                    return;
                }
                if (source.source instanceof DataGridRequestSource) {
                    ((DataGridRequestSource)((Object)source.source)).addUpdateCount(updateCount2);
                }
            }

            @Override
            public void requestFinished(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source, boolean success) {
                boolean isNull;
                if (source == null) {
                    6.$$$reportNull$$$0(2);
                }
                this.doRepaint(source);
                if (source.grid != TableResultPanel.this) {
                    return;
                }
                DataGridRequestSource requestSource = (DataGridRequestSource)((Object)ObjectUtils.tryCast((Object)source.source, DataGridRequestSource.class));
                boolean bl = isNull = requestSource == null;
                if (isNull || !requestSource.isErrorReported()) {
                    TableResultPanel.this.hideErrorPanel();
                    if (isNull) {
                        return;
                    }
                }
                if (!requestSource.isForceSuccess()) {
                    this.countRows(requestSource, success);
                }
                requestSource.requestComplete(success);
            }

            private void countRows(@NotNull DataGridRequestSource requestSource, boolean success) {
                if (requestSource == null) {
                    6.$$$reportNull$$$0(3);
                }
                if (success && !requestSource.isErrorReported() && DataGridUtil.getDataBusHookUp(TableResultPanel.this) != null) {
                    int actualUpdateCount = requestSource.getUpdateCount();
                    if (actualUpdateCount == -2) {
                        return;
                    }
                    int expectedUpdateCount = requestSource.getRows().size();
                    if (expectedUpdateCount != actualUpdateCount) {
                        Exception e = new Exception(actualUpdateCount + " rows updated.");
                        e.setStackTrace(new StackTraceElement[0]);
                        TableResultPanel.this.showError(e, requestSource);
                    }
                }
            }

            private void doRepaint(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> source) {
                Component rowHeader;
                if (source == null) {
                    6.$$$reportNull$$$0(4);
                }
                if (!(source.source instanceof DataGridRequestSource)) {
                    return;
                }
                DataGridRequestSource requestSource = (DataGridRequestSource)((Object)source.source);
                if (!requestSource.isForceSuccess()) {
                    return;
                }
                TableResultPanel.this.myResultView.getComponent().repaint(50L);
                JViewport header = TableResultPanel.this.myMainResultViewComponent instanceof JScrollPane ? ((JScrollPane)TableResultPanel.this.myMainResultViewComponent).getRowHeader() : null;
                Component component = rowHeader = header == null ? null : header.getView();
                if (rowHeader != null) {
                    rowHeader.repaint(50L);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "requestSource";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/run/ui/TableResultPanel$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateCountReceived";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "requestFinished";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "countRows";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doRepaint";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this);
        this.getDataModel().addListener(this, this);
        this.fireDataEvents();
    }

    private void fireDataEvents() {
        if (this.getDataModel().getColumnCount() != 0) {
            this.columnsAdded(this.getDataModel().getColumnIndices());
        }
    }

    @Override
    public void columnsAdded(ModelIndexSet<DataConsumer.Column> columnIndices) {
        this.myColumnAttributes.newColumns(this, this.getDataModel().getColumns());
        this.updateColumnAttributes();
        this.updateSortKeysFromColumnAttributes();
        this.myResultView.columnsAdded(columnIndices);
        this.trueLayout();
        this.restoreColumnsOrder();
    }

    public void restoreColumnsOrder() {
        LinkedHashMap<Integer, ModelIndex<DataConsumer.Column>> expectedToModel = new LinkedHashMap<Integer, ModelIndex<DataConsumer.Column>>();
        JBIterable modelIndices = this.getDataModel().getColumnIndices().asIterable();
        for (ModelIndex modelIndex : modelIndices) {
            DataConsumer.Column column = this.getDataModel().getColumn(modelIndex);
            if (column == null) {
                return;
            }
            int initialPosition = this.getInitialPosition(column);
            if (initialPosition == 0) {
                return;
            }
            initialPosition = initialPosition == -1 ? modelIndex.value : DatabaseTableFileEditor.fromSerializedPosition(initialPosition);
            expectedToModel.put(initialPosition, modelIndex);
        }
        this.myResultView.restoreColumnsOrder(expectedToModel);
    }

    @Override
    public void columnsRemoved(ModelIndexSet<DataConsumer.Column> columns) {
        this.myResultView.columnsRemoved(columns);
        this.trueLayout();
    }

    @Override
    public void rowsAdded(ModelIndexSet<DataConsumer.Row> rows) {
        this.myResultView.rowsAdded(rows);
        this.trueLayout();
    }

    @Override
    public void afterRowsAdded() {
        Component rowHeader;
        JViewport header = this.myMainResultViewComponent instanceof JScrollPane ? ((JScrollPane)this.myMainResultViewComponent).getRowHeader() : null;
        Component component = rowHeader = header == null ? null : header.getView();
        if (rowHeader == null) {
            return;
        }
        if (rowHeader instanceof TableResultRowHeader) {
            ((TableResultRowHeader)rowHeader).updatePreferredSize();
        }
        rowHeader.revalidate();
        rowHeader.repaint();
    }

    @Override
    public void setCommonEditorValue(@Nullable Object object) {
        this.myResultView.setCommonEditorValue(object);
    }

    @Override
    @NotNull
    public ResultView getResultView() {
        ResultView resultView = this.myResultView;
        if (resultView == null) {
            TableResultPanel.$$$reportNull$$$0(13);
        }
        return resultView;
    }

    @Override
    public void rowsRemoved(ModelIndexSet<DataConsumer.Row> rows) {
        this.myResultView.rowsRemoved(rows);
        this.trueLayout();
    }

    @Override
    public void cellsUpdated(ModelIndexSet<DataConsumer.Row> rows, ModelIndexSet<DataConsumer.Column> columns) {
        this.myResultView.cellsUpdated(rows, columns);
    }

    private void registerEscapeAction(@NotNull ResultView resultView) {
        if (resultView == null) {
            TableResultPanel.$$$reportNull$$$0(14);
        }
        resultView.registerEscapeAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TableResultPanel.this.myErrorNotificationPanel != null) {
                    TableResultPanel.this.hideErrorPanel();
                } else if (TableResultPanel.this.mySearchSession != null) {
                    TableResultPanel.this.mySearchSession.close();
                }
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && !TableResultPanel.this.isEditing() && (TableResultPanel.this.myErrorNotificationPanel != null || TableResultPanel.this.mySearchSession != null);
            }
        });
    }

    @Override
    public boolean isSortViaOrderBySupported() {
        return this.myDataHookUp.getSortingModel() != null;
    }

    @Override
    public boolean isSortViaOrderBy() {
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        return sortingModel != null && sortingModel.isSortingEnabled();
    }

    @Override
    public void setSortViaOrderBy(boolean sortViaOrderBy) {
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        if (sortingModel == null) {
            return;
        }
        boolean reload = this.updateDataOrdering(false) || sortingModel.isSortingEnabled() != sortViaOrderBy;
        sortingModel.setSortingEnabled(sortViaOrderBy);
        if (reload && this.isSafeToReload()) {
            this.myDataHookUp.getLoader().loadFirstPage(GridRequestSource.create(this, null));
        }
    }

    public void setOrdering(List<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering) {
        this.myColumnAttributes.resetOrdering();
        for (RowSortOrder<ModelIndex<DataConsumer.Column>> o : ordering) {
            ModelIndex<DataConsumer.Column> columnIdx = o.getColumn();
            DataConsumer.Column column = this.getDataModel().getColumn(columnIdx);
            this.myColumnAttributes.changeSortOrder(column, o.getOrder());
        }
        this.updateSortKeysFromColumnAttributes();
    }

    @Override
    @NotNull
    public RowSortOrder.Type getSortOrder(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        int sortOrder;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(15);
        }
        int n = sortOrder = this.shouldExposeSortingInfo() ? this.getSortOrder(this.getDataModel().getColumn(columnIdx)) : 0;
        RowSortOrder.Type type = sortOrder == 0 ? RowSortOrder.Type.UNSORTED : (sortOrder < 0 ? RowSortOrder.Type.ASC : RowSortOrder.Type.DESC);
        if (type == null) {
            TableResultPanel.$$$reportNull$$$0(16);
        }
        return type;
    }

    @Override
    public int getThenBySortOrder(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(17);
        }
        return this.shouldExposeSortingInfo() ? Math.abs(this.getSortOrder(this.getDataModel().getColumn(columnIdx))) : 0;
    }

    private boolean shouldExposeSortingInfo() {
        return !this.getResultView().isTransposed() || this.isSortViaOrderBy();
    }

    public int getSortOrder(@Nullable DataConsumer.Column column) {
        return column != null ? this.myColumnAttributes.getSortOrder(column) : 0;
    }

    @Override
    public void addDataGridListener(DataGridListener listener2, Disposable disposable2) {
        this.myEventDispatcher.addListener((EventListener)listener2, disposable2);
    }

    @Override
    @NotNull
    public GridColorsScheme getColorsScheme() {
        GridColorsScheme gridColorsScheme = this.myColorsScheme;
        if (gridColorsScheme == null) {
            TableResultPanel.$$$reportNull$$$0(18);
        }
        return gridColorsScheme;
    }

    @Override
    public void searchSessionStarted(@NotNull SearchSession searchSession) {
        if (searchSession == null) {
            TableResultPanel.$$$reportNull$$$0(19);
        }
        assert (this.mySearchSession == null);
        this.mySearchSession = searchSession;
        this.myResultView.searchSessionStarted(searchSession);
        this.getResultView().searchSessionUpdated();
    }

    @Override
    public void searchSessionStopped(@NotNull SearchSession searchSession) {
        if (searchSession == null) {
            TableResultPanel.$$$reportNull$$$0(20);
        }
        assert (this.mySearchSession == searchSession);
        this.mySearchSession = null;
        this.getResultView().searchSessionUpdated();
    }

    @Override
    @Nullable
    public SearchSession getSearchSession() {
        return this.mySearchSession;
    }

    public TreeMap<Integer, DataConsumer.Column> getSortOrderMap() {
        return this.myColumnAttributes.getSortOrderMap();
    }

    @Override
    public ObjectFormatter getObjectFormatter() {
        return this.myConverter;
    }

    @Override
    public boolean isEditable() {
        return !this.myDataHookUp.isReadOnly() && GridEditGuard.get(this) == null && !DataGridUtil.getDbms(this).isMongo();
    }

    @Override
    public boolean isCellEditingAllowed() {
        return this.myResultView instanceof ResultViewWithCells && ((ResultViewWithCells)((Object)this.myResultView)).isCellEditingAllowed();
    }

    @Override
    public void setCells(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, @Nullable Object value2) {
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (rows == null) {
            TableResultPanel.$$$reportNull$$$0(21);
        }
        if (columns == null) {
            TableResultPanel.$$$reportNull$$$0(22);
        }
        if ((mutator = this.myDataHookUp.getMutator()) != null && this.isSafeToUpdate(rows, columns, value2)) {
            DataGridRequestSource source = new DataGridRequestSource(rows, columns);
            mutator.mutate(GridRequestSource.create(this, (Object)source), rows, columns, value2);
        }
        this.cellsUpdated(rows, columns);
    }

    public Project getProject() {
        return this.myProject;
    }

    @Override
    public void insertRow() {
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
        if (mutator == null) {
            return;
        }
        if (mutator.isUpdateImmediately() && mutator.hasPendingChanges()) {
            this.submit().doWhenDone(() -> mutator.insertRow(this.newInsertOrCloneRowRequestSource()));
            return;
        }
        mutator.insertRow(this.newInsertOrCloneRowRequestSource());
    }

    @Override
    public void cloneRow(@NotNull ModelIndex<DataConsumer.Row> rowToClone) {
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (rowToClone == null) {
            TableResultPanel.$$$reportNull$$$0(23);
        }
        if ((mutator = this.getRowsMutator()) == null) {
            return;
        }
        if (mutator.isUpdateImmediately() && mutator.hasPendingChanges()) {
            this.submit().doWhenDone(() -> mutator.cloneRow(this.newInsertOrCloneRowRequestSource(), rowToClone));
            return;
        }
        mutator.cloneRow(this.newInsertOrCloneRowRequestSource(), rowToClone);
    }

    private GridRequestSource<DataConsumer.Row, DataConsumer.Column> newInsertOrCloneRowRequestSource() {
        DataGridRequestSource source = new DataGridRequestSource(this);
        source.doWhenDone(() -> {
            if (this.myResultView.isEditing()) {
                return;
            }
            GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getRowsMutator();
            ModelIndex<DataConsumer.Row> row = mutator != null ? mutator.getLastInsertedRow() : ModelIndex.forRow(this, -1);
            row = row != null && row.isValid(this) ? row : ModelIndex.forRow(this, this.getDataModel().getRowCount() - 1);
            this.scrollToLocally(row.toView(this));
        });
        return GridRequestSource.create(this, (Object)source);
    }

    @Override
    public void insertColumn() {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getColumnsMutator();
        if (mutator == null) {
            return;
        }
        this.submit().doWhenDone(() -> mutator.insertColumn(GridRequestSource.create(this, (Object)this.newInsertOrCloneColumnRequestSource())));
    }

    @Override
    public void cloneColumn(@NotNull ModelIndex<DataConsumer.Column> columnToClone) {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (columnToClone == null) {
            TableResultPanel.$$$reportNull$$$0(24);
        }
        if ((mutator = this.getColumnsMutator()) == null) {
            return;
        }
        this.submit().doWhenDone(() -> mutator.cloneColumn(GridRequestSource.create(this, (Object)this.newInsertOrCloneColumnRequestSource()), columnToClone));
    }

    private DataGridRequestSource newInsertOrCloneColumnRequestSource() {
        DataGridRequestSource source = new DataGridRequestSource(this);
        source.doWhenDone(() -> {
            ModelIndex<DataConsumer.Column> column = ModelIndex.forColumn(this, this.getDataModel().getColumnCount() - 1);
            this.scrollToLocally(ViewIndex.forRow(this, 0), column.toView(this));
        });
        return source;
    }

    @Override
    public void deleteRows(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        boolean canDelete;
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (rows == null) {
            TableResultPanel.$$$reportNull$$$0(25);
        }
        if ((mutator = this.getRowsMutator()) == null) {
            return;
        }
        boolean areRowsInserted = true;
        for (ModelIndex index2 : rows.asIterable()) {
            areRowsInserted &= mutator.isInsertedRow(index2);
        }
        boolean bl = canDelete = !mutator.hasPendingChanges() || !mutator.isUpdateImmediately() || areRowsInserted || DataGridUtil.showIgnoreUnsubmittedChangesYesNoDialog(this);
        if (!canDelete) {
            return;
        }
        GridSelection<DataConsumer.Row, DataConsumer.Column> selection = this.getSelectionModel().store();
        DataGridRequestSource source = new DataGridRequestSource(rows, ModelIndexSet.forColumns(this, new int[0]));
        mutator.deleteRows(GridRequestSource.create(this, (Object)source), rows);
        source.doWhenDone(() -> this.myAutoscrollLocker.runWithLock(() -> this.getSelectionModel().restore(this.getSelectionModel().fit(selection))));
    }

    @Override
    public void deleteColumns(@NotNull ModelIndexSet<DataConsumer.Column> columns) {
        GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (columns == null) {
            TableResultPanel.$$$reportNull$$$0(26);
        }
        if ((mutator = this.getColumnsMutator()) != null) {
            DataGridRequestSource source = new DataGridRequestSource(ModelIndexSet.forRows(this, new int[0]), columns);
            mutator.deleteColumns(GridRequestSource.create(this, (Object)source), columns);
        }
    }

    @Override
    public boolean isColumnsMutationSupported() {
        return this.getColumnsMutator() != null;
    }

    @Override
    @NotNull
    public ActionCallback submit() {
        GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getDatabaseMutator();
        if (mutator == null || !mutator.hasPendingChanges()) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TableResultPanel.$$$reportNull$$$0(27);
            }
            return actionCallback;
        }
        GridSelection<DataConsumer.Row, DataConsumer.Column> selection = this.getSelectionModel().store();
        DataGridRequestSource source = new DataGridRequestSource(mutator.getAffectedRows(), ModelIndexSet.forColumns(this, -1));
        mutator.submit(GridRequestSource.create(this, (Object)source), true);
        ActionCallback actionCallback = source.doWhenDone(() -> this.getSelectionModel().restore(this.getSelectionModel().fit(selection)));
        if (actionCallback == null) {
            TableResultPanel.$$$reportNull$$$0(28);
        }
        return actionCallback;
    }

    @NotNull
    public GridMutationModel getMutationModel() {
        return new GridMutationModel(this.myDataHookUp.getMutator(), this, this.getDataModel(), this.myResultView);
    }

    @Override
    @NotNull
    public GridDataSupport getDataSupport() {
        return new GridMutationModel(this.myDataHookUp.getMutator(), this, this.getDataModel(), this.myResultView);
    }

    @Nullable
    private GridMutator.ColumnsMutator<DataConsumer.Row, DataConsumer.Column> getColumnsMutator() {
        return (GridMutator.ColumnsMutator)ObjectUtils.tryCast(this.myDataHookUp.getMutator(), GridMutator.ColumnsMutator.class);
    }

    @Override
    public boolean isInsertedRow(@NotNull ModelIndex<DataConsumer.Row> row) {
        GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (row == null) {
            TableResultPanel.$$$reportNull$$$0(29);
        }
        return (mutator = this.getRowsMutator()) != null && mutator.isInsertedRow(row);
    }

    @Override
    @NotNull
    public SelectionModel<DataConsumer.Row, DataConsumer.Column> getSelectionModel() {
        SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = SelectionModel.get(this, this.myResultView);
        if (selectionModel == null) {
            TableResultPanel.$$$reportNull$$$0(30);
        }
        return selectionModel;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        DataRequest.OwnerEx ownerEx = (DataRequest.OwnerEx)ObjectUtils.tryCast(this.getDataHookup(), DataRequest.OwnerEx.class);
        return ownerEx != null ? StringUtil.notNullize((String)ownerEx.getDisplayName()) : "";
    }

    @Override
    @NotNull
    public GridMarkupModel<DataConsumer.Row, DataConsumer.Column> getMarkupModel() {
        GridMarkupModel<DataConsumer.Row, DataConsumer.Column> gridMarkupModel = this.myMarkupModel;
        if (gridMarkupModel == null) {
            TableResultPanel.$$$reportNull$$$0(31);
        }
        return gridMarkupModel;
    }

    @Override
    @NotNull
    public GridModel<DataConsumer.Row, DataConsumer.Column> getDataModel(@NotNull DataAccessType reason) {
        if (reason == null) {
            TableResultPanel.$$$reportNull$$$0(32);
        }
        GridModel<DataConsumer.Row, DataConsumer.Column> gridModel = reason.getModel(this);
        if (gridModel == null) {
            TableResultPanel.$$$reportNull$$$0(33);
        }
        return gridModel;
    }

    @Override
    @NotNull
    public GridModel<DataConsumer.Row, DataConsumer.Column> getDataModel() {
        GridModel<DataConsumer.Row, DataConsumer.Column> gridModel = this.myDataHookUp.getModel();
        if (gridModel == null) {
            TableResultPanel.$$$reportNull$$$0(34);
        }
        return gridModel;
    }

    @Override
    @NotNull
    public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> getDataHookup() {
        GridDataHookUp<DataConsumer.Row, DataConsumer.Column> gridDataHookUp = this.myDataHookUp;
        if (gridDataHookUp == null) {
            TableResultPanel.$$$reportNull$$$0(35);
        }
        return gridDataHookUp;
    }

    @Override
    @NotNull
    public RawIndexConverter getRawIndexConverter() {
        RawIndexConverter rawIndexConverter = this.myResultView.getRawIndexConverter();
        if (rawIndexConverter == null) {
            TableResultPanel.$$$reportNull$$$0(36);
        }
        return rawIndexConverter;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myResultView.getPreferredFocusedComponent();
        if (jComponent == null) {
            TableResultPanel.$$$reportNull$$$0(37);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public JComponent getMainResultViewComponent() {
        JComponent jComponent = this.myMainResultViewComponent;
        if (jComponent == null) {
            TableResultPanel.$$$reportNull$$$0(38);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public JBLoadingPanel getLoadingPanel() {
        GridMainPanel gridMainPanel = this.myMainPanel;
        if (gridMainPanel == null) {
            TableResultPanel.$$$reportNull$$$0(39);
        }
        return gridMainPanel;
    }

    @Override
    @NotNull
    public GridMainPanel getComponent() {
        GridMainPanel gridMainPanel = this.myMainPanel;
        if (gridMainPanel == null) {
            TableResultPanel.$$$reportNull$$$0(40);
        }
        return gridMainPanel;
    }

    @Override
    public void setTopComponent(@Nullable Component component) {
        this.myMainPanel.setTopComponent(component);
    }

    @Override
    public void setFilterComponent(@Nullable Component component) {
        EditorHeaderComponent header = (EditorHeaderComponent)ObjectUtils.tryCast((Object)this.myMainPanel.getTopComponent(), EditorHeaderComponent.class);
        if (header == null) {
            return;
        }
        if (this.myFilterComponent != null) {
            header.remove(this.myFilterComponent);
        }
        if (component != null) {
            header.add(component, (Object)"South");
        }
        this.myFilterComponent = component;
        header.revalidate();
        header.repaint();
    }

    @Override
    @Nullable
    public Component getTopComponent() {
        return this.myMainPanel.getTopComponent();
    }

    @Override
    @Nullable
    public Component getFilterComponent() {
        return this.myFilterComponent;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Column> getVisibleColumns() {
        ModelIndexSet<DataConsumer.Column> modelIndexSet = this.myResultView.getVisibleColumns();
        if (modelIndexSet == null) {
            TableResultPanel.$$$reportNull$$$0(41);
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndexSet<DataConsumer.Row> getVisibleRows() {
        ModelIndexSet<DataConsumer.Row> modelIndexSet = this.myResultView.getVisibleRows();
        if (modelIndexSet == null) {
            TableResultPanel.$$$reportNull$$$0(42);
        }
        return modelIndexSet;
    }

    @Override
    public int getVisibleRowsCount() {
        return this.myResultView.getViewRowCount();
    }

    @Override
    public boolean isEditing() {
        return this.myResultView.isEditing();
    }

    @Override
    public boolean stopEditing() {
        return this.myResultView.stopEditing();
    }

    @Override
    public void cancelEditing() {
        this.myResultView.cancelEditing();
    }

    @Override
    public void editSelectedCell() {
        if (this.myResultView instanceof ResultViewWithCells) {
            ((ResultViewWithCells)((Object)this.myResultView)).editSelectedCell();
        }
    }

    @Override
    public boolean isViewModified() {
        for (DataConsumer.Column column : this.getDataModel().getColumns()) {
            boolean sortOrderChanged;
            boolean shouldBeShown = column == null || !DbImplUtil.isRowId(column);
            boolean shown = this.isColumnEnabled(column);
            boolean bl = sortOrderChanged = this.getSortOrder(column) != 0;
            if (shown == shouldBeShown && !sortOrderChanged) continue;
            return true;
        }
        return this.myResultView.isViewModified();
    }

    public int getVisibleColumnCount() {
        return this.myResultView.getViewColumnCount();
    }

    private void showError(@NotNull Throwable error2, @Nullable DataGridRequestSource source) {
        if (error2 == null) {
            TableResultPanel.$$$reportNull$$$0(43);
        }
        this.hideErrorPanel();
        ErrorNotificationPanel.Builder builder = ErrorNotificationPanel.create(null, error2, (JComponent)((Object)this.myMainPanel));
        if (source != null && source.getRows().size() == 1) {
            ModelIndex modelRowIdx = (ModelIndex)source.getRows().first();
            ModelIndex modelColumnIdx = (ModelIndex)source.getColumns().first();
            ViewIndex viewRowIdx = modelRowIdx.toView(this);
            ViewIndex viewColumnIdx = modelColumnIdx.toView(this);
            int r = viewRowIdx.asInteger() + 1;
            int c2 = viewColumnIdx.asInteger() + 1;
            String title = "[row:" + r + (c2 < 1 ? "" : " col:" + c2) + "]";
            builder.addLink("navigate", title, () -> {
                if (viewRowIdx.isValid(this) && viewColumnIdx.isValid(this)) {
                    this.scrollToLocally(viewRowIdx, viewColumnIdx);
                }
            });
        }
        this.myErrorNotificationPanel = builder.addDetailsButton().addCloseButton(this::hideErrorPanel).build();
        this.myMainPanel.setBottomComponent(this.myErrorNotificationPanel);
        this.myErrorNotificationPanel.revalidate();
        this.myMainPanel.repaint();
    }

    private void hideErrorPanel() {
        if (this.myErrorNotificationPanel == null) {
            return;
        }
        this.myMainPanel.setBottomComponent(null);
        this.myErrorNotificationPanel = null;
        this.myMainPanel.revalidate();
        this.myMainPanel.repaint();
    }

    private void handleError(@NotNull GridRequestSource<DataConsumer.Row, DataConsumer.Column> requestSource, @NotNull Throwable error2) {
        if (requestSource == null) {
            TableResultPanel.$$$reportNull$$$0(44);
        }
        if (error2 == null) {
            TableResultPanel.$$$reportNull$$$0(45);
        }
        Object source = requestSource.source;
        DbUIUtil.invokeLater(() -> {
            if (source == this.myFilterPanel) {
                this.myFilterPanel.onError(error2);
                return;
            }
            this.showError(error2, (DataGridRequestSource)((Object)((Object)ObjectUtils.tryCast((Object)source, DataGridRequestSource.class))));
        });
    }

    @Nullable
    protected Object getData(@NonNls @NotNull String dataId) {
        if (dataId == null) {
            TableResultPanel.$$$reportNull$$$0(46);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return new GridCopyProvider(this);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return new DeleteRowsAction();
        }
        if (DatabaseDataKeys.DATA_GRID_KEY.is(dataId)) {
            return this;
        }
        if (Session.SESSION_KEY.is(dataId) && this.myDataHookUp instanceof SessionClient) {
            return ((SessionClient)((Object)this.myDataHookUp)).getSession();
        }
        if (SessionClientHolder.CLIENT_KEY.is(dataId) && this.myDataHookUp instanceof SessionClient) {
            return this.myDataHookUp;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return this.getPsiElementForSelection();
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            return ContainerUtil.ar((Object[])new PsiElement[]{this.getPsiElementForSelection()});
        }
        if (LangDataKeys.NO_NEW_ACTION.is(dataId)) {
            return Boolean.TRUE;
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return new GridPasteProvider(this);
        }
        return null;
    }

    private PsiElement getPsiElementForSelection() {
        SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel = this.getSelectionModel();
        if (selectionModel.isSelectionEmpty()) {
            return DataGridPomTarget.wrapDataGrid(this.myProject, this);
        }
        return DataGridPomTarget.wrapCell(this.myProject, this, selectionModel.getSelectedRows(), selectionModel.getSelectedColumns());
    }

    @Override
    public void sortColumns(@NotNull List<ModelIndex<DataConsumer.Column>> columns, @NotNull RowSortOrder.Type order) {
        if (columns == null) {
            TableResultPanel.$$$reportNull$$$0(47);
        }
        if (order == null) {
            TableResultPanel.$$$reportNull$$$0(48);
        }
        boolean updated = false;
        for (ModelIndex<DataConsumer.Column> column : columns) {
            updated |= this.changeSortOrder(column, order, true);
        }
        if (updated) {
            this.updateSortKeysFromColumnAttributes();
            this.updateDataOrderingIfNeeded();
        }
    }

    @Override
    @NotNull
    public Language getContentLanguage(@NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        DataConsumer.Column column;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(49);
        }
        Language language = (column = this.getDataModel().getColumn(columnIdx)) != null ? this.getContentLanguage(column) : Language.ANY;
        if (language == null) {
            TableResultPanel.$$$reportNull$$$0(50);
        }
        return language;
    }

    @NotNull
    Language getContentLanguage(@NotNull DataConsumer.Column column) {
        Language fromAttributes;
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(51);
        }
        if ((fromAttributes = this.myColumnAttributes.getContentLanguage(column)) == null) {
            Language language = this.getInitialContentLanguage(column);
            if (language == null) {
                TableResultPanel.$$$reportNull$$$0(52);
            }
            return language;
        }
        if (fromAttributes != Language.ANY) {
            Language language = fromAttributes;
            if (language == null) {
                TableResultPanel.$$$reportNull$$$0(53);
            }
            return language;
        }
        Dbms dbms = DataGridUtil.getDbms(this);
        if (ObjectFormatter.isJson(column, dbms)) {
            return TableResultPanel.getLanguageByIdOrAny(JSON_LANGUAGE_ID);
        }
        if (dbms.isTransactSql() && StringUtil.equalsIgnoreCase((CharSequence)"xml", (CharSequence)column.typeName)) {
            return TableResultPanel.getLanguageByIdOrAny(XML_LANGUAGE_ID);
        }
        if (column.type == 2009) {
            return TableResultPanel.getLanguageByIdOrAny(XML_LANGUAGE_ID);
        }
        Language language = Language.ANY;
        if (language == null) {
            TableResultPanel.$$$reportNull$$$0(54);
        }
        return language;
    }

    public boolean isRowFilteredOut(@NotNull ModelIndex<?> rowIdx) {
        if (rowIdx == null) {
            TableResultPanel.$$$reportNull$$$0(55);
        }
        return false;
    }

    @Override
    @NotNull
    public DataExtractorFactory.Text getExtractorFactory() {
        DataExtractorFactory.Text text2 = this.myExtractorFactory;
        if (text2 == null) {
            TableResultPanel.$$$reportNull$$$0(56);
        }
        return text2;
    }

    @Override
    public void setExtractorFactory(@NotNull DataExtractorFactory.Text extractorFactory) {
        if (extractorFactory == null) {
            TableResultPanel.$$$reportNull$$$0(57);
        }
        this.myExtractorFactory = extractorFactory;
        this.myResultView.extractorFactoryChanged();
    }

    @NotNull
    private static Language getLanguageByIdOrAny(@NotNull String languageId) {
        if (languageId == null) {
            TableResultPanel.$$$reportNull$$$0(58);
        }
        Language language = (Language)ObjectUtils.notNull((Object)Language.findLanguageByID((String)languageId), (Object)Language.ANY);
        if (language == null) {
            TableResultPanel.$$$reportNull$$$0(59);
        }
        return language;
    }

    @Override
    public void setContentLanguage(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @NotNull Language language) {
        DataConsumer.Column column;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(60);
        }
        if (language == null) {
            TableResultPanel.$$$reportNull$$$0(61);
        }
        if ((column = this.getDataModel().getColumn(columnIdx)) != null) {
            this.myColumnAttributes.setContentLanguage(column, language);
            this.myResultView.contentLanguageUpdated(columnIdx, language);
        }
    }

    @Override
    @NotNull
    public ModelIndex<DataConsumer.Column> getContextColumn() {
        ModelIndex<DataConsumer.Column> modelIndex = this.myResultView.getContextColumn();
        if (modelIndex == null) {
            TableResultPanel.$$$reportNull$$$0(62);
        }
        return modelIndex;
    }

    @Override
    public void setFilterText(String filter2, int caretPosition) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.isFilteringEnabled() && !StringUtil.isEmptyOrSpaces((String)filter2)) {
            this.toggleFiltering();
        }
        this.myFilterPanel.setFilterText(filter2, caretPosition);
    }

    @NotNull
    public String getFilterText() {
        String string = this.myFilterPanel.getFilterText();
        if (string == null) {
            TableResultPanel.$$$reportNull$$$0(63);
        }
        return string;
    }

    @Override
    public void applyFilter() {
        GridFilteringModel model = this.myDataHookUp.getFilteringModel();
        if (model != null && this.isSafeToReload()) {
            this.myDataHookUp.getLoader().applyFilter(GridRequestSource.create(this, (Object)this.myFilterPanel));
        }
    }

    @Override
    public boolean isReady() {
        return !this.getDataModel().isUpdatingNow();
    }

    @Override
    public boolean isEmpty() {
        return this.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRowCount() == 0;
    }

    public void dispose() {
        if (this.myResultView != null) {
            Disposer.dispose((Disposable)this.myResultView);
        }
    }

    @Override
    public void showCell(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (row == null) {
            TableResultPanel.$$$reportNull$$$0(64);
        }
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(65);
        }
        DbUIUtil.invokeLaterIfNeeded(() -> {
            int rawRowIndex = row.asInteger() + 1;
            this.scrollTo(rawRowIndex, column);
        });
    }

    private void scrollTo(int dataRowIndex, ModelIndex<DataConsumer.Column> columnIdx) {
        GridPagingModel<DataConsumer.Row, DataConsumer.Column> pageModel = this.myDataHookUp.getPageModel();
        Runnable localScrollRunnable = () -> {
            ModelIndex rowIdx = pageModel.findRow(dataRowIndex);
            Pair<Integer, Integer> rowAndColumn = this.getRawIndexConverter().rowAndColumn2View().fun(rowIdx.asInteger(), columnIdx.asInteger());
            ViewIndex<DataConsumer.Row> row = ViewIndex.forRow(this, (Integer)rowAndColumn.first);
            ViewIndex<DataConsumer.Column> column = ViewIndex.forColumn(this, (Integer)rowAndColumn.second);
            this.scrollToLocally(row, column);
        };
        if (pageModel.findRow(dataRowIndex).isValid(this)) {
            localScrollRunnable.run();
        } else {
            GridLoader<DataConsumer.Row, DataConsumer.Column> loader = this.myDataHookUp.getLoader();
            int offset = Math.max(0, dataRowIndex - pageModel.getPageSize() / 2);
            loader.load(GridRequestSource.create(this, new DataGridRequestSource(this).doWhenDone(localScrollRunnable)), offset);
        }
    }

    private void scrollToLocally(ViewIndex<DataConsumer.Row> row) {
        this.getSelectionModel().setRowSelection(row.toModel(this), true);
    }

    private void scrollToLocally(ViewIndex<DataConsumer.Row> row, ViewIndex<DataConsumer.Column> column) {
        Pair<Integer, Integer> rowAndColumn = this.getRawIndexConverter().rowAndColumn2Model().fun(row.asInteger(), column.asInteger());
        this.getSelectionModel().setSelection(ModelIndex.forRow(this, (int)((Integer)rowAndColumn.first)), ModelIndex.forColumn(this, (int)((Integer)rowAndColumn.second)));
    }

    @Override
    public boolean isFilteringSupported() {
        return this.getDataHookup().getFilteringModel() != null;
    }

    @Override
    public boolean isFilteringEnabled() {
        return this.myFilterPanel.isVisible();
    }

    @Override
    public boolean toggleFiltering() {
        boolean enabled = !this.isFilteringEnabled();
        this.myFilterPanel.setVisible(enabled);
        if (enabled) {
            this.myFilterPanel.requestFocusInWindow();
        }
        return enabled;
    }

    @Override
    public void resetLayout() {
        this.myResultView.resetLayout();
    }

    public void fireContentChanged() {
        Component rowHeader;
        JViewport header = this.myMainResultViewComponent instanceof JScrollPane ? ((JScrollPane)this.myMainResultViewComponent).getRowHeader() : null;
        Component component = rowHeader = header == null ? null : header.getView();
        if (rowHeader instanceof TableResultRowHeader) {
            ((TableResultRowHeader)rowHeader).updatePreferredSize();
            rowHeader.revalidate();
            rowHeader.repaint();
        }
        ((DataGridListener)this.myEventDispatcher.getMulticaster()).onContentChanged(this);
    }

    protected boolean isInitiallyDisabled(@NotNull DataConsumer.Column column) {
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(66);
        }
        return DbImplUtil.isRowId(column);
    }

    protected Language getInitialContentLanguage(@NotNull DataConsumer.Column column) {
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(67);
        }
        return Language.ANY;
    }

    protected int getInitialPosition(@NotNull DataConsumer.Column column) {
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(68);
        }
        return -1;
    }

    private Formatter getDateFormat(@NotNull DataConsumer.Column column) {
        boolean isPostgresRange;
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(69);
        }
        int jdbcType = ExtractorsUtil.guessJdbcType(column);
        ObjectFormatter converter = this.getObjectFormatter();
        Dbms dbms = DataGridUtil.getDbms(this);
        boolean bl = isPostgresRange = dbms.isPostgres() && StringUtil.findIgnoreCase((String)column.typeName, (String[])new String[]{"tstzrange", "tsrange"});
        if (isPostgresRange) {
            return RangeFormatResolver.resolveFormatter(converter, column, dbms);
        }
        if (DbImplUtil.isZonedTimestampColumn(column, dbms)) {
            return converter.getZonedTimestampFormat(column, dbms);
        }
        if (DbImplUtil.isZonedTimeColumn(column, dbms)) {
            return converter.getZonedTimeFormat(column, dbms);
        }
        return jdbcType == 91 ? converter.getDateFormat(column, dbms) : (jdbcType == 92 ? converter.getTimeFormat() : (jdbcType == 93 ? converter.getTimestampFormat(column, dbms) : null));
    }

    public void setValueAt(@NotNull ViewIndexSet<DataConsumer.Row> viewRows, @NotNull ViewIndexSet<DataConsumer.Column> viewColumns, @Nullable Object value2) {
        if (viewRows == null) {
            TableResultPanel.$$$reportNull$$$0(70);
        }
        if (viewColumns == null) {
            TableResultPanel.$$$reportNull$$$0(71);
        }
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.getDataHookup().getMutator();
        int[] validRows = this.valid(viewRows);
        int[] validColumns = this.valid(viewColumns);
        ModelIndexSet<DataConsumer.Row> rows = validRows.length > 0 ? ViewIndexSet.forRows(this, validRows).toModel(this) : null;
        ModelIndexSet<DataConsumer.Column> columns = validRows.length > 0 ? ViewIndexSet.forColumns(this, validColumns).toModel(this) : null;
        Runnable moveToNextCellRunnable = this.newMoveToNextCellRunnable((ViewIndex)viewRows.last(), (ViewIndex)viewColumns.last());
        if (mutator == null || rows == null || this.getMutationModel().allValuesEqualTo(rows, columns, value2)) {
            DbUIUtil.invokeLater(moveToNextCellRunnable);
            return;
        }
        ModelIndexSet<DataConsumer.Row> rowsIdxs = viewRows.toModel(this);
        ModelIndexSet<DataConsumer.Column> columnsIdxs = viewColumns.toModel(this);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (mutator.isUpdateImmediately()) {
                this.setValueImmediately(rowsIdxs, columnsIdxs, moveToNextCellRunnable, mutator, value2);
                return;
            }
            DataGridRequestSource requestSource = new DataGridRequestSource(rows, columns);
            requestSource.doWhenDone(moveToNextCellRunnable);
            mutator.mutate(GridRequestSource.create(this, (Object)requestSource), rowsIdxs, columnsIdxs, value2);
        });
    }

    private void setValueImmediately(@NotNull ModelIndexSet<DataConsumer.Row> rowsIdxs, @NotNull ModelIndexSet<DataConsumer.Column> columnsIdxs, @NotNull Runnable moveToNextCellRunnable, @NotNull GridMutator<DataConsumer.Row, DataConsumer.Column> mutator, @Nullable Object value2) {
        if (rowsIdxs == null) {
            TableResultPanel.$$$reportNull$$$0(72);
        }
        if (columnsIdxs == null) {
            TableResultPanel.$$$reportNull$$$0(73);
        }
        if (moveToNextCellRunnable == null) {
            TableResultPanel.$$$reportNull$$$0(74);
        }
        if (mutator == null) {
            TableResultPanel.$$$reportNull$$$0(75);
        }
        List<CellMutation> mutations = this.toCellMutations(rowsIdxs, columnsIdxs, value2);
        ModelIndexSet<DataConsumer.Row> filteredRows = TableResultPanel.getIndices(mutations, rowArray -> ModelIndexSet.forRows(this, rowArray), Mutation::getRow);
        ModelIndexSet<DataConsumer.Column> filteredCols = TableResultPanel.getIndices(mutations, colArray -> ModelIndexSet.forColumns(this, colArray), CellMutation::getColumn);
        DataGridRequestSource requestSource = new DataGridRequestSource(filteredRows, filteredCols);
        requestSource.doWhenDone(moveToNextCellRunnable);
        mutator.mutate(GridRequestSource.create(this, (Object)requestSource), mutations);
    }

    @NotNull
    private List<CellMutation> toCellMutations(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, @Nullable Object value2) {
        if (rows == null) {
            TableResultPanel.$$$reportNull$$$0(76);
        }
        if (columns == null) {
            TableResultPanel.$$$reportNull$$$0(77);
        }
        ArrayList<CellMutation> mutations = new ArrayList<CellMutation>();
        GridMutationModel model = this.getMutationModel();
        for (ModelIndex row : rows.asIterable()) {
            for (ModelIndex column : columns.asIterable()) {
                int rowIdx = row.asInteger();
                int colIdx = column.asInteger();
                if (model.allValuesEqualTo(ModelIndexSet.forRows(this, rowIdx), ModelIndexSet.forColumns(this, colIdx), value2)) continue;
                mutations.add(new CellMutation(row, column, this.isInsertedRow(row) ? MutationType.INSERT : MutationType.MODIFY, value2));
            }
        }
        ArrayList<CellMutation> arrayList = mutations;
        if (arrayList == null) {
            TableResultPanel.$$$reportNull$$$0(78);
        }
        return arrayList;
    }

    @NotNull
    private static <T> ModelIndexSet<T> getIndices(@NotNull List<CellMutation> mutations, @NotNull Function<int[], ModelIndexSet<T>> setCreator, @NotNull Function<CellMutation, ModelIndex<T>> indexSupplier) {
        if (mutations == null) {
            TableResultPanel.$$$reportNull$$$0(79);
        }
        if (setCreator == null) {
            TableResultPanel.$$$reportNull$$$0(80);
        }
        if (indexSupplier == null) {
            TableResultPanel.$$$reportNull$$$0(81);
        }
        int[] values2 = mutations.stream().map(indexSupplier).mapToInt(Index::asInteger).distinct().toArray();
        ModelIndexSet<T> modelIndexSet = setCreator.apply(values2);
        if (modelIndexSet == null) {
            TableResultPanel.$$$reportNull$$$0(82);
        }
        return modelIndexSet;
    }

    private <T> int[] valid(ViewIndexSet<T> set) {
        return set.asList().stream().filter(idx -> idx.isValid(this)).mapToInt(Index::asInteger).toArray();
    }

    private Runnable newMoveToNextCellRunnable(ViewIndex<DataConsumer.Row> row, ViewIndex<DataConsumer.Column> col) {
        return () -> IdeFocusManager.findInstanceByComponent((Component)this.myResultView.getComponent()).doWhenFocusSettlesDown(() -> this.moveToNextCell(row, col));
    }

    private void moveToNextCell(@NotNull ViewIndex<DataConsumer.Row> rowIndex, @NotNull ViewIndex<DataConsumer.Column> colIndex) {
        SelectionModel<DataConsumer.Row, DataConsumer.Column> selectionModel;
        if (rowIndex == null) {
            TableResultPanel.$$$reportNull$$$0(83);
        }
        if (colIndex == null) {
            TableResultPanel.$$$reportNull$$$0(84);
        }
        if ((selectionModel = this.getSelectionModel()).getSelectedRowCount() != 1 || selectionModel.getSelectedColumnCount() != 1 || !ApplicationManager.getApplication().isUnitTestMode() && (!UIUtil.isFocusAncestor((Component)this.myResultView.getComponent()) || this.isEditing())) {
            return;
        }
        if (!Comparing.equal(selectionModel.getSelectedRow(), rowIndex.toModel(this)) || !Comparing.equal(selectionModel.getSelectedColumn(), colIndex.toModel(this))) {
            return;
        }
        if (this.isInsertedRow(rowIndex.toModel(this))) {
            ViewIndex<DataConsumer.Column> nextColumn = ViewIndex.forColumn(this, colIndex.asInteger() + 1);
            colIndex = nextColumn.isValid(this) ? nextColumn : colIndex;
        } else {
            ViewIndex<DataConsumer.Row> nextRow = ViewIndex.forRow(this, rowIndex.asInteger() + 1);
            rowIndex = nextRow.isValid(this) ? nextRow : rowIndex;
        }
        this.scrollToLocally(rowIndex, colIndex);
    }

    public boolean isHeaderSelecting() {
        return false;
    }

    private void updateColumnAttributes() {
        if (!this.isSortViaOrderBy()) {
            return;
        }
        this.myColumnAttributes.resetOrdering();
        for (RowSortOrder<ModelIndex<DataConsumer.Column>> order : this.getOrderingFromModel()) {
            this.changeSortOrder(order.getColumn(), order.getOrder(), true);
        }
    }

    @NotNull
    private List<RowSortOrder<ModelIndex<DataConsumer.Column>>> getOrderingFromModel() {
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        List<RowSortOrder<ModelIndex<DataConsumer.Column>>> list = sortingModel != null ? sortingModel.getOrdering() : ContainerUtil.emptyList();
        if (list == null) {
            TableResultPanel.$$$reportNull$$$0(85);
        }
        return list;
    }

    public void updateSortKeysFromColumnAttributes() {
        this.myResultView.updateSortKeysFromColumnAttributes();
        this.fireContentChanged();
    }

    public boolean changeSortOrder(@NotNull ModelIndex<DataConsumer.Column> columnIdx, @Nullable RowSortOrder.Type targetSortOrder, boolean silent) {
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(86);
        }
        boolean updated = false;
        DataConsumer.Column column = this.getDataModel().getColumn(columnIdx);
        if (column != null) {
            updated = this.myColumnAttributes.changeSortOrder(column, targetSortOrder);
        }
        if (!silent && updated) {
            this.updateSortKeysFromColumnAttributes();
            this.updateDataOrderingIfNeeded();
        }
        return updated;
    }

    private void updateDataOrderingIfNeeded() {
        if (this.isSortViaOrderBy()) {
            this.updateDataOrdering(true);
        }
    }

    private boolean updateDataOrdering(boolean reloadIfUpdated) {
        List newOrdering;
        GridSortingModel<DataConsumer.Row, DataConsumer.Column> sortingModel = this.myDataHookUp.getSortingModel();
        if (sortingModel == null) {
            return false;
        }
        List<RowSortOrder<ModelIndex<DataConsumer.Column>>> oldOrdering = this.getOrderingFromModel();
        if (TableResultPanel.isSameOrdering(oldOrdering, newOrdering = this.createOrdering())) {
            return false;
        }
        if (reloadIfUpdated && !this.isSafeToReload()) {
            return false;
        }
        sortingModel.setOrdering(newOrdering);
        if (reloadIfUpdated) {
            this.myDataHookUp.getLoader().loadFirstPage(GridRequestSource.create(this, null));
        }
        return true;
    }

    @NotNull
    private List<RowSortOrder<ModelIndex<DataConsumer.Column>>> createOrdering() {
        TreeMap<Integer, DataConsumer.Column> sortOrderMap = this.getSortOrderMap();
        ArrayList<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering = new ArrayList<RowSortOrder<ModelIndex<DataConsumer.Column>>>(sortOrderMap.size());
        for (DataConsumer.Column column : sortOrderMap.values()) {
            ModelIndex<DataConsumer.Column> columnIdx = ModelIndex.forColumn(this, column.columnNum);
            ordering.add(this.getSortOrder(column) < 0 ? RowSortOrder.asc(columnIdx) : RowSortOrder.desc(columnIdx));
        }
        ArrayList<RowSortOrder<ModelIndex<DataConsumer.Column>>> arrayList = ordering;
        if (arrayList == null) {
            TableResultPanel.$$$reportNull$$$0(87);
        }
        return arrayList;
    }

    private static boolean isSameOrdering(@NotNull List<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering1, @NotNull List<RowSortOrder<ModelIndex<DataConsumer.Column>>> ordering2) {
        if (ordering1 == null) {
            TableResultPanel.$$$reportNull$$$0(88);
        }
        if (ordering2 == null) {
            TableResultPanel.$$$reportNull$$$0(89);
        }
        if (ordering1.size() != ordering2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < ordering1.size(); ++i2) {
            RowSortOrder<ModelIndex<DataConsumer.Column>> o1 = ordering1.get(i2);
            RowSortOrder<ModelIndex<DataConsumer.Column>> o2 = ordering2.get(i2);
            if (Comparing.equal((Object)((Object)o1.getOrder()), (Object)((Object)o2.getOrder())) && Comparing.equal(o1.getColumn(), o2.getColumn())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isColumnEnabled(@NotNull ModelIndex<DataConsumer.Column> columnIndex) {
        if (columnIndex == null) {
            TableResultPanel.$$$reportNull$$$0(90);
        }
        if (!columnIndex.isValid(this)) {
            return false;
        }
        return this.isColumnEnabled(this.getDataModel().getColumn(columnIndex));
    }

    public boolean isColumnEnabled(@Nullable DataConsumer.Column column) {
        if (column == null) {
            return false;
        }
        Boolean enabled = this.myColumnAttributes.isEnabled(column);
        return enabled != null ? enabled : !this.isInitiallyDisabled(column);
    }

    @Override
    public void setColumnEnabled(@NotNull ModelIndex<DataConsumer.Column> columnIdx, boolean state) {
        DataConsumer.Column column;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(91);
        }
        if ((column = this.getDataModel().getColumn(columnIdx)) == null || this.isColumnEnabled(column) == state) {
            return;
        }
        this.myColumnAttributes.setEnabled(column, state);
        GridSelection<DataConsumer.Row, DataConsumer.Column> selection = this.getSelectionModel().store();
        this.storeOrRestoreSelection(columnIdx, state, selection);
        this.myResultView.setColumnEnabled(columnIdx, state);
        this.fireContentChanged();
        this.runWithIgnoreSelectionChanges(() -> this.getSelectionModel().restore(selection));
    }

    @Override
    public void setRowEnabled(@NotNull ModelIndex<DataConsumer.Row> rowIdx, boolean state) {
        if (rowIdx == null) {
            TableResultPanel.$$$reportNull$$$0(92);
        }
        this.myResultView.setRowEnabled(rowIdx, state);
    }

    public void storeOrRestoreSelection(@NotNull ModelIndex<DataConsumer.Column> columnIdx, boolean state, @NotNull GridSelection<DataConsumer.Row, DataConsumer.Column> selection) {
        boolean selected;
        if (columnIdx == null) {
            TableResultPanel.$$$reportNull$$$0(93);
        }
        if (selection == null) {
            TableResultPanel.$$$reportNull$$$0(94);
        }
        int modelIndex = columnIdx.asInteger();
        if (state && this.myHiddenColumnSelectionHolder.contains(modelIndex)) {
            selection.addSelectedColumns(this, ModelIndexSet.forColumns(this, columnIdx.value));
            this.myHiddenColumnSelectionHolder.columnShown(modelIndex);
        } else if (!state && (selected = this.getSelectionModel().isSelectedColumn(columnIdx))) {
            this.myHiddenColumnSelectionHolder.columnHidden(modelIndex);
        }
    }

    @Override
    public void setPresentationMode(@NotNull GridPresentationMode presentationMode) {
        boolean requestFocusInSearchField;
        if (presentationMode == null) {
            TableResultPanel.$$$reportNull$$$0(95);
        }
        if (this.myPresentationMode == presentationMode) {
            return;
        }
        GridSelection<DataConsumer.Row, DataConsumer.Column> selection = this.getSelectionModel().store();
        GridScrollPositionManager.GridScrollPosition scrollPosition = GridScrollPositionManager.get(this.myResultView, this).store();
        this.myPresentationMode = presentationMode;
        ResultViewFactory newFactory = ResultViewFactory.of(presentationMode);
        boolean bl = requestFocusInSearchField = this.mySearchSession != null && IdeFocusManager.getInstance((Project)this.getProject()).getFocusOwner() == this.mySearchSession.getComponent().getSearchTextComponent();
        if (this.myViewFactory != newFactory) {
            boolean wasTransposed = this.myResultView.isTransposed();
            this.myViewFactory = newFactory;
            this.myLayeredPane.remove(this.myMainResultViewComponent);
            Disposer.dispose((Disposable)this.myResultView);
            this.createResultView();
            this.myResultView.setTransposed(wasTransposed);
            this.fireDataEvents();
            if (this.mySearchSession != null) {
                FindModel findModel = this.mySearchSession.getFindModel();
                this.mySearchSession.close();
                this.mySearchSession = this.myResultView.createSearchSession(findModel);
            }
        }
        this.myMainPanel.revalidate();
        this.myMainPanel.repaint();
        if (!DatabaseStartupActivity.DataEditorConfigurator.isLoadingDelayed(this)) {
            IdeFocusManager.getInstance((Project)this.getProject()).doWhenFocusSettlesDown(() -> IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)(requestFocusInSearchField ? this.mySearchSession.getComponent().getSearchTextComponent() : this.getPreferredFocusedComponent()), true));
        }
        DbUIUtil.invokeLater(() -> {
            this.getSelectionModel().restore(selection);
            GridScrollPositionManager.get(this.myResultView, this).restore(scrollPosition);
        });
    }

    @Override
    @NotNull
    public GridPresentationMode getPresentationMode() {
        GridPresentationMode gridPresentationMode = this.myPresentationMode;
        if (gridPresentationMode == null) {
            TableResultPanel.$$$reportNull$$$0(96);
        }
        return gridPresentationMode;
    }

    public void runWithIgnoreSelectionChanges(Runnable runnable) {
        try {
            this.myHiddenColumnSelectionHolder.startAdjusting();
            runnable.run();
        }
        finally {
            this.myHiddenColumnSelectionHolder.endAdjusting();
        }
    }

    private boolean isSafeToReload() {
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator = this.myDataHookUp.getMutator();
        return mutator == null || !mutator.hasPendingChanges() || DataGridUtil.showIgnoreUnsubmittedChangesYesNoDialog(this);
    }

    public boolean isSafeToUpdate(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, @Nullable Object newValue) {
        GridMutator<DataConsumer.Row, DataConsumer.Column> mutator;
        if (rows == null) {
            TableResultPanel.$$$reportNull$$$0(97);
        }
        if (columns == null) {
            TableResultPanel.$$$reportNull$$$0(98);
        }
        return (mutator = this.myDataHookUp.getMutator()) == null || mutator.isUpdateSafe(rows, columns, newValue) || DataGridUtil.showIgnoreUnsubmittedChangesYesNoDialog(this);
    }

    @Override
    @NotNull
    public JPanel getFilterPanel() {
        GridFilterPanel gridFilterPanel = this.myFilterPanel;
        if (gridFilterPanel == null) {
            TableResultPanel.$$$reportNull$$$0(99);
        }
        return gridFilterPanel;
    }

    @Override
    public void resetFilters() {
        this.setFilterText("", -1);
        this.resetOrderingAndVisibility();
    }

    @Override
    public void resetView() {
        if (this.isSortViaOrderBy() && !this.isSafeToReload()) {
            return;
        }
        HiddenColumnsSelectionHolder copy = this.myHiddenColumnSelectionHolder.copy();
        this.myHiddenColumnSelectionHolder.reset();
        GridSelection<DataConsumer.Row, DataConsumer.Column> selection = this.getSelectionModel().store();
        this.resetOrderingAndVisibility();
        if (this.myResultView instanceof ResultViewWithRows) {
            ((ResultViewWithRows)((Object)this.myResultView)).resetRowHeights();
        }
        if (this.myResultView instanceof ResultViewWithColumns) {
            ((ResultViewWithColumns)((Object)this.myResultView)).createDefaultColumnsFromModel();
        }
        this.myResultView.resetLayout();
        int[] modelIndices = copy.selectedModelIndices(this);
        selection.addSelectedColumns(this, ModelIndexSet.forColumns(this, modelIndices));
        this.getSelectionModel().restore(selection);
        if (this.isSortViaOrderBy()) {
            this.myDataHookUp.getLoader().reloadCurrentPage(GridRequestSource.create(this, null));
        }
    }

    public void trueLayout() {
        Container parent2;
        Container container = parent2 = this.myResultView != null ? this.myResultView.getComponent().getParent() : null;
        if (parent2 == null) {
            return;
        }
        Dimension size = parent2.getSize();
        this.myResultView.getComponent().setPreferredSize(this.getDataModel().getColumnCount() == 0 ? size : null);
        this.myMainResultViewComponent.revalidate();
        this.myMainResultViewComponent.repaint(50L);
    }

    @Nullable
    private GridMutator.RowsMutator<DataConsumer.Row, DataConsumer.Column> getRowsMutator() {
        return (GridMutator.RowsMutator)ObjectUtils.tryCast(this.myDataHookUp.getMutator(), GridMutator.RowsMutator.class);
    }

    @Nullable
    private GridMutator.DatabaseMutator<DataConsumer.Row, DataConsumer.Column> getDatabaseMutator() {
        return (GridMutator.DatabaseMutator)ObjectUtils.tryCast(this.myDataHookUp.getMutator(), GridMutator.DatabaseMutator.class);
    }

    @Nullable
    private GridMutator<DataConsumer.Row, DataConsumer.Column> getMutator() {
        return this.myDataHookUp.getMutator();
    }

    private void resetOrderingAndVisibility() {
        this.myColumnAttributes.resetOrdering();
        this.myColumnAttributes.resetVisibility();
        this.updateSortKeysFromColumnAttributes();
        this.updateDataOrderingIfNeeded();
        this.myResultView.orderingAndVisibilityChanged();
    }

    @NotNull
    public String getColumnTooltipHtml(@Nullable DataConsumer.Column column) {
        if (column == null) {
            return "";
        }
        String type = DataGridUtil.getSqlType(this, column);
        String string = "<html><b>" + this.myColumnAttributes.getName(column) + "</b>" + (StringUtil.isNotEmpty((String)type) ? ": " + StringUtil.escapeXmlEntities((String)type) : "") + this.getDateFormatSuffix(column) + this.getColumnComment(column) + "</html>";
        if (string == null) {
            TableResultPanel.$$$reportNull$$$0(100);
        }
        return string;
    }

    @NotNull
    private String getDateFormatSuffix(@NotNull DataConsumer.Column column) {
        Formatter dateFormat;
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(101);
        }
        return (dateFormat = this.getDateFormat(column)) != null ? " (" + dateFormat + ") " : "";
    }

    @NotNull
    private String getColumnComment(@NotNull DataConsumer.Column column) {
        DasColumn dasColumn;
        String comment;
        if (column == null) {
            TableResultPanel.$$$reportNull$$$0(102);
        }
        String string = comment = (dasColumn = DataGridUtil.getDatabaseColumn((DataGrid)this, column)) == null ? null : dasColumn.getComment();
        if (StringUtil.isEmptyOrSpaces((String)comment)) {
            return "";
        }
        String string2 = "<br><pre>" + StringUtil.escapeXmlEntities((String)DbNodeDescriptor.adjustCommentString(comment)) + "</pre>";
        if (string2 == null) {
            TableResultPanel.$$$reportNull$$$0(103);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 59: 
            case 62: 
            case 63: 
            case 78: 
            case 82: 
            case 85: 
            case 87: 
            case 96: 
            case 99: 
            case 100: 
            case 103: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 59: 
            case 62: 
            case 63: 
            case 78: 
            case 82: 
            case 85: 
            case 87: 
            case 96: 
            case 99: 
            case 100: 
            case 103: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHookUp";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupActions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gutterPopupActions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnHeaderActions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowHeaderActions";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 59: 
            case 62: 
            case 63: 
            case 78: 
            case 82: 
            case 85: 
            case 87: 
            case 96: 
            case 99: 
            case 100: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/TableResultPanel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultView";
                break;
            }
            case 15: 
            case 17: 
            case 49: 
            case 60: 
            case 86: 
            case 91: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchSession";
                break;
            }
            case 21: 
            case 25: 
            case 76: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 22: 
            case 26: 
            case 47: 
            case 77: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowToClone";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnToClone";
                break;
            }
            case 29: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestSource";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 51: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 101: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 55: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractorFactory";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageId";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewRows";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewColumns";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowsIdxs";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnsIdxs";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveToNextCellRunnable";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutator";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setCreator";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexSupplier";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIndex";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colIndex";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering1";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering2";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIndex";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/TableResultPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentExtractorFactory";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowHeaderActions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultView";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortOrder";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "submit";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkupModel";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataModel";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataHookup";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawIndexConverter";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainResultViewComponent";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingPanel";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleColumns";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleRows";
                break;
            }
            case 50: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentLanguage";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractorFactory";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageByIdOrAny";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextColumn";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterText";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "toCellMutations";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndices";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderingFromModel";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrdering";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationMode";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterPanel";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnTooltipHtml";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 59: 
            case 62: 
            case 63: 
            case 78: 
            case 82: 
            case 85: 
            case 87: 
            case 96: 
            case 99: 
            case 100: 
            case 103: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRowHeader";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerEscapeAction";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSortOrder";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getThenBySortOrder";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "searchSessionStarted";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "searchSessionStopped";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setCells";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "cloneRow";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "cloneColumn";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "deleteRows";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "deleteColumns";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isInsertedRow";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getDataModel";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "handleError";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "sortColumns";
                break;
            }
            case 49: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getContentLanguage";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isRowFilteredOut";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "setExtractorFactory";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageByIdOrAny";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "setContentLanguage";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "showCell";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isInitiallyDisabled";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getInitialContentLanguage";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getInitialPosition";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getDateFormat";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "setValueAt";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "setValueImmediately";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "toCellMutations";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getIndices";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "moveToNextCell";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "changeSortOrder";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "isSameOrdering";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "isColumnEnabled";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "setColumnEnabled";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "setRowEnabled";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "storeOrRestoreSelection";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "setPresentationMode";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "isSafeToUpdate";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getDateFormatSuffix";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "getColumnComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 59: 
            case 62: 
            case 63: 
            case 78: 
            case 82: 
            case 85: 
            case 87: 
            case 96: 
            case 99: 
            case 100: 
            case 103: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LoadingMouseListener
    extends MouseAdapter {
        final Component myComponent;
        final TableResultPanel myGrid;

        LoadingMouseListener(@NotNull Component component, @NotNull TableResultPanel grid) {
            if (component == null) {
                LoadingMouseListener.$$$reportNull$$$0(0);
            }
            if (grid == null) {
                LoadingMouseListener.$$$reportNull$$$0(1);
            }
            this.myComponent = component;
            this.myGrid = grid;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (DatabaseStartupActivity.DataEditorConfigurator.isLoadingDelayed(this.myGrid)) {
                this.myGrid.getDataHookup().getLoader().reloadCurrentPage(GridRequestSource.create(this.myGrid, null));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (DatabaseStartupActivity.DataEditorConfigurator.isLoadingDelayed(this.myGrid)) {
                ResultView view2 = this.myGrid.myResultView;
                if (view2 != null) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)view2.getComponent(), true));
                }
            } else {
                this.myComponent.removeMouseListener(this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "grid";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ui/TableResultPanel$LoadingMouseListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyLoadDataPanel
    extends JPanel {
        final UIUtil.TextPainter myPainter;
        final TableResultPanel myGrid;

        MyLoadDataPanel(@NotNull TableResultPanel grid) {
            if (grid == null) {
                MyLoadDataPanel.$$$reportNull$$$0(0);
            }
            this.myPainter = EditorEmptyTextPainter.createTextPainter();
            this.myGrid = grid;
            this.setOpaque(true);
            this.myPainter.appendLine("Load Data <shortcut>" + KeymapUtil.getFirstKeyboardShortcutText((String)"Refresh") + "</shortcut>");
            this.addMouseListener(new LoadingMouseListener(this, grid));
        }

        @Override
        public Color getBackground() {
            return this.myGrid == null || this.myGrid.myResultView == null ? super.getBackground() : this.myGrid.myColorsScheme.getDefaultBackground();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            UISettings.setupAntialiasing((Graphics)g);
            this.myPainter.draw(g, (width, height) -> Couple.of((Object)((this.getWidth() - width) / 2), (Object)((this.getHeight() - height) / 2)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/TableResultPanel$MyLoadDataPanel", "<init>"));
        }
    }

    public static class ColumnAttributes {
        private final Map<DataConsumer.Column, Attributes> myAttributesMap = new HashMap<DataConsumer.Column, Attributes>();
        private List<String> myUnambiguousColumnNames = ContainerUtil.emptyList();

        @NotNull
        public String getName(DataConsumer.Column column) {
            String name = column.columnNum < this.myUnambiguousColumnNames.size() ? this.myUnambiguousColumnNames.get(column.columnNum) : column.name;
            return StringUtil.isNotEmpty((String)name) ? name : "<anonymous>";
        }

        @Nullable
        public Language getContentLanguage(DataConsumer.Column column) {
            Attributes attributes2 = this.myAttributesMap.get(column);
            return attributes2 == null ? null : attributes2.myContentLanguage;
        }

        public void setContentLanguage(DataConsumer.Column column, @NotNull Language language) {
            if (language == null) {
                ColumnAttributes.$$$reportNull$$$0(0);
            }
            this.myAttributesMap.get((Object)column).myContentLanguage = language;
        }

        @Nullable
        public Comparator<DataConsumer.Row> getComparator(DataConsumer.Column column) {
            Attributes attributes2 = this.myAttributesMap.get(column);
            return attributes2 == null ? null : attributes2.myComparator;
        }

        @Nullable
        private Boolean isEnabled(DataConsumer.Column column) {
            Attributes attributes2 = this.myAttributesMap.get(column);
            return attributes2 == null ? null : Boolean.valueOf(attributes2.myEnabled);
        }

        public void setEnabled(DataConsumer.Column column, boolean enabled) {
            this.myAttributesMap.get((Object)column).myEnabled = enabled;
        }

        public int getSortOrder(DataConsumer.Column column) {
            Attributes attributes2 = this.myAttributesMap.get(column);
            return attributes2 == null ? 0 : attributes2.mySortOrder;
        }

        public void resetOrdering() {
            for (Attributes attr : this.myAttributesMap.values()) {
                attr.mySortOrder = 0;
            }
        }

        public void resetVisibility() {
            for (DataConsumer.Column column : this.myAttributesMap.keySet()) {
                this.setEnabled(column, !DbImplUtil.isRowId(column));
            }
        }

        public boolean changeSortOrder(DataConsumer.Column targetColumn, @Nullable RowSortOrder.Type targetSortOrder) {
            if (this.getComparator(targetColumn) == null) {
                return false;
            }
            int prevOrder = this.getSortOrder(targetColumn);
            int maxOrder = 0;
            for (DataConsumer.Column column : this.myAttributesMap.keySet()) {
                if (Comparing.equal((Object)column, (Object)targetColumn)) continue;
                int order = this.getSortOrder(column);
                if (prevOrder != 0 && Math.abs(order) > Math.abs(prevOrder)) {
                    order = order > 0 ? order - 1 : order + 1;
                    this.setSortOrder(column, order);
                }
                maxOrder = Math.max(maxOrder, Math.abs(order));
            }
            int asc = -maxOrder - 1;
            int desc = maxOrder + 1;
            int newOrder = targetSortOrder == RowSortOrder.Type.ASC ? asc : (targetSortOrder == RowSortOrder.Type.DESC ? desc : (targetSortOrder == null ? (prevOrder == 0 ? asc : (prevOrder < 0 ? desc : 0)) : 0));
            this.setSortOrder(targetColumn, newOrder);
            return prevOrder != newOrder;
        }

        public TreeMap<Integer, DataConsumer.Column> getSortOrderMap() {
            TreeMap<Integer, DataConsumer.Column> sortOrderMap = new TreeMap<Integer, DataConsumer.Column>();
            for (DataConsumer.Column column : this.myAttributesMap.keySet()) {
                int sortOrder = this.getSortOrder(column);
                if (sortOrder == 0) continue;
                sortOrderMap.put(Math.abs(sortOrder), column);
            }
            return sortOrderMap;
        }

        private void updateColumnNames(TableResultPanel resultPanel) {
            DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(resultPanel);
            SqlTableType type = hookup != null ? hookup.getTableType() : null;
            this.myUnambiguousColumnNames = type == null ? ContainerUtil.emptyList() : DbSqlUtil.getUnambiguousColumnNames(resultPanel.getProject(), hookup.getDatabaseDialect(), type, null);
        }

        public void newColumns(TableResultPanel resultPanel, Collection<DataConsumer.Column> columnsToRetain) {
            this.updateColumnNames(resultPanel);
            this.myAttributesMap.keySet().retainAll(columnsToRetain);
            columnsToRetain.stream().filter(column -> !this.myAttributesMap.containsKey(column)).forEach(column -> this.myAttributesMap.put((DataConsumer.Column)column, ColumnAttributes.createAttributes(resultPanel, column)));
            this.updateSortOrders();
        }

        private void setSortOrder(DataConsumer.Column column, int sortOrder) {
            this.myAttributesMap.get((Object)column).mySortOrder = sortOrder;
        }

        private void updateSortOrders() {
            int order = 1;
            for (DataConsumer.Column column : this.getSortOrderMap().values()) {
                this.setSortOrder(column, (this.getSortOrder(column) < 0 ? -1 : 1) * order++);
            }
        }

        private static Attributes createAttributes(TableResultPanel resultPanel, DataConsumer.Column column) {
            Attributes attributes2 = new Attributes();
            attributes2.myComparator = GridRowComparator.create(column);
            attributes2.myEnabled = !resultPanel.isInitiallyDisabled(column);
            attributes2.myContentLanguage = resultPanel.getInitialContentLanguage(column);
            return attributes2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/database/run/ui/TableResultPanel$ColumnAttributes", "setContentLanguage"));
        }

        static final class Attributes {
            public Language myContentLanguage;
            public Comparator<DataConsumer.Row> myComparator;
            public boolean myEnabled;
            public int mySortOrder;

            Attributes() {
            }
        }
    }
}

