/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.audit;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseLogView;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.debugger.SqlDebugController;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.audit.SessionLogger;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ObjectUtils;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseSessionLogger
extends SessionLogger {
    public static final Key<Boolean> SILENT_REQUEST = Key.create((String)"SILENT_REQUEST");

    public DatabaseSessionLogger(@NotNull DatabaseLogView view2) {
        if (view2 == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(0);
        }
        super(view2);
    }

    @Override
    public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
        if (request == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(1);
        }
        if (producer == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(2);
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (!this.myView.getTarget().isValid()) {
                return;
            }
            ((DatabaseLogView)this.myView).ensureContentInitialized();
            this.myView.beforeExecution();
        }, (ModalityState)ModalityState.defaultModalityState());
        super.jobSubmitted(request, producer);
    }

    @Override
    protected boolean skipJob(@NotNull DataRequest request) {
        if (request == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(3);
        }
        return super.skipJob(request) || request instanceof SqlDebugController.AuxiliaryRequest || Boolean.TRUE.equals(SILENT_REQUEST.get((UserDataHolder)request)) || request instanceof DataRequest.Disconnect || !this.shouldShowView(request.owner) || request instanceof DataRequest.TxRequest || request instanceof DataRequest.SchemaSwitchRequest && !((DataRequest.SchemaSwitchRequest)request).forced || SessionsUtil.isInternalOwner(request.owner);
    }

    @Override
    @NotNull
    protected Pair<String, Throwable> getLogMessageAndThrowable(@Nullable String message2, @Nullable Throwable throwable) {
        Pair pair = throwable instanceof JdbcEngine.EngineWarningException ? Pair.create((Object)((JdbcEngine.EngineWarningException)throwable).getLogMessage(), null) : super.getLogMessageAndThrowable(message2, throwable);
        if (pair == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(4);
        }
        return pair;
    }

    @Override
    protected boolean shouldActivate(@NotNull DataRequest request) {
        ConsoleDataRequest cdr;
        DataRequest.Owner owner;
        if (request == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(5);
        }
        if ((owner = request.owner) instanceof JdbcConsole && ((JdbcConsole)owner).isNotebookMode() && (cdr = (ConsoleDataRequest)ObjectUtils.tryCast((Object)((Object)request), ConsoleDataRequest.class)) != null && cdr.resultType instanceof SqlTableType) {
            return false;
        }
        return DatabaseSessionLogger.getClient(owner).map(c2 -> c2.getShowOnActivity()).orElseGet(() -> super.shouldActivate(request));
    }

    @Override
    protected boolean shouldFocusOnError(@NotNull DataRequest.Context context) {
        if (context == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(6);
        }
        return DatabaseSessionLogger.getClient(context.request.owner).map(c2 -> c2.focusOnError(context)).orElseGet(() -> super.shouldFocusOnError(context));
    }

    @Override
    protected boolean shouldShowOnAttention(@NotNull DataRequest.Context context) {
        if (context == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(7);
        }
        return this.shouldShowView(context) && !Boolean.TRUE.equals(SILENT_REQUEST.get((UserDataHolder)context.request)) && DatabaseSessionLogger.getClient(context.request.owner).map(c2 -> c2.showOnAttention(context)).orElseGet(() -> super.shouldFocusOnError(context)) != false;
    }

    @Override
    protected void bringAttentionByNotification(@NotNull DataRequest.Context context) {
        if (context == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(8);
        }
        if (this.shouldShowView(context)) {
            super.bringAttentionByNotification(context);
        }
    }

    @NotNull
    private static Optional<VisibleDatabaseSessionClient> getClient(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(9);
        }
        Optional<Object> optional = Optional.ofNullable(ObjectUtils.tryCast((Object)owner, VisibleDatabaseSessionClient.class));
        if (optional == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(10);
        }
        return optional;
    }

    private boolean shouldShowView(@NotNull DataRequest.Context context) {
        if (context == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(11);
        }
        return this.shouldShowView(context.request.owner);
    }

    private boolean shouldShowView(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(12);
        }
        return this.getView().shouldActivateFor(owner);
    }

    @NotNull
    private DatabaseLogView<?> getView() {
        DatabaseLogView databaseLogView = (DatabaseLogView)this.myView;
        if (databaseLogView == null) {
            DatabaseSessionLogger.$$$reportNull$$$0(13);
        }
        return databaseLogView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 4: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/audit/DatabaseSessionLogger";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/audit/DatabaseSessionLogger";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogMessageAndThrowable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getClient";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "jobSubmitted";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "skipJob";
                break;
            }
            case 4: 
            case 10: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldActivate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldFocusOnError";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowOnAttention";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bringAttentionByNotification";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getClient";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowView";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

