/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.SingleFragmentText;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicModSourceAware
extends BasicSourceAware,
BasicModNamedElement {
    public static final BasicMetaProperty<Integer> SOURCE_TEXT_LENGTH = BasicMetaProperty.create("SourceTextLength", BasicMetaType.Types.INT, 0, BasicModSourceAware.class, true);

    public void setSourceTextLength(int var1);

    default public void setSourceText(@Nullable CompositeText sourceText) {
        BasicModel model = this.getModel();
        this.setSourceTextLength(sourceText != null ? sourceText.getLength() : 0);
        model.saveSourceText(this, sourceText);
    }

    @Override
    @Nullable
    default public CompositeText getSourceText() {
        int length = this.getSourceTextLength();
        if (length == 0) {
            return null;
        }
        BasicModel model = this.getModel();
        CompositeText compositeText = model.loadSourceText(this);
        if (compositeText == null) {
            String ersatz = String.format("-- The source text lost (family: %s, kind: %s, name:%s, source text length: %d)", model.getDbms().getName(), this.getKind().code(), this.getRealName(), length);
            return new SingleFragmentText(ersatz, CompositeText.Kind.COMMENT);
        }
        return compositeText;
    }

    default public void setInvalid(boolean invalid) {
    }

    default public void setErrors(@NotNull List<SourceError> errors) {
        if (errors == null) {
            BasicModSourceAware.$$$reportNull$$$0(0);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/database/model/basic/BasicModSourceAware", "setErrors"));
    }
}

