/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.csv;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.preview.TableCsvFormatPreview;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.dbimport.csv.CsvPreviewModel;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.component.DataPreviewComponent;
import com.intellij.database.dbimport.ui.csv.CsvTableEditorComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvPreviewComponent
extends DataPreviewComponent<CsvPreviewInfo> {
    private Disposable myPreviewDisposable;
    private final ImportAction.ImportEditorContext myContext;
    private final CsvPreviewModel myModel;
    private CsvFormat myFormat;
    private TableCsvFormatPreview myPreview;

    public CsvPreviewComponent(@NotNull ImportAction.ImportEditorContext context, @NotNull CsvPreviewModel model) {
        if (context == null) {
            CsvPreviewComponent.$$$reportNull$$$0(0);
        }
        if (model == null) {
            CsvPreviewComponent.$$$reportNull$$$0(1);
        }
        super(context.getBuilder());
        this.myContext = context;
        this.myModel = model;
    }

    @NotNull
    private TableCsvFormatPreview recreatePreview() {
        if (this.myPreviewDisposable != null) {
            Disposer.dispose((Disposable)this.myPreviewDisposable);
        }
        this.myPreviewDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)this.myContext.getDisposable(), (Disposable)this.myPreviewDisposable);
        return this.createPreview(this.myFormat);
    }

    @NotNull
    private TableCsvFormatPreview createPreview(@NotNull CsvFormat selectedFormat) {
        if (selectedFormat == null) {
            CsvPreviewComponent.$$$reportNull$$$0(2);
        }
        TableCsvFormatPreview preview = new TableCsvFormatPreview(this.myBuilder.getContext().getProject(), selectedFormat, this.myModel.getText(), this.myPreviewDisposable);
        preview.getGrid().getDataHookup().getLoader().loadFirstPage(GridRequestSource.create(preview.getGrid(), null));
        TableCsvFormatPreview tableCsvFormatPreview = preview;
        if (tableCsvFormatPreview == null) {
            CsvPreviewComponent.$$$reportNull$$$0(3);
        }
        return tableCsvFormatPreview;
    }

    @Override
    public void addListener(@NotNull GraphObservable.ObserverListener<?> listener2) {
        if (listener2 == null) {
            CsvPreviewComponent.$$$reportNull$$$0(4);
        }
    }

    @Override
    @NotNull
    public CompletionStage<DataGrid> notifyChanged(@Nullable CsvPreviewInfo object) {
        boolean isCharset = object instanceof CharsetInfo;
        boolean isFormat = object instanceof FormatInfo;
        if (!isFormat && !isCharset) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                CsvPreviewComponent.$$$reportNull$$$0(5);
            }
            return completableFuture;
        }
        if (isFormat) {
            return this.formatChanged(object);
        }
        this.myModel.setCharset(((CharsetInfo)object).myCharset);
        return this.resetGrid();
    }

    @NotNull
    private CompletionStage<DataGrid> formatChanged(@NotNull CsvPreviewInfo object) {
        if (object == null) {
            CsvPreviewComponent.$$$reportNull$$$0(6);
        }
        this.myFormat = object.getFormat();
        if (this.myPreview == null) {
            return this.resetGrid();
        }
        this.myPreview.setFormat(Objects.requireNonNull(this.myFormat));
        CompletableFuture<DataGrid> completableFuture = CompletableFuture.completedFuture(this.getGrid());
        if (completableFuture == null) {
            CsvPreviewComponent.$$$reportNull$$$0(7);
        }
        return completableFuture;
    }

    @NotNull
    private CompletableFuture<DataGrid> resetGrid() {
        this.myPreview = this.recreatePreview();
        DataGrid grid = this.myPreview.getGrid();
        this.setGrid(grid);
        CompletableFuture<DataGrid> completableFuture = CompletableFuture.completedFuture(grid);
        if (completableFuture == null) {
            CsvPreviewComponent.$$$reportNull$$$0(8);
        }
        return completableFuture;
    }

    @Override
    public boolean dependsOn(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            CsvPreviewComponent.$$$reportNull$$$0(9);
        }
        return observer instanceof CsvTableEditorComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFormat";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPreview";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyChanged";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "formatChanged";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resetGrid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPreview";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "formatChanged";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "dependsOn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FormatInfo
    extends CsvPreviewInfo {
        private final CsvFormat myFormat;

        public FormatInfo(@NotNull CsvFormat format) {
            if (format == null) {
                FormatInfo.$$$reportNull$$$0(0);
            }
            this.myFormat = format;
        }

        @Override
        @Nullable
        public CsvFormat getFormat() {
            return this.myFormat;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent$FormatInfo", "<init>"));
        }
    }

    public static class CharsetInfo
    extends CsvPreviewInfo {
        private final Charset myCharset;

        public CharsetInfo(@NotNull Charset charset) {
            if (charset == null) {
                CharsetInfo.$$$reportNull$$$0(0);
            }
            this.myCharset = charset;
        }

        @Override
        @Nullable
        public Charset getCharset() {
            return this.myCharset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/database/dbimport/ui/csv/CsvPreviewComponent$CharsetInfo", "<init>"));
        }
    }

    public static abstract class CsvPreviewInfo {
        @Nullable
        public Charset getCharset() {
            return null;
        }

        @Nullable
        public CsvFormat getFormat() {
            return null;
        }
    }
}

