/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.component;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.ImportColumnEditor;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TableEditorComponent<T>
implements ImportComponent<T, ImportDatabaseTableEditor<?>> {
    private static final String MAPPING_ERROR = "Columns are not mapped";
    private static final String EMPTY_TABLE = "Table is empty";
    private static final String EMPTY_NAME = "Name of the table is empty";
    private static final String TABLE_EXISTS = "Table with this name already exists";
    protected final ImportAction.ImportEditorContext myContext;
    private final JPanel myPanel;
    private ImportDatabaseTableEditor<?> myEditor;
    private EditorModelBase.Listener myPreviewUpdater;

    public TableEditorComponent(@NotNull ImportAction.ImportEditorContext context) {
        if (context == null) {
            TableEditorComponent.$$$reportNull$$$0(0);
        }
        this.myContext = context;
        this.myPanel = new JPanel(new BorderLayout());
    }

    @Nullable
    public ImportDatabaseTableEditor<?> getEditor() {
        return this.myEditor;
    }

    @NotNull
    protected final ImportDatabaseTableEditor<?> createEditor(@NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<DataConsumer.Row> rows) {
        if (descriptors == null) {
            TableEditorComponent.$$$reportNull$$$0(1);
        }
        String tableName = this.getTableName();
        String tableComment = this.getComment();
        DeTable table = this.myContext.getBuilder().getImportType().createTable(this.myContext, descriptors, rows);
        table.name = tableName;
        table.comment = (String)ObjectUtils.chooseNotNull((Object)tableComment, (Object)table.comment);
        ImportDatabaseTableEditor<?> editor = ImportUtil.createEditor(table, descriptors, this.myContext);
        if (this.myPreviewUpdater != null) {
            editor.addListener(this.myPreviewUpdater, editor);
        }
        ImportDatabaseTableEditor<?> importDatabaseTableEditor = editor;
        if (importDatabaseTableEditor == null) {
            TableEditorComponent.$$$reportNull$$$0(2);
        }
        return importDatabaseTableEditor;
    }

    protected final void setEditor(@NotNull ImportDatabaseTableEditor<?> editor) {
        DeTable table;
        if (editor == null) {
            TableEditorComponent.$$$reportNull$$$0(3);
        }
        if (this.myEditor != null && (table = this.myEditor.getTable()) != editor.getTable()) {
            DeObject parent2 = table.getParent();
            if (parent2 != null && parent2.lightChildren != null) {
                parent2.lightChildren.remove(table);
            } else {
                table.model.removeRoot(table);
            }
        }
        this.myEditor = editor;
        this.myPanel.removeAll();
        this.myPanel.add((Component)this.myEditor.getComponent(), "Center");
    }

    @Nullable
    private String getComment() {
        return this.myEditor != null ? this.myEditor.getTable().comment : (this.myContext.getBuilder().getImportType().isTableCreated() ? this.myContext.getElement().getComment() : null);
    }

    @NotNull
    private String getTableName() {
        String string = this.myEditor == null ? this.myContext.getTableName() : this.myEditor.getTable().name;
        if (string == null) {
            TableEditorComponent.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            TableEditorComponent.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @Override
    public void addListener(final @NotNull GraphObservable.ObserverListener<?> listener2) {
        if (listener2 == null) {
            TableEditorComponent.$$$reportNull$$$0(6);
        }
        this.myPreviewUpdater = new EditorModelBase.Listener(){

            @Override
            public void changed() {
                listener2.changed(TableEditorComponent.this, TableEditorComponent.this.myEditor);
            }
        };
        if (this.myEditor != null) {
            this.myEditor.addListener(this.myPreviewUpdater, this.myEditor);
        }
    }

    @Override
    public void build(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            TableEditorComponent.$$$reportNull$$$0(7);
        }
        LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> mapping = ((ImportColumnEditor)this.myEditor.getColumnsEditor()).getMapping();
        builder.mapping(mapping).consumer(this.myEditor.getTable()).consumers(new ArrayList<AutoValueDescriptor>(mapping.keySet()));
    }

    @Override
    public boolean isVisible(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            TableEditorComponent.$$$reportNull$$$0(8);
        }
        return builder.getMapping() == null || builder.getTable() == null;
    }

    @Override
    @Nullable
    public ValidationInfo validate() {
        if (this.myEditor == null) {
            return null;
        }
        JComponent editorComponent = this.myEditor.getPreferredFocusedComponent();
        TableEditorModel model = this.myEditor.getTableModel();
        if (model.getName().isEmpty()) {
            return new ValidationInfo(EMPTY_NAME, editorComponent);
        }
        if (this.myContext.isTableExists(this.myEditor.getTable().name)) {
            return new ValidationInfo(TABLE_EXISTS, editorComponent);
        }
        JComponent columnEditorComponent = this.myEditor.getColumnsEditor().getComponent();
        if (model.getColumnsCount() == 0) {
            return new ValidationInfo(EMPTY_TABLE, columnEditorComponent);
        }
        return this.checkMapping() ? null : new ValidationInfo(MAPPING_ERROR, columnEditorComponent);
    }

    private boolean checkMapping() {
        LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> mapping = this.myEditor == null ? null : ((ImportColumnEditor)this.myEditor.getColumnsEditor()).getMapping();
        return mapping == null || !this.myContext.getBuilder().getImportType().isTableCreated() || ContainerUtil.exists(mapping.values(), (Condition)Conditions.notNull());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ui/component/TableEditorComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ui/component/TableEditorComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setEditor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

