/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceSshPanel;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.model.DasDataSource;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.ssh.AuthFailSshTransportException;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.config.ConfigRepository;
import com.intellij.ssh.config.OpenSSHClientConfig;
import com.intellij.ssh.config.OpenSSHConfigService;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.util.ui.JBUI;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import javax.swing.border.Border;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseSshTunnelEstablisher {
    private static final Logger LOG = Logger.getInstance(DatabaseSshTunnelEstablisher.class);
    static Function<DataSourceSshPanel, Boolean> ourSshInterceptor = null;
    static final int DEF_PORT = 22;
    static final String DEF_KEY_FILE = "~/.ssh/id_rsa";
    private final Project myProject;
    private final LocalDataSource myDataSource;

    public static void setCredentialsInterceptor(Function<DataSourceSshPanel, Boolean> di) {
        ourSshInterceptor = di;
    }

    private DatabaseSshTunnelEstablisher(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myDataSource = dataSource2;
    }

    @Nullable
    public static Pair<SshSession, Integer> createTunnelSync(@NotNull Project project, @NotNull LocalDataSource dataSource2) throws SshTransportException {
        if (project == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(2);
        }
        if (dataSource2 == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(3);
        }
        try {
            return DatabaseSshTunnelEstablisher.createTunnel(project, dataSource2).toCompletableFuture().get();
        }
        catch (InterruptedException e) {
            throw new ProcessCanceledException();
        }
        catch (ExecutionException e) {
            if (AsyncUtil.isCancellation(e)) {
                throw new ProcessCanceledException();
            }
            Throwable ue = AsyncUtil.unwrap(e);
            if (ue instanceof SshTransportException) {
                throw (SshTransportException)ue;
            }
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)ue);
            return null;
        }
    }

    @NotNull
    public static CompletionStage<Pair<SshSession, Integer>> createTunnel(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(4);
        }
        if (dataSource2 == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(5);
        }
        CompletionStage<Pair<SshSession, Integer>> completionStage = new DatabaseSshTunnelEstablisher(project, dataSource2).createTunnel();
        if (completionStage == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(6);
        }
        return completionStage;
    }

    @NotNull
    public CompletionStage<Pair<SshSession, Integer>> createTunnel() {
        Pair.NonNull<String, String> hostPort;
        DataSourceSshTunnelConfiguration ssh = this.myDataSource.getSshConfiguration();
        if (ssh == null || !ssh.isEnabled()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                DatabaseSshTunnelEstablisher.$$$reportNull$$$0(7);
            }
            return completableFuture;
        }
        String connectionUrl = this.myDataSource.getUrl();
        DatabaseDriver driver = this.myDataSource.getDatabaseDriver();
        Pair.NonNull<String, String> nonNull = hostPort = connectionUrl == null || driver == null ? null : JdbcUrlParserUtil.extractHostPort(driver.getJDBCUrlParsers(), connectionUrl, null);
        if (hostPort == null) {
            throw new UnsupportedOperationException("Unable to find host/port in URL");
        }
        CompletionStage<Pair<SshSession, Integer>> completionStage = AsyncUtil.thenComposeAsync(DatabaseSshTunnelEstablisher.getInitialSshCredentials(this.myProject, this.myDataSource, true), config -> this.createSshSessionWithRetries(config == null ? null : (DataSourceSshTunnelConfiguration)config.first, config == null ? null : (SshUiData)config.second), AsyncUtil.getPoolExecutor()).thenApply(session2 -> {
            if (session2 == null) {
                return null;
            }
            int localPort = this.getAddLocalPortTunnel((Pair<String, String>)hostPort, ((SshUiData)session2.getThird()).getAuthType() == AuthType.OPEN_SSH, StringUtil.nullize((String)((SshUiData)session2.getThird()).getLiteralLocalPort()), (SshSession)session2.getSecond());
            return Pair.create((Object)session2.getSecond(), (Object)localPort);
        });
        if (completionStage == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(8);
        }
        return completionStage;
    }

    private int getAddLocalPortTunnel(@NotNull Pair<String, String> hostPort, boolean reuseExisting, @Nullable String requiredLocal, @NotNull SshSession session2) {
        if (hostPort == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(9);
        }
        if (session2 == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(10);
        }
        int existingPort = reuseExisting || requiredLocal != null ? this.findExistingPort(hostPort, requiredLocal, session2) : -1;
        return existingPort != -1 ? existingPort : this.getNewTunnelPort(hostPort, requiredLocal, session2);
    }

    private int getNewTunnelPort(@NotNull Pair<String, String> hostPort, @Nullable String requiredLocal, @NotNull SshSession session2) {
        if (hostPort == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(11);
        }
        if (session2 == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(12);
        }
        int localPort = this.findLocalPort(requiredLocal);
        session2.addLocalTunnel(localPort, (String)hostPort.first, StringUtil.parseInt((String)((String)hostPort.second), (int)-1));
        LOG.info("SSH tunnel created: " + localPort + ":" + (String)hostPort.first + ":" + (String)hostPort.second);
        return localPort;
    }

    private int findLocalPort(@Nullable String requiredLocal) {
        if (requiredLocal != null) {
            int localPort = StringUtil.parseInt((String)requiredLocal, (int)-1);
            if (localPort != -1) {
                return localPort;
            }
            throw new SshTransportException("Requested local port is not an integer: " + requiredLocal);
        }
        try {
            return NetUtils.findAvailableSocketPort();
        }
        catch (IOException e) {
            throw new SshTransportException("Free port not found", (Throwable)e);
        }
    }

    private int findExistingPort(@NotNull Pair<String, String> hostPort, @Nullable String requiredLocal, @NotNull SshSession session2) {
        String existing;
        if (hostPort == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(13);
        }
        if (session2 == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(14);
        }
        if ((existing = this.findExistingForwarding(hostPort, requiredLocal, session2)) != null) {
            int localPort = StringUtil.parseInt((String)existing.substring(0, existing.indexOf(58)), (int)-1);
            if (localPort == -1) {
                throw new RuntimeException("Failed to parse forwarding: " + existing);
            }
            LOG.info("SSH tunnel reused: " + existing);
            return localPort;
        }
        return -1;
    }

    private String findExistingForwarding(@NotNull Pair<String, String> hostPort, @Nullable String requiredLocal, @NotNull SshSession session2) {
        String prefix;
        if (hostPort == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(15);
        }
        if (session2 == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(16);
        }
        session2.applyPortForwardings();
        List existing = session2.getPortForwardingList();
        String term = StringUtil.notNullize((String)requiredLocal) + ":" + (String)hostPort.first + ":" + (String)hostPort.second;
        String found = (String)ContainerUtil.find((Iterable)existing, (Condition)(requiredLocal == null ? o -> o.endsWith(term) : o -> o.equals(term)));
        if (found != null) {
            return found;
        }
        if (requiredLocal != null && (found = (String)ContainerUtil.find((Iterable)existing, arg_0 -> DatabaseSshTunnelEstablisher.lambda$findExistingForwarding$4(prefix = requiredLocal + ":", arg_0))) != null) {
            LOG.warn("Were looking for `" + term + "` but found nothing. But there was an existing mapping `" + found + "` for the forced local port.");
        }
        return found;
    }

    @NotNull
    private @NotNull CompletionStage<Triple<@NotNull DataSourceSshTunnelConfiguration, @NotNull SshSession, @NotNull SshUiData>> createSshSessionWithRetries(@Nullable DataSourceSshTunnelConfiguration ssh, @Nullable SshUiData sshUiData) {
        CompletableFuture<Triple<DataSourceSshTunnelConfiguration, SshSession, SshUiData>> completableFuture;
        if (ssh == null || !ssh.isEnabled() || sshUiData == null) {
            CompletableFuture<Object> completableFuture2 = CompletableFuture.completedFuture(null);
            if (completableFuture2 == null) {
                DatabaseSshTunnelEstablisher.$$$reportNull$$$0(17);
            }
            return completableFuture2;
        }
        try {
            completableFuture = CompletableFuture.completedFuture(new Triple((Object)ssh, (Object)DatabaseSshTunnelEstablisher.createSshSession(sshUiData), (Object)sshUiData));
        }
        catch (Throwable e) {
            if (!DatabaseSshTunnelEstablisher.isAuthFailure(e)) {
                CompletableFuture<Triple<DataSourceSshTunnelConfiguration, SshSession, SshUiData>> completableFuture3 = AsyncUtil.exceptional(e);
                if (completableFuture3 == null) {
                    DatabaseSshTunnelEstablisher.$$$reportNull$$$0(19);
                }
                return completableFuture3;
            }
            CompletionStage<Triple<DataSourceSshTunnelConfiguration, SshSession, SshUiData>> completionStage = AsyncUtil.thenComposeAsync(DatabaseSshTunnelEstablisher.askSshCredentialsWhenFailed(this.myProject, this.myDataSource, "<html>" + e.getMessage() + "</html>", true), config -> this.createSshSessionWithRetries(config == null ? null : (DataSourceSshTunnelConfiguration)config.first, config == null ? null : (SshUiData)config.second), AsyncUtil.getPoolExecutor());
            if (completionStage == null) {
                DatabaseSshTunnelEstablisher.$$$reportNull$$$0(20);
            }
            return completionStage;
        }
        if (completableFuture == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(18);
        }
        return completableFuture;
    }

    private static boolean isAuthFailure(Throwable e) {
        if (e instanceof SshTransportException) {
            if (e instanceof AuthFailSshTransportException) {
                return true;
            }
            String message2 = e.getMessage();
            if (message2 == null) {
                return false;
            }
            if ("Auth cancel".equals(message2)) {
                return true;
            }
            if (message2.contains("Too many authentication failures")) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static SshSession createSshSession(@NotNull SshUiData sshUiData) {
        if (sshUiData == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(21);
        }
        RemoteCredentialsHolder holder = new RemoteCredentialsHolder();
        holder.copyFrom((RemoteCredentials)sshUiData);
        holder.setPort(StringUtil.parseInt((String)holder.getLiteralPort(), (int)22));
        switch (holder.getAuthType()) {
            case KEY_PAIR: {
                holder.setPrivateKeyFile(DatabaseSshTunnelEstablisher.tildeExpandFilename(StringUtil.notNullize((String)StringUtil.nullize((String)holder.getPrivateKeyFile()), (String)DEF_KEY_FILE)));
                break;
            }
            case OPEN_SSH: {
                OpenSSHClientConfig openSSHConfig = OpenSSHConfigService.getInstance().getConfig();
                if (openSSHConfig == null) break;
                OpenSSHClientConfig.HostConfig hostConfig = openSSHConfig.getConfig(holder.getHost());
                if (StringUtil.isEmptyOrSpaces((String)holder.getHost())) {
                    DatabaseSshTunnelEstablisher.usePortFromOpenSSHConfig(holder, (ConfigRepository.Config)hostConfig);
                }
                if (!StringUtil.isEmptyOrSpaces((String)holder.getUserName())) break;
                DatabaseSshTunnelEstablisher.useUserFromOpenSSHConfig(holder, (ConfigRepository.Config)hostConfig);
                break;
            }
        }
        ConnectionBuilder builder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)holder);
        if (holder.getAuthType() != AuthType.OPEN_SSH) {
            builder.withOpenSSHConfig(null);
        }
        SshSession sshSession = builder.connect();
        if (sshSession == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(22);
        }
        return sshSession;
    }

    private static void usePortFromOpenSSHConfig(@NotNull RemoteCredentialsHolder holder, @NotNull ConfigRepository.Config hostConfig) {
        int port;
        if (holder == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(23);
        }
        if (hostConfig == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(24);
        }
        if ((port = hostConfig.getPort()) != -1) {
            LOG.info("Use " + port + " port from OpenSSH configuration file");
            holder.setPort(port);
        }
    }

    private static void useUserFromOpenSSHConfig(@NotNull RemoteCredentialsHolder holder, @NotNull ConfigRepository.Config hostConfig) {
        String user;
        if (holder == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(25);
        }
        if (hostConfig == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(26);
        }
        if (StringUtil.isNotEmpty((String)(user = hostConfig.getUser()))) {
            LOG.info("Use \"" + user + "\" user from OpenSSH configuration file");
            holder.setUserName(user);
        }
    }

    @NotNull
    public static String tildeExpandFilename(@NotNull String path) {
        if (path == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(27);
        }
        if ((path = path.trim()).startsWith("~")) {
            String string = SystemProperties.getUserHome() + path.substring(1);
            if (string == null) {
                DatabaseSshTunnelEstablisher.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    static CompletionStage<Pair<DataSourceSshTunnelConfiguration, SshUiData>> askSshCredentialsWhenFailed(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull String message2, boolean error2) {
        if (project == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(30);
        }
        if (dataSource2 == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(31);
        }
        if (message2 == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(32);
        }
        if (project.isDefault()) {
            CompletableFuture<Pair<DataSourceSshTunnelConfiguration, SshUiData>> completableFuture = AsyncUtil.cancelled();
            if (completableFuture == null) {
                DatabaseSshTunnelEstablisher.$$$reportNull$$$0(33);
            }
            return completableFuture;
        }
        DataSourceSshTunnelConfiguration ssh = dataSource2.getSshConfiguration();
        if (ssh == null || !ssh.isEnabled()) {
            CompletableFuture<Pair<DataSourceSshTunnelConfiguration, SshUiData>> completableFuture = AsyncUtil.cancelled();
            if (completableFuture == null) {
                DatabaseSshTunnelEstablisher.$$$reportNull$$$0(34);
            }
            return completableFuture;
        }
        Pair<DataSourceSshTunnelConfiguration, SshUiData> p1 = DatabaseSshTunnelEstablisher.getSshAuth(dataSource2, project);
        CompletableFuture<Pair<DataSourceSshTunnelConfiguration, SshUiData>> completableFuture = DatabaseCredentials.showCredentialsDialog(() -> {
            Pair<DataSourceSshTunnelConfiguration, SshUiData> p2 = DatabaseSshTunnelEstablisher.getSshAuth(dataSource2, project);
            if (!(Comparing.equal((Object)p1, p2) || p1 != null && p2 != null && Comparing.equal((Object)p1.first, (Object)p2.first) && p1.second != null && p2.second != null && ((SshUiData)p1.second).hasEqualConfigAndAuthData((SshUiData)p2.second, true))) {
                return p2;
            }
            Disposable disposable2 = Disposer.newDisposable();
            try {
                boolean ok;
                DataSourceSshPanel sshPanel = new DataSourceSshPanel(project, dataSource2, disposable2);
                sshPanel.reset(dataSource2);
                if (ourSshInterceptor == null) {
                    sshPanel.getComponent().setBorder((Border)JBUI.Borders.emptyTop((int)4));
                    DialogBuilder builder = DatabaseCredentials.prepareDialog(project, (error2 ? MessageType.ERROR : MessageType.WARNING).getDefaultIcon(), sshPanel.getComponent(), "Opening tunnel for '" + dataSource2.getName() + "'...", message2);
                    builder.setPreferredFocusComponent(sshPanel.getPreferredFocusedComponent());
                    ok = builder.show() == 0;
                } else {
                    ok = (Boolean)ourSshInterceptor.fun((Object)sshPanel);
                }
                if (!ok) {
                    throw new ProcessCanceledException();
                }
                sshPanel.saveData(dataSource2, true);
                DataSourceSshTunnelConfiguration config = sshPanel.createSshConfig();
                if (config == null || !config.isEnabled()) {
                    Pair pair = null;
                    return pair;
                }
                Pair pair = Pair.create((Object)config, (Object)sshPanel.getUiData());
                return pair;
            }
            finally {
                Disposer.dispose((Disposable)disposable2);
            }
        });
        if (completableFuture == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(35);
        }
        return completableFuture;
    }

    public static CompletionStage<Pair<DataSourceSshTunnelConfiguration, SshUiData>> askNoSshCredentials(@NotNull Project project, @NotNull LocalDataSource dataSource2) {
        if (project == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(36);
        }
        if (dataSource2 == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(37);
        }
        return DatabaseSshTunnelEstablisher.askSshCredentialsWhenFailed(project, dataSource2, DatabaseBundle.message((String)"ssh.tunnel.html.please.provide.ssh.credentials.html", (Object[])new Object[0]), false);
    }

    public static CompletionStage<Pair<@NotNull DataSourceSshTunnelConfiguration, @NotNull SshUiData>> getInitialSshCredentials(@NotNull Project project, @NotNull LocalDataSource dataSource2, boolean askPassword) {
        if (project == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(38);
        }
        if (dataSource2 == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(39);
        }
        return DatabaseCredentials.getInitialCredentialsImpl2(askPassword, () -> DatabaseSshTunnelEstablisher.getSshAuthAsync(dataSource2, project), th -> th == null ? DatabaseSshTunnelEstablisher.askNoSshCredentials(project, dataSource2) : DatabaseSshTunnelEstablisher.askSshCredentialsWhenFailed(project, dataSource2, th.getMessage(), true), c2 -> c2 == null || c2.second == null || ((SshUiData)c2.second).hasNoCredentials());
    }

    @Nullable
    private static Pair<DataSourceSshTunnelConfiguration, SshUiData> getSshAuth(@NotNull LocalDataSource dataSource2, @NotNull Project project) {
        DataSourceSshTunnelConfiguration ssh;
        if (dataSource2 == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(40);
        }
        if (project == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(41);
        }
        if ((ssh = dataSource2.getSshConfiguration()) == null || !ssh.isEnabled()) {
            return null;
        }
        SshConfig config = ssh.getSshConfig(project);
        if (config == null) {
            return null;
        }
        return Pair.create((Object)ssh, (Object)new SshUiData(config));
    }

    public static CompletionStage<Pair<DataSourceSshTunnelConfiguration, SshUiData>> getSshAuthAsync(@NotNull DasDataSource info, @NotNull Project project) {
        LocalDataSource dataSource2;
        DataSourceSshTunnelConfiguration ssh;
        if (info == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(42);
        }
        if (project == null) {
            DatabaseSshTunnelEstablisher.$$$reportNull$$$0(43);
        }
        DataSourceSshTunnelConfiguration dataSourceSshTunnelConfiguration = ssh = (dataSource2 = (LocalDataSource)ObjectUtils.tryCast((Object)info, LocalDataSource.class)) == null ? null : dataSource2.getSshConfiguration();
        if (ssh == null) {
            return CompletableFuture.completedFuture(null);
        }
        return AsyncUtil.supplyAsync(() -> CompletableFuture.completedFuture(DatabaseSshTunnelEstablisher.getSshAuth(dataSource2, project)), AsyncUtil.getPoolExecutor());
    }

    private static /* synthetic */ boolean lambda$findExistingForwarding$4(String prefix, String o) {
        return o.startsWith(prefix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 31: 
            case 37: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseSshTunnelEstablisher";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostPort";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshUiData";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostConfig";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseSshTunnelEstablisher";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTunnel";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createSshSessionWithRetries";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createSshSession";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "tildeExpandFilename";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "askSshCredentialsWhenFailed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTunnelSync";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTunnel";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAddLocalPortTunnel";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNewTunnelPort";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findExistingPort";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findExistingForwarding";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createSshSession";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "usePortFromOpenSSHConfig";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "useUserFromOpenSSHConfig";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "tildeExpandFilename";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "askSshCredentialsWhenFailed";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "askNoSshCredentials";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getInitialSshCredentials";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getSshAuth";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSshAuthAsync";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

