/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.CommonBundle;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.util.ErrorHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.sql.SQLException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncPromiseKt;
import org.jetbrains.concurrency.Promise;

public class AsyncUtil {
    private static final Key<Boolean> ASYNC_FRIENDLY = Key.create((String)"ASYNC_FRIENDLY");
    private static final Key<Object> ASYNC_CALL_TRACE = Key.create((String)"ASYNC_CALL_TRACE");

    public static Executor transactionExecutor(@NotNull Disposable d2, @NotNull ModalityState modality) {
        if (d2 == null) {
            AsyncUtil.$$$reportNull$$$0(0);
        }
        if (modality == null) {
            AsyncUtil.$$$reportNull$$$0(1);
        }
        return AsyncUtil.asyncFriendlyExecutor(command -> ((AppUIExecutor)AppUIExecutor.onWriteThread((ModalityState)modality).expireWith(d2)).submit(command));
    }

    public static Executor transactionExecutor(@NotNull Disposable d2) {
        if (d2 == null) {
            AsyncUtil.$$$reportNull$$$0(2);
        }
        return AsyncUtil.transactionExecutor(d2, ModalityState.defaultModalityState());
    }

    public static Executor asyncFriendlyExecutor(@NotNull Executor e) {
        if (e == null) {
            AsyncUtil.$$$reportNull$$$0(3);
        }
        ProgressIndicator indicator = AsyncUtil.getAsyncFriendlyIndicator();
        return task -> {
            Application application = ApplicationManager.getApplication();
            UserDataHolder dataHolder = application == null || application.isUnitTestMode() ? (UserDataHolder)ObjectUtils.tryCast((Object)indicator, UserDataHolder.class) : null;
            Throwable currentTrace = dataHolder == null ? null : new Throwable();
            ASYNC_CALL_TRACE.set(dataHolder, (Object)currentTrace);
            e.execute(() -> {
                try {
                    AsyncUtil.underProgress(task, indicator);
                }
                finally {
                    if (currentTrace != null && ASYNC_CALL_TRACE.get(dataHolder) == currentTrace) {
                        ASYNC_CALL_TRACE.set(dataHolder, null);
                    }
                }
            });
        };
    }

    @Nullable
    public static Throwable getAsyncCallTrace(@Nullable ProgressIndicator indicator) {
        if (indicator instanceof UserDataHolder) {
            return (Throwable)ObjectUtils.tryCast((Object)ASYNC_CALL_TRACE.get((UserDataHolder)indicator), Throwable.class);
        }
        return null;
    }

    @Nullable
    public static ProgressIndicator getAsyncFriendlyIndicator() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (AsyncUtil.isAsyncFriendly(indicator)) {
            if (indicator == null || indicator.isRunning()) {
                return indicator;
            }
            return null;
        }
        return null;
    }

    @Nullable
    public static Throwable unwrap(@Nullable Throwable e) {
        Throwable first2 = (Throwable)JBIterable.generate((Object)e, Throwable::getCause).skipWhile(o -> o.getCause() != null && (o instanceof CompletionException || o instanceof ExecutionException || o instanceof com.intellij.execution.ExecutionException && o.getCause() instanceof ProcessCanceledException || o instanceof SQLException && (o.getCause().getClass() == RuntimeException.class || o.getCause().getClass() == SQLException.class) || o.getClass() == RuntimeException.class)).first();
        return first2 instanceof CancellationException ? new ProcessCanceledException() : first2;
    }

    public static boolean isAsyncFriendly(@Nullable ProgressIndicator indicator) {
        return indicator == null || indicator instanceof EmptyProgressIndicator || indicator instanceof UserDataHolder && ASYNC_FRIENDLY.get((UserDataHolder)indicator) == Boolean.TRUE;
    }

    public static <T extends ProgressIndicator> T markAsyncFriendly(@Nullable T indicator, boolean friendly) {
        if (indicator instanceof UserDataHolder) {
            ASYNC_FRIENDLY.set((UserDataHolder)indicator, (Object)(friendly ? Boolean.TRUE : null));
        }
        return indicator;
    }

    public static <T> CompletionStage<T> supplyAsync(@NotNull Supplier<? extends CompletionStage<T>> s, @NotNull Executor e) {
        if (s == null) {
            AsyncUtil.$$$reportNull$$$0(4);
        }
        if (e == null) {
            AsyncUtil.$$$reportNull$$$0(5);
        }
        return AsyncUtil.thenComposeAsync(CompletableFuture.completedFuture(null), x -> (CompletionStage)s.get(), e);
    }

    public static <U, T> CompletionStage<T> thenComposeAsync(@NotNull CompletionStage<? extends U> s, @NotNull Function<? super U, ? extends CompletionStage<T>> f, @NotNull Executor e) {
        if (s == null) {
            AsyncUtil.$$$reportNull$$$0(6);
        }
        if (f == null) {
            AsyncUtil.$$$reportNull$$$0(7);
        }
        if (e == null) {
            AsyncUtil.$$$reportNull$$$0(8);
        }
        CompletableFuture result = new CompletableFuture();
        AsyncUtil.processWhenComplete(s, result, r -> e.execute(() -> {
            try {
                AsyncUtil.processWhenComplete((CompletionStage)f.apply((Object)r), result, result::complete);
            }
            catch (Throwable th) {
                result.completeExceptionally(th);
            }
        }));
        return result;
    }

    public static <U, T> CompletionStage<T> thenHandleAsync(@NotNull CompletionStage<? extends U> s, @NotNull BiFunction<? super U, ? super Throwable, ? extends CompletionStage<T>> f, @NotNull Executor e) {
        if (s == null) {
            AsyncUtil.$$$reportNull$$$0(9);
        }
        if (f == null) {
            AsyncUtil.$$$reportNull$$$0(10);
        }
        if (e == null) {
            AsyncUtil.$$$reportNull$$$0(11);
        }
        CompletableFuture result = new CompletableFuture();
        AsyncUtil.handleWhenComplete(s, result, (r, th) -> e.execute(() -> {
            try {
                AsyncUtil.handleWhenComplete((CompletionStage)f.apply((Object)r, (Throwable)th), result, (r2, th2) -> {
                    if (th2 != null) {
                        result.completeExceptionally((Throwable)th2);
                    } else {
                        result.complete(r2);
                    }
                });
            }
            catch (Throwable th22) {
                result.completeExceptionally(th22);
            }
        }));
        return result;
    }

    private static <T> void processWhenComplete(@NotNull CompletionStage<T> what, @NotNull CompletableFuture<?> where, @NotNull Consumer<? super T> cons) {
        if (what == null) {
            AsyncUtil.$$$reportNull$$$0(12);
        }
        if (where == null) {
            AsyncUtil.$$$reportNull$$$0(13);
        }
        if (cons == null) {
            AsyncUtil.$$$reportNull$$$0(14);
        }
        AsyncUtil.handleWhenComplete(what, where, (r, th) -> {
            if (th != null) {
                where.completeExceptionally((Throwable)th);
            } else {
                cons.consume(r);
            }
        });
    }

    private static <T> void handleWhenComplete(@NotNull CompletionStage<T> what, @NotNull CompletableFuture<?> where, @NotNull BiConsumer<? super T, ? super Throwable> cons) {
        if (what == null) {
            AsyncUtil.$$$reportNull$$$0(15);
        }
        if (where == null) {
            AsyncUtil.$$$reportNull$$$0(16);
        }
        if (cons == null) {
            AsyncUtil.$$$reportNull$$$0(17);
        }
        try {
            what.whenComplete((r, th) -> {
                try {
                    cons.accept((Object)r, (Throwable)th);
                }
                catch (Throwable ex) {
                    where.completeExceptionally(ex);
                }
            });
        }
        catch (Throwable ex) {
            where.completeExceptionally(ex);
        }
    }

    public static <T> T underProgress(@NotNull Computable<T> r, @Nullable ProgressIndicator indicator) {
        if (r == null) {
            AsyncUtil.$$$reportNull$$$0(18);
        }
        Ref res = Ref.create();
        AsyncUtil.underProgress(() -> res.set(r.compute()), indicator);
        return (T)res.get();
    }

    public static void underProgress(@NotNull Runnable r, @Nullable ProgressIndicator indicator) {
        if (r == null) {
            AsyncUtil.$$$reportNull$$$0(19);
        }
        ProgressManager.getInstance().executeProcessUnderProgress(r, indicator);
    }

    public static <T> CompletionStage<T> runTask(@NotNull Computable<? extends CompletionStage<T>> r, @NotNull ProgressIndicatorEx indicator) {
        CompletionStage<Object> res;
        if (r == null) {
            AsyncUtil.$$$reportNull$$$0(20);
        }
        if (indicator == null) {
            AsyncUtil.$$$reportNull$$$0(21);
        }
        indicator.start();
        try {
            res = AsyncUtil.underProgress(r, (ProgressIndicator)indicator);
        }
        catch (Throwable th) {
            indicator.stop();
            indicator.processFinish();
            return AsyncUtil.exceptional(th);
        }
        if (res == null) {
            indicator.stop();
            indicator.processFinish();
            return null;
        }
        return res.whenComplete((t, throwable) -> {
            indicator.stop();
            indicator.processFinish();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T withAsyncFriendly(@Nullable ProgressIndicator indicator, @NotNull ThrowableComputable<T, E> computable) throws E {
        boolean wasFriendly;
        if (computable == null) {
            AsyncUtil.$$$reportNull$$$0(22);
        }
        if (!(wasFriendly = AsyncUtil.isAsyncFriendly(indicator))) {
            AsyncUtil.markAsyncFriendly(indicator, true);
        }
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            if (!wasFriendly) {
                AsyncUtil.markAsyncFriendly(indicator, false);
            }
        }
    }

    public static ProgressIndicatorEx createBackgroundIndicator(@NotNull Project project, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String name) {
        if (project == null) {
            AsyncUtil.$$$reportNull$$$0(23);
        }
        if (name == null) {
            AsyncUtil.$$$reportNull$$$0(24);
        }
        return (ProgressIndicatorEx)AsyncUtil.markAsyncFriendly(new BackgroundableProcessIndicator(project, name, PerformInBackgroundOption.ALWAYS_BACKGROUND, CommonBundle.getCancelButtonText(), CommonBundle.getCancelButtonText(), true), true);
    }

    public static <T> CompletableFuture<T> cancelled() {
        CompletableFuture res = new CompletableFuture();
        res.cancel(false);
        return res;
    }

    public static <T> CompletableFuture<T> exceptional(@NotNull Throwable th) {
        if (th == null) {
            AsyncUtil.$$$reportNull$$$0(25);
        }
        CompletableFuture res = new CompletableFuture();
        res.completeExceptionally(th);
        return res;
    }

    public static <T> CompletionStage<T> completed(@Nullable T r, @Nullable Throwable th) {
        return th != null ? AsyncUtil.exceptional(th) : CompletableFuture.completedFuture(r);
    }

    public static <T> void transfer(@NotNull CompletionStage<T> from, @NotNull CompletableFuture<T> to) {
        if (from == null) {
            AsyncUtil.$$$reportNull$$$0(26);
        }
        if (to == null) {
            AsyncUtil.$$$reportNull$$$0(27);
        }
        from.handle((r, th) -> th == null ? to.complete(r) : to.completeExceptionally((Throwable)th));
    }

    public static boolean isCancellation(@Nullable Throwable e) {
        return JBIterable.generate((Object)e, Throwable::getCause).find(o -> o instanceof ProcessCanceledException && o.getCause() == null || o instanceof CancellationException) != null;
    }

    public static void addUnhandledError(@NotNull ErrorHandler errorHandler, @Nullable Throwable e, @Nullable LocalDataSource dataSource2) {
        if (errorHandler == null) {
            AsyncUtil.$$$reportNull$$$0(28);
        }
        if (e == null || AsyncUtil.isCancellation(e)) {
            return;
        }
        Throwable unwrapped = AsyncUtil.unwrap(e);
        errorHandler.addError(JdbcEngine.getErrorMessage(unwrapped, dataSource2), unwrapped);
    }

    public static <T> Promise<T> runAsync(@NotNull Supplier<? extends Promise<T>> s, @NotNull Executor e) {
        if (s == null) {
            AsyncUtil.$$$reportNull$$$0(29);
        }
        if (e == null) {
            AsyncUtil.$$$reportNull$$$0(30);
        }
        AsyncPromise res = new AsyncPromise();
        e.execute(() -> AsyncPromiseKt.catchError((AsyncPromise)res, () -> AsyncUtil.lambda$null$16((Supplier)s, res)));
        return res;
    }

    public static Executor getPoolExecutor() {
        return AsyncUtil.asyncFriendlyExecutor(arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0));
    }

    public static Executor getEdtExecutor() {
        return AsyncUtil.asyncFriendlyExecutor(UIUtil::invokeLaterIfNeeded);
    }

    public static Executor getNonEdtExecutor() {
        return AsyncUtil.asyncFriendlyExecutor(command -> {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                ApplicationManager.getApplication().executeOnPooledThread(command);
            } else {
                command.run();
            }
        });
    }

    private static /* synthetic */ Object lambda$null$16(Supplier s, AsyncPromise res) {
        ((Promise)s.get()).processed((Promise)res);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cons";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "th";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/AsyncUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "transactionExecutor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "asyncFriendlyExecutor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "supplyAsync";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "thenComposeAsync";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "thenHandleAsync";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "processWhenComplete";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "handleWhenComplete";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "underProgress";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "runTask";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "withAsyncFriendly";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "createBackgroundIndicator";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "exceptional";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "transfer";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "addUnhandledError";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "runAsync";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

