/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFormatter {
    private final CsvFormat myFormat;

    public CsvFormatter(@NotNull CsvFormat format) {
        if (format == null) {
            CsvFormatter.$$$reportNull$$$0(0);
        }
        this.myFormat = format;
    }

    @NotNull
    public CsvFormat getFormat() {
        CsvFormat csvFormat = this.myFormat;
        if (csvFormat == null) {
            CsvFormatter.$$$reportNull$$$0(1);
        }
        return csvFormat;
    }

    @NotNull
    public String formatValue(@Nullable Object value2) {
        return this.formatValue(this.myFormat.dataRecord, value2);
    }

    @NotNull
    public String formatHeaderValue(@Nullable Object value2) {
        return this.formatValue((CsvRecordFormat)ObjectUtils.notNull((Object)this.myFormat.headerRecord, (Object)this.myFormat.dataRecord), value2);
    }

    @NotNull
    public String valueSeparator() {
        return CsvFormatter.valueSeparator(this.myFormat.dataRecord);
    }

    @NotNull
    public String headerValueSeparator() {
        return CsvFormatter.valueSeparator((CsvRecordFormat)ObjectUtils.notNull((Object)this.myFormat.headerRecord, (Object)this.myFormat.dataRecord));
    }

    @NotNull
    public String recordSeparator() {
        String string = this.myFormat.dataRecord.recordSeparator;
        if (string == null) {
            CsvFormatter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String formatRecord(@NotNull List<?> values2) {
        if (values2 == null) {
            CsvFormatter.$$$reportNull$$$0(3);
        }
        return this.formatRecord(this.myFormat.dataRecord, values2);
    }

    public String formatHeader(@NotNull List<?> values2) {
        if (values2 == null) {
            CsvFormatter.$$$reportNull$$$0(4);
        }
        return this.formatRecord((CsvRecordFormat)ObjectUtils.notNull((Object)this.myFormat.headerRecord, (Object)this.myFormat.dataRecord), values2);
    }

    public boolean requiresRowNumbers() {
        return this.myFormat.rowNumbers;
    }

    @NotNull
    protected String valueToRawText(@Nullable Object value2) {
        String string = String.valueOf(value2);
        if (string == null) {
            CsvFormatter.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private String formatRecord(@NotNull CsvRecordFormat recordTemplate, @NotNull List<?> values2) {
        if (recordTemplate == null) {
            CsvFormatter.$$$reportNull$$$0(6);
        }
        if (values2 == null) {
            CsvFormatter.$$$reportNull$$$0(7);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtil.notNullize((String)recordTemplate.prefix));
        for (Object value2 : values2) {
            sb.append(this.formatValue(recordTemplate, value2)).append(CsvFormatter.valueSeparator(recordTemplate));
        }
        sb.setLength(values2.isEmpty() ? sb.length() : sb.length() - CsvFormatter.valueSeparator(recordTemplate).length());
        sb.append(StringUtil.notNullize((String)recordTemplate.suffix));
        String string = sb.toString();
        if (string == null) {
            CsvFormatter.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private String formatValue(@NotNull CsvRecordFormat recordTemplate, @Nullable Object value2) {
        if (recordTemplate == null) {
            CsvFormatter.$$$reportNull$$$0(9);
        }
        String valueText = value2 == null ? StringUtil.notNullize((String)recordTemplate.nullText) : this.valueToRawText(value2);
        valueText = recordTemplate.trimWhitespace ? StringUtil.trimLeading((String)StringUtil.trimTrailing((String)valueText)) : valueText;
        CsvRecordFormat.QuotationPolicy quotationPolicy = recordTemplate.quotationPolicy;
        CsvRecordFormat.Quotes quotes = value2 == null ? null : CsvFormatter.getQuotes(recordTemplate, valueText, quotationPolicy);
        String string = quotes != null ? quotes.leftQuote + CsvFormatter.escapeQuotes(valueText, quotes) + quotes.rightQuote : valueText;
        if (string == null) {
            CsvFormatter.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Nullable
    private static CsvRecordFormat.Quotes getQuotes(@NotNull CsvRecordFormat recordTemplate, @NotNull String valueText, @NotNull CsvRecordFormat.QuotationPolicy quotationPolicy) {
        if (recordTemplate == null) {
            CsvFormatter.$$$reportNull$$$0(11);
        }
        if (valueText == null) {
            CsvFormatter.$$$reportNull$$$0(12);
        }
        if (quotationPolicy == null) {
            CsvFormatter.$$$reportNull$$$0(13);
        }
        if (quotationPolicy == CsvRecordFormat.QuotationPolicy.ALWAYS) {
            return (CsvRecordFormat.Quotes)ContainerUtil.getFirstItem(recordTemplate.quotes);
        }
        if (quotationPolicy == CsvRecordFormat.QuotationPolicy.AS_NEEDED) {
            return CsvFormatter.shouldQuote(recordTemplate, valueText) ? (CsvRecordFormat.Quotes)ContainerUtil.getFirstItem(recordTemplate.quotes) : null;
        }
        throw new AssertionError((Object)("Unhandled quotation policy: " + (Object)((Object)quotationPolicy)));
    }

    @NotNull
    private static String escapeQuotes(@NotNull CharSequence s, @NotNull CsvRecordFormat.Quotes quotes) {
        if (s == null) {
            CsvFormatter.$$$reportNull$$$0(14);
        }
        if (quotes == null) {
            CsvFormatter.$$$reportNull$$$0(15);
        }
        boolean leftIsEmpty = quotes.leftQuote.isEmpty();
        boolean rightIsEmpty = quotes.rightQuote.isEmpty();
        List escapedQuotes = ContainerUtil.filter(Arrays.asList(leftIsEmpty ? null : quotes.leftQuoteEscaped, rightIsEmpty ? null : quotes.rightQuoteEscaped), (Condition)Conditions.notNull());
        List unescapedQuotes = ContainerUtil.filter(Arrays.asList(leftIsEmpty ? null : quotes.leftQuote, rightIsEmpty ? null : quotes.rightQuote), (Condition)Conditions.notNull());
        String string = StringUtil.replace((String)s.toString(), (List)unescapedQuotes, (List)escapedQuotes);
        if (string == null) {
            CsvFormatter.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String valueSeparator(@NotNull CsvRecordFormat template) {
        if (template == null) {
            CsvFormatter.$$$reportNull$$$0(17);
        }
        String string = template.valueSeparator;
        if (string == null) {
            CsvFormatter.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static boolean shouldQuote(@NotNull CsvRecordFormat recordTemplate, @NotNull String valueText) {
        if (recordTemplate == null) {
            CsvFormatter.$$$reportNull$$$0(19);
        }
        if (valueText == null) {
            CsvFormatter.$$$reportNull$$$0(20);
        }
        return StringUtil.contains((CharSequence)valueText, (CharSequence)recordTemplate.valueSeparator) || StringUtil.contains((CharSequence)valueText, (CharSequence)recordTemplate.recordSeparator) || StringUtil.isNotEmpty((String)recordTemplate.prefix) && StringUtil.contains((CharSequence)valueText, (CharSequence)recordTemplate.prefix) || StringUtil.isNotEmpty((String)recordTemplate.suffix) && StringUtil.contains((CharSequence)valueText, (CharSequence)recordTemplate.suffix) || StringUtil.equals((CharSequence)valueText, (CharSequence)recordTemplate.nullText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/csv/CsvFormatter";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordTemplate";
                break;
            }
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueText";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotationPolicy";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/csv/CsvFormatter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "recordSeparator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "valueToRawText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "formatRecord";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "formatValue";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeQuotes";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "valueSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 16: 
            case 18: {
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "formatRecord";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "formatHeader";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "formatValue";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getQuotes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "escapeQuotes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "valueSeparator";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuote";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

