/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.DatabaseObjectRefactoring;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbIndex;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableChild;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import com.intellij.database.schemaEditor.SchemaEditor;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.script.CompositeText;
import com.intellij.database.script.DbSrcMigration;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilder;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.database.view.CommentQueryGenerator;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DropQueryGenerator;
import com.intellij.database.view.ModelLightCopier;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.builder.ForeignKeyModelBuilder;
import com.intellij.database.view.models.builder.IndexModelBuilder;
import com.intellij.database.view.models.builder.KeyModelBuilder;
import com.intellij.database.view.models.builder.TableModelBuilder;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.database.view.ui.DbBatchIndicesDialog;
import com.intellij.database.view.ui.DbRefactoringDialogHelper;
import com.intellij.database.view.ui.DbTableDialog;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.FieldPanel;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.components.BorderLayoutPanel;
import icons.DatabaseIcons;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlActions {
    private static void deleteDataSources(@NotNull Project project, final @NotNull Set<DbDataSource> dataSources2) {
        String message2;
        if (project == null) {
            DdlActions.$$$reportNull$$$0(0);
        }
        if (dataSources2 == null) {
            DdlActions.$$$reportNull$$$0(1);
        }
        if (dataSources2.size() == 1) {
            DbDataSource element2 = dataSources2.iterator().next();
            message2 = DatabaseBundle.message((String)"confirmation.text.remove.data.source", (Object[])new Object[]{element2.getName()});
        } else {
            StringBuilder sb = new StringBuilder(DatabaseBundle.message((String)"confirmation.text.remove.data.source.2", (Object[])new Object[0])).append("\n");
            int i2 = 0;
            for (DbDataSource o : dataSources2) {
                if (i2++ > 0) {
                    sb.append(",").append(i2 % 3 == 1 ? "\n" : " ");
                }
                sb.append(o.getName());
            }
            message2 = sb.toString();
        }
        int ret = Messages.showOkCancelDialog((Project)project, (String)message2, (String)CommonBundle.message((String)"title.confirmation", (Object[])new Object[0]), (String)Messages.getOkButton(), (String)Messages.getCancelButton(), (Icon)Messages.getWarningIcon());
        if (ret != 0) {
            return;
        }
        DdlActions.closeAllFilesBeforeDataSourceRemoval(project, dataSources2);
        final DbPsiFacade facade = DbPsiFacade.getInstance((Project)project);
        GlobalUndoableAction action2 = new GlobalUndoableAction(){

            public void undo() {
                for (DbDataSource dataSource2 : dataSources2) {
                    facade.getDataSourceManager(dataSource2).addDataSource((DasDataSource)dataSource2.getDelegate());
                }
            }

            public void redo() {
                for (DbDataSource dataSource2 : dataSources2) {
                    facade.getDataSourceManager(dataSource2).removeDataSource((DasDataSource)dataSource2.getDelegate());
                }
            }
        };
        try {
            WriteCommandAction.writeCommandAction((Project)project).withName(DatabaseBundle.message((String)"command.name.remove.data.source", (Object[])new Object[0])).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).run(() -> DdlActions.lambda$deleteDataSources$0((UndoableAction)action2, project));
        }
        catch (UnexpectedUndoException e) {
            throw new RuntimeException(e);
        }
    }

    public static void closeAllFilesBeforeDataSourceRemoval(@NotNull Project project, @NotNull Set<DbDataSource> elements) {
        if (project == null) {
            DdlActions.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            DdlActions.$$$reportNull$$$0(3);
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        for (VirtualFile virtualFile : fileEditorManager.getOpenFiles()) {
            DbDataSource dataSource2 = DbImplUtil.findDataSource(project, virtualFile);
            if (!elements.contains(dataSource2)) continue;
            fileEditorManager.closeFile(virtualFile);
        }
    }

    @NotNull
    static Pair<DbTable, Set<DbColumn>> getTableAndColumns(AnActionEvent e) {
        DbTable tableElement;
        Set<Object> columns = DatabaseView.getSelectedElements(e.getDataContext(), DbColumn.class);
        Set tables = ContainerUtil.map2Set(columns, (Function)((NullableFunction)element2 -> element2.getParent()));
        DbTable dbTable = tableElement = tables.size() == 1 ? (DbTable)tables.iterator().next() : null;
        if (tableElement == null) {
            JBIterable<DbElement> selection = DatabaseView.getSelectedElementsNoGroups(e.getDataContext(), true);
            DbElement element3 = (DbElement)selection.single();
            tableElement = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)element3, DbTable.class, (boolean)false);
            columns = Collections.emptySet();
        }
        Pair pair = Pair.create((Object)tableElement, columns);
        if (pair == null) {
            DdlActions.$$$reportNull$$$0(4);
        }
        return pair;
    }

    private static /* synthetic */ void lambda$deleteDataSources$0(UndoableAction action2, Project project) throws UnexpectedUndoException {
        action2.redo();
        UndoManager.getInstance((Project)project).undoableActionPerformed(action2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DdlActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DdlActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableAndColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deleteDataSources";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "closeAllFilesBeforeDataSourceRemoval";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CreateObject
    extends DumbAwareAction {
        private final BasicMetaObject<?> myMeta;
        private final String myVariant;

        CreateObject(@NotNull BasicMetaObject<?> meta, @NotNull String variant) {
            if (meta == null) {
                CreateObject.$$$reportNull$$$0(0);
            }
            if (variant == null) {
                CreateObject.$$$reportNull$$$0(1);
            }
            super(StringUtil.isNotEmpty((String)variant) ? variant : StringUtil.capitalizeWords((String)DbPresentation.getPresentableName(meta), (boolean)true), null, DbPresentation.getIcon(meta));
            this.myMeta = meta;
            this.myVariant = variant;
        }

        public static boolean isSupported(@NotNull BasicElement e) {
            if (e == null) {
                CreateObject.$$$reportNull$$$0(2);
            }
            Dbms dbms = DbImplUtil.getDbms(e);
            ScriptingCapabilities capabilities = ((ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms)).capabilities(e);
            BasicModel model = e.getModel();
            return capabilities.getCreate().get(model == null ? Version.INFINITY : model.getRoot().getServerVersion());
        }

        public void update(@NotNull AnActionEvent e) {
            DbElement single;
            BasicElement element2;
            if (e == null) {
                CreateObject.$$$reportNull$$$0(3);
            }
            boolean visible = (element2 = ModifyObject.getElement(single = CreateObject.getSingle(e))) != null && DbImplUtil.canConnectTo(single) && CreateObject.getParent(element2, this.myMeta) != null && CreateObject.isSupported(this.myMeta.newDataObject());
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify(single));
        }

        @Nullable
        private static BasicElement getParent(@Nullable BasicElement e, BasicMetaObject<?> meta) {
            return e == null || meta.getParent() == e.getMetaObject() ? e : CreateObject.getParent(e.getParent(), meta);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement single;
            BasicElement element2;
            BasicModel model;
            if (e == null) {
                CreateObject.$$$reportNull$$$0(4);
            }
            BasicModel basicModel = model = (element2 = ModifyObject.getElement(single = CreateObject.getSingle(e))) == null ? null : element2.getModel();
            if (model == null) {
                return;
            }
            final BasicElement parent2 = CreateObject.getParent(element2, this.myMeta);
            if (parent2 == null) {
                return;
            }
            final ModelHelper helper = ModelFacade.forDbms(model.getDbms()).getModelHelper();
            BasicNamespace current = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.getSearchPathObjectForSwitch(single.getDataSource(), parent2), BasicNamespace.class);
            DbObjectEditorFactory.DbObjectEditorBase dialog2 = new DbObjectEditorFactory.DbObjectEditorBase(single.getProject(), single.getDataSource(), ObjectPaths.searchPathOf(current), "Create"){
                private final DbObjectEditorFactory.DbObjectEditor editor;
                private final BasicModModel myTargetModel;
                private final BasicModElement myTargetParent;
                private final BasicModElement myTargetElement;
                {
                    super(project, dataSource2, searchPath, title);
                    this.editor = DbObjectEditorFactory.forDbms(model.getDbms()).createObjectEditor(single.getProject(), myMeta);
                    this.myTargetModel = new ModelFactory(new MemoryTextStorage()).createModel(model.getDbms());
                    this.myTargetParent = ModelLightCopier.copy(parent2, this.myTargetModel);
                    this.myTargetElement = ((ModFamily)Objects.requireNonNull(this.myTargetParent.familyOf(((CreateObject)this).myMeta.kind))).createNewOne();
                    helper.fillPropertiesWithExamples(this.myTargetElement, myVariant, new HashMap<String, String>());
                    this.editor.initCompletion(model);
                }

                @Override
                protected void reset() {
                    this.editor.reset(this.myTargetElement);
                }

                @Override
                protected void apply() {
                    this.editor.apply(null, this.myTargetElement);
                }

                @Override
                protected DbObjectEditorFactory.DbObjectEditor getObjectEditor() {
                    return this.editor;
                }

                @Override
                protected ScriptingTaskBuilder createBuilder() {
                    ScriptingSingleModelTaskBuilder builder = new ScriptingSingleModelTaskBuilder((BasicModel)this.myTargetModel, ScriptCategory.CREATE_COMPLETE);
                    builder.getElements().add(this.myTargetElement);
                    return builder;
                }
            };
            dialog2.initAndShow();
        }

        @Nullable
        static DbElement getSingle(@NotNull AnActionEvent e) {
            Set<DbElement> selection;
            if (e == null) {
                CreateObject.$$$reportNull$$$0(5);
            }
            return (selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class)).size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variant";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DdlActions$CreateObject";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSupported";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSingle";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PublicModifyObject
    extends ModifyObject {
        @Override
        protected boolean isAcceptable(BasicElement e) {
            return PublicCreateObjectGroup.isPublic(e.getMetaObject());
        }
    }

    public static class PublicCreateObjectGroup
    extends CreateObjectGroup {
        @Override
        @NotNull
        protected JBIterable<BasicMetaObject<?>> getCreateTargets(BasicElement element2) {
            JBIterable jBIterable = super.getCreateTargets(element2).filter(p2 -> PublicCreateObjectGroup.isPublic(p2));
            if (jBIterable == null) {
                PublicCreateObjectGroup.$$$reportNull$$$0(0);
            }
            return jBIterable;
        }

        public static boolean isPublic(BasicMetaObject<?> p2) {
            return p2.kind == ObjectKind.USER || p2.kind == ObjectKind.ROLE || p2.kind == ObjectKind.COLLATION || p2.kind == ObjectKind.DATABASE || p2.kind == ObjectKind.SCHEMA || p2.kind == ObjectKind.SEQUENCE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DdlActions$PublicCreateObjectGroup", "getCreateTargets"));
        }
    }

    public static class CreateObjectGroup
    extends ActionGroup {
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            BasicModel model;
            DbElement single = e == null ? null : CreateObject.getSingle(e);
            BasicElement element2 = ModifyObject.getElement(single);
            BasicModel basicModel = model = element2 == null ? null : element2.getModel();
            if (model == null) {
                if (AnAction.EMPTY_ARRAY == null) {
                    CreateObjectGroup.$$$reportNull$$$0(0);
                }
                return AnAction.EMPTY_ARRAY;
            }
            ModelHelper helper = ModelFacade.forDbms(model.getDbms()).getModelHelper();
            AnAction[] anActionArray = (AnAction[])this.getCreateTargets(element2).flatten(m -> helper.generationVariants((BasicMetaObject<?>)m).map(v -> Pair.create((Object)m, (Object)v))).map(p2 -> new CreateObject((BasicMetaObject)p2.first, (String)p2.second)).toArray((Object[])AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                CreateObjectGroup.$$$reportNull$$$0(1);
            }
            return anActionArray;
        }

        @NotNull
        protected JBIterable<BasicMetaObject<?>> getCreateTargets(BasicElement element2) {
            JBIterable jBIterable = JBIterable.generate(element2.getMetaObject(), BasicMetaObject::getParent).flatten(e -> JBIterable.of((Object[])e.children));
            if (jBIterable == null) {
                CreateObjectGroup.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/actions/DdlActions$CreateObjectGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCreateTargets";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class ModifyObject
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            Set<DbElement> selection;
            if (e == null) {
                ModifyObject.$$$reportNull$$$0(0);
            }
            DbElement single = (selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class)).size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
            BasicElement element2 = ModifyObject.getElement(single);
            boolean visible = element2 != null && this.isAcceptable(element2) && DbImplUtil.canConnectTo(single) && ModifyObject.isSupported(element2);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify(single));
        }

        public static boolean isSupported(@NotNull BasicElement e) {
            if (e == null) {
                ModifyObject.$$$reportNull$$$0(1);
            }
            Dbms dbms = DbImplUtil.getDbms(e);
            ScriptingCapabilities capabilities = ((ScriptGenerator)ScriptGenerators.INSTANCE.forDbms(dbms)).capabilities(e);
            BasicModel model = e.getModel();
            return capabilities.getAlterAnything().get(model == null ? Version.INFINITY : model.getRoot().getServerVersion());
        }

        protected boolean isAcceptable(BasicElement e) {
            return !PublicCreateObjectGroup.isPublic(e.getMetaObject());
        }

        @Contract(value="null->null")
        static BasicElement getElement(DbElement single) {
            BasicElement element2;
            BasicElement basicElement = element2 = single == null ? null : (BasicElement)ObjectUtils.tryCast((Object)single.getDelegate(), BasicElement.class);
            if (element2 == null && single != null && single.getDelegate() instanceof LocalDataSource) {
                BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)((LocalDataSource)single.getDelegate()).getModel(), BasicModel.class);
                element2 = model == null ? null : model.getRoot();
            }
            return element2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            BasicModel model;
            Set<DbElement> selection;
            if (e == null) {
                ModifyObject.$$$reportNull$$$0(2);
            }
            final DbElement single = (selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class)).size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
            final BasicElement element2 = ModifyObject.getElement(single);
            BasicModel basicModel = model = element2 == null ? null : element2.getModel();
            if (model == null) {
                return;
            }
            BasicNamespace current = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.getSearchPathObjectForSwitch(single.getDataSource(), element2), BasicNamespace.class);
            DbObjectEditorFactory.DbObjectEditorBase dialog2 = new DbObjectEditorFactory.DbObjectEditorBase(single.getProject(), single.getDataSource(), ObjectPaths.searchPathOf(current), "Modify"){
                private final DbObjectEditorFactory.DbObjectEditor myEditor;
                private final BasicModModel myTargetModel;
                private final BasicModElement myTargetElement;
                {
                    super(project, dataSource2, searchPath, title);
                    this.myEditor = DbObjectEditorFactory.forDbms(model.getDbms()).createObjectEditor(single.getProject(), element2.getMetaObject());
                    this.myTargetModel = new ModelFactory(new MemoryTextStorage()).createModel(model.getDbms());
                    this.myTargetElement = ModelLightCopier.copy(element2, this.myTargetModel);
                    ScriptingCapabilities capabilities = ScriptGenerators.INSTANCE.byModel(model).capabilities(element2);
                    Version version = model.getRoot().getServerVersion();
                    this.myEditor.enable(p2 -> capabilities.canAlter((BasicMetaProperty<?>)p2).get(version));
                    this.myEditor.initCompletion(model);
                }

                @Override
                protected void reset() {
                    this.myEditor.reset(element2);
                }

                @Override
                protected void apply() {
                    this.myEditor.apply(element2, this.myTargetElement);
                }

                @Override
                protected DbObjectEditorFactory.DbObjectEditor getObjectEditor() {
                    return this.myEditor;
                }

                @Override
                protected ScriptingTaskBuilder createBuilder() {
                    ScriptingAlterTaskBuilder builder = new ScriptingAlterTaskBuilder(model, this.myTargetModel);
                    BasicElement e1 = element2;
                    for (BasicElement e2 = this.myTargetElement; e1 != null && e2 != null; e1 = e1.getParent(), e2 = e2.getParent()) {
                        if (e1.getKind() == ObjectKind.ROOT) continue;
                        builder.getCorrespondence().add(ElementDelta.create(e1, e2));
                    }
                    return builder;
                }
            };
            dialog2.initAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$ModifyObject";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSupported";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CommentOnObjectAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            Set<DbElement> selection;
            if (e == null) {
                CommentOnObjectAction.$$$reportNull$$$0(0);
            }
            DbElement single = (selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class)).size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
            BasicNamedElement element2 = single == null ? null : (BasicNamedElement)ObjectUtils.tryCast((Object)single.getDelegate(), BasicNamedElement.class);
            BasicModel model = element2 == null ? null : element2.getModel();
            boolean visible = model != null && CommentQueryGenerator.canComment(model, element2) && DbImplUtil.canConnectTo(single);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify(single));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            BasicModel model;
            Set<DbElement> selection;
            if (e == null) {
                CommentOnObjectAction.$$$reportNull$$$0(1);
            }
            DbElement single = (selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class)).size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
            final BasicNamedElement element2 = single == null ? null : (BasicNamedElement)ObjectUtils.tryCast((Object)single.getDelegate(), BasicNamedElement.class);
            BasicModel basicModel = model = element2 == null ? null : element2.getModel();
            if (model == null) {
                return;
            }
            BasicNamespace current = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.getSearchPathObjectForSwitch(single.getDataSource(), element2), BasicNamespace.class);
            final CommentQueryGenerator generator = new CommentQueryGenerator(single.getProject(), model, element2);
            generator.setCurrentNamespace(current);
            new DatabaseScriptDialog(single.getProject(), single.getDataSource(), ObjectPaths.searchPathOf(current), DatabaseBundle.message((String)"action.DatabaseView.Ddl.CommentOnObject.title", (Object[])new Object[0])){
                private FieldPanel myComment;

                @Override
                protected ScriptingTask getTask() {
                    return generator.createTask(null);
                }

                @Override
                protected void settingsChanged(ScriptingOptions options) {
                    generator.setOptions(options);
                    this.regenerate();
                }

                @Override
                protected JComponent createCenterPanel() {
                    this.myComment = new FieldPanel(DatabaseBundle.message((String)"action.DatabaseView.Ddl.CommentOnObject.comment", (Object[])new Object[0]), null, null, () -> this.regenerate());
                    this.myComment.setText(element2.getComment());
                    return new BorderLayoutPanel().addToTop((Component)this.myComment).addToCenter((Component)Objects.requireNonNull(super.createCenterPanel()));
                }

                private void regenerate() {
                    this.generateText(this.myComment.getText());
                }

                @Nullable
                public JComponent getPreferredFocusedComponent() {
                    return this.myComment.getTextField();
                }

                private void generateText(String comment) {
                    this.updateText(generator.generate(comment));
                }

                @Override
                protected void fillContext(@NotNull DatabaseRefactoringHandler handler) {
                    if (handler == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    handler.getContext().include(element2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/actions/DdlActions$CommentOnObjectAction$1", "fillContext"));
                }
            }.initAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$CommentOnObjectAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DropForeignKeyAction
    extends DumbAwareAction {
        public DropForeignKeyAction() {
            super(DatabaseIcons.BlueKey);
        }

        public void update(@NotNull AnActionEvent e) {
            Set<DbColumn> selection;
            if (e == null) {
                DropForeignKeyAction.$$$reportNull$$$0(0);
            }
            DbColumn column = (selection = DatabaseView.getSelectedElements(e.getDataContext(), DbColumn.class)).size() == 1 ? (DbColumn)ContainerUtil.getFirstItem(selection) : null;
            boolean visible = column != null && SchemaEditor.forDbms(DbImplUtil.getDbms((DbElement)column)).getDbEditorCaps().getTableEditorCaps(true).getForeignKeys().canRemove() && DbImplUtil.canConnectTo((DbElement)column) && DasUtil.isForeign((DasColumn)column);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)column));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbColumn column;
            DbTable table;
            if (e == null) {
                DropForeignKeyAction.$$$reportNull$$$0(1);
            }
            DbTable dbTable = table = (column = (DbColumn)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbColumn.class))) == null ? null : column.getTable();
            if (table == null) {
                return;
            }
            DbDataSource dataSource2 = column.getDataSource();
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.unwrap((DasObject)DbImplUtil.getSearchPathObjectForSwitch((DbElement)column)), BasicNamespace.class);
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class);
            if (model == null) {
                return;
            }
            DropQueryGenerator generator = new DropQueryGenerator(dataSource2.getProject(), model);
            JBIterable selection = JBIterable.from((Iterable)DasUtil.getForeignKeys((DasTable)table)).filter(key -> DasUtil.containsName((String)column.getName(), (MultiRef)key.getColumnsRef())).filter(DbElement.class);
            generator.setItems((Iterable<BasicElement>)DeleteProvider2.getElements((JBIterable<DbElement>)selection));
            generator.setCurrentNamespace(namespace);
            DeleteProvider2.showDialogAndRun(dataSource2.getProject(), dataSource2, ObjectPaths.searchPathOf(namespace), (JBIterable<DbElement>)selection, generator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$DropForeignKeyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DropPrimaryKeyAction
    extends DumbAwareAction {
        public DropPrimaryKeyAction() {
            super(DatabaseIcons.GoldKey);
        }

        public void update(@NotNull AnActionEvent e) {
            Set<DbElement> selection;
            if (e == null) {
                DropPrimaryKeyAction.$$$reportNull$$$0(0);
            }
            DbElement element2 = (selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class)).size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
            DbTable tableElement = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)element2, DbTable.class, (boolean)false);
            boolean visible = tableElement != null && SchemaEditor.forDbms(DbImplUtil.getDbms((DbElement)tableElement)).getDbEditorCaps().getTableEditorCaps(true).getPrimaryKey().canRemove() && DbImplUtil.canConnectTo((DbElement)tableElement) && DasUtil.getPrimaryKey((DasTable)tableElement) != null;
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)tableElement));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement element2;
            DbTable table;
            if (e == null) {
                DropPrimaryKeyAction.$$$reportNull$$$0(1);
            }
            if ((table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)(element2 = (DbElement)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class))), DbTable.class, (boolean)false)) == null) {
                return;
            }
            DbTableKey pk = (DbTableKey)DasUtil.getPrimaryKey((DasTable)table);
            if (pk == null) {
                return;
            }
            DbDataSource dataSource2 = pk.getDataSource();
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.unwrap((DasObject)DbImplUtil.getSearchPathObjectForSwitch((DbElement)pk)), BasicNamespace.class);
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class);
            if (model == null) {
                return;
            }
            DropQueryGenerator generator = new DropQueryGenerator(dataSource2.getProject(), model);
            JBIterable selection = JBIterable.of((Object)pk);
            generator.setItems((Iterable<BasicElement>)DeleteProvider2.getElements((JBIterable<DbElement>)selection));
            generator.setCurrentNamespace(namespace);
            DeleteProvider2.showDialogAndRun(dataSource2.getProject(), dataSource2, ObjectPaths.searchPathOf(namespace), (JBIterable<DbElement>)selection, generator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$DropPrimaryKeyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddForeignKeyAction
    extends DumbAwareAction {
        public AddForeignKeyAction() {
            super(DatabaseIcons.BlueKey);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddForeignKeyAction.$$$reportNull$$$0(0);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            boolean visible = pair.first != null && DbImplUtil.canConnectTo((DbElement)pair.first) && DbRefactoringDialogHelper.canAddForeignKey(new DatabaseEditorContext((DbElement)pair.first, null), (DasTable)pair.first);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)pair.first));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddForeignKeyAction.$$$reportNull$$$0(1);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            DbTable table = (DbTable)pair.first;
            BasicTable basicTable = (BasicTable)ObjectUtils.tryCast((Object)(table == null ? null : table.getDelegate()), BasicTable.class);
            Set columns = JBIterable.from((Iterable)((Iterable)pair.second)).transform(DbElement::getDelegate).filter(BasicTableColumn.class).toSet();
            if (basicTable == null) {
                return;
            }
            DbTableDialog dialog2 = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext((DbElement)table, null), basicTable);
            DbRefactoringDialogHelper.bootstrap(dialog2, (Computable<? extends DeObject>)((Computable)() -> {
                Ref newFk = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((ForeignKeyModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog2.getEditor()).getTableModel()).withForeignKey(""))).addRefRefs((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog2, columns))).addAndGet((Ref<DeForeignKey>)newFk)).leave()).commit();
                return (DeObject)newFk.get();
            })).finishAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddForeignKeyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddPrimaryKeyAction
    extends DumbAwareAction {
        public AddPrimaryKeyAction() {
            super(DatabaseIcons.GoldKey);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddPrimaryKeyAction.$$$reportNull$$$0(0);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            boolean visible = pair.first != null && DbImplUtil.canConnectTo((DbElement)pair.first) && DasUtil.getPrimaryKey((DasTable)((DasTable)pair.first)) == null && DbRefactoringDialogHelper.canAddPrimaryKey(new DatabaseEditorContext((DbElement)pair.first, null), (DasTable)pair.first) && ((DbTable)pair.first).getKind() == ObjectKind.TABLE && !((Set)pair.second).isEmpty();
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)pair.first));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddPrimaryKeyAction.$$$reportNull$$$0(1);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            DbTable table = (DbTable)pair.first;
            BasicTable basicTable = (BasicTable)ObjectUtils.tryCast((Object)(table == null ? null : table.getDelegate()), BasicTable.class);
            Set columns = JBIterable.from((Iterable)((Iterable)pair.second)).transform(DbElement::getDelegate).filter(BasicTableColumn.class).toSet();
            if (basicTable == null) {
                return;
            }
            DbTableDialog dialog2 = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext((DbElement)table, null), basicTable);
            DbRefactoringDialogHelper.bootstrap(dialog2, (Computable<? extends DeObject>)((Computable)() -> {
                Ref newKey = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableKeyModelBuilder)((TableModelBuilder.TableKeyModelBuilder)((KeyModelBuilder)((Object)((TableModelBuilder.TableKeyModelBuilder)TableModelBuilder.modify(((DatabaseTableEditor)dialog2.getEditor()).getTableModel()).withKey("")).setPrimary(true, false))).addColumns((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog2, columns), DasIndex.Sorting.NONE)).addAndGet((Ref<DeTableKey>)newKey)).leave()).commit();
                return (DeObject)newKey.get();
            })).finishAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddPrimaryKeyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BatchAddIndicesAction
    extends DumbAwareAction {
        public BatchAddIndicesAction() {
            super(DatabaseIcons.Index);
        }

        @NotNull
        private static List<DbColumn> getColumns(@NotNull AnActionEvent e) {
            if (e == null) {
                BatchAddIndicesAction.$$$reportNull$$$0(0);
            }
            Set<DbColumn> columns = DatabaseView.getSelectedElements(e.getDataContext(), DbColumn.class);
            DbDataSource dataSource2 = null;
            for (DbColumn column : columns) {
                if (dataSource2 == null) {
                    dataSource2 = column.getDataSource();
                }
                if (dataSource2 == column.getDataSource()) continue;
                List<DbColumn> list = Collections.emptyList();
                if (list == null) {
                    BatchAddIndicesAction.$$$reportNull$$$0(1);
                }
                return list;
            }
            return new ArrayList<DbColumn>(columns);
        }

        public void update(@NotNull AnActionEvent e) {
            List<DbColumn> columns;
            if (e == null) {
                BatchAddIndicesAction.$$$reportNull$$$0(2);
            }
            boolean visible = (columns = BatchAddIndicesAction.getColumns(e)).size() > 1 && DbImplUtil.canConnectTo((DbElement)columns.get(0)) && DbBatchIndicesDialog.canAddAnything(new DatabaseEditorContext((DbElement)columns.get(0), null), columns);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)columns.get(0)));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<DbColumn> columns;
            List basicColumns;
            if (e == null) {
                BatchAddIndicesAction.$$$reportNull$$$0(3);
            }
            if ((basicColumns = JBIterable.from(columns = BatchAddIndicesAction.getColumns(e)).transform(DbElement::getDelegate).filter(BasicTableColumn.class).toList()).size() < 2) {
                return;
            }
            DbBatchIndicesDialog.newBatchAddIndicesDialog(new DatabaseEditorContext((DbElement)columns.get(0), null), basicColumns).finishAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$BatchAddIndicesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$BatchAddIndicesAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumns";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AddIndexAction
    extends DumbAwareAction {
        public AddIndexAction() {
            super(DatabaseIcons.Index);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddIndexAction.$$$reportNull$$$0(0);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            boolean visible = pair.first != null && DbImplUtil.canConnectTo((DbElement)pair.first) && DbRefactoringDialogHelper.canAddIndex(new DatabaseEditorContext((DbElement)pair.first, null), (DasTable)pair.first) && !DbImplUtil.getDbms((DbElement)pair.first).isMongo();
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)pair.first));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddIndexAction.$$$reportNull$$$0(1);
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            DbTable table = (DbTable)pair.first;
            BasicTable basicTable = (BasicTable)ObjectUtils.tryCast((Object)(table == null ? null : table.getDelegate()), BasicTable.class);
            Set columns = JBIterable.from((Iterable)((Iterable)pair.second)).transform(DbElement::getDelegate).filter(BasicTableColumn.class).toSet();
            if (basicTable == null) {
                return;
            }
            DbTableDialog dialog2 = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext((DbElement)table, null), basicTable);
            DbRefactoringDialogHelper.bootstrap(dialog2, (Computable<? extends DeObject>)((Computable)() -> {
                Ref newIndex = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((IndexModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog2.getEditor()).getTableModel()).withIndex(""))).addColumns((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog2, columns), DasIndex.Sorting.NONE)).addAndGet((Ref<DeIndex>)newIndex)).leave()).commit();
                return (DeObject)newIndex.get();
            })).finishAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddIndexAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddColumnAction
    extends DumbAwareAction {
        public AddColumnAction() {
            super(DatabaseIcons.Col);
        }

        public void update(@NotNull AnActionEvent e) {
            JBIterable<DbElement> selection;
            DbElement element2;
            DbTable table;
            if (e == null) {
                AddColumnAction.$$$reportNull$$$0(0);
            }
            boolean visible = (table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)(element2 = (DbElement)(selection = DatabaseView.getSelectedElementsNoGroups(e.getDataContext(), true)).single()), DbTable.class, (boolean)false)) != null && SchemaEditor.forDbms(DbImplUtil.getDbms((DbElement)table)).getDbEditorCaps().getTableEditorCaps(true).getColumns().canAdd() && DbImplUtil.canConnectTo((DbElement)table) && DbRefactoringDialogHelper.canAddColumn(new DatabaseEditorContext((DbElement)table, null), (DasTable)table) && table.getKind() == ObjectKind.TABLE;
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)table));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement element2;
            DbTable table;
            if (e == null) {
                AddColumnAction.$$$reportNull$$$0(1);
            }
            if ((table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)(element2 = (DbElement)DatabaseView.getSelectedElementsNoGroups(e.getDataContext(), true).single()), DbTable.class, (boolean)false)) == null) {
                return;
            }
            AddColumnAction.perform(table, (DbColumn)PsiTreeUtil.getParentOfType((PsiElement)element2, DbColumn.class, (boolean)false), "new_column");
        }

        public static void perform(@NotNull DbTable table, @Nullable DbColumn anchor, @NotNull String colName) {
            BasicTable basicTable;
            if (table == null) {
                AddColumnAction.$$$reportNull$$$0(2);
            }
            if (colName == null) {
                AddColumnAction.$$$reportNull$$$0(3);
            }
            if ((basicTable = (BasicTable)ObjectUtils.tryCast((Object)table.getDelegate(), BasicTable.class)) == null) {
                return;
            }
            DbTableDialog dialog2 = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext((DbElement)table, null), basicTable);
            DbRefactoringDialogHelper.bootstrap(dialog2, (Computable<? extends DeObject>)((Computable)() -> {
                List<DeColumn> columns = ((DatabaseTableEditor)dialog2.getEditor()).getTable().columns;
                int idx = columns.size();
                if (anchor != null && ((DatabaseTableEditor)dialog2.getEditor()).getCaps().getColumns().canReorder()) {
                    String name = anchor.getName();
                    idx = 0;
                    for (DeColumn column : columns) {
                        ++idx;
                        if (!column.name.equals(name)) continue;
                        break;
                    }
                }
                Ref newCol = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableColumnModelBuilder)((TableModelBuilder.TableColumnModelBuilder)TableModelBuilder.modify(((DatabaseTableEditor)dialog2.getEditor()).getTableModel()).withColumn(colName)).addAndGet((Ref<DeColumn>)newCol, idx)).leave()).commit();
                return (DeObject)newCol.get();
            })).finishAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddColumnAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class BatchModifyIndicesAction
    extends DumbAwareAction {
        @NotNull
        private static List<DbIndex> getIndicesToModify(@NotNull AnActionEvent e) {
            if (e == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(0);
            }
            JBIterable elements = DatabaseView.getSelectedElementsNoGroups(e.getDataContext(), false).filter(DbIndex.class);
            DbDataSource dataSource2 = null;
            for (DbIndex element2 : elements) {
                DbDataSource currentSource = element2.getDataSource();
                if (dataSource2 == null) {
                    dataSource2 = currentSource;
                }
                if (dataSource2 == currentSource) continue;
                List<DbIndex> list = Collections.emptyList();
                if (list == null) {
                    BatchModifyIndicesAction.$$$reportNull$$$0(1);
                }
                return list;
            }
            List list = elements.toList();
            if (list == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(2);
            }
            return list;
        }

        public void update(@NotNull AnActionEvent e) {
            List<DbIndex> indices;
            if (e == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(3);
            }
            boolean visible = (indices = BatchModifyIndicesAction.getIndicesToModify(e)).size() > 1 && DbImplUtil.canConnectTo((DbElement)indices.get(0)) && DbBatchIndicesDialog.canModifyAnything(new DatabaseEditorContext((DbElement)indices.get(0), null), indices);
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify((DbElement)indices.get(0)));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<DbIndex> indices;
            if (e == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(4);
            }
            if ((indices = BatchModifyIndicesAction.getIndicesToModify(e)).size() < 2) {
                return;
            }
            BatchModifyIndicesAction.showModifyIndicesDialogAndRun(indices);
        }

        public static void showModifyIndicesDialogAndRun(@NotNull List<DbIndex> indices) {
            if (indices == null) {
                BatchModifyIndicesAction.$$$reportNull$$$0(5);
            }
            List basicIndices = JBIterable.from(indices).transform(DbElement::getDelegate).filter(BasicIndex.class).toList();
            DbBatchIndicesDialog.newBatchModifyIndicesDialog(new DatabaseEditorContext((DbElement)indices.get(0), null), basicIndices).finishAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$BatchModifyIndicesAction";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indices";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$BatchModifyIndicesAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndicesToModify";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getIndicesToModify";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "showModifyIndicesDialogAndRun";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AddTableAction
    extends DumbAwareAction {
        public AddTableAction() {
            super(DatabaseIcons.Table);
        }

        public void update(@NotNull AnActionEvent e) {
            DbElement element2;
            DbElement parent2;
            if (e == null) {
                AddTableAction.$$$reportNull$$$0(0);
            }
            boolean visible = (parent2 = (DbElement)DbImplUtil.getTopSingleNamespace((DasObject)(element2 = AddTableAction.getElement(e)))) != null && parent2.getKind() == ObjectKind.SCHEMA && DbImplUtil.canConnectTo(parent2) && !DbImplUtil.getDbms(element2).isMongo();
            e.getPresentation().setVisible(visible);
            e.getPresentation().setEnabled(visible && DbImplUtil.canModify(parent2) && AddTableAction.canDoAnything(element2));
        }

        private static boolean canDoAnything(DbElement element2) {
            return SchemaEditor.forDbms(DbImplUtil.getDbms(element2)).getDbEditorCaps().getTableEditorCaps(false).canDoAnything();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement element2;
            if (e == null) {
                AddTableAction.$$$reportNull$$$0(1);
            }
            if ((element2 = AddTableAction.getElement(e)) == null) {
                return;
            }
            DasNamespace namespace = DbImplUtil.getTopSingleNamespace((DasObject)element2);
            Pair<BasicElement, DatabaseEditorContext> info = DatabaseObjectRefactoring.prepareForEditing((PsiElement)((DbNamespaceImpl)namespace), (DasObject)namespace);
            if (info == null || !(info.first instanceof BasicSchema)) {
                return;
            }
            AddTableAction.showAddTableDialogAndRun((BasicSchema)info.first, (DatabaseEditorContext)info.second, "table_name", ContainerUtil.emptyList());
        }

        @Nullable
        private static DbElement getElement(@NotNull AnActionEvent e) {
            if (e == null) {
                AddTableAction.$$$reportNull$$$0(2);
            }
            return (DbElement)DatabaseView.getSelectedElementsNoGroups(e.getDataContext(), true).first();
        }

        public static void showAddTableDialogAndRun(@Nullable BasicSchema schema, @Nullable DatabaseEditorContext context, @NotNull String defaultName, @NotNull Collection<String> columnNames) {
            if (defaultName == null) {
                AddTableAction.$$$reportNull$$$0(3);
            }
            if (columnNames == null) {
                AddTableAction.$$$reportNull$$$0(4);
            }
            if (context != null) {
                DbRefactoringDialogHelper.newAddTableDialog(context, schema, defaultName, columnNames).finishAndShow();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnNames";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/DdlActions$AddTableAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getElement";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showAddTableDialogAndRun";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DeleteProvider2
    implements DeleteProvider,
    TitledHandler {
        public String getActionTitle() {
            return DatabaseBundle.message((String)"action.DatabaseView.DropAction.text", (Object[])new Object[0]);
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            BasicModel model;
            Project project;
            if (dataContext == null) {
                DeleteProvider2.$$$reportNull$$$0(0);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return false;
            }
            JBIterable<DbElement> selection = DatabaseView.getSelectedElementsNoGroups(dataContext, false);
            if (selection.isEmpty() || !selection.filter(DbDataSource.class).isEmpty()) {
                return false;
            }
            DbElement any = (DbElement)selection.iterator().next();
            DbDataSource dataSource2 = any == null ? null : any.getDataSource();
            BasicModel basicModel = model = dataSource2 == null ? null : (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class);
            if (model == null || !DbImplUtil.canConnectToAndModify((DbElement)dataSource2)) {
                return false;
            }
            for (DbElement e : selection) {
                if (!e.isWritable()) {
                    return false;
                }
                if (dataSource2.equals(e.getDataSource())) continue;
                return false;
            }
            return DropQueryGenerator.canDeleteAnything(model, DeleteProvider2.getElements(selection));
        }

        @NotNull
        public static JBIterable<BasicElement> getElements(JBIterable<DbElement> selection) {
            JBIterable jBIterable = selection.filter(e -> !DataImporter.isBusy(e)).transform(DbElement::getDelegate).filter(BasicElement.class);
            if (jBIterable == null) {
                DeleteProvider2.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DeleteProvider2.$$$reportNull$$$0(2);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return;
            }
            JBIterable<DbElement> selection = DatabaseView.getSelectedElementsNoGroups(dataContext, false);
            DbElement first2 = (DbElement)selection.first();
            if (first2 == null) {
                return;
            }
            DbDataSource dataSource2 = first2.getDataSource();
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.unwrap((DasObject)DbImplUtil.getSearchPathObjectForSwitch(first2)), BasicNamespace.class);
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)dataSource2.getModel(), BasicModel.class);
            if (model == null) {
                return;
            }
            DropQueryGenerator generator = new DropQueryGenerator(project, model);
            generator.setItems((Iterable<BasicElement>)DeleteProvider2.getElements(selection));
            while (namespace != null && generator.getItems().contains(namespace)) {
                namespace = (BasicNamespace)ObjectUtils.tryCast((Object)namespace.getParent(), BasicNamespace.class);
            }
            generator.setCurrentNamespace(namespace);
            DeleteProvider2.showDialogAndRun(project, dataSource2, ObjectPaths.searchPathOf(namespace), selection, generator);
        }

        public static void showDialogAndRun(final @NotNull Project project, final @NotNull DbDataSource dataSource2, @Nullable SearchPath searchPath, final @NotNull JBIterable<DbElement> selection, final @NotNull DropQueryGenerator generator) {
            if (project == null) {
                DeleteProvider2.$$$reportNull$$$0(3);
            }
            if (dataSource2 == null) {
                DeleteProvider2.$$$reportNull$$$0(4);
            }
            if (selection == null) {
                DeleteProvider2.$$$reportNull$$$0(5);
            }
            if (generator == null) {
                DeleteProvider2.$$$reportNull$$$0(6);
            }
            DatabaseScriptDialog dialog2 = new DatabaseScriptDialog(project, dataSource2, searchPath, DatabaseBundle.message((String)"ddl.actions.confirm.drop", (Object[])new Object[0])){

                @Override
                protected void init() {
                    super.init();
                    this.generate();
                }

                @Override
                protected ScriptingTask getTask() {
                    return generator.createTask(null);
                }

                @Override
                protected void settingsChanged(ScriptingOptions options) {
                    generator.setOptions(options);
                    this.generate();
                }

                private void generate() {
                    CompositeText text2 = generator.generate().getScript();
                    try {
                        ObjectPath first2 = ObjectPaths.of((DasObject)ContainerUtil.getFirstItem(generator.getItems()));
                        String comment = first2.getDisplayName() + (generator.getItems().size() > 1 ? " +" + (generator.getItems().size() - 1) : "");
                        text2 = DbSrcMigration.formatCompositeText(project, DbSqlUtil.getSqlDialect((DbElement)dataSource2), comment, text2);
                    }
                    catch (Error | RuntimeException e) {
                        Logger.getInstance(DdlActions.class).warn(e);
                    }
                    String query = text2.getText().toString();
                    this.updateText(query);
                }

                @Override
                protected void fillContext(@NotNull DatabaseRefactoringHandler handler) {
                    if (handler == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    LoaderContext context = handler.getContext();
                    for (DbElement element2 : selection) {
                        if (element2 instanceof DbTableChild) {
                            DbTable table = ((DbTableChild)element2).getTable();
                            context.include((DbElement)table);
                            for (DasForeignKey fk : DasUtil.getForeignKeys((DasTable)table)) {
                                context.include((DasObject)fk.getRefTable());
                            }
                        }
                        context.include(element2);
                    }
                    if (DatabaseSettings.getSettings().trackNamespaces) {
                        ArrayList<ObjectPath> toRemove = new ArrayList<ObjectPath>();
                        generator.fillNamespacesToRemove(toRemove);
                        for (ObjectPath pair : toRemove) {
                            context.getScopeUpdater().toRemove(pair);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/actions/DdlActions$DeleteProvider2$1", "fillContext"));
                }
            };
            dialog2.initAndShow();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/DdlActions$DeleteProvider2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selection";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "generator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/DdlActions$DeleteProvider2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "canDeleteElement";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteElement";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "showDialogAndRun";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DeleteProvider1
    implements DeleteProvider,
    TitledHandler {
        public String getActionTitle() {
            return DatabaseBundle.message((String)"ddl.actions.remove", (Object[])new Object[0]);
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DeleteProvider1.$$$reportNull$$$0(0);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return false;
            }
            JBIterable selection = JBIterable.from(DatabaseView.getSelectedElements(dataContext, DbElement.class));
            if (selection.filter(DbDataSource.class).size() != selection.size()) {
                return false;
            }
            return !selection.isEmpty();
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            Project project;
            if (dataContext == null) {
                DeleteProvider1.$$$reportNull$$$0(1);
            }
            if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return;
            }
            JBIterable selection = JBIterable.from(DatabaseView.getSelectedElements(dataContext, DbDataSource.class));
            DdlActions.deleteDataSources(project, selection.toSet());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/database/actions/DdlActions$DeleteProvider1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDeleteElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

