/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.BarContainer;
import com.intellij.ui.mac.touchbar.BuildUtils;
import com.intellij.ui.mac.touchbar.ItemListener;
import com.intellij.ui.mac.touchbar.ItemsContainer;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.NSTLibrary;
import com.intellij.ui.mac.touchbar.SpacingItem;
import com.intellij.ui.mac.touchbar.StatsCounters;
import com.intellij.ui.mac.touchbar.TBItem;
import com.intellij.ui.mac.touchbar.TBItemAnActionButton;
import com.intellij.ui.mac.touchbar.TBItemButton;
import com.intellij.ui.mac.touchbar.TBItemGroup;
import com.intellij.ui.mac.touchbar.TBItemScrubber;
import com.intellij.ui.mac.touchbar.TouchBarStats;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Robot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

final class TouchBar
implements NSTLibrary.ItemCreator {
    private static final boolean ourAsyncUpdate = Registry.is((String)"actionSystem.update.touchbar.actions.asynchronously");
    private static final boolean ourUseCached = Registry.is((String)"actionSystem.update.touchbar.actions.use.cached");
    private static final boolean ourCollectStats = Boolean.getBoolean("touchbar.collect.stats");
    private static final Logger LOG = Logger.getInstance(TouchBar.class);
    @Nullable
    private final TouchBarStats myStats;
    @NotNull
    private final ItemsContainer myItems;
    private final ItemListener myItemListener;
    private final PresentationFactory myFactory;
    private final TBItemButton myCustomEsc;
    private final ActionGroup myActionGroup;
    @Nullable
    private final String mySkipSubgroupsPrefix;
    @NotNull
    private final Updater myUpdateTimer;
    private CancellablePromise<List<AnAction>> myLastUpdate;
    private String[] myVisibleIds;
    private long myStartShowNs;
    private long myLastUpdateNs;
    private ID myNativePeer;
    private String myDefaultOptionalContextName;
    private BarContainer myBarContainer;
    private final Object myHideReleaseLock;
    private Future<?> myLastUpdateNativePeers;
    private boolean myAllowSkipSlowUpdates;
    @NotNull
    private final Map<AnAction, TBItemAnActionButton> myActionButtonPool;
    @NotNull
    private final LinkedList<TBItemGroup> myGroupPool;
    public static final TouchBar EMPTY = new TouchBar();

    private TouchBar() {
        this.myFactory = new PresentationFactory();
        this.myUpdateTimer = new Updater(500);
        this.myStartShowNs = 0L;
        this.myLastUpdateNs = 0L;
        this.myHideReleaseLock = new Object();
        this.myAllowSkipSlowUpdates = false;
        this.myActionButtonPool = new HashMap<AnAction, TBItemAnActionButton>();
        this.myGroupPool = new LinkedList();
        this.myItems = new ItemsContainer("EMPTY_STUB_TOUCHBAR");
        this.myCustomEsc = null;
        this.myNativePeer = ID.NIL;
        this.myItemListener = null;
        this.myActionGroup = null;
        this.mySkipSubgroupsPrefix = null;
        this.myStats = null;
    }

    TouchBar(@NotNull String touchbarName, boolean replaceEsc) {
        if (touchbarName == null) {
            TouchBar.$$$reportNull$$$0(0);
        }
        this(touchbarName, replaceEsc, false, false, null, null);
    }

    TouchBar(@NotNull String touchbarName, boolean replaceEsc, boolean autoClose, boolean emulateESC, @Nullable ActionGroup actionGroup, @Nullable String skipSubgroupsPrefix) {
        if (touchbarName == null) {
            TouchBar.$$$reportNull$$$0(1);
        }
        this.myFactory = new PresentationFactory();
        this.myUpdateTimer = new Updater(500);
        this.myStartShowNs = 0L;
        this.myLastUpdateNs = 0L;
        this.myHideReleaseLock = new Object();
        this.myAllowSkipSlowUpdates = false;
        this.myActionButtonPool = new HashMap<AnAction, TBItemAnActionButton>();
        this.myGroupPool = new LinkedList();
        this.myItemListener = autoClose ? (src, evcode) -> this._closeSelf() : null;
        this.myActionGroup = actionGroup;
        this.mySkipSubgroupsPrefix = skipSubgroupsPrefix;
        this.myStats = ourCollectStats ? TouchBarStats.getStats(touchbarName) : null;
        this.myItems = new ItemsContainer(touchbarName);
        if (replaceEsc) {
            Icon ic2 = IconLoader.getIcon((String)"/mac/touchbar/popoverClose_dark.svg");
            this.myCustomEsc = new TBItemButton(this.myItemListener, null).setIcon(ic2).setWidth(64).setTransparentBg(true).setAction(() -> {
                this._closeSelf();
                if (emulateESC) {
                    try {
                        Robot robot = new Robot();
                        robot.keyPress(27);
                        robot.keyRelease(27);
                    }
                    catch (AWTException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }, false, null);
            this.myCustomEsc.setUid(touchbarName + "_custom_esc_button");
        } else {
            this.myCustomEsc = null;
        }
        this.myNativePeer = NST.createTouchBar(touchbarName, this, this.myCustomEsc != null ? this.myCustomEsc.getUid() : null);
    }

    @NotNull
    PresentationFactory getFactory() {
        PresentationFactory presentationFactory = this.myFactory;
        if (presentationFactory == null) {
            TouchBar.$$$reportNull$$$0(2);
        }
        return presentationFactory;
    }

    void setAllowSkipSlowUpdates(boolean allowSkipSlowUpdates) {
        this.myAllowSkipSlowUpdates = allowSkipSlowUpdates;
    }

    @Nullable
    TouchBarStats getStats() {
        return this.myStats;
    }

    boolean isManualClose() {
        return this.myCustomEsc != null;
    }

    boolean isEmpty() {
        return this.isEmptyActionGroup() && (this.myItems.isEmpty() || !this.myItems.anyMatchDeep(item -> item != null && !(item instanceof SpacingItem)));
    }

    public String toString() {
        return this.myItems.toString() + "_" + this.myNativePeer;
    }

    @Override
    public ID createItem(@NotNull String uid) {
        if (uid == null) {
            TouchBar.$$$reportNull$$$0(3);
        }
        long startNs = this.myStats != null ? System.nanoTime() : 0L;
        ID result2 = this.createItemImpl(uid);
        if (this.myStats != null) {
            this.myStats.incrementCounter(StatsCounters.itemsCreationDurationNs, System.nanoTime() - startNs);
        }
        return result2;
    }

    private ID createItemImpl(@NotNull String uid) {
        if (uid == null) {
            TouchBar.$$$reportNull$$$0(4);
        }
        if (this.myCustomEsc != null && this.myCustomEsc.getUid().equals(uid)) {
            return this.myCustomEsc.getNativePeer();
        }
        TBItem item = this.myItems.findItem(uid);
        if (item == null) {
            LOG.error("can't find TBItem with uid '" + uid + "'");
            return ID.NIL;
        }
        return item.getNativePeer();
    }

    ID getNativePeer() {
        return this.myNativePeer;
    }

    @NotNull
    ItemsContainer getItemsContainer() {
        ItemsContainer itemsContainer = this.myItems;
        if (itemsContainer == null) {
            TouchBar.$$$reportNull$$$0(5);
        }
        return itemsContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        Object object = this.myHideReleaseLock;
        synchronized (object) {
            long startNs = this.myStats != null ? System.nanoTime() : 0L;
            this.myItems.releaseAll();
            if (!this.myNativePeer.equals((Object)ID.NIL)) {
                NST.releaseTouchBar(this.myNativePeer);
                this.myNativePeer = ID.NIL;
            }
            this.myUpdateTimer.stop();
            this.myActionButtonPool.forEach((act, item) -> item.releaseNativePeer());
            this.myActionButtonPool.clear();
            this.myGroupPool.forEach(item -> item.releaseNativePeer());
            this.myGroupPool.clear();
            if (this.myStats != null) {
                this.myStats.incrementCounter(StatsCounters.touchbarReleaseDurationNs, System.nanoTime() - startNs);
            }
        }
    }

    void softClear() {
        this.myItems.softClear(this.myActionButtonPool, this.myGroupPool);
    }

    @NotNull
    TBItemButton addButton() {
        @NotNull TBItemButton butt = new TBItemButton(this.myItemListener, this.myStats != null ? this.myStats.getActionStats("simple_button") : null);
        this.myItems.addItem(butt);
        TBItemButton tBItemButton = butt;
        if (tBItemButton == null) {
            TouchBar.$$$reportNull$$$0(6);
        }
        return tBItemButton;
    }

    @NotNull
    TBItemAnActionButton addAnActionButton(@NotNull AnAction act) {
        if (act == null) {
            TouchBar.$$$reportNull$$$0(7);
        }
        TBItemAnActionButton tBItemAnActionButton = this.addAnActionButton(act, null);
        if (tBItemAnActionButton == null) {
            TouchBar.$$$reportNull$$$0(8);
        }
        return tBItemAnActionButton;
    }

    @NotNull
    TBItemAnActionButton addAnActionButton(@NotNull AnAction act, @Nullable TBItem positionAnchor) {
        if (act == null) {
            TouchBar.$$$reportNull$$$0(9);
        }
        @NotNull TBItemAnActionButton butt = this.createActionButton(act);
        this.myItems.addItem((TBItem)butt, positionAnchor);
        TBItemAnActionButton tBItemAnActionButton = butt;
        if (tBItemAnActionButton == null) {
            TouchBar.$$$reportNull$$$0(10);
        }
        return tBItemAnActionButton;
    }

    @NotNull
    TBItemGroup addGroup() {
        @NotNull TBItemGroup group = this.createGroup();
        this.myItems.addItem(group);
        TBItemGroup tBItemGroup = group;
        if (tBItemGroup == null) {
            TouchBar.$$$reportNull$$$0(11);
        }
        return tBItemGroup;
    }

    @NotNull
    TBItemScrubber addScrubber() {
        int defaultScrubberWidth = 500;
        @NotNull TBItemScrubber scrub = new TBItemScrubber(this.myItemListener, this.myStats, 500);
        this.myItems.addItem(scrub);
        TBItemScrubber tBItemScrubber = scrub;
        if (tBItemScrubber == null) {
            TouchBar.$$$reportNull$$$0(12);
        }
        return tBItemScrubber;
    }

    void addSpacing(boolean large) {
        this.myItems.addSpacing(large);
    }

    void addFlexibleSpacing() {
        this.myItems.addFlexibleSpacing();
    }

    void setBarContainer(BarContainer barContainer) {
        this.myBarContainer = barContainer;
    }

    void setDefaultOptionalContextName(@NotNull String defaultCtxName) {
        if (defaultCtxName == null) {
            TouchBar.$$$reportNull$$$0(13);
        }
        this.myDefaultOptionalContextName = defaultCtxName;
    }

    void setOptionalContextItems(@NotNull ActionGroup actions, final @NotNull String contextName) {
        if (actions == null) {
            TouchBar.$$$reportNull$$$0(14);
        }
        if (contextName == null) {
            TouchBar.$$$reportNull$$$0(15);
        }
        this.myItems.releaseItems(tbi -> contextName.equals(tbi.myOptionalContextName));
        BuildUtils.addActionGroupButtons(this, actions, null, new BuildUtils.Customizer(){

            @Override
            public void process(@NotNull BuildUtils.INodeInfo ni, @NotNull TBItemAnActionButton butt) {
                if (ni == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (butt == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.process(ni, butt);
                butt.myOptionalContextName = contextName;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "ni";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "butt";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/mac/touchbar/TouchBar$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.selectVisibleItemsToShow();
    }

    void removeOptionalContextItems(@NotNull String contextName) {
        if (contextName == null) {
            TouchBar.$$$reportNull$$$0(16);
        }
        this.myItems.releaseItems(tbi -> contextName.equals(tbi.myOptionalContextName));
        this.selectVisibleItemsToShow();
    }

    void setOptionalContextVisible(@Nullable String contextName) {
        @Nullable String ctx = contextName == null ? this.myDefaultOptionalContextName : contextName;
        boolean[] visibilityChanged = new boolean[]{false};
        this.myItems.forEachDeep(tbi -> {
            if (tbi.myOptionalContextName == null) {
                return;
            }
            boolean newVisible = tbi.myOptionalContextName.equals(ctx);
            if (tbi.myIsVisible != newVisible) {
                if (tbi instanceof TBItemAnActionButton) {
                    ((TBItemAnActionButton)tbi).setAutoVisibility(newVisible);
                }
                tbi.myIsVisible = newVisible;
                visibilityChanged[0] = true;
            }
        });
        if (visibilityChanged[0]) {
            this.selectVisibleItemsToShow();
        }
    }

    void selectVisibleItemsToShow() {
        if (this.myItems.isEmpty()) {
            if (this.myVisibleIds != null && this.myVisibleIds.length > 0) {
                NST.selectItemsToShow(this.myNativePeer, null, 0);
            }
            this.myVisibleIds = null;
            return;
        }
        Object[] ids = this.myItems.getVisibleIds();
        if (Arrays.equals(ids, this.myVisibleIds)) {
            return;
        }
        this.myVisibleIds = ids;
        NST.selectItemsToShow(this.myNativePeer, (String[])ids, ids.length);
    }

    void setPrincipal(@NotNull TBItem item) {
        if (item == null) {
            TouchBar.$$$reportNull$$$0(17);
        }
        NST.setPrincipal(this.myNativePeer, item.getUid());
    }

    void onBeforeShow() {
        this.myStartShowNs = System.nanoTime();
        this.myUpdateTimer.start();
        this.updateActionItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onHide() {
        Object object = this.myHideReleaseLock;
        synchronized (object) {
            if (this.myLastUpdate != null) {
                this.myLastUpdate.cancel();
                this.myLastUpdate = null;
            }
            this.myUpdateTimer.stop();
        }
    }

    void forEachDeep(Consumer<? super TBItem> proc) {
        this.myItems.forEachDeep(proc);
    }

    private void _applyPresentationChanges(List<AnAction> actions) {
        long startNs;
        long l = startNs = this.myStats != null ? System.nanoTime() : 0L;
        if (this.myLastUpdateNativePeers != null && !this.myLastUpdateNativePeers.isDone()) {
            this.myLastUpdateNativePeers.cancel(false);
        }
        ArrayList toUpdate = new ArrayList();
        this.forEachDeep(tbitem -> {
            if (!(tbitem instanceof TBItemAnActionButton)) {
                return;
            }
            TBItemAnActionButton item = (TBItemAnActionButton)tbitem;
            @NotNull Presentation presentation = this.myFactory.getPresentation(item.getAnAction());
            item.updateVisibility(presentation);
            item.updateView(presentation);
            @Nullable TBItemButton.Updater updater2 = item.getNativePeerUpdater();
            if (updater2 != null) {
                toUpdate.add(updater2);
            }
        });
        Runnable updateAllNativePeers = () -> {
            toUpdate.forEach(item -> item.prepareUpdateData());
            Object object = this.myHideReleaseLock;
            synchronized (object) {
                if (!this.myUpdateTimer.isRunning() || this.myNativePeer.equals((Object)ID.NIL)) {
                    return;
                }
                toUpdate.forEach(item -> item.updateNativePeer());
            }
        };
        @NotNull Application app = ApplicationManager.getApplication();
        this.myLastUpdateNativePeers = app.executeOnPooledThread(() -> app.runReadAction(updateAllNativePeers));
        this.selectVisibleItemsToShow();
        if (this.myStats != null) {
            this.myStats.incrementCounter(StatsCounters.applyPresentaionChangesDurationNs, System.nanoTime() - startNs);
        }
    }

    void updateActionItems() {
        if (!this.myUpdateTimer.isRunning()) {
            return;
        }
        long timeNs = System.nanoTime();
        long elapsedFromStartShowNs = timeNs - this.myStartShowNs;
        this.myLastUpdateNs = timeNs;
        int delayMillis = 500;
        long delayNanos = TimeUnit.MILLISECONDS.toNanos(delayMillis);
        if (ourUseCached && elapsedFromStartShowNs < delayNanos) {
            if (this.myStats != null) {
                this.myStats.incrementCounter(StatsCounters.forceUseCached);
            }
            Timer t = new Timer(delayMillis, e -> {
                if (System.nanoTime() - this.myLastUpdateNs > delayNanos) {
                    if (this.myStats != null) {
                        this.myStats.incrementCounter(StatsCounters.forceCachedDelayedUpdateCount);
                    }
                    this.updateActionItems();
                }
            });
            t.setRepeats(false);
            t.start();
            return;
        }
        if (this.myActionGroup != null) {
            DataContext dctx = DataManager.getInstance().getDataContext(BuildUtils.getCurrentFocusComponent());
            BuildUtils.GroupVisitor visitor = new BuildUtils.GroupVisitor(this, this.mySkipSubgroupsPrefix, null, this.myStats, this.myAllowSkipSlowUpdates);
            if (ourAsyncUpdate) {
                if (this.myLastUpdate != null) {
                    this.myLastUpdate.cancel();
                }
                this.myLastUpdate = Utils.expandActionGroupAsync(LaterInvocator.isInModalContext(), this.myActionGroup, this.myFactory, dctx, "TouchBarGeneral", visitor);
                this.myLastUpdate.onSuccess(actions -> this._applyPresentationChanges((List<AnAction>)actions)).onProcessed(__ -> {
                    this.myLastUpdate = null;
                });
            } else {
                List<AnAction> actions2 = Utils.expandActionGroupWithTimeout(LaterInvocator.isInModalContext(), this.myActionGroup, this.myFactory, dctx, "TouchBarGeneral", visitor, Registry.intValue((String)"actionSystem.update.touchbar.timeout.ms"));
                this._applyPresentationChanges(actions2);
            }
        } else {
            this.forEachDeep(tbitem -> {
                if (!(tbitem instanceof TBItemAnActionButton)) {
                    return;
                }
                long startNs = this.myStats != null ? System.nanoTime() : 0L;
                @NotNull TBItemAnActionButton item = (TBItemAnActionButton)tbitem;
                @NotNull Presentation presentation = this.myFactory.getPresentation(item.getAnAction());
                Component component2 = item.getComponent();
                DataContext dctx = DataManager.getInstance().getDataContext(component2);
                ActionManagerEx am = ActionManagerEx.getInstanceEx();
                AnActionEvent e = new AnActionEvent(null, dctx, "TouchBarGeneral", presentation, (ActionManager)am, 0);
                try {
                    ActionUtil.performFastUpdate((boolean)false, (AnAction)item.getAnAction(), (AnActionEvent)e, (boolean)false);
                }
                catch (IndexNotReadyException e1) {
                    presentation.setEnabledAndVisible(false);
                }
                if (this.myStats != null) {
                    this.myStats.getActionStats(item.getActionId()).onUpdate(System.nanoTime() - startNs);
                }
            });
            this._applyPresentationChanges(null);
        }
        if (this.myStats != null) {
            this.myStats.incrementCounter(StatsCounters.totalUpdateDurationNs, System.nanoTime() - timeNs);
        }
    }

    private void _closeSelf() {
        if (this.myBarContainer == null) {
            LOG.error("can't perform _closeSelf for touchbar '" + this.toString() + "' because parent container wasn't set");
            return;
        }
        TouchBarsManager.hideContainer(this.myBarContainer);
    }

    @NotNull
    TBItemAnActionButton createActionButton(@NotNull AnAction acaction) {
        if (acaction == null) {
            TouchBar.$$$reportNull$$$0(18);
        }
        TouchBarStats.AnActionStats stats = this.myStats == null ? null : this.myStats.getActionStats(BuildUtils.getActionId(acaction));
        TBItemAnActionButton cached = this.myActionButtonPool.remove(acaction);
        return cached != null ? cached : new TBItemAnActionButton(this.myItemListener, acaction, stats);
    }

    @NotNull
    TBItemGroup createGroup() {
        TBItemGroup tBItemGroup = this.myGroupPool.isEmpty() ? new TBItemGroup(this.myItems.toString(), this.myItemListener) : this.myGroupPool.poll();
        if (tBItemGroup == null) {
            TouchBar.$$$reportNull$$$0(19);
        }
        return tBItemGroup;
    }

    private boolean isEmptyActionGroup() {
        if (this.myActionGroup == null) {
            return true;
        }
        AnAction[] actions = this.myActionGroup.getChildren(null);
        if (actions.length == 0) {
            return true;
        }
        for (AnAction act : actions) {
            if (act instanceof Separator) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "touchbarName";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/TouchBar";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uid";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "act";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCtxName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acaction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/TouchBar";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsContainer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addButton";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "addAnActionButton";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addGroup";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addScrubber";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 19: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createItem";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createItemImpl";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addAnActionButton";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultOptionalContextName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setOptionalContextItems";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeOptionalContextItems";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setPrincipal";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createActionButton";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class Updater {
        private final int myDelay;
        @Nullable
        private TimerListener myTimerImpl;

        Updater(int delay) {
            this.myDelay = delay;
        }

        void start() {
            if (this.myTimerImpl != null) {
                this.stop();
            }
            this.myTimerImpl = new TimerListener(){

                public ModalityState getModalityState() {
                    return ModalityState.current();
                }

                public void run() {
                    TouchBar.this.updateActionItems();
                }
            };
            ActionManager.getInstance().addTransparentTimerListener(this.myDelay, this.myTimerImpl);
        }

        void stop() {
            if (this.myTimerImpl == null) {
                return;
            }
            ActionManager.getInstance().removeTransparentTimerListener(this.myTimerImpl);
            this.myTimerImpl = null;
        }

        boolean isRunning() {
            return this.myTimerImpl != null;
        }
    }
}

