/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.configurable;

import com.intellij.ide.IdeBundle;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.ui.ItemRemovable;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

final class PatternsTableModel
extends AbstractTableModel
implements ItemRemovable {
    private final String[] ourColumnNames = new String[]{IdeBundle.message((String)"column.todo.patterns.icon", (Object[])new Object[0]), IdeBundle.message((String)"column.todo.patterns.case.sensitive", (Object[])new Object[0]), IdeBundle.message((String)"column.todo.patterns.pattern", (Object[])new Object[0])};
    private final Class[] ourColumnClasses = new Class[]{Icon.class, Boolean.class, String.class};
    private final List<? extends TodoPattern> myPatterns;

    PatternsTableModel(List<? extends TodoPattern> patterns) {
        this.myPatterns = patterns;
    }

    @Override
    public String getColumnName(int column) {
        return this.ourColumnNames[column];
    }

    public Class getColumnClass(int column) {
        return this.ourColumnClasses[column];
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.myPatterns.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    @Override
    public Object getValueAt(int row, int column) {
        TodoPattern pattern = this.myPatterns.get(row);
        switch (column) {
            case 0: {
                return pattern.getAttributes().getIcon();
            }
            case 1: {
                return pattern.isCaseSensitive() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return pattern.getPatternString();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void setValueAt(Object value2, int row, int column) {
        TodoPattern pattern = this.myPatterns.get(row);
        switch (column) {
            case 0: {
                pattern.getAttributes().setIcon((Icon)value2);
                break;
            }
            case 1: {
                pattern.setCaseSensitive(((Boolean)value2).booleanValue());
                break;
            }
            case 2: {
                pattern.setPatternString(((String)value2).trim());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void removeRow(int index) {
        this.myPatterns.remove(index);
        this.fireTableRowsDeleted(index, index);
    }
}

