/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics;

import com.intellij.featureStatistics.ApplicabilityFilter;
import com.intellij.featureStatistics.CompletionStatistics;
import com.intellij.featureStatistics.CumulativeStatistics;
import com.intellij.featureStatistics.FeatureDescriptor;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.ProductivityFeaturesRegistry;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FeatureUsageStatistics", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED)})
public final class FeatureUsageTrackerImpl
extends FeatureUsageTracker
implements PersistentStateComponent<Element> {
    private static final int HOUR = 3600000;
    private static final long DAY = 86400000L;
    private long FIRST_RUN_TIME = 0L;
    private CompletionStatistics myCompletionStats = new CompletionStatistics();
    private CumulativeStatistics myFixesStats = new CumulativeStatistics();
    boolean HAVE_BEEN_SHOWN = false;
    @NonNls
    private static final String FEATURE_TAG = "feature";
    @NonNls
    private static final String ATT_SHOW_IN_OTHER = "show-in-other";
    @NonNls
    private static final String ATT_SHOW_IN_COMPILATION = "show-in-compilation";
    @NonNls
    private static final String ATT_ID = "id";
    @NonNls
    private static final String ATT_FIRST_RUN = "first-run";
    @NonNls
    private static final String COMPLETION_STATS_TAG = "completionStatsTag";
    @NonNls
    private static final String FIXES_STATS_TAG = "fixesStatsTag";
    @NonNls
    private static final String ATT_HAVE_BEEN_SHOWN = "have-been-shown";

    @Override
    public boolean isToBeShown(String featureId, Project project) {
        return this.isToBeShown(featureId, project, 86400000L);
    }

    private boolean isToBeShown(String featureId, Project project, long timeUnit) {
        ApplicabilityFilter[] filters;
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        FeatureDescriptor descriptor2 = registry.getFeatureDescriptor(featureId);
        if (descriptor2 == null || !descriptor2.isUnused()) {
            return false;
        }
        String[] dependencyFeatures = descriptor2.getDependencyFeatures();
        boolean locked = dependencyFeatures.length > 0;
        for (int i = 0; locked && i < dependencyFeatures.length; ++i) {
            if (registry.getFeatureDescriptor(dependencyFeatures[i]).isUnused()) continue;
            locked = false;
        }
        if (locked) {
            return false;
        }
        for (ApplicabilityFilter filter2 : filters = registry.getMatchingFilters(featureId)) {
            if (filter2.isApplicable(featureId, project)) continue;
            return false;
        }
        long current2 = System.currentTimeMillis();
        long succesive_interval = (long)descriptor2.getDaysBetweenSuccessiveShowUps() * timeUnit + (long)descriptor2.getShownCount() * 2L;
        long firstShowUpInterval = (long)descriptor2.getDaysBeforeFirstShowUp() * timeUnit;
        long lastTimeUsed = descriptor2.getLastTimeUsed();
        long lastTimeShown = descriptor2.getLastTimeShown();
        return lastTimeShown == 0L && firstShowUpInterval + this.getFirstRunTime() < current2 || lastTimeShown > 0L && current2 - lastTimeShown > succesive_interval && current2 - lastTimeUsed > succesive_interval;
    }

    @Override
    public boolean isToBeAdvertisedInLookup(@NonNls String featureId, Project project) {
        FeatureDescriptor descriptor2 = ProductivityFeaturesRegistry.getInstance().getFeatureDescriptor(featureId);
        if (descriptor2 != null && System.currentTimeMillis() - descriptor2.getLastTimeUsed() > 864000000L) {
            return true;
        }
        return this.isToBeShown(featureId, project, 3600000L);
    }

    @NotNull
    public CompletionStatistics getCompletionStatistics() {
        CompletionStatistics completionStatistics = this.myCompletionStats;
        if (completionStatistics == null) {
            FeatureUsageTrackerImpl.$$$reportNull$$$0(0);
        }
        return completionStatistics;
    }

    public CumulativeStatistics getFixesStats() {
        return this.myFixesStats;
    }

    public long getFirstRunTime() {
        if (this.FIRST_RUN_TIME == 0L) {
            this.FIRST_RUN_TIME = System.currentTimeMillis();
        }
        return this.FIRST_RUN_TIME;
    }

    public void loadState(@NotNull Element element2) {
        Element fStats;
        ProductivityFeaturesRegistry featureRegistry;
        List featuresList;
        if (element2 == null) {
            FeatureUsageTrackerImpl.$$$reportNull$$$0(1);
        }
        if (!(featuresList = element2.getChildren(FEATURE_TAG)).isEmpty() && (featureRegistry = ProductivityFeaturesRegistry.getInstance()) != null) {
            for (Element itemElement : featuresList) {
                FeatureDescriptor descriptor2 = featureRegistry.getFeatureDescriptor(itemElement.getAttributeValue(ATT_ID));
                if (descriptor2 == null) continue;
                descriptor2.readStatistics(itemElement);
            }
        }
        try {
            this.FIRST_RUN_TIME = Long.parseLong(element2.getAttributeValue(ATT_FIRST_RUN));
        }
        catch (NumberFormatException e) {
            this.FIRST_RUN_TIME = 0L;
        }
        Element stats = element2.getChild(COMPLETION_STATS_TAG);
        if (stats != null) {
            this.myCompletionStats = (CompletionStatistics)XmlSerializer.deserialize((Element)stats, CompletionStatistics.class);
        }
        if ((fStats = element2.getChild(FIXES_STATS_TAG)) != null) {
            this.myFixesStats = (CumulativeStatistics)XmlSerializer.deserialize((Element)fStats, CumulativeStatistics.class);
        }
        this.HAVE_BEEN_SHOWN = Boolean.valueOf(element2.getAttributeValue(ATT_HAVE_BEEN_SHOWN));
        this.SHOW_IN_OTHER_PROGRESS = Boolean.valueOf(element2.getAttributeValue(ATT_SHOW_IN_OTHER, Boolean.toString(true)));
        this.SHOW_IN_COMPILATION_PROGRESS = Boolean.valueOf(element2.getAttributeValue(ATT_SHOW_IN_COMPILATION, Boolean.toString(true)));
    }

    public Element getState() {
        Element element2 = new Element("state");
        ProductivityFeaturesRegistry registry = ProductivityFeaturesRegistry.getInstance();
        if (registry != null) {
            Set ids = registry.getFeatureIds();
            for (String id2 : ids) {
                Element featureElement = new Element(FEATURE_TAG);
                featureElement.setAttribute(ATT_ID, id2);
                FeatureDescriptor descriptor2 = registry.getFeatureDescriptor(id2);
                descriptor2.writeStatistics(featureElement);
                element2.addContent(featureElement);
            }
        }
        Element statsTag = new Element(COMPLETION_STATS_TAG);
        XmlSerializer.serializeInto((Object)this.myCompletionStats, (Element)statsTag);
        element2.addContent(statsTag);
        Element fstatsTag = new Element(FIXES_STATS_TAG);
        XmlSerializer.serializeInto((Object)this.myFixesStats, (Element)fstatsTag);
        element2.addContent(fstatsTag);
        element2.setAttribute(ATT_FIRST_RUN, String.valueOf(this.getFirstRunTime()));
        element2.setAttribute(ATT_HAVE_BEEN_SHOWN, String.valueOf(this.HAVE_BEEN_SHOWN));
        element2.setAttribute(ATT_SHOW_IN_OTHER, String.valueOf(this.SHOW_IN_OTHER_PROGRESS));
        element2.setAttribute(ATT_SHOW_IN_COMPILATION, String.valueOf(this.SHOW_IN_COMPILATION_PROGRESS));
        return element2;
    }

    @Override
    public void triggerFeatureUsed(@NotNull String featureId) {
        ProductivityFeaturesRegistry registry;
        FeatureDescriptor descriptor2;
        if (featureId == null) {
            FeatureUsageTrackerImpl.$$$reportNull$$$0(2);
        }
        FeatureDescriptor featureDescriptor = descriptor2 = (registry = ProductivityFeaturesRegistry.getInstance()) == null ? null : registry.getFeatureDescriptor(featureId);
        if (descriptor2 == null) {
            return;
        }
        descriptor2.triggerUsed();
        Class provider = descriptor2.getProvider();
        String id2 = provider == null || PluginInfoDetectorKt.getPluginInfo((Class)provider).isDevelopedByJetBrains() ? descriptor2.getId() : "third.party";
        String group = descriptor2.getGroupId();
        FeatureUsageData data2 = new FeatureUsageData().addData(ATT_ID, id2).addData("group", StringUtil.notNullize((String)group, (String)"unknown"));
        FUCounterUsageLogger.getInstance().logEvent("productivity", "feature.used", data2);
    }

    @Override
    public void triggerFeatureShown(String featureId) {
        FeatureDescriptor descriptor2 = ProductivityFeaturesRegistry.getInstance().getFeatureDescriptor(featureId);
        if (descriptor2 != null) {
            descriptor2.triggerShown();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/featureStatistics/FeatureUsageTrackerImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionStatistics";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/featureStatistics/FeatureUsageTrackerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "triggerFeatureUsed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ProductivityUtilValidator
    extends CustomWhiteListRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "productivity".equals(ruleId) || "productivity_group".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context) {
            ProductivityFeaturesRegistry registry;
            FeatureDescriptor descriptor2;
            String group;
            if (data2 == null) {
                ProductivityUtilValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ProductivityUtilValidator.$$$reportNull$$$0(1);
            }
            if (ProductivityUtilValidator.isThirdPartyValue((String)data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    ProductivityUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            String id2 = this.getEventDataField(context, FeatureUsageTrackerImpl.ATT_ID);
            if (ProductivityUtilValidator.isValid(data2, id2, group = this.getEventDataField(context, "group")) && (descriptor2 = (registry = ProductivityFeaturesRegistry.getInstance()).getFeatureDescriptor(id2)) != null) {
                String actualGroup = descriptor2.getGroupId();
                if (StringUtil.equals((CharSequence)group, (CharSequence)"unknown") || StringUtil.equals((CharSequence)group, (CharSequence)actualGroup)) {
                    Class provider = descriptor2.getProvider();
                    PluginInfo info = provider == null ? PluginInfoDetectorKt.getPlatformPlugin() : PluginInfoDetectorKt.getPluginInfo((Class)provider);
                    context.setPluginInfo(info);
                    ValidationResultType validationResultType = info.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                    if (validationResultType == null) {
                        ProductivityUtilValidator.$$$reportNull$$$0(3);
                    }
                    return validationResultType;
                }
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                ProductivityUtilValidator.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        private static boolean isValid(@NotNull String data2, String id2, String group) {
            if (data2 == null) {
                ProductivityUtilValidator.$$$reportNull$$$0(5);
            }
            return id2 != null && group != null && (data2.equals(id2) || data2.equals(group));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/featureStatistics/FeatureUsageTrackerImpl$ProductivityUtilValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/featureStatistics/FeatureUsageTrackerImpl$ProductivityUtilValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isValid";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

