/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.RunDashboardGroup;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.tree.GroupingNode;
import com.intellij.execution.dashboard.tree.RunDashboardGroupImpl;
import com.intellij.execution.services.ServiceViewContributorDeleteProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class RunDashboardServiceViewDeleteProvider
implements ServiceViewContributorDeleteProvider {
    private DeleteProvider myDelegate;

    RunDashboardServiceViewDeleteProvider() {
    }

    @Override
    public void setFallbackProvider(DeleteProvider provider) {
        this.myDelegate = provider;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        List<ConfigurationType> targetTypes;
        if (dataContext == null) {
            RunDashboardServiceViewDeleteProvider.$$$reportNull$$$0(0);
        }
        if ((targetTypes = RunDashboardServiceViewDeleteProvider.getTargetTypes(dataContext)).isEmpty()) {
            if (this.myDelegate != null) {
                this.myDelegate.deleteElement(dataContext);
            }
            return;
        }
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        ConfigurationType onlyType = (ConfigurationType)ContainerUtil.getOnlyItem(targetTypes);
        String message = onlyType != null ? ExecutionBundle.message((String)"run.dashboard.remove.run.configuration.type.confirmation", (Object[])new Object[]{onlyType.getDisplayName()}) : ExecutionBundle.message((String)"run.dashboard.remove.run.configuration.types.confirmation", (Object[])new Object[]{targetTypes.size()});
        if (Messages.showYesNoDialog((Project)project, (String)message, (String)IdeBundle.message((String)"button.remove", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.remove", (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getWarningIcon(), null) != 0) {
            return;
        }
        RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)project);
        HashSet types = new HashSet(runDashboardManager.getTypes());
        for (ConfigurationType type : targetTypes) {
            types.remove(type.getId());
        }
        runDashboardManager.setTypes(types);
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        List<ConfigurationType> targetTypes;
        if (dataContext == null) {
            RunDashboardServiceViewDeleteProvider.$$$reportNull$$$0(1);
        }
        return !(targetTypes = RunDashboardServiceViewDeleteProvider.getTargetTypes(dataContext)).isEmpty() || this.myDelegate != null && this.myDelegate.canDeleteElement(dataContext);
    }

    private static List<ConfigurationType> getTargetTypes(DataContext dataContext) {
        Object[] items = (Object[])dataContext.getData(PlatformDataKeys.SELECTED_ITEMS);
        if (items == null) {
            return Collections.emptyList();
        }
        SmartList types = new SmartList();
        for (Object item : items) {
            RunDashboardGroup group;
            ConfigurationType type;
            if (!(item instanceof GroupingNode) || (type = (ConfigurationType)ObjectUtils.tryCast(((RunDashboardGroupImpl)(group = ((GroupingNode)((Object)item)).getGroup())).getValue(), ConfigurationType.class)) == null) {
                return Collections.emptyList();
            }
            types.add(type);
        }
        return types;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "dataContext";
        objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardServiceViewDeleteProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canDeleteElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

