/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ComponentManagerSettings;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.ModuleSettings;
import com.intellij.conversion.ProjectSettings;
import com.intellij.conversion.WorkspaceSettings;
import com.intellij.conversion.impl.ArtifactsSettingsImpl;
import com.intellij.conversion.impl.ComponentManagerSettingsImpl;
import com.intellij.conversion.impl.ConversionRunner;
import com.intellij.conversion.impl.ModuleSettingsImpl;
import com.intellij.conversion.impl.ProjectLibrariesSettingsImpl;
import com.intellij.conversion.impl.ProjectSettingsImpl;
import com.intellij.conversion.impl.RunManagerSettingsImpl;
import com.intellij.conversion.impl.SettingsXmlFile;
import com.intellij.conversion.impl.WorkspaceSettingsImpl;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.ide.impl.convert.ProjectFileVersionState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectLongHashMap;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

public final class ConversionContextImpl
implements ConversionContext {
    private static final Logger LOG = Logger.getInstance(ConversionContextImpl.class);
    private static final String PROJECT_FILE_VERSION_COMPONENT_NAME = "ProjectFileVersion";
    private final Map<Path, SettingsXmlFile> mySettingsFiles;
    private final StorageScheme myStorageScheme;
    private final Path myProjectBaseDir;
    private final Path myProjectFile;
    private final Path myWorkspaceFile;
    private volatile List<Path> myModuleFiles;
    private ProjectSettingsImpl myProjectSettings;
    private WorkspaceSettingsImpl myWorkspaceSettings;
    private final List<Path> myNonExistingModuleFiles;
    private final Map<Path, ModuleSettingsImpl> myFile2ModuleSettings;
    private final Map<String, ModuleSettingsImpl> myName2ModuleSettings;
    private RunManagerSettingsImpl myRunManagerSettings;
    private Path mySettingsBaseDir;
    private ComponentManagerSettings myCompilerManagerSettings;
    private ComponentManagerSettings myProjectRootManagerSettings;
    private ComponentManagerSettingsImpl myModulesSettings;
    private ProjectLibrariesSettingsImpl myProjectLibrariesSettings;
    private ArtifactsSettingsImpl myArtifactsSettings;
    private ComponentManagerSettings myProjectFileVersionSettings;
    private final Set<String> myPerformedConversionIds;
    private final Path myModuleListFile;

    public ConversionContextImpl(@NotNull Path projectPath) {
        if (projectPath == null) {
            ConversionContextImpl.$$$reportNull$$$0(0);
        }
        this.mySettingsFiles = new HashMap<Path, SettingsXmlFile>();
        this.myNonExistingModuleFiles = new ArrayList<Path>();
        this.myFile2ModuleSettings = new HashMap<Path, ModuleSettingsImpl>();
        this.myName2ModuleSettings = new HashMap<String, ModuleSettingsImpl>();
        this.myProjectFile = projectPath;
        if (Files.isDirectory(this.myProjectFile, new LinkOption[0])) {
            this.myStorageScheme = StorageScheme.DIRECTORY_BASED;
            this.myProjectBaseDir = this.myProjectFile;
            this.mySettingsBaseDir = this.myProjectBaseDir.toAbsolutePath().resolve(".idea");
            this.myModuleListFile = this.mySettingsBaseDir.resolve("modules.xml");
            this.myWorkspaceFile = this.mySettingsBaseDir.resolve("workspace.xml");
        } else {
            this.myStorageScheme = StorageScheme.DEFAULT;
            this.myProjectBaseDir = this.myProjectFile.getParent();
            this.myModuleListFile = this.myProjectFile;
            this.myWorkspaceFile = Paths.get(StringUtil.trimEnd((String)projectPath.toString(), (String)".ipr") + ".iws", new String[0]);
        }
        this.myPerformedConversionIds = this.loadPerformedConversionIds();
    }

    @NotNull
    public ObjectLongHashMap<String> getAllProjectFiles() throws CannotConvertException {
        if (this.myStorageScheme == StorageScheme.DEFAULT) {
            List<Path> moduleFiles2 = this.getModulePaths();
            ObjectLongHashMap totalResult = new ObjectLongHashMap(moduleFiles2.size() + 2);
            ConversionContextImpl.addLastModifiedTme(this.myProjectFile, (ObjectLongHashMap<String>)totalResult);
            ConversionContextImpl.addLastModifiedTme(this.myWorkspaceFile, (ObjectLongHashMap<String>)totalResult);
            ConversionContextImpl.addLastModifiedTime(moduleFiles2, (ObjectLongHashMap<String>)totalResult);
            ObjectLongHashMap objectLongHashMap = totalResult;
            if (objectLongHashMap == null) {
                ConversionContextImpl.$$$reportNull$$$0(1);
            }
            return objectLongHashMap;
        }
        Path dotIdeaDirectory = this.mySettingsBaseDir;
        List<Path> dirs = Arrays.asList(dotIdeaDirectory, dotIdeaDirectory.resolve("libraries"), dotIdeaDirectory.resolve("artifacts"), dotIdeaDirectory.resolve("runConfigurations"));
        ExecutorService executor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Conversion: Project Files Collecting", (int)3, (boolean)false);
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(dirs.size() + 1);
        futures.add(CompletableFuture.supplyAsync(() -> {
            List<Path> moduleFiles = this.myModuleFiles;
            if (moduleFiles == null) {
                try {
                    moduleFiles = Files.exists(this.myModuleListFile, new LinkOption[0]) ? this.findModuleFiles(JDOMUtil.load((Path)this.myModuleListFile)) : Collections.emptyList();
                }
                catch (IOException | JDOMException e) {
                    throw new CompletionException(e);
                }
                this.myModuleFiles = moduleFiles;
            }
            return moduleFiles;
        }, executor).thenComposeAsync(moduleFiles -> {
            int moduleCount = moduleFiles.size();
            if (moduleCount < 50) {
                return ConversionContextImpl.computeModuleFilesTimestamp(moduleFiles, executor);
            }
            int secondOffset = moduleCount / 2;
            return ConversionContextImpl.computeModuleFilesTimestamp(moduleFiles.subList(0, secondOffset), executor).thenCombine(ConversionContextImpl.computeModuleFilesTimestamp(moduleFiles.subList(secondOffset, moduleCount), executor), (v1, v2) -> ContainerUtil.concat((List)v1, (List)v2));
        }, (Executor)executor));
        for (Path path : dirs) {
            futures.add(CompletableFuture.supplyAsync(() -> {
                ObjectLongHashMap result2 = new ObjectLongHashMap();
                ConversionContextImpl.addXmlFilesFromDirectory(path, (ObjectLongHashMap<String>)result2);
                return Collections.singletonList(result2);
            }, executor));
        }
        ObjectLongHashMap totalResult = new ObjectLongHashMap();
        try {
            for (CompletableFuture completableFuture : futures) {
                for (ObjectLongHashMap result2 : (List)completableFuture.get()) {
                    totalResult.putAll(result2);
                }
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new CannotConvertException(exception.getMessage(), exception);
        }
        ObjectLongHashMap objectLongHashMap = totalResult;
        if (objectLongHashMap == null) {
            ConversionContextImpl.$$$reportNull$$$0(2);
        }
        return objectLongHashMap;
    }

    @NotNull
    private static CompletableFuture<List<ObjectLongHashMap<String>>> computeModuleFilesTimestamp(@NotNull List<Path> moduleFiles, @NotNull Executor executor) {
        if (moduleFiles == null) {
            ConversionContextImpl.$$$reportNull$$$0(3);
        }
        if (executor == null) {
            ConversionContextImpl.$$$reportNull$$$0(4);
        }
        CompletableFuture<List<ObjectLongHashMap<String>>> completableFuture = CompletableFuture.supplyAsync(() -> {
            ObjectLongHashMap result2 = new ObjectLongHashMap();
            ConversionContextImpl.addLastModifiedTime(moduleFiles, (ObjectLongHashMap<String>)result2);
            return Collections.singletonList(result2);
        }, executor);
        if (completableFuture == null) {
            ConversionContextImpl.$$$reportNull$$$0(5);
        }
        return completableFuture;
    }

    private static void addLastModifiedTime(@NotNull List<Path> moduleFiles, @NotNull ObjectLongHashMap<String> result2) {
        if (moduleFiles == null) {
            ConversionContextImpl.$$$reportNull$$$0(6);
        }
        if (result2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(7);
        }
        for (Path file2 : moduleFiles) {
            ConversionContextImpl.addLastModifiedTme(file2, result2);
        }
    }

    private static void addLastModifiedTme(@NotNull Path file2, @NotNull ObjectLongHashMap<String> files2) {
        FileTime time;
        if (file2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(8);
        }
        if (files2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(9);
        }
        try {
            time = Files.getLastModifiedTime(file2, new LinkOption[0]);
        }
        catch (IOException ignore) {
            return;
        }
        files2.put((Object)file2.toString(), time.toMillis());
    }

    private static void addXmlFilesFromDirectory(@NotNull Path dir, @NotNull ObjectLongHashMap<String> result2) {
        if (dir == null) {
            ConversionContextImpl.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(11);
        }
        try (DirectoryStream<Path> children22 = Files.newDirectoryStream(dir);){
            for (Path child2 : children22) {
                BasicFileAttributes attributes;
                String childPath = child2.toString();
                if (!childPath.endsWith(".xml") || child2.getFileName().toString().startsWith(".")) continue;
                try {
                    attributes = Files.readAttributes(child2, BasicFileAttributes.class, new LinkOption[0]);
                    if (attributes.isDirectory()) {
                    }
                }
                catch (IOException ignore) {}
                continue;
                result2.put((Object)childPath, attributes.lastModifiedTime().toMillis());
            }
        }
        catch (NoSuchFileException | NotDirectoryException children22) {
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public boolean isConversionAlreadyPerformed(ConverterProvider provider) {
        return this.myPerformedConversionIds.contains(provider.getId());
    }

    @Override
    @NotNull
    public File getProjectBaseDir() {
        File file2 = this.myProjectBaseDir.toFile();
        if (file2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(12);
        }
        return file2;
    }

    @Override
    public File[] getModuleFiles() {
        try {
            return (File[])ContainerUtil.map2Array(this.getModulePaths(), File.class, path -> path.toFile());
        }
        catch (CannotConvertException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public List<Path> getModulePaths() throws CannotConvertException {
        List<Path> result2 = this.myModuleFiles;
        if (result2 == null) {
            this.myModuleFiles = result2 = Files.exists(this.myModuleListFile, new LinkOption[0]) ? this.findModuleFiles(JDomConvertingUtil.load(this.myModuleListFile)) : Collections.emptyList();
        }
        List<Path> list2 = result2;
        if (list2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @NotNull
    private List<Path> findModuleFiles(@NotNull Element root) {
        Element modulesManager;
        Element modules;
        if (root == null) {
            ConversionContextImpl.$$$reportNull$$$0(14);
        }
        Element element2 = modules = (modulesManager = JDomSerializationUtil.findComponent((Element)root, (String)"ProjectModuleManager")) == null ? null : modulesManager.getChild("modules");
        if (modules == null) {
            List<Path> list2 = Collections.emptyList();
            if (list2 == null) {
                ConversionContextImpl.$$$reportNull$$$0(15);
            }
            return list2;
        }
        ExpandMacroToPathMap macros = this.createExpandMacroMap();
        ArrayList<Path> files2 = new ArrayList<Path>();
        for (Element module : modules.getChildren("module")) {
            String filePath = module.getAttributeValue("filepath");
            if (filePath == null) continue;
            filePath = macros.substitute(filePath, true);
            files2.add(Paths.get(filePath, new String[0]));
        }
        ArrayList<Path> arrayList = files2;
        if (arrayList == null) {
            ConversionContextImpl.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    public String expandPath(@NotNull String path, @NotNull ModuleSettingsImpl moduleSettings) {
        if (path == null) {
            ConversionContextImpl.$$$reportNull$$$0(17);
        }
        if (moduleSettings == null) {
            ConversionContextImpl.$$$reportNull$$$0(18);
        }
        String string = this.createExpandMacroMap(moduleSettings).substitute(path, true);
        if (string == null) {
            ConversionContextImpl.$$$reportNull$$$0(19);
        }
        return string;
    }

    private ExpandMacroToPathMap createExpandMacroMap(@Nullable ModuleSettingsImpl moduleSettings) {
        ExpandMacroToPathMap map2 = this.createExpandMacroMap();
        if (moduleSettings != null) {
            String modulePath = FileUtil.toSystemIndependentName((String)moduleSettings.getModuleFile().getParentFile().getAbsolutePath());
            map2.addMacroExpand("MODULE_DIR", modulePath);
        }
        return map2;
    }

    @Override
    @NotNull
    public String expandPath(@NotNull String path) {
        if (path == null) {
            ConversionContextImpl.$$$reportNull$$$0(20);
        }
        ExpandMacroToPathMap map2 = this.createExpandMacroMap(null);
        String string = map2.substitute(path, SystemInfo.isFileSystemCaseSensitive);
        if (string == null) {
            ConversionContextImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Override
    @NotNull
    public String collapsePath(@NotNull String path) {
        if (path == null) {
            ConversionContextImpl.$$$reportNull$$$0(22);
        }
        ReplacePathToMacroMap map2 = ConversionContextImpl.createCollapseMacroMap("PROJECT_DIR", this.myProjectBaseDir.toFile());
        String string = map2.substitute(path, SystemInfo.isFileSystemCaseSensitive);
        if (string == null) {
            ConversionContextImpl.$$$reportNull$$$0(23);
        }
        return string;
    }

    public static String collapsePath(@NotNull String path, @NotNull ModuleSettingsImpl moduleSettings) {
        if (path == null) {
            ConversionContextImpl.$$$reportNull$$$0(24);
        }
        if (moduleSettings == null) {
            ConversionContextImpl.$$$reportNull$$$0(25);
        }
        ReplacePathToMacroMap map2 = ConversionContextImpl.createCollapseMacroMap("MODULE_DIR", moduleSettings.getModuleFile().getParentFile());
        return map2.substitute(path, SystemInfo.isFileSystemCaseSensitive);
    }

    private static ReplacePathToMacroMap createCollapseMacroMap(String macroName, File dir) {
        ReplacePathToMacroMap map2 = new ReplacePathToMacroMap();
        map2.addMacroReplacement(FileUtil.toSystemIndependentName((String)dir.getAbsolutePath()), macroName);
        PathMacrosImpl.getInstanceEx().addMacroReplacements(map2);
        return map2;
    }

    @Override
    public Collection<File> getLibraryClassRoots(@NotNull String name, @NotNull String level) {
        if (name == null) {
            ConversionContextImpl.$$$reportNull$$$0(26);
        }
        if (level == null) {
            ConversionContextImpl.$$$reportNull$$$0(27);
        }
        try {
            Element libraryElement = null;
            if ("project".equals(level)) {
                libraryElement = this.findProjectLibraryElement(name);
            } else if ("application".equals(level)) {
                libraryElement = ConversionContextImpl.findGlobalLibraryElement(name);
            }
            if (libraryElement != null) {
                return this.getClassRoots(libraryElement, null);
            }
            return Collections.emptyList();
        }
        catch (CannotConvertException e) {
            return Collections.emptyList();
        }
    }

    @NotNull
    public List<File> getClassRoots(Element libraryElement, @Nullable ModuleSettingsImpl moduleSettings) {
        ArrayList<File> files2 = new ArrayList<File>();
        Element classesChild = libraryElement.getChild("CLASSES");
        if (classesChild != null) {
            ExpandMacroToPathMap pathMap = this.createExpandMacroMap(moduleSettings);
            for (Element root : classesChild.getChildren("root")) {
                String url = root.getAttributeValue("url");
                String path = VfsUtilCore.urlToPath((String)url);
                files2.add(new File(PathUtil.getLocalPath((String)pathMap.substitute(path, true))));
            }
        }
        ArrayList<File> arrayList = files2;
        if (arrayList == null) {
            ConversionContextImpl.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @Override
    public ComponentManagerSettings getCompilerSettings() {
        if (this.myCompilerManagerSettings == null) {
            this.myCompilerManagerSettings = this.createProjectSettings("compiler.xml");
        }
        return this.myCompilerManagerSettings;
    }

    @Override
    public ComponentManagerSettings getProjectRootManagerSettings() {
        if (this.myProjectRootManagerSettings == null) {
            this.myProjectRootManagerSettings = this.createProjectSettings("misc.xml");
        }
        return this.myProjectRootManagerSettings;
    }

    @Override
    public ComponentManagerSettings getModulesSettings() {
        if (this.myModulesSettings == null) {
            this.myModulesSettings = this.createProjectSettings("modules.xml");
        }
        return this.myModulesSettings;
    }

    @Nullable
    public ComponentManagerSettings getProjectFileVersionSettings() {
        if (this.myProjectFileVersionSettings == null) {
            this.myProjectFileVersionSettings = this.createProjectSettings("misc.xml");
        }
        return this.myProjectFileVersionSettings;
    }

    @Override
    @Nullable
    public ComponentManagerSettingsImpl createProjectSettings(@NotNull String fileName) {
        if (fileName == null) {
            ConversionContextImpl.$$$reportNull$$$0(29);
        }
        try {
            Path file2;
            if (this.myStorageScheme == StorageScheme.DEFAULT) {
                file2 = this.myProjectFile;
            } else {
                file2 = this.mySettingsBaseDir.resolve(fileName);
                if (!Files.exists(file2, new LinkOption[0])) {
                    return null;
                }
            }
            return new ComponentManagerSettingsImpl(file2, this);
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @Nullable
    private static Element findGlobalLibraryElement(String name) throws CannotConvertException {
        Element root;
        Element libraryTable;
        File file2 = PathManager.getOptionsFile((String)"applicationLibraries");
        if (file2.exists() && (libraryTable = JDomSerializationUtil.findComponent((Element)(root = JDomConvertingUtil.load(file2.toPath())), (String)"libraryTable")) != null) {
            return ConversionContextImpl.findLibraryInTable(libraryTable, name);
        }
        return null;
    }

    @Nullable
    private Element findProjectLibraryElement(String name) throws CannotConvertException {
        Collection<? extends Element> libraries = this.getProjectLibrariesSettings().getProjectLibraries();
        Condition<Element> filter2 = JDomConvertingUtil.createElementWithAttributeFilter("library", "name", name);
        return (Element)ContainerUtil.find(libraries, filter2);
    }

    @Nullable
    private static Element findLibraryInTable(Element tableElement, String name) {
        Condition<Element> filter2 = JDomConvertingUtil.createElementWithAttributeFilter("library", "name", name);
        return JDomConvertingUtil.findChild(tableElement, filter2);
    }

    private ExpandMacroToPathMap createExpandMacroMap() {
        ExpandMacroToPathMap macros = new ExpandMacroToPathMap();
        String projectDir = FileUtil.toSystemIndependentName((String)this.myProjectBaseDir.toAbsolutePath().toString());
        macros.addMacroExpand("PROJECT_DIR", projectDir);
        PathMacrosImpl.getInstanceEx().addMacroExpands(macros);
        return macros;
    }

    @Override
    public File getSettingsBaseDir() {
        return this.mySettingsBaseDir != null ? this.mySettingsBaseDir.toFile() : null;
    }

    @Override
    @NotNull
    public File getProjectFile() {
        File file2 = this.myProjectFile.toFile();
        if (file2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(30);
        }
        return file2;
    }

    @Override
    public ProjectSettings getProjectSettings() throws CannotConvertException {
        if (this.myProjectSettings == null) {
            this.myProjectSettings = new ProjectSettingsImpl(this.myProjectFile, this);
        }
        return this.myProjectSettings;
    }

    @Override
    public RunManagerSettingsImpl getRunManagerSettings() throws CannotConvertException {
        if (this.myRunManagerSettings == null) {
            if (this.myStorageScheme == StorageScheme.DEFAULT) {
                this.myRunManagerSettings = new RunManagerSettingsImpl(this.myWorkspaceFile, this.myProjectFile, null, this);
            } else {
                File[] files2 = this.mySettingsBaseDir.resolve("runConfigurations").toFile().listFiles(FileFilters.filesWithExtension((String)"xml"));
                this.myRunManagerSettings = new RunManagerSettingsImpl(this.myWorkspaceFile, null, files2, this);
            }
        }
        return this.myRunManagerSettings;
    }

    @Override
    public WorkspaceSettings getWorkspaceSettings() throws CannotConvertException {
        if (this.myWorkspaceSettings == null) {
            this.myWorkspaceSettings = new WorkspaceSettingsImpl(this.myWorkspaceFile, this);
        }
        return this.myWorkspaceSettings;
    }

    @Override
    public ModuleSettings getModuleSettings(@NotNull Path moduleFile) throws CannotConvertException {
        ModuleSettingsImpl settings;
        if (moduleFile == null) {
            ConversionContextImpl.$$$reportNull$$$0(31);
        }
        if ((settings = this.myFile2ModuleSettings.get(moduleFile)) == null) {
            settings = new ModuleSettingsImpl(moduleFile, this);
            this.myFile2ModuleSettings.put(moduleFile, settings);
            this.myName2ModuleSettings.put(settings.getModuleName(), settings);
        }
        return settings;
    }

    @Override
    public ModuleSettings getModuleSettings(@NotNull String moduleName) {
        if (moduleName == null) {
            ConversionContextImpl.$$$reportNull$$$0(32);
        }
        if (!this.myName2ModuleSettings.containsKey(moduleName)) {
            for (Path moduleFile : this.myModuleFiles) {
                try {
                    this.getModuleSettings(moduleFile);
                }
                catch (CannotConvertException cannotConvertException) {}
            }
        }
        return this.myName2ModuleSettings.get(moduleName);
    }

    public List<Path> getNonExistingModuleFiles() {
        return this.myNonExistingModuleFiles;
    }

    @Override
    @NotNull
    public StorageScheme getStorageScheme() {
        StorageScheme storageScheme = this.myStorageScheme;
        if (storageScheme == null) {
            ConversionContextImpl.$$$reportNull$$$0(33);
        }
        return storageScheme;
    }

    public Path getWorkspaceFile() {
        return this.myWorkspaceFile;
    }

    public void saveFiles(Collection<? extends Path> files2, List<? extends ConversionRunner> usedRunners) throws IOException {
        HashSet<String> performedConversions = new HashSet<String>();
        for (ConversionRunner conversionRunner : usedRunners) {
            ConverterProvider provider = conversionRunner.getProvider();
            if (provider.canDetermineIfConversionAlreadyPerformedByProjectFiles()) continue;
            performedConversions.add(provider.getId());
        }
        if (!performedConversions.isEmpty()) {
            performedConversions.addAll(this.myPerformedConversionIds);
            ComponentManagerSettings settings = this.getProjectFileVersionSettings();
            if (settings != null) {
                ArrayList<String> arrayList = new ArrayList<String>(performedConversions);
                Collections.sort(arrayList, String.CASE_INSENSITIVE_ORDER);
                Element element2 = JDomSerializationUtil.findOrCreateComponentElement((Element)settings.getRootElement(), (String)PROJECT_FILE_VERSION_COMPONENT_NAME);
                XmlSerializer.serializeInto((Object)new ProjectFileVersionState(arrayList), (Element)element2);
            }
        }
        for (Path path : files2) {
            SettingsXmlFile xmlFile = this.mySettingsFiles.get(path);
            if (xmlFile == null) continue;
            xmlFile.save();
        }
    }

    @NotNull
    private Set<String> loadPerformedConversionIds() {
        Element componentElement;
        ComponentManagerSettings component2 = this.getProjectFileVersionSettings();
        if (component2 != null && (componentElement = component2.getComponentElement(PROJECT_FILE_VERSION_COMPONENT_NAME)) != null) {
            ProjectFileVersionState state = (ProjectFileVersionState)XmlSerializer.deserialize((Element)componentElement, ProjectFileVersionState.class);
            return new HashSet<String>(state.getPerformedConversionIds());
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            ConversionContextImpl.$$$reportNull$$$0(34);
        }
        return set;
    }

    @NotNull
    public SettingsXmlFile getOrCreateFile(@NotNull Path file2) throws CannotConvertException {
        SettingsXmlFile settingsFile;
        if (file2 == null) {
            ConversionContextImpl.$$$reportNull$$$0(35);
        }
        if ((settingsFile = this.mySettingsFiles.get(file2)) == null) {
            settingsFile = new SettingsXmlFile(file2);
            this.mySettingsFiles.put(file2, settingsFile);
        }
        SettingsXmlFile settingsXmlFile = settingsFile;
        if (settingsXmlFile == null) {
            ConversionContextImpl.$$$reportNull$$$0(36);
        }
        return settingsXmlFile;
    }

    @Override
    public ProjectLibrariesSettingsImpl getProjectLibrariesSettings() throws CannotConvertException {
        if (this.myProjectLibrariesSettings == null) {
            this.myProjectLibrariesSettings = this.myStorageScheme == StorageScheme.DEFAULT ? new ProjectLibrariesSettingsImpl(this.myProjectFile, null, this) : new ProjectLibrariesSettingsImpl(null, this.getSettingsXmlFiles("libraries"), this);
        }
        return this.myProjectLibrariesSettings;
    }

    @Override
    public ArtifactsSettingsImpl getArtifactsSettings() throws CannotConvertException {
        if (this.myArtifactsSettings == null) {
            this.myArtifactsSettings = this.myStorageScheme == StorageScheme.DEFAULT ? new ArtifactsSettingsImpl(this.myProjectFile, null, this) : new ArtifactsSettingsImpl(null, this.getSettingsXmlFiles("artifacts"), this);
        }
        return this.myArtifactsSettings;
    }

    private File @NotNull [] getSettingsXmlFiles(@NotNull String dirName) {
        if (dirName == null) {
            ConversionContextImpl.$$$reportNull$$$0(37);
        }
        Path librariesDir = this.mySettingsBaseDir.resolve(dirName);
        File[] fileArray = (File[])ObjectUtils.notNull((Object)librariesDir.toFile().listFiles(FileFilters.filesWithExtension((String)"xml")), (Object)ArrayUtilRt.EMPTY_FILE_ARRAY);
        if (fileArray == null) {
            ConversionContextImpl.$$$reportNull$$$0(38);
        }
        return fileArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 33: 
            case 34: 
            case 36: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 33: 
            case 34: 
            case 36: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 33: 
            case 34: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/conversion/impl/ConversionContextImpl";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFiles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 17: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSettings";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/conversion/impl/ConversionContextImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProjectFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeModuleFilesTimestamp";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectBaseDir";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulePaths";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findModuleFiles";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "expandPath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "collapsePath";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassRoots";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectFile";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageScheme";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPerformedConversionIds";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateFile";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsXmlFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 33: 
            case 34: 
            case 36: 
            case 38: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeModuleFilesTimestamp";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addLastModifiedTime";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addLastModifiedTme";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addXmlFilesFromDirectory";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findModuleFiles";
                break;
            }
            case 17: 
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "expandPath";
                break;
            }
            case 22: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collapsePath";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryClassRoots";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createProjectSettings";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getModuleSettings";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateFile";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getSettingsXmlFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 28: 
            case 30: 
            case 33: 
            case 34: 
            case 36: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

