/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.fix;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.NullNode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Binds;
import com.intellij.docker.agent.fix.FixedBindParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

@JsonDeserialize(using=FixedDeserializer.class)
public class FixedBinds
extends Binds {
    public FixedBinds(Bind ... binds) {
        super(binds);
    }

    public static class FixedDeserializer
    extends JsonDeserializer<Binds> {
        public Binds deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ArrayList<Bind> binds = new ArrayList<Bind>();
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            Iterator it = node.elements();
            while (it.hasNext()) {
                JsonNode element = (JsonNode)it.next();
                if (element.equals((Object)NullNode.getInstance())) continue;
                binds.add(FixedBindParser.parse(element.asText()));
            }
            return new FixedBinds(binds.toArray(new Bind[0]));
        }
    }
}

