/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecStartCmd;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.command.PullImageCmd;
import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthResponse;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.Event;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.command.ExecCreateCmdImpl;
import com.github.dockerjava.core.command.ExecStartCmdImpl;
import com.github.dockerjava.jaxrs.JerseyDockerCmdExecFactory;
import com.intellij.docker.agent.AgentLogConfigurator;
import com.intellij.docker.agent.AgentLogSettings;
import com.intellij.docker.agent.ApiTaskBase;
import com.intellij.docker.agent.ApiTaskException;
import com.intellij.docker.agent.AuthConfigEx;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentConfig;
import com.intellij.docker.agent.DockerAgentContainerImpl;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.DockerAgentDeployment;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentDeploymentImpl;
import com.intellij.docker.agent.DockerAgentImageBuilderImpl;
import com.intellij.docker.agent.DockerAgentImageImpl;
import com.intellij.docker.agent.DockerAgentLogManager;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.PullImageResultCallbackImpl;
import com.intellij.docker.agent.auth.DockerClientConfigWithCustomAuth;
import com.intellij.docker.agent.event.DockerEventImpl;
import com.intellij.docker.agent.events.DockerEvent;
import com.intellij.docker.agent.fix.FixedDockerCmdExecNettyFactoryCopyImpl;
import com.intellij.docker.agent.progress.PromisingSerializedItemsCallback;
import com.intellij.docker.agent.tty.ResizeContainerCmd;
import com.intellij.docker.agent.tty.ResizeContainerCmdImpl;
import com.intellij.docker.agent.tty.ResizeExecCmd;
import com.intellij.docker.agent.tty.ResizeExecCmdImpl;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class DockerAgentImpl
implements DockerAgent {
    private static final String HTTPS_ERROR_MESSAGE = "https protocol is not supported";
    private static final String REGISTRY_AUTH_SUCCESS = "Login Succeeded";
    private static final String HTTPS_ERROR_MESSAGE_HINT = "<br/>Please check if path to certificates folder is specified and correct.<br/>Please also note, you don't need to specify path to certificates folder if use unsecured http connection on Linux.";
    private static final String HTTP_PROTOCOL_PREFIX = "http://";
    private static final String HTTPS_PROTOCOL_PREFIX = "https://";
    private static final String TCP_PROTOCOL_PREFIX = "tcp://";
    private final DockerAgentLogManager myLogManager = new DockerAgentLogManager.Impl();
    private DockerAgentContext.DockerClientExt myClient;
    private CloudAgentLogger myLogger;
    private CloudAgentErrorHandler myErrorHandler;
    private volatile boolean myIsConnected;
    private AgentEventsListener myEventsListener;
    private AgentLogSettings myLogSettings;
    private static final RemoteApiVersion MAX_DOCKER_JAVA_SUPPORTED = RemoteApiVersion.VERSION_1_40;

    public void setLogSettings(AgentLogSettings settings) {
        this.myLogSettings = settings;
    }

    public void connect(final DockerAgentConfig config, CloudAgentLogger logger, CloudAgentErrorHandler errorHandler) {
        this.myLogger = logger;
        this.myErrorHandler = errorHandler;
        new ApiTaskBase<Void>(errorHandler){

            @Override
            protected Void doPerform() throws ApiTaskException {
                AgentLogConfigurator.configure(DockerAgentImpl.this.myLogSettings);
                RemoteApiVersion remoteApiVersion = RemoteApiVersion.VERSION_1_24;
                try (DockerAgentContext.DockerClientExt clientExtWithOldVersion = DockerClientExtImpl.buildClient(config, remoteApiVersion);){
                    DockerClient realClient = clientExtWithOldVersion.getDockerClient();
                    realClient.pingCmd().exec();
                    Version actualVersion = (Version)realClient.versionCmd().exec();
                    remoteApiVersion = RemoteApiVersion.parseConfig((String)actualVersion.getApiVersion());
                    if (remoteApiVersion.isGreaterOrEqual(MAX_DOCKER_JAVA_SUPPORTED)) {
                        remoteApiVersion = MAX_DOCKER_JAVA_SUPPORTED;
                    }
                }
                catch (ConnectException e) {
                    DockerAgentImpl.this.myLogger.debugEx((Exception)e);
                    throw new ApiTaskException(MessageFormat.format("Cannot connect to the Docker daemon at {0}. Is the docker daemon running?", DockerAgentImpl.getDockerHost(config.getApiUrl())));
                }
                catch (IOException e) {
                    throw new ApiTaskException(e);
                }
                DockerAgentContext.DockerClientExt clientExt = DockerClientExtImpl.buildClient(config, remoteApiVersion);
                clientExt.getDockerClient().pingCmd().exec();
                DockerAgentImpl.this.myClient = clientExt;
                DockerAgentImpl.this.myIsConnected = true;
                return null;
            }

            @Override
            protected void onError(String error) {
                if (error.contains(DockerAgentImpl.HTTPS_ERROR_MESSAGE)) {
                    error = error + DockerAgentImpl.HTTPS_ERROR_MESSAGE_HINT;
                }
                super.onError(error);
            }
        }.perform();
    }

    private static String getDockerHost(String url) {
        if (url == null) {
            return null;
        }
        for (String prefix : new String[]{HTTP_PROTOCOL_PREFIX, HTTPS_PROTOCOL_PREFIX}) {
            if (!url.startsWith(prefix)) continue;
            return TCP_PROTOCOL_PREFIX + url.substring(prefix.length());
        }
        return url;
    }

    private static boolean isTlsVerifyEnabled(String url) {
        return url != null && url.startsWith(HTTPS_PROTOCOL_PREFIX);
    }

    public void disconnect() {
        this.myIsConnected = false;
        this.myLogManager.dispose();
        if (this.myEventsListener != null) {
            this.myEventsListener.close();
            this.myEventsListener = null;
        }
        try {
            this.myClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private DockerClient getDockerClient() {
        return this.myClient.getDockerClient();
    }

    public boolean isConnected() {
        return this.myIsConnected;
    }

    public void attachEventListener(@NotNull DockerEvent.Listener listener) {
        if (listener == null) {
            DockerAgentImpl.$$$reportNull$$$0(0);
        }
        assert (this.myEventsListener == null);
        this.myEventsListener = new AgentEventsListener(this.myLogger, listener);
        this.getDockerClient().eventsCmd().exec((ResultCallback)this.myEventsListener);
    }

    public DockerAgentApplication[] getApplications() {
        return (DockerAgentApplication[])new ApplicationsApiTaskBase(){

            @Override
            protected void collectApplications(List<DockerAgentApplication> result) {
                DockerAgentImpl.this.collectContainers(result);
                DockerAgentImpl.this.collectImages(result, null);
            }
        }.perform();
    }

    public DockerAgentApplication[] getImages(final String label) {
        return (DockerAgentApplication[])new ApplicationsApiTaskBase(){

            @Override
            protected void collectApplications(List<DockerAgentApplication> result) {
                DockerAgentImpl.this.collectImages(result, label);
            }
        }.perform();
    }

    private void collectImages(List<DockerAgentApplication> result, String label) {
        ListImagesCmd listImagesCmd = this.getDockerClient().listImagesCmd();
        if (label != null) {
            listImagesCmd.withLabelFilter(new String[]{label});
        }
        List images = (List)listImagesCmd.exec();
        for (Image image : images) {
            result.add(new DockerAgentImageImpl(new DockerAgentContextImpl(), image));
        }
    }

    public DockerAgentApplication[] getContainers() {
        return (DockerAgentApplication[])new ApplicationsApiTaskBase(){

            @Override
            protected void collectApplications(List<DockerAgentApplication> result) {
                DockerAgentImpl.this.collectContainers(result);
            }
        }.perform();
    }

    public DockerAgentApplication findContainer(final @NotNull String containerId) {
        if (containerId == null) {
            DockerAgentImpl.$$$reportNull$$$0(1);
        }
        return (DockerAgentApplication)new ApiTaskBase<DockerAgentApplication>(this.myErrorHandler){

            @Override
            protected DockerAgentApplication doPerform() {
                List containers = (List)DockerAgentImpl.this.getDockerClient().listContainersCmd().withShowAll(Boolean.TRUE).withIdFilter(Collections.singletonList(containerId)).withLimit(Integer.valueOf(1)).exec();
                return containers.isEmpty() ? null : new DockerAgentContainerImpl(new DockerAgentContextImpl(), (Container)containers.get(0));
            }
        }.perform();
    }

    private void collectContainers(List<DockerAgentApplication> result) {
        List containers = (List)this.getDockerClient().listContainersCmd().withShowAll(Boolean.TRUE).exec();
        for (Container container : containers) {
            result.add(new DockerAgentContainerImpl(new DockerAgentContextImpl(), container));
        }
    }

    public void removeVolume(final String volumeName) {
        new ApiTaskBase<Void>(this.myErrorHandler){

            @Override
            protected Void doPerform() {
                DockerAgentImpl.this.getDockerClient().removeVolumeCmd(volumeName).exec();
                return null;
            }
        }.perform();
    }

    static StringBuilder appendAll(StringBuilder builder, String ... items) {
        if (items == null) {
            builder.append("<unknown>");
            return builder;
        }
        boolean first = true;
        TreeSet<String> sortedItems = new TreeSet<String>(Arrays.asList(items));
        for (String item : sortedItems) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(item);
        }
        return builder;
    }

    public OngoingProcess pullImage(final DockerAgentRepositoryConfig repositoryConfig, final DockerAgentProgressCallback progressCallback) {
        return (OngoingProcess)new ApiTaskBase<PullImageResultCallbackImpl>(this.myErrorHandler){

            @Override
            protected PullImageResultCallbackImpl doPerform() {
                PullImageCmd pullImageCmd = DockerAgentImpl.this.preparePullImageCmd(repositoryConfig);
                return (PullImageResultCallbackImpl)pullImageCmd.exec((ResultCallback)new PullImageResultCallbackImpl(progressCallback, DockerAgentImpl.this.myLogger));
            }
        }.perform();
    }

    @NotNull
    public CompletableFuture<BlockingQueue<byte[]>> asyncPullImage(DockerAgentRepositoryConfig repositoryConfig) {
        CompletableFuture<BlockingQueue<byte[]>> result = new CompletableFuture<BlockingQueue<byte[]>>();
        try (PullImageCmd pullImageCmd = this.preparePullImageCmd(repositoryConfig);){
            pullImageCmd.exec(new PromisingSerializedItemsCallback(result));
        }
        catch (Exception e) {
            result.completeExceptionally(e);
        }
        CompletableFuture<BlockingQueue<byte[]>> completableFuture = result;
        if (completableFuture == null) {
            DockerAgentImpl.$$$reportNull$$$0(2);
        }
        return completableFuture;
    }

    @NotNull
    public DockerAgent.DockerImageBuilder createImageBuilder() {
        return new DockerAgentImageBuilderImpl(this.getDockerClient());
    }

    PullImageCmd preparePullImageCmd(DockerAgentRepositoryConfig repositoryConfig) {
        String tag;
        PullImageCmd pullImageCmd = this.getDockerClient().pullImageCmd(repositoryConfig.getQualifiedRepository());
        DockerAuthConfig customAuthConfig = repositoryConfig.getAuthConfig();
        if (customAuthConfig != null) {
            pullImageCmd.withAuthConfig((AuthConfig)new AuthConfigEx(customAuthConfig));
        }
        if ((tag = repositoryConfig.getTag()) == null) {
            tag = "latest";
        }
        pullImageCmd.withTag(tag);
        return pullImageCmd;
    }

    public void imageRegistryAuth(final DockerAuthConfig authConfig) {
        new ApiTaskBase<Void>(this.myErrorHandler){

            @Override
            protected Void doPerform() throws ApiTaskException {
                AuthResponse authResponse = DockerAgentImpl.this.getDockerClient().authCmd().withAuthConfig((AuthConfig)new AuthConfigEx(authConfig)).exec();
                String status = authResponse.getStatus();
                if (!DockerAgentImpl.REGISTRY_AUTH_SUCCESS.equals(status)) {
                    throw new ApiTaskException(status);
                }
                return null;
            }
        }.perform();
    }

    public DockerAgentDeployment createDeployment(@NotNull DockerAgentDeploymentConfig config, @NotNull CloudAgentLoggingHandler loggingHandler, @NotNull DockerAgentPathMapper pathMapper) {
        if (config == null) {
            DockerAgentImpl.$$$reportNull$$$0(3);
        }
        if (loggingHandler == null) {
            DockerAgentImpl.$$$reportNull$$$0(4);
        }
        if (pathMapper == null) {
            DockerAgentImpl.$$$reportNull$$$0(5);
        }
        return new DockerAgentDeploymentImpl(new DockerAgentContextImpl(), config, loggingHandler, pathMapper);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/agent/DockerAgentImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loggingHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/agent/DockerAgentImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncPullImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "attachEventListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findContainer";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDeployment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AgentEventsListener
    implements ResultCallback<Event> {
        private final CloudAgentLogger myLogger;
        private final DockerEvent.Listener myListener;
        private Closeable myCloseable;

        AgentEventsListener(CloudAgentLogger logger, DockerEvent.Listener realListener) {
            this.myLogger = logger;
            this.myListener = realListener;
        }

        public void onStart(Closeable closeable) {
            this.myCloseable = closeable;
        }

        public void onNext(Event event) {
            if (event != null) {
                this.myListener.onDockerEvent((DockerEvent)new DockerEventImpl(event));
            }
        }

        public void onComplete() {
        }

        public void onError(Throwable throwable) {
            this.myLogger.debugEx(throwable instanceof Exception ? (Exception)throwable : new Exception(throwable));
        }

        public void close() {
            this.closeNettyChannel();
        }

        void closeNettyChannel() {
            if (this.myCloseable != null) {
                try {
                    this.myCloseable.close();
                }
                catch (IOException e) {
                    this.myLogger.debugEx((Exception)e);
                }
            }
            this.myCloseable = null;
        }
    }

    private abstract class ApplicationsApiTaskBase
    extends ApiTaskBase<DockerAgentApplication[]> {
        ApplicationsApiTaskBase() {
            super(DockerAgentImpl.this.myErrorHandler);
        }

        @Override
        protected DockerAgentApplication[] doPerform() throws IOException, ApiTaskException {
            ArrayList<DockerAgentApplication> result = new ArrayList<DockerAgentApplication>();
            this.collectApplications(result);
            return result.toArray(DockerAgentApplication.EMPTY_ARRAY);
        }

        protected abstract void collectApplications(List<DockerAgentApplication> var1);
    }

    private static class DockerClientExtImpl
    implements DockerAgentContext.DockerClientExt {
        private final FixedDockerCmdExecNettyFactoryCopyImpl myMainExecFactory;
        private final JerseyDockerCmdExecFactory myJerseyExecFactory;
        private final DockerClient myDockerClient;
        private final ObjectMapper myObjectMapper;

        private static DockerAgentContext.DockerClientExt buildClient(@NotNull DockerAgentConfig config, @NotNull RemoteApiVersion remoteApiVersion) {
            DefaultDockerClientConfig.Builder builder;
            if (config == null) {
                DockerClientExtImpl.$$$reportNull$$$0(0);
            }
            if (remoteApiVersion == null) {
                DockerClientExtImpl.$$$reportNull$$$0(1);
            }
            try {
                builder = DefaultDockerClientConfig.createDefaultConfigBuilder();
            }
            catch (IllegalArgumentException e) {
                builder = new DefaultDockerClientConfig.Builder();
            }
            DefaultDockerClientConfig defaultConfig = builder.withDockerHost(DockerAgentImpl.getDockerHost(config.getApiUrl())).withDockerTlsVerify(Boolean.valueOf(DockerAgentImpl.isTlsVerifyEnabled(config.getApiUrl()))).withDockerCertPath(config.getCertificatesPath()).withApiVersion(remoteApiVersion).build();
            DockerClientConfigWithCustomAuth decoratedConfig = new DockerClientConfigWithCustomAuth(defaultConfig);
            return new DockerClientExtImpl(decoratedConfig);
        }

        private DockerClientExtImpl(@NotNull DockerClientConfig config) {
            if (config == null) {
                DockerClientExtImpl.$$$reportNull$$$0(2);
            }
            this.myObjectMapper = config.getObjectMapper().copy();
            this.myMainExecFactory = new FixedDockerCmdExecNettyFactoryCopyImpl();
            this.myJerseyExecFactory = new JerseyDockerCmdExecFactory();
            this.myDockerClient = DockerClientImpl.getInstance((DockerClientConfig)config).withDockerCmdExecFactory((DockerCmdExecFactory)this.myMainExecFactory);
            this.myJerseyExecFactory.init(config);
        }

        @Override
        @NotNull
        public ObjectMapper getObjectMapper() {
            ObjectMapper objectMapper2 = this.myObjectMapper.copy();
            if (objectMapper2 == null) {
                DockerClientExtImpl.$$$reportNull$$$0(3);
            }
            return objectMapper2;
        }

        @Override
        @NotNull
        public DockerClient getDockerClient() {
            DockerClient dockerClient = this.myDockerClient;
            if (dockerClient == null) {
                DockerClientExtImpl.$$$reportNull$$$0(4);
            }
            return dockerClient;
        }

        @Override
        public ExecStartCmd jerseyExecStartCmd(String execId) {
            return new ExecStartCmdImpl(this.myJerseyExecFactory.createExecStartCmdExec(), execId);
        }

        @Override
        public ExecCreateCmd jerseyExecCreateCmd(String containerId) {
            return new ExecCreateCmdImpl(this.myJerseyExecFactory.createExecCmdExec(), containerId);
        }

        @Override
        @NotNull
        public ResizeExecCmd resizeExecCmd() {
            return new ResizeExecCmdImpl(this.myMainExecFactory.createResizeExecCmdExec());
        }

        @Override
        @NotNull
        public ResizeContainerCmd resizeContainerCmd() {
            return new ResizeContainerCmdImpl(this.myMainExecFactory.createResizeContainerCmdExec());
        }

        @Override
        public void close() throws IOException {
            this.myDockerClient.close();
            this.myJerseyExecFactory.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteApiVersion";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/agent/DockerAgentImpl$DockerClientExtImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/agent/DockerAgentImpl$DockerClientExtImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjectMapper";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDockerClient";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "buildClient";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class DockerAgentContextImpl
    implements DockerAgentContext {
        private DockerAgentContextImpl() {
        }

        @Override
        public DockerAgent getAgent() {
            return DockerAgentImpl.this;
        }

        @Override
        public DockerAgentContext.DockerClientExt getClientExt() {
            return DockerAgentImpl.this.myClient;
        }

        @Override
        public DockerClient getClient() {
            return DockerAgentImpl.this.myClient.getDockerClient();
        }

        @Override
        public CloudAgentErrorHandler getErrorHandler() {
            return DockerAgentImpl.this.myErrorHandler;
        }

        @Override
        public DockerAgentLogManager getLogManager() {
            return DockerAgentImpl.this.myLogManager;
        }

        @Override
        public CloudAgentLogger getLogger() {
            return DockerAgentImpl.this.myLogger;
        }
    }
}

