/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc;

import com.intellij.database.remote.jdba.core.Layouts;
import com.intellij.database.remote.jdba.core.ParameterDef;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.exceptions.DBSessionIsClosedException;
import com.intellij.database.remote.jdba.intermediate.DBExceptionRecognizer;
import com.intellij.database.remote.jdba.intermediate.IntegralIntermediateSession;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateCallableSeance;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateCursor;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateSeance;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateSimpleSeance;
import com.intellij.database.remote.jdba.jdbc.JdbcUtil;
import com.intellij.database.remote.jdba.util.Objects;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcIntermediateSession
implements IntegralIntermediateSession {
    @Nullable
    protected final JdbcIntermediateFacade myFacade;
    @NotNull
    private final DBExceptionRecognizer myExceptionRecognizer;
    @NotNull
    private final Connection myConnection;
    private final boolean myOwnConnection;
    private boolean myInTransaction;
    private boolean myClosed;
    @NotNull
    private final Queue<JdbcIntermediateSeance> mySeances;
    protected static final int DEFAULT_FETCH_SIZE = 1000;
    protected static final int LARGEST_FETCH_SIZE = 1000000;

    protected JdbcIntermediateSession(@Nullable JdbcIntermediateFacade facade, @NotNull DBExceptionRecognizer exceptionRecognizer, @NotNull Connection connection, boolean ownConnection) {
        if (exceptionRecognizer == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(0);
        }
        if (connection == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(1);
        }
        this.mySeances = new LinkedBlockingQueue<JdbcIntermediateSeance>();
        this.myFacade = facade;
        this.myExceptionRecognizer = exceptionRecognizer;
        this.myConnection = connection;
        this.myOwnConnection = ownConnection;
        this.myClosed = false;
    }

    @Override
    public synchronized void beginTransaction() {
        this.checkNotClosed();
        if (!this.myInTransaction) {
            try {
                this.myConnection.setAutoCommit(false);
            }
            catch (SQLException sqle) {
                throw this.recognizeException(sqle, "set autocommit = false");
            }
        } else {
            throw new IllegalStateException("The sessions is already in a transaction");
        }
        this.myInTransaction = true;
    }

    @Override
    public boolean isInTransaction() {
        return this.myInTransaction;
    }

    @Override
    public synchronized void commit() {
        if (this.myInTransaction) {
            this.myInTransaction = false;
            try {
                this.myConnection.commit();
            }
            catch (SQLException sqle) {
                this.rollback();
                throw this.myExceptionRecognizer.recognizeException(sqle, "commit");
            }
        } else {
            throw new IllegalStateException("The sessions is not in a transaction");
        }
    }

    @Override
    public synchronized void rollback() {
        if (this.myClosed) {
            return;
        }
        this.myInTransaction = false;
        try {
            this.myConnection.rollback();
            this.myConnection.setAutoCommit(true);
        }
        catch (SQLException sqle) {
            JdbcUtil.printOperationException(sqle, "rollback");
            this.close();
        }
    }

    @Override
    @NotNull
    public synchronized JdbcIntermediateSeance openSeance(@NotNull String statementText, @Nullable ParameterDef[] outParameterDefs) {
        if (statementText == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(2);
        }
        this.checkNotClosed();
        JdbcIntermediateSeance seance = outParameterDefs == null ? this.openSimpleStatementSeance(statementText) : this.openPreparedStatementSeance(statementText, outParameterDefs);
        this.mySeances.add(seance);
        JdbcIntermediateSeance jdbcIntermediateSeance = seance;
        if (jdbcIntermediateSeance == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(3);
        }
        return jdbcIntermediateSeance;
    }

    @NotNull
    protected JdbcIntermediateSimpleSeance openSimpleStatementSeance(@NotNull String statementText) {
        if (statementText == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(4);
        }
        return new JdbcIntermediateSimpleSeance(this, statementText);
    }

    @NotNull
    protected JdbcIntermediateCallableSeance openPreparedStatementSeance(@NotNull String statementText, @NotNull ParameterDef[] outParameterDefs) {
        if (statementText == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(5);
        }
        if (outParameterDefs == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(6);
        }
        return new JdbcIntermediateCallableSeance(this, statementText, outParameterDefs);
    }

    @Override
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) {
        if (serviceClass == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(7);
        }
        if (serviceName == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(8);
        }
        if (serviceName.equalsIgnoreCase("intermediate-service")) {
            return Objects.castTo(serviceClass, this);
        }
        if (serviceName.equalsIgnoreCase("jdbc-connection")) {
            return Objects.castTo(serviceClass, this.myConnection);
        }
        if (serviceName.equalsIgnoreCase("jdbc-metadata")) {
            return Objects.castTo(serviceClass, this.getConnectionMetaData());
        }
        return null;
    }

    private DatabaseMetaData getConnectionMetaData() {
        try {
            return this.myConnection.getMetaData();
        }
        catch (SQLException e) {
            String className = this.myConnection.getClass().getName();
            throw this.myExceptionRecognizer.recognizeException(e, className + ".getMetaData()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long ping() {
        if (this.myClosed) {
            throw new DBSessionIsClosedException("The session is closed.");
        }
        long time1 = System.currentTimeMillis();
        boolean ok = false;
        try {
            if (this.myConnection.isClosed()) {
                throw new DBSessionIsClosedException("The JDBC connection is closed.");
            }
            Statement statement = this.myConnection.createStatement();
            try {
                this.performPing(statement);
                ok = true;
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException sqle) {
            throw this.myExceptionRecognizer.recognizeException(sqle, "ping");
        }
        finally {
            if (!ok) {
                this.close();
            }
        }
        long duration = System.currentTimeMillis() - time1;
        if (duration == 0L) {
            duration = 1L;
        }
        return duration;
    }

    protected void performPing(Statement statement) throws SQLException {
        String pingQuery = "select 1";
        statement.execute("select 1");
    }

    @Override
    public synchronized void close() {
        if (this.myClosed) {
            return;
        }
        this.closeSeances();
        if (this.myInTransaction) {
            this.rollback();
        }
        this.myClosed = true;
        if (this.myFacade != null) {
            this.myFacade.sessionIsClosed(this, this.myConnection);
        }
        if (this.myOwnConnection) {
            JdbcUtil.close(this.myConnection);
        }
    }

    private void closeSeances() {
        while (!this.mySeances.isEmpty()) {
            JdbcIntermediateSeance seanceToClose = this.mySeances.poll();
            seanceToClose.close();
        }
    }

    @Override
    public boolean isClosed() {
        return this.myClosed;
    }

    @NotNull
    protected PreparedStatement prepareSimpleStatement(@NotNull String statementText) throws SQLException {
        PreparedStatement statement;
        if (statementText == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(9);
        }
        PreparedStatement preparedStatement = statement = this.myConnection.prepareStatement(statementText, 1003, 1007);
        if (preparedStatement == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(10);
        }
        return preparedStatement;
    }

    @NotNull
    protected CallableStatement prepareCallableStatement(@NotNull String statementText) throws SQLException {
        if (statementText == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(11);
        }
        CallableStatement callableStatement = this.myConnection.prepareCall(statementText);
        if (callableStatement == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(12);
        }
        return callableStatement;
    }

    @NotNull
    ResultSet getDefaultResultSet(@NotNull Statement statement) throws SQLException {
        if (statement == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(13);
        }
        ResultSet resultSet = statement.getResultSet();
        if (resultSet == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(14);
        }
        return resultSet;
    }

    void tuneStatement(@NotNull PreparedStatement stmt, int packLimit) throws SQLException {
        if (stmt == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(15);
        }
        this.tuneStatementWithFetchSize(stmt, packLimit);
    }

    protected void tuneStatementWithFetchSize(PreparedStatement stmt, int packLimit) throws SQLException {
        if (packLimit > 0) {
            int fetchSize = Math.min(packLimit, 1000000);
            stmt.setFetchSize(fetchSize);
        } else {
            stmt.setFetchSize(this.getDefaultFetchSize());
        }
    }

    void tuneResultSet(@NotNull ResultSet rset, int packLimit) throws SQLException {
        if (rset == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(16);
        }
        this.tuneResultSetWithFetchSize(rset, packLimit);
    }

    protected void tuneResultSetWithFetchSize(@NotNull ResultSet rset, int packLimit) throws SQLException {
        if (rset == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(17);
        }
        if (JdbcUtil.getFetchDirection(rset) != 1000) {
            rset.setFetchDirection(1000);
        }
        if (packLimit > 0) {
            int fetchSize = Math.min(packLimit, 1000000);
            rset.setFetchSize(fetchSize);
        } else {
            rset.setFetchSize(this.getDefaultFetchSize());
        }
    }

    protected int getDefaultFetchSize() {
        return 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <V> V[] queryOneRow(@NotNull String queryText, int columnCount, @NotNull Class<V> columnClass) {
        if (queryText == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(18);
        }
        if (columnClass == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(19);
        }
        JdbcIntermediateSeance seance1 = this.openSeance(queryText, null);
        try {
            JdbcIntermediateCursor<V[]> cursor1;
            block10: {
                seance1.execute();
                cursor1 = seance1.openDefaultCursor(Layouts.rowOf(Layouts.arrayOf(columnCount, columnClass)));
                try {
                    if (!cursor1.hasRows()) break block10;
                    V[] VArray = cursor1.fetch();
                    cursor1.close();
                    return VArray;
                }
                catch (Throwable throwable) {
                    cursor1.close();
                    throw throwable;
                }
            }
            V[] VArray = null;
            cursor1.close();
            return VArray;
        }
        finally {
            seance1.close();
        }
    }

    public int countOpenedSeances() {
        int count = 0;
        for (JdbcIntermediateSeance seance : this.mySeances) {
            if (!seance.isStatementOpened()) continue;
            ++count;
        }
        return count;
    }

    public int countOpenedCursors() {
        int count = 0;
        for (JdbcIntermediateSeance seance : this.mySeances) {
            count += seance.countOpenedCursors();
        }
        return count;
    }

    @NotNull
    public Connection getConnection() {
        Connection connection = this.myConnection;
        if (connection == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(20);
        }
        return connection;
    }

    private void checkNotClosed() {
        if (this.myClosed) {
            throw new DBSessionIsClosedException("The session is closed");
        }
    }

    @NotNull
    protected DBException recognizeException(@NotNull SQLException sqle) {
        if (sqle == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(21);
        }
        DBException dBException = this.myExceptionRecognizer.recognizeException(sqle, null);
        if (dBException == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(22);
        }
        return dBException;
    }

    @NotNull
    protected DBException recognizeException(@NotNull SQLException sqle, @Nullable String statementText) {
        if (sqle == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(23);
        }
        DBException dBException = this.myExceptionRecognizer.recognizeException(sqle, statementText);
        if (dBException == null) {
            JdbcIntermediateSession.$$$reportNull$$$0(24);
        }
        return dBException;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 10: 
            case 12: 
            case 14: 
            case 20: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 10: 
            case 12: 
            case 14: 
            case 20: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionRecognizer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementText";
                break;
            }
            case 3: 
            case 10: 
            case 12: 
            case 14: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/jdbc/JdbcIntermediateSession";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outParameterDefs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rset";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnClass";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/JdbcIntermediateSession";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "openSeance";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareSimpleStatement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareCallableStatement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultResultSet";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnection";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "recognizeException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "openSeance";
                break;
            }
            case 3: 
            case 10: 
            case 12: 
            case 14: 
            case 20: 
            case 22: 
            case 24: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "openSimpleStatementSeance";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "openPreparedStatementSeance";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSpecificService";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prepareSimpleStatement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prepareCallableStatement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultResultSet";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tuneStatement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "tuneResultSet";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tuneResultSetWithFetchSize";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "queryOneRow";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "recognizeException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 10: 
            case 12: 
            case 14: 
            case 20: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

