/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.IndexableSetContributor;
import gnu.trove.THashSet;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.stdlib.SassScssStdlibInclusionContext;
import org.jetbrains.plugins.sass.stdlib.SassScssStubMarker;

public class SassScssIndexedRootProvider
extends IndexableSetContributor {
    private static final Logger LOG = Logger.getInstance(SassScssIndexedRootProvider.class);
    private volatile Set<VirtualFile> myAdditionalRoots;

    @NotNull
    public Set<VirtualFile> getAdditionalRootsToIndex() {
        Set<VirtualFile> result = this.myAdditionalRoots;
        if (result == null || result.isEmpty() || VfsUtilCore.hasInvalidFiles(result)) {
            this.myAdditionalRoots = result = SassScssIndexedRootProvider.findStdlibStubFiles();
        }
        Set<VirtualFile> set = result;
        if (set == null) {
            SassScssIndexedRootProvider.$$$reportNull$$$0(0);
        }
        return set;
    }

    public static SassScssIndexedRootProvider getInstance() {
        return (SassScssIndexedRootProvider)((Object)IndexableSetContributor.EP_NAME.findExtension(SassScssIndexedRootProvider.class));
    }

    private static Set<VirtualFile> findStdlibStubFiles() {
        URL globalFunctionsUrl = SassScssStubMarker.class.getResource("sass_functions.scss");
        assert (globalFunctionsUrl != null);
        VirtualFile globalFunctionsFile = VfsUtil.findFileByURL((URL)globalFunctionsUrl);
        if (globalFunctionsFile == null) {
            LOG.error("Cannot find sass stdlib file in ", new String[]{globalFunctionsUrl.getFile()});
            return Collections.emptySet();
        }
        THashSet result = new THashSet(SassScssStdlibInclusionContext.SASS_BUILTIN_MODULE_FILE_NAMES.length + 1);
        result.add(globalFunctionsFile);
        for (String moduleFileName : SassScssStdlibInclusionContext.SASS_BUILTIN_MODULE_FILE_NAMES) {
            VirtualFile moduleFile = globalFunctionsFile.getParent().findChild(moduleFileName);
            if (moduleFile != null) {
                result.add(moduleFile);
                continue;
            }
            LOG.error("Cannot find sass built-in module file ", new String[]{moduleFileName});
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/index/SassScssIndexedRootProvider", "getAdditionalRootsToIndex"));
    }
}

