/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.Nullable;

public class CommaExpressionJSInspection
extends JavaScriptInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("comma.expression.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSCommaExpression(JSCommaExpression node) {
            super.visitJSCommaExpression(node);
            if (node.getParent() instanceof JSCommaExpression) {
                return;
            }
            if (node.getParent() instanceof JSForStatement) {
                return;
            }
            ASTNode commaNode = node.getNode().findChildByType(JSTokenTypes.COMMA);
            if (commaNode != null) {
                this.registerError(commaNode.getPsi());
            }
        }
    }
}

