/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceToolWindowManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptToolWindowProvider {
    private final JSLanguageServiceToolWindowManager myToolWindow;

    @Nullable
    public static JSLanguageServiceToolWindowManager getToolWindow(Project project) {
        if (project == null || project.isDefault() || project.isDisposed()) {
            return null;
        }
        TypeScriptToolWindowProvider provider = (TypeScriptToolWindowProvider)ServiceManager.getService((Project)project, TypeScriptToolWindowProvider.class);
        return provider == null ? null : provider.getToolWindow();
    }

    public TypeScriptToolWindowProvider(Project project) {
        this.myToolWindow = new TypeScriptLanguageServiceToolWindowManager(project);
        Disposer.register((Disposable)project, (Disposable)this.myToolWindow);
    }

    public JSLanguageServiceToolWindowManager getToolWindow() {
        return this.myToolWindow;
    }
}

