/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.JSInsertThisFix;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.ES6CreateClassOrInterfaceFix;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSScopeSelectionUI;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionHandler;
import com.intellij.lang.javascript.refactoring.extractMethod.JSIntroduceFunctionScopeSelectionPopup;
import com.intellij.lang.javascript.refactoring.extractMethod.JSSignatureContext;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionActionBase;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateJSFunctionIntentionAction
extends CreateJSFunctionIntentionActionBase {
    private final boolean myIsMethod;
    private final boolean myIsModuleScope;
    private final boolean myIsAsync;
    private final String myFunctionName;
    private static final String ourJSImplementedMethodBodyTemplate = "JavaScript Implemented Method Body.js";
    private static final String ATTRIBUTE_IS_ASSIGNMENT_TARGET = "IS_ASSIGNMENT_TARGET";
    private static final String ATTRIBUTE_IS_NEW_CALL = "IS_NEW_CALL";
    private static final String ATTRIBUTE_HAS_EXPECTED_TYPE = "HAS_EXPECTED_TYPE";

    public CreateJSFunctionIntentionAction(String name, boolean isMethod, boolean isModuleScope) {
        this(name, isMethod, isModuleScope, false);
    }

    public CreateJSFunctionIntentionAction(String name, boolean isMethod, boolean isModuleScope, boolean isAsync) {
        super(name, isMethod && !isModuleScope ? "javascript.create.method.intention.name" : "javascript.create.function.intention.name");
        this.myFunctionName = name;
        this.myIsMethod = isMethod;
        this.myIsModuleScope = isModuleScope;
        this.myIsAsync = isAsync;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myIsProperty ? JavaScriptBundle.message((String)"javascript.create.function.property.intention.name", (Object[])new Object[]{this.myFunctionName}) : super.getName();
        if (string == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, @NotNull PsiFile file2, @Nullable Editor editor) {
        if (file2 == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(1);
        }
        this.applyFixWithScopeSelection(project, psiElement, file2, editor, ApplicationManager.getApplication().isUnitTestMode() ? (defaultSuggestedScope, scopeList, cb) -> cb.pass((Object)CreateJSFunctionIntentionAction.chooseIntroductionScopeForTest(psiElement, scopeList)) : new JSIntroduceFunctionScopeSelectionPopup(editor));
    }

    public void applyFixWithScopeSelection(Project project, final PsiElement psiElement, PsiFile file2, Editor editor, JSScopeSelectionUI<JSExtractFunctionHandler.IntroductionScope> scopeSelectionUi) {
        if (psiElement == null) {
            return;
        }
        JSExtractFunctionHandler extractFunctionHandler = new JSExtractFunctionHandler();
        JSReferenceExpression referenceExpression = (JSReferenceExpression)this.calculateAnchors((PsiElement)psiElement).first;
        if (CreateJSFunctionIntentionAction.getScopeFromReferenceExpression(referenceExpression) != null) {
            this.doApplyFix(project, psiElement, file2, editor);
            return;
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)referenceExpression);
        List scopes = extractFunctionHandler.findBases(psiElement, false);
        if (referenceExpression != null && referenceExpression.getQualifier() == null) {
            boolean isEs6Class = JSClassUtils.isES6ClassImplementation(dialect);
            scopes = ContainerUtil.filter(scopes, scope -> {
                if (scope.getParent() instanceof JSObjectLiteralExpression) {
                    return false;
                }
                if (isEs6Class) {
                    return scope.isClassContext() == this.myIsMethod;
                }
                return true;
            });
        }
        final List finalScopes = scopes;
        final boolean isActionScript = dialect != null && dialect.isECMA4;
        final boolean isTypeScript = dialect != null && dialect.isTypeScript;
        JSSignatureContext context = new JSSignatureContext(){

            @Override
            public boolean isActionScript() {
                return isActionScript;
            }

            @Override
            public boolean isTypeScript() {
                return isTypeScript;
            }

            @Override
            public boolean isAsync() {
                return false;
            }

            @Override
            @NotNull
            public JSContext getJSContext() {
                JSContext jSContext = JSContext.UNKNOWN;
                if (jSContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                return jSContext;
            }

            @Override
            public PsiElement getContextElement() {
                return psiElement;
            }

            @Override
            @NotNull
            public List<JSExtractFunctionHandler.IntroductionScope> getIntroductionScopes() {
                List list2 = finalScopes;
                if (list2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return list2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getJSContext";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIntroductionScopes";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        Consumer callback = scope -> {
            if (scope.isClassContext()) {
                this.doApplyFix(project, psiElement, file2, editor);
            } else {
                boolean placeAtScopeStart = JSCodeStyleSettings.isLocalDeclarationsAtScopeStart(psiElement);
                PsiElement anchor = JSUtils.findFunctionAnchor(scope.getParent(), psiElement, placeAtScopeStart);
                anchor = JSPsiImplUtils.findLeadingCommentOrSelf(anchor);
                this.doApplyFix(project, psiElement, file2, editor, anchor, scope.getParent());
            }
        };
        extractFunctionHandler.chooseIntroductionScope(context, (Consumer<? super JSExtractFunctionHandler.IntroductionScope>)callback, scopeSelectionUi, this.myFunctionName);
    }

    private static JSExtractFunctionHandler.IntroductionScope chooseIntroductionScopeForTest(@NotNull PsiElement usageElement, @NotNull List<? extends JSScopeSelectionUI.ScopePresentation<JSExtractFunctionHandler.IntroductionScope>> presentations) {
        List scopes;
        if (usageElement == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(2);
        }
        if (presentations == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(3);
        }
        if ((scopes = ContainerUtil.map(presentations, presentation -> (JSExtractFunctionHandler.IntroductionScope)presentation.getScope())).isEmpty()) {
            throw new RuntimeException("No available scopes");
        }
        if (scopes.size() == 1) {
            return (JSExtractFunctionHandler.IntroductionScope)scopes.get(0);
        }
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)usageElement, JSStatement.class, (boolean)false);
        if (statement == null) {
            throw new RuntimeException("Could not find statement from usage");
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)statement);
        if (docComment instanceof JSDocComment) {
            String scopePresentation = docComment.getText().substring(3, docComment.getTextLength() - 2).trim();
            for (JSExtractFunctionHandler.IntroductionScope scope : scopes) {
                if (!scopePresentation.equals(scope.toString())) continue;
                return scope;
            }
            throw new RuntimeException("Scope with name " + scopePresentation + " not found");
        }
        return (JSExtractFunctionHandler.IntroductionScope)scopes.get(scopes.size() - 1);
    }

    @Nullable
    private static PsiElement getScopeFromReferenceExpression(@Nullable JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            return null;
        }
        JSExpression qualifier = referenceExpression.getQualifier();
        return qualifier != null ? CreateJSFunctionIntentionAction.getScope(qualifier, referenceExpression.getContainingFile()) : null;
    }

    @Override
    protected void writeFunctionAndName(Template template, String createdMethodName, @NotNull PsiElement anchorParent, @Nullable PsiElement clazz, JSReferenceExpression referenceExpression) {
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(4);
        }
        String generics = CreateJSFunctionIntentionAction.getGenericArgumentsString(anchorParent, clazz, referenceExpression);
        if (anchorParent instanceof JSObjectLiteralExpression && !this.myIsModuleScope) {
            createdMethodName = createdMethodName.substring(createdMethodName.lastIndexOf(".") + 1);
            template.addTextSegment(createdMethodName);
            if (!DialectDetector.hasFeature(anchorParent, JSLanguageFeature.METHOD_DEFINITION_SHORTHANDS)) {
                template.addTextSegment(": ");
                template.addTextSegment(this.getFunctionKeywords());
                template.addTextSegment(generics);
            } else {
                template.addTextSegment(generics);
            }
            return;
        }
        if (clazz != null) {
            if (createdMethodName.indexOf(46) != -1) {
                createdMethodName = createdMethodName.substring(createdMethodName.lastIndexOf(".") + 1);
            }
            if (this.myIsAsync) {
                template.addTextSegment("async ");
            }
            template.addTextSegment(JSClassUtils.createClassFunctionName(createdMethodName, anchorParent));
            template.addTextSegment(generics);
            return;
        }
        if (!this.myIsMethod || this.isExportWithoutFrom() || DialectDetector.isActionScript(anchorParent) || DialectDetector.isTypeScript(anchorParent) && referenceExpression != null && referenceExpression.getQualifier() == null) {
            template.addTextSegment(this.getFunctionKeywords());
            template.addTextSegment(createdMethodName);
            template.addTextSegment(generics);
            return;
        }
        int indexOfDot = createdMethodName.lastIndexOf(46);
        if (referenceExpression == null || indexOfDot > 0 && (referenceExpression.getContainingFile() != anchorParent.getContainingFile() || this.myIsModuleScope)) {
            template.addTextSegment(this.isExportDefault() ? "export default " : "export ");
            template.addTextSegment(this.getFunctionKeywords());
            template.addTextSegment(createdMethodName.substring(indexOfDot + 1));
            template.addTextSegment(generics);
            return;
        }
        if (indexOfDot == -1) {
            template.addTextSegment(JSChangeUtil.getVariablePrefix(anchorParent) + " ");
        }
        template.addTextSegment(createdMethodName);
        template.addTextSegment(" = " + this.getFunctionKeywords());
        template.addTextSegment(generics);
    }

    private static String getGenericArgumentsString(@NotNull PsiElement anchorParent, PsiElement clazz, @Nullable JSReferenceExpression referenceExpression) {
        PsiElement parent;
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(5);
        }
        String genericArguments = null;
        if (referenceExpression != null && DialectDetector.hasFeature(anchorParent, JSLanguageFeature.GENERICS) && (parent = referenceExpression.getParent()) instanceof JSCallItem) {
            JSTypeDeclaration[] arguments = ((JSCallItem)parent).getTypeArguments();
            genericArguments = ES6CreateClassOrInterfaceFix.getTypeArgumentsString(arguments, clazz instanceof TypeScriptTypeParameterListOwner ? ContainerUtil.map2Set((Object[])((TypeScriptTypeParameterListOwner)clazz).getTypeParameters(), p -> p.getName()) : Collections.emptySet());
        }
        if (genericArguments == null) {
            genericArguments = "";
        }
        return genericArguments;
    }

    protected String getFunctionKeywords() {
        return this.myIsAsync ? "async function " : "function ";
    }

    @Override
    protected void addParameters(Template template, JSReferenceExpression methodExpression, @NotNull PsiElement anchorParent) {
        PsiElement element;
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(6);
        }
        if ((element = methodExpression.getParent()) instanceof JSCallLikeExpression) {
            JSExpression[] arguments = ((JSCallLikeExpression)element).getArguments();
            if (element instanceof ES6TaggedTemplateExpression) {
                CreateJSFunctionIntentionAction.addParameter(template, "strings", DialectDetector.isTypeScript((PsiElement)methodExpression) ? "TemplateStringsArray" : null, (PsiElement)methodExpression, false);
                if (arguments.length > 0) {
                    template.addTextSegment(", ");
                }
            }
            CreateJSFunctionIntentionAction.addParameters(template, arguments, (PsiElement)methodExpression, anchorParent);
        }
    }

    public static void addParameters(@NotNull Template template, JSExpression @NotNull [] expressions, @NotNull PsiElement callExpressionContext, PsiElement anchorParent) {
        if (template == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(7);
        }
        if (callExpressionContext == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(8);
        }
        if (expressions == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(9);
        }
        int paramCount = expressions.length;
        THashSet usedParameterNames = new THashSet();
        boolean hasSpread = false;
        for (int i = 0; i < paramCount && !hasSpread; ++i) {
            JSExpression passedParameterValue = expressions[i];
            String var = passedParameterValue instanceof JSReferenceExpression ? ((JSReferenceExpression)passedParameterValue).getReferenceName() : JSNameSuggestionsUtil.generateVariableNameFromExpression(passedParameterValue, callExpressionContext);
            if (var == null || var.length() == 0) {
                var = "param" + (i != 0 ? Integer.toString(i + 1) : "");
            } else {
                String baseName = var;
                int j = 2;
                while (usedParameterNames.contains(var)) {
                    var = baseName + j;
                    ++j;
                }
                usedParameterNames.add(var);
            }
            String typeName = null;
            DialectOptionHolder holder = DialectDetector.dialectOfElement(anchorParent);
            if (passedParameterValue instanceof JSSpreadExpression) {
                hasSpread = true;
                if (CreateJSFunctionIntentionAction.shouldHaveType(holder)) {
                    boolean eraseType = false;
                    for (int j = i + 1; j < paramCount; ++j) {
                        if (!(expressions[j] instanceof JSSpreadExpression)) continue;
                        eraseType = true;
                        break;
                    }
                    if (!eraseType) {
                        JSType innerType = ((JSSpreadExpression)passedParameterValue).getInnerExpressionType();
                        typeName = innerType == null ? null : CreateJSFunctionIntentionAction.getTypeText(innerType, anchorParent);
                    }
                }
            } else if (CreateJSFunctionIntentionAction.shouldHaveType(holder)) {
                JSType type = JSResolveUtil.getExpressionJSType(passedParameterValue);
                String string = typeName = type == null ? null : CreateJSFunctionIntentionAction.getTypeText(type, anchorParent);
                if (holder.isTypeScript && (typeName == null || "null".equals(typeName))) {
                    typeName = null;
                }
            }
            if (i != 0) {
                template.addTextSegment(", ");
            }
            CreateJSFunctionIntentionAction.addParameter(template, var, typeName, callExpressionContext, hasSpread);
        }
    }

    private static boolean shouldHaveType(DialectOptionHolder holder) {
        return holder != null && (holder.isTypeScript || holder.isECMA4);
    }

    private static void addParameter(@NotNull Template template, @NotNull String parameterName, @Nullable String typeName, @NotNull PsiElement context, boolean isRest) {
        if (template == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(10);
        }
        if (parameterName == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(11);
        }
        if (context == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(12);
        }
        if (isRest) {
            template.addTextSegment("...");
        }
        ConstantNode expression = new ConstantNode(parameterName);
        template.addVariable(parameterName, (Expression)expression, (Expression)expression, true);
        if (typeName != null) {
            template.addTextSegment(":");
            CreateJSFunctionIntentionAction.addTypeVariable(template, parameterName, context, typeName);
        }
    }

    @Override
    protected void addReturnType(Template template, JSReferenceExpression referenceExpression, @NotNull PsiElement anchorParent) {
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(13);
        }
        this.guessTypeAndAddTemplateVariable(template, (JSExpression)referenceExpression, anchorParent, true);
    }

    @Override
    protected JSReferenceExpression beforeStartTemplateAction(JSReferenceExpression referenceExpression, Editor editor, @NotNull PsiElement anchor, boolean isStaticContext) {
        JSReferenceExpression superRefExpression;
        if (anchor == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(14);
        }
        if ((superRefExpression = super.beforeStartTemplateAction(referenceExpression, editor, anchor, isStaticContext)) == null) {
            return null;
        }
        if (CreateJSFunctionIntentionAction.shouldInsertQualifier(anchor, superRefExpression)) {
            String name;
            JSClass contextClass = JSUtils.getMemberContainingClass(anchor);
            String qualifier = "this";
            if (contextClass != null && isStaticContext && (name = contextClass.getName()) != null) {
                qualifier = name;
            }
            return (JSReferenceExpression)JSInsertThisFix.insertQualifier((JSExpression)superRefExpression, editor, qualifier);
        }
        return superRefExpression;
    }

    private static boolean shouldInsertQualifier(@Nullable PsiElement anchor, JSReferenceExpression superRefExpression) {
        return !DialectDetector.isActionScript((PsiElement)superRefExpression) && superRefExpression.getQualifier() == null && anchor != null && null != JSUtils.getMemberContainingClass(anchor);
    }

    @Override
    protected void addBody(Template template, JSReferenceExpression refExpr, @NotNull PsiElement anchorParent) {
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(15);
        }
        template.addTextSegment("\n");
        template.addSelectionStartVariable();
        this.appendFunctionBody(template, refExpr, anchorParent);
        template.addSelectionEndVariable();
        template.addEndVariable();
        template.addTextSegment("\n");
    }

    protected void appendFunctionBody(Template template, JSReferenceExpression refExpr, PsiElement anchorParent) {
        JSType expectedType;
        PsiElement parent = refExpr.getParent();
        JSType jSType = expectedType = parent instanceof JSCallExpression ? JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parent) : null;
        if (parent != null && ES6PsiUtil.isAwaitExpression(parent.getParent())) {
            JSType type;
            JSType jSType2 = type = expectedType == null ? null : JSTypeUtils.getPromiseComponentTypeOrNull(expectedType);
            if (type != null) {
                expectedType = type;
            }
        }
        String methodName = refExpr.getReferenceName();
        assert (methodName != null);
        if (DialectDetector.isTypeScript(anchorParent)) {
            StringBuilder builder = new StringBuilder();
            TypeScriptImplementMemberUtil.appendDefaultMethodBody((PsiElement)refExpr, expectedType, builder, methodName);
            template.addTextSegment(builder.toString());
        } else {
            CreateJSFunctionIntentionAction.buildImplementedFunctionBody(template, refExpr.getParent() instanceof JSNewExpression, anchorParent.getProject(), CreateJSFunctionIntentionAction.isAssignmentTarget(parent, expectedType), expectedType, methodName);
        }
    }

    private static void buildImplementedFunctionBody(@NotNull Template template, boolean isNewCall, @NotNull Project project, boolean isAssignmentTarget, @Nullable JSType expectedType, @NotNull String methodName) {
        if (template == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(16);
        }
        if (project == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(17);
        }
        if (methodName == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(18);
        }
        template.addTextSegment(CreateJSFunctionIntentionAction.getImplementedFunctionBodyText(isNewCall, project, isAssignmentTarget, expectedType, methodName));
    }

    @NotNull
    public static String getImplementedFunctionBodyText(boolean isNewCall, @NotNull Project project, boolean isAssignmentTarget, @Nullable JSType expectedType, @NotNull String methodName) {
        if (project == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(19);
        }
        if (methodName == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(20);
        }
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)project);
        FileTemplate fileTemplate = fileTemplateManager.getCodeTemplate(ourJSImplementedMethodBodyTemplate);
        Properties properties = fileTemplateManager.getDefaultProperties();
        properties.setProperty(ATTRIBUTE_HAS_EXPECTED_TYPE, String.valueOf(expectedType != null && !(expectedType instanceof JSVoidType)));
        properties.setProperty(ATTRIBUTE_IS_NEW_CALL, String.valueOf(isNewCall));
        properties.setProperty(ATTRIBUTE_IS_ASSIGNMENT_TARGET, String.valueOf(isAssignmentTarget));
        properties.setProperty("DEFAULT_RETURN_VALUE", JSRefactoringUtil.defaultValueOfType(expectedType));
        properties.setProperty("METHOD_NAME", methodName);
        String string = TypeScriptImplementMemberUtil.getBodyTextFromTemplate(fileTemplate, properties);
        if (string == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static boolean isAssignmentTarget(PsiElement parent, JSType expectedType) {
        PsiElement parentParent = parent == null ? null : parent.getParent();
        return expectedType != null || parentParent instanceof JSAssignmentExpression && ((JSAssignmentExpression)parentParent).getROperand() == parent || parentParent instanceof JSVariable && ((JSVariable)parentParent).getInitializer() == parent || parentParent instanceof JSReturnStatement || parentParent instanceof JSArgumentList;
    }

    @Override
    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, @NotNull PsiElement anchorParent) {
        if (anchorParent == null) {
            CreateJSFunctionIntentionAction.$$$reportNull$$$0(22);
        }
        super.buildTemplate(template, referenceExpression, staticContext, anchorParent);
        if (this.myIsMethod && !JSClassUtils.canHaveClasses(anchorParent) && !(anchorParent instanceof JSObjectLiteralExpression)) {
            this.addSemicolonSegment(template, anchorParent);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentations";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorParent";
                break;
            }
            case 7: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpressionContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/CreateJSFunctionIntentionAction";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementedFunctionBodyText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "chooseIntroductionScopeForTest";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeFunctionAndName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getGenericArgumentsString";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addReturnType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "beforeStartTemplateAction";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addBody";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildImplementedFunctionBody";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getImplementedFunctionBodyText";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "buildTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

