/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.ecmascript6.refactoring.ES6ModuleMemberInfo;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRenamePsiFileProcessor
extends RenamePsiFileProcessor {
    private final boolean myForceHidePreview;

    public JSRenamePsiFileProcessor() {
        this(false);
    }

    public JSRenamePsiFileProcessor(boolean forceHidePreview) {
        this.myForceHidePreview = forceHidePreview;
    }

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(0);
        }
        if (!(element instanceof JSFile)) {
            return false;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(element);
        return holder == null || !holder.isECMA4;
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        if (project == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(2);
        }
        RenameDialog dialog = super.createRenameDialog(project, element, nameSuggestionContext, editor);
        if (this.myForceHidePreview) {
            dialog.setPreviewResults(false);
        }
        RenameDialog renameDialog = dialog;
        if (renameDialog == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(3);
        }
        return renameDialog;
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        if (element == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(5);
        }
        long currentModificationCount = PsiModificationTracker.SERVICE.getInstance((Project)element.getProject()).getModificationCount();
        Long setTimestamp = (Long)element.getUserData(JSDefaultRenameProcessor.FORCE_SEARCH_FOR_FILE_REFERENCES_KEY);
        if (setTimestamp != null && currentModificationCount == setTimestamp) {
            Collection collection = ReferencesSearch.search((PsiElement)element, (SearchScope)searchScope).findAll();
            if (collection == null) {
                JSRenamePsiFileProcessor.$$$reportNull$$$0(6);
            }
            return collection;
        }
        Collection collection = super.findReferences(element, searchScope, searchInCommentsAndStrings);
        if (collection == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(7);
        }
        return collection;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        String message;
        String newElementName;
        JSNamedElement declaration;
        if (element == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(8);
        }
        if (newName == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(9);
        }
        if (allRenames == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(10);
        }
        if ((declaration = JSRenamePsiFileProcessor.findMatchingDeclaration((JSFile)element)) != null && (newElementName = JSNameSuggestionsUtil.fileNameToElementName(declaration, newName)) != null && !StringUtil.equals((CharSequence)newElementName, (CharSequence)declaration.getName()) && Messages.showYesNoDialog((String)(message = JavaScriptBundle.message((String)"javascript.rename.related.declaration.message", (Object[])new Object[]{new JSNamedElementPresenter((PsiElement)declaration).describeElementKind(), newElementName})), (String)JavaScriptBundle.message((String)"javascript.rename.file.with.related.title", (Object[])new Object[0]), (Icon)UIUtil.getQuestionIcon()) == 0) {
            allRenames.put((PsiElement)declaration, newElementName);
        }
        super.prepareRenaming(element, newName, allRenames);
    }

    @Nullable
    public static JSNamedElement findMatchingDeclaration(@NotNull JSFile file2) {
        PsiElement[] children;
        if (file2 == null) {
            JSRenamePsiFileProcessor.$$$reportNull$$$0(11);
        }
        Ref result2 = new Ref();
        for (PsiElement child : children = file2.getChildren()) {
            JSQualifiedNamedElement element = ES6ModuleMemberInfo.getMember(child);
            if (!(element instanceof JSVariable) && !(element instanceof JSClass) && !(element instanceof JSFunction) || !JSNameSuggestionsUtil.matchesFileNameRelaxed((JSNamedElement)element)) continue;
            result2.set((Object)element);
            return element;
        }
        return (JSNamedElement)result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/JSRenamePsiFileProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSRenamePsiFileProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameDialog";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingDeclaration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

